package software.amazon.awscdk.services.qldb;

/**
 * A reference to a Ledger resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qldb.*;
 * LedgerReference ledgerReference = LedgerReference.builder()
 *         .ledgerId("ledgerId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:11.136Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qldb.LedgerReference")
@software.amazon.jsii.Jsii.Proxy(LedgerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LedgerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the Ledger resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLedgerId();

    /**
     * @return a {@link Builder} of {@link LedgerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LedgerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LedgerReference> {
        java.lang.String ledgerId;

        /**
         * Sets the value of {@link LedgerReference#getLedgerId}
         * @param ledgerId The Id of the Ledger resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ledgerId(java.lang.String ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LedgerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LedgerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LedgerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LedgerReference {
        private final java.lang.String ledgerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ledgerId = software.amazon.jsii.Kernel.get(this, "ledgerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ledgerId = java.util.Objects.requireNonNull(builder.ledgerId, "ledgerId is required");
        }

        @Override
        public final java.lang.String getLedgerId() {
            return this.ledgerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ledgerId", om.valueToTree(this.getLedgerId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qldb.LedgerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LedgerReference.Jsii$Proxy that = (LedgerReference.Jsii$Proxy) o;

            return this.ledgerId.equals(that.ledgerId);
        }

        @Override
        public final int hashCode() {
            int result = this.ledgerId.hashCode();
            return result;
        }
    }
}
