package software.amazon.awscdk.services.quicksight;

/**
 * A reference to a Analysis resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * AnalysisReference analysisReference = AnalysisReference.builder()
 *         .analysisArn("analysisArn")
 *         .analysisId("analysisId")
 *         .awsAccountId("awsAccountId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:11.137Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.AnalysisReference")
@software.amazon.jsii.Jsii.Proxy(AnalysisReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AnalysisReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Analysis resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAnalysisArn();

    /**
     * The AnalysisId of the Analysis resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAnalysisId();

    /**
     * The AwsAccountId of the Analysis resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * @return a {@link Builder} of {@link AnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AnalysisReference> {
        java.lang.String analysisArn;
        java.lang.String analysisId;
        java.lang.String awsAccountId;

        /**
         * Sets the value of {@link AnalysisReference#getAnalysisArn}
         * @param analysisArn The ARN of the Analysis resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisArn(java.lang.String analysisArn) {
            this.analysisArn = analysisArn;
            return this;
        }

        /**
         * Sets the value of {@link AnalysisReference#getAnalysisId}
         * @param analysisId The AnalysisId of the Analysis resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analysisId(java.lang.String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        /**
         * Sets the value of {@link AnalysisReference#getAwsAccountId}
         * @param awsAccountId The AwsAccountId of the Analysis resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AnalysisReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AnalysisReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AnalysisReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnalysisReference {
        private final java.lang.String analysisArn;
        private final java.lang.String analysisId;
        private final java.lang.String awsAccountId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.analysisArn = software.amazon.jsii.Kernel.get(this, "analysisArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.analysisId = software.amazon.jsii.Kernel.get(this, "analysisId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.analysisArn = java.util.Objects.requireNonNull(builder.analysisArn, "analysisArn is required");
            this.analysisId = java.util.Objects.requireNonNull(builder.analysisId, "analysisId is required");
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
        }

        @Override
        public final java.lang.String getAnalysisArn() {
            return this.analysisArn;
        }

        @Override
        public final java.lang.String getAnalysisId() {
            return this.analysisId;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("analysisArn", om.valueToTree(this.getAnalysisArn()));
            data.set("analysisId", om.valueToTree(this.getAnalysisId()));
            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.AnalysisReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AnalysisReference.Jsii$Proxy that = (AnalysisReference.Jsii$Proxy) o;

            if (!analysisArn.equals(that.analysisArn)) return false;
            if (!analysisId.equals(that.analysisId)) return false;
            return this.awsAccountId.equals(that.awsAccountId);
        }

        @Override
        public final int hashCode() {
            int result = this.analysisArn.hashCode();
            result = 31 * result + (this.analysisId.hashCode());
            result = 31 * result + (this.awsAccountId.hashCode());
            return result;
        }
    }
}
