package software.amazon.awscdk.services.quicksight;

/**
 * Creates a new Q topic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnTopic cfnTopic = CfnTopic.Builder.create(this, "MyCfnTopic")
 *         .awsAccountId("awsAccountId")
 *         .configOptions(TopicConfigOptionsProperty.builder()
 *                 .qBusinessInsightsEnabled(false)
 *                 .build())
 *         .customInstructions(CustomInstructionsProperty.builder()
 *                 .customInstructionsString("customInstructionsString")
 *                 .build())
 *         .dataSets(List.of(DatasetMetadataProperty.builder()
 *                 .datasetArn("datasetArn")
 *                 // the properties below are optional
 *                 .calculatedFields(List.of(TopicCalculatedFieldProperty.builder()
 *                         .calculatedFieldName("calculatedFieldName")
 *                         .expression("expression")
 *                         // the properties below are optional
 *                         .aggregation("aggregation")
 *                         .allowedAggregations(List.of("allowedAggregations"))
 *                         .calculatedFieldDescription("calculatedFieldDescription")
 *                         .calculatedFieldSynonyms(List.of("calculatedFieldSynonyms"))
 *                         .cellValueSynonyms(List.of(CellValueSynonymProperty.builder()
 *                                 .cellValue("cellValue")
 *                                 .synonyms(List.of("synonyms"))
 *                                 .build()))
 *                         .columnDataRole("columnDataRole")
 *                         .comparativeOrder(ComparativeOrderProperty.builder()
 *                                 .specifedOrder(List.of("specifedOrder"))
 *                                 .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
 *                                 .useOrdering("useOrdering")
 *                                 .build())
 *                         .defaultFormatting(DefaultFormattingProperty.builder()
 *                                 .displayFormat("displayFormat")
 *                                 .displayFormatOptions(DisplayFormatOptionsProperty.builder()
 *                                         .blankCellFormat("blankCellFormat")
 *                                         .currencySymbol("currencySymbol")
 *                                         .dateFormat("dateFormat")
 *                                         .decimalSeparator("decimalSeparator")
 *                                         .fractionDigits(123)
 *                                         .groupingSeparator("groupingSeparator")
 *                                         .negativeFormat(NegativeFormatProperty.builder()
 *                                                 .prefix("prefix")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .prefix("prefix")
 *                                         .suffix("suffix")
 *                                         .unitScaler("unitScaler")
 *                                         .useBlankCellFormat(false)
 *                                         .useGrouping(false)
 *                                         .build())
 *                                 .build())
 *                         .disableIndexing(false)
 *                         .isIncludedInTopic(false)
 *                         .neverAggregateInFilter(false)
 *                         .nonAdditive(false)
 *                         .notAllowedAggregations(List.of("notAllowedAggregations"))
 *                         .semanticType(SemanticTypeProperty.builder()
 *                                 .falseyCellValue("falseyCellValue")
 *                                 .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
 *                                 .subTypeName("subTypeName")
 *                                 .truthyCellValue("truthyCellValue")
 *                                 .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
 *                                 .typeName("typeName")
 *                                 .typeParameters(Map.of(
 *                                         "typeParametersKey", "typeParameters"))
 *                                 .build())
 *                         .timeGranularity("timeGranularity")
 *                         .build()))
 *                 .columns(List.of(TopicColumnProperty.builder()
 *                         .columnName("columnName")
 *                         // the properties below are optional
 *                         .aggregation("aggregation")
 *                         .allowedAggregations(List.of("allowedAggregations"))
 *                         .cellValueSynonyms(List.of(CellValueSynonymProperty.builder()
 *                                 .cellValue("cellValue")
 *                                 .synonyms(List.of("synonyms"))
 *                                 .build()))
 *                         .columnDataRole("columnDataRole")
 *                         .columnDescription("columnDescription")
 *                         .columnFriendlyName("columnFriendlyName")
 *                         .columnSynonyms(List.of("columnSynonyms"))
 *                         .comparativeOrder(ComparativeOrderProperty.builder()
 *                                 .specifedOrder(List.of("specifedOrder"))
 *                                 .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
 *                                 .useOrdering("useOrdering")
 *                                 .build())
 *                         .defaultFormatting(DefaultFormattingProperty.builder()
 *                                 .displayFormat("displayFormat")
 *                                 .displayFormatOptions(DisplayFormatOptionsProperty.builder()
 *                                         .blankCellFormat("blankCellFormat")
 *                                         .currencySymbol("currencySymbol")
 *                                         .dateFormat("dateFormat")
 *                                         .decimalSeparator("decimalSeparator")
 *                                         .fractionDigits(123)
 *                                         .groupingSeparator("groupingSeparator")
 *                                         .negativeFormat(NegativeFormatProperty.builder()
 *                                                 .prefix("prefix")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .prefix("prefix")
 *                                         .suffix("suffix")
 *                                         .unitScaler("unitScaler")
 *                                         .useBlankCellFormat(false)
 *                                         .useGrouping(false)
 *                                         .build())
 *                                 .build())
 *                         .disableIndexing(false)
 *                         .isIncludedInTopic(false)
 *                         .neverAggregateInFilter(false)
 *                         .nonAdditive(false)
 *                         .notAllowedAggregations(List.of("notAllowedAggregations"))
 *                         .semanticType(SemanticTypeProperty.builder()
 *                                 .falseyCellValue("falseyCellValue")
 *                                 .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
 *                                 .subTypeName("subTypeName")
 *                                 .truthyCellValue("truthyCellValue")
 *                                 .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
 *                                 .typeName("typeName")
 *                                 .typeParameters(Map.of(
 *                                         "typeParametersKey", "typeParameters"))
 *                                 .build())
 *                         .timeGranularity("timeGranularity")
 *                         .build()))
 *                 .dataAggregation(DataAggregationProperty.builder()
 *                         .datasetRowDateGranularity("datasetRowDateGranularity")
 *                         .defaultDateColumnName("defaultDateColumnName")
 *                         .build())
 *                 .datasetDescription("datasetDescription")
 *                 .datasetName("datasetName")
 *                 .filters(List.of(TopicFilterProperty.builder()
 *                         .filterName("filterName")
 *                         .operandFieldName("operandFieldName")
 *                         // the properties below are optional
 *                         .categoryFilter(TopicCategoryFilterProperty.builder()
 *                                 .categoryFilterFunction("categoryFilterFunction")
 *                                 .categoryFilterType("categoryFilterType")
 *                                 .constant(TopicCategoryFilterConstantProperty.builder()
 *                                         .collectiveConstant(CollectiveConstantProperty.builder()
 *                                                 .valueList(List.of("valueList"))
 *                                                 .build())
 *                                         .constantType("constantType")
 *                                         .singularConstant("singularConstant")
 *                                         .build())
 *                                 .inverse(false)
 *                                 .build())
 *                         .dateRangeFilter(TopicDateRangeFilterProperty.builder()
 *                                 .constant(TopicRangeFilterConstantProperty.builder()
 *                                         .constantType("constantType")
 *                                         .rangeConstant(RangeConstantProperty.builder()
 *                                                 .maximum("maximum")
 *                                                 .minimum("minimum")
 *                                                 .build())
 *                                         .build())
 *                                 .inclusive(false)
 *                                 .build())
 *                         .filterClass("filterClass")
 *                         .filterDescription("filterDescription")
 *                         .filterSynonyms(List.of("filterSynonyms"))
 *                         .filterType("filterType")
 *                         .numericEqualityFilter(TopicNumericEqualityFilterProperty.builder()
 *                                 .aggregation("aggregation")
 *                                 .constant(TopicSingularFilterConstantProperty.builder()
 *                                         .constantType("constantType")
 *                                         .singularConstant("singularConstant")
 *                                         .build())
 *                                 .build())
 *                         .numericRangeFilter(TopicNumericRangeFilterProperty.builder()
 *                                 .aggregation("aggregation")
 *                                 .constant(TopicRangeFilterConstantProperty.builder()
 *                                         .constantType("constantType")
 *                                         .rangeConstant(RangeConstantProperty.builder()
 *                                                 .maximum("maximum")
 *                                                 .minimum("minimum")
 *                                                 .build())
 *                                         .build())
 *                                 .inclusive(false)
 *                                 .build())
 *                         .relativeDateFilter(TopicRelativeDateFilterProperty.builder()
 *                                 .constant(TopicSingularFilterConstantProperty.builder()
 *                                         .constantType("constantType")
 *                                         .singularConstant("singularConstant")
 *                                         .build())
 *                                 .relativeDateFilterFunction("relativeDateFilterFunction")
 *                                 .timeGranularity("timeGranularity")
 *                                 .build())
 *                         .build()))
 *                 .namedEntities(List.of(TopicNamedEntityProperty.builder()
 *                         .entityName("entityName")
 *                         // the properties below are optional
 *                         .definition(List.of(NamedEntityDefinitionProperty.builder()
 *                                 .fieldName("fieldName")
 *                                 .metric(NamedEntityDefinitionMetricProperty.builder()
 *                                         .aggregation("aggregation")
 *                                         .aggregationFunctionParameters(Map.of(
 *                                                 "aggregationFunctionParametersKey", "aggregationFunctionParameters"))
 *                                         .build())
 *                                 .propertyName("propertyName")
 *                                 .propertyRole("propertyRole")
 *                                 .propertyUsage("propertyUsage")
 *                                 .build()))
 *                         .entityDescription("entityDescription")
 *                         .entitySynonyms(List.of("entitySynonyms"))
 *                         .semanticEntityType(SemanticEntityTypeProperty.builder()
 *                                 .subTypeName("subTypeName")
 *                                 .typeName("typeName")
 *                                 .typeParameters(Map.of(
 *                                         "typeParametersKey", "typeParameters"))
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .description("description")
 *         .folderArns(List.of("folderArns"))
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .topicId("topicId")
 *         .userExperienceVersion("userExperienceVersion")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.014Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic")
public class CfnTopic extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.quicksight.ITopicRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnTopic(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTopic(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.quicksight.CfnTopic.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTopic(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnTopicProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTopic(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Topic resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.quicksight.TopicReference getTopicRef() {
        return software.amazon.jsii.Kernel.get(this, "topicRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.quicksight.TopicReference.class));
    }

    /**
     * The ID of the AWS account that you want to create a topic in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
        return software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the AWS account that you want to create a topic in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAwsAccountId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "awsAccountId", value);
    }

    /**
     * Configuration options for a <code>Topic</code> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicConfigOptionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigOptions() {
        return software.amazon.jsii.Kernel.get(this, "configOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration options for a <code>Topic</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configOptions", value);
    }

    /**
     * Configuration options for a <code>Topic</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnTopic.TopicConfigOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "configOptions", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.CustomInstructionsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomInstructions() {
        return software.amazon.jsii.Kernel.get(this, "customInstructions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomInstructions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customInstructions", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomInstructions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.quicksight.CfnTopic.CustomInstructionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "customInstructions", value);
    }

    /**
     * The data sets that the topic is associated with.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.DatasetMetadataProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataSets() {
        return software.amazon.jsii.Kernel.get(this, "dataSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The data sets that the topic is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataSets", value);
    }

    /**
     * The data sets that the topic is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSets(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.quicksight.CfnTopic.DatasetMetadataProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.quicksight.CfnTopic.DatasetMetadataProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "dataSets", value);
    }

    /**
     * The description of the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFolderArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "folderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFolderArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "folderArns", value);
    }

    /**
     * The name of the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The ID for the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTopicId() {
        return software.amazon.jsii.Kernel.get(this, "topicId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID for the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "topicId", value);
    }

    /**
     * The user experience version of the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUserExperienceVersion() {
        return software.amazon.jsii.Kernel.get(this, "userExperienceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user experience version of the topic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserExperienceVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userExperienceVersion", value);
    }
    /**
     * A structure that represents the cell value synonym.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CellValueSynonymProperty cellValueSynonymProperty = CellValueSynonymProperty.builder()
     *         .cellValue("cellValue")
     *         .synonyms(List.of("synonyms"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-cellvaluesynonym.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-cellvaluesynonym.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.CellValueSynonymProperty")
    @software.amazon.jsii.Jsii.Proxy(CellValueSynonymProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CellValueSynonymProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cell value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-cellvaluesynonym.html#cfn-quicksight-topic-cellvaluesynonym-cellvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-cellvaluesynonym.html#cfn-quicksight-topic-cellvaluesynonym-cellvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCellValue() {
            return null;
        }

        /**
         * Other names or aliases for the cell value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-cellvaluesynonym.html#cfn-quicksight-topic-cellvaluesynonym-synonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-cellvaluesynonym.html#cfn-quicksight-topic-cellvaluesynonym-synonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSynonyms() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CellValueSynonymProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CellValueSynonymProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CellValueSynonymProperty> {
            java.lang.String cellValue;
            java.util.List<java.lang.String> synonyms;

            /**
             * Sets the value of {@link CellValueSynonymProperty#getCellValue}
             * @param cellValue The cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cellValue(java.lang.String cellValue) {
                this.cellValue = cellValue;
                return this;
            }

            /**
             * Sets the value of {@link CellValueSynonymProperty#getSynonyms}
             * @param synonyms Other names or aliases for the cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder synonyms(java.util.List<java.lang.String> synonyms) {
                this.synonyms = synonyms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CellValueSynonymProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CellValueSynonymProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CellValueSynonymProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CellValueSynonymProperty {
            private final java.lang.String cellValue;
            private final java.util.List<java.lang.String> synonyms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cellValue = software.amazon.jsii.Kernel.get(this, "cellValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.synonyms = software.amazon.jsii.Kernel.get(this, "synonyms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cellValue = builder.cellValue;
                this.synonyms = builder.synonyms;
            }

            @Override
            public final java.lang.String getCellValue() {
                return this.cellValue;
            }

            @Override
            public final java.util.List<java.lang.String> getSynonyms() {
                return this.synonyms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCellValue() != null) {
                    data.set("cellValue", om.valueToTree(this.getCellValue()));
                }
                if (this.getSynonyms() != null) {
                    data.set("synonyms", om.valueToTree(this.getSynonyms()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.CellValueSynonymProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CellValueSynonymProperty.Jsii$Proxy that = (CellValueSynonymProperty.Jsii$Proxy) o;

                if (this.cellValue != null ? !this.cellValue.equals(that.cellValue) : that.cellValue != null) return false;
                return this.synonyms != null ? this.synonyms.equals(that.synonyms) : that.synonyms == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cellValue != null ? this.cellValue.hashCode() : 0;
                result = 31 * result + (this.synonyms != null ? this.synonyms.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a collective constant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CollectiveConstantProperty collectiveConstantProperty = CollectiveConstantProperty.builder()
     *         .valueList(List.of("valueList"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-collectiveconstant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-collectiveconstant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.CollectiveConstantProperty")
    @software.amazon.jsii.Jsii.Proxy(CollectiveConstantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CollectiveConstantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of values for the collective constant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-collectiveconstant.html#cfn-quicksight-topic-collectiveconstant-valuelist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-collectiveconstant.html#cfn-quicksight-topic-collectiveconstant-valuelist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValueList() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CollectiveConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CollectiveConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CollectiveConstantProperty> {
            java.util.List<java.lang.String> valueList;

            /**
             * Sets the value of {@link CollectiveConstantProperty#getValueList}
             * @param valueList A list of values for the collective constant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueList(java.util.List<java.lang.String> valueList) {
                this.valueList = valueList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CollectiveConstantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CollectiveConstantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CollectiveConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CollectiveConstantProperty {
            private final java.util.List<java.lang.String> valueList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.valueList = software.amazon.jsii.Kernel.get(this, "valueList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.valueList = builder.valueList;
            }

            @Override
            public final java.util.List<java.lang.String> getValueList() {
                return this.valueList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValueList() != null) {
                    data.set("valueList", om.valueToTree(this.getValueList()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.CollectiveConstantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CollectiveConstantProperty.Jsii$Proxy that = (CollectiveConstantProperty.Jsii$Proxy) o;

                return this.valueList != null ? this.valueList.equals(that.valueList) : that.valueList == null;
            }

            @Override
            public final int hashCode() {
                int result = this.valueList != null ? this.valueList.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The order in which data is displayed for the column when it's used in a comparative context.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * ComparativeOrderProperty comparativeOrderProperty = ComparativeOrderProperty.builder()
     *         .specifedOrder(List.of("specifedOrder"))
     *         .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
     *         .useOrdering("useOrdering")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-comparativeorder.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-comparativeorder.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.ComparativeOrderProperty")
    @software.amazon.jsii.Jsii.Proxy(ComparativeOrderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComparativeOrderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of columns to be used in the ordering.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-comparativeorder.html#cfn-quicksight-topic-comparativeorder-specifedorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-comparativeorder.html#cfn-quicksight-topic-comparativeorder-specifedorder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSpecifedOrder() {
            return null;
        }

        /**
         * The treat of undefined specified values.
         * <p>
         * Valid values for this structure are <code>LEAST</code> and <code>MOST</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-comparativeorder.html#cfn-quicksight-topic-comparativeorder-treatundefinedspecifiedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-comparativeorder.html#cfn-quicksight-topic-comparativeorder-treatundefinedspecifiedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTreatUndefinedSpecifiedValues() {
            return null;
        }

        /**
         * The ordering type for a column.
         * <p>
         * Valid values for this structure are <code>GREATER_IS_BETTER</code> , <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-comparativeorder.html#cfn-quicksight-topic-comparativeorder-useordering">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-comparativeorder.html#cfn-quicksight-topic-comparativeorder-useordering</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUseOrdering() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComparativeOrderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComparativeOrderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComparativeOrderProperty> {
            java.util.List<java.lang.String> specifedOrder;
            java.lang.String treatUndefinedSpecifiedValues;
            java.lang.String useOrdering;

            /**
             * Sets the value of {@link ComparativeOrderProperty#getSpecifedOrder}
             * @param specifedOrder The list of columns to be used in the ordering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder specifedOrder(java.util.List<java.lang.String> specifedOrder) {
                this.specifedOrder = specifedOrder;
                return this;
            }

            /**
             * Sets the value of {@link ComparativeOrderProperty#getTreatUndefinedSpecifiedValues}
             * @param treatUndefinedSpecifiedValues The treat of undefined specified values.
             *                                      Valid values for this structure are <code>LEAST</code> and <code>MOST</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder treatUndefinedSpecifiedValues(java.lang.String treatUndefinedSpecifiedValues) {
                this.treatUndefinedSpecifiedValues = treatUndefinedSpecifiedValues;
                return this;
            }

            /**
             * Sets the value of {@link ComparativeOrderProperty#getUseOrdering}
             * @param useOrdering The ordering type for a column.
             *                    Valid values for this structure are <code>GREATER_IS_BETTER</code> , <code>LESSER_IS_BETTER</code> and <code>SPECIFIED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useOrdering(java.lang.String useOrdering) {
                this.useOrdering = useOrdering;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComparativeOrderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComparativeOrderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComparativeOrderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComparativeOrderProperty {
            private final java.util.List<java.lang.String> specifedOrder;
            private final java.lang.String treatUndefinedSpecifiedValues;
            private final java.lang.String useOrdering;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.specifedOrder = software.amazon.jsii.Kernel.get(this, "specifedOrder", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.treatUndefinedSpecifiedValues = software.amazon.jsii.Kernel.get(this, "treatUndefinedSpecifiedValues", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useOrdering = software.amazon.jsii.Kernel.get(this, "useOrdering", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.specifedOrder = builder.specifedOrder;
                this.treatUndefinedSpecifiedValues = builder.treatUndefinedSpecifiedValues;
                this.useOrdering = builder.useOrdering;
            }

            @Override
            public final java.util.List<java.lang.String> getSpecifedOrder() {
                return this.specifedOrder;
            }

            @Override
            public final java.lang.String getTreatUndefinedSpecifiedValues() {
                return this.treatUndefinedSpecifiedValues;
            }

            @Override
            public final java.lang.String getUseOrdering() {
                return this.useOrdering;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSpecifedOrder() != null) {
                    data.set("specifedOrder", om.valueToTree(this.getSpecifedOrder()));
                }
                if (this.getTreatUndefinedSpecifiedValues() != null) {
                    data.set("treatUndefinedSpecifiedValues", om.valueToTree(this.getTreatUndefinedSpecifiedValues()));
                }
                if (this.getUseOrdering() != null) {
                    data.set("useOrdering", om.valueToTree(this.getUseOrdering()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.ComparativeOrderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComparativeOrderProperty.Jsii$Proxy that = (ComparativeOrderProperty.Jsii$Proxy) o;

                if (this.specifedOrder != null ? !this.specifedOrder.equals(that.specifedOrder) : that.specifedOrder != null) return false;
                if (this.treatUndefinedSpecifiedValues != null ? !this.treatUndefinedSpecifiedValues.equals(that.treatUndefinedSpecifiedValues) : that.treatUndefinedSpecifiedValues != null) return false;
                return this.useOrdering != null ? this.useOrdering.equals(that.useOrdering) : that.useOrdering == null;
            }

            @Override
            public final int hashCode() {
                int result = this.specifedOrder != null ? this.specifedOrder.hashCode() : 0;
                result = 31 * result + (this.treatUndefinedSpecifiedValues != null ? this.treatUndefinedSpecifiedValues.hashCode() : 0);
                result = 31 * result + (this.useOrdering != null ? this.useOrdering.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * CustomInstructionsProperty customInstructionsProperty = CustomInstructionsProperty.builder()
     *         .customInstructionsString("customInstructionsString")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-custominstructions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-custominstructions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.CustomInstructionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomInstructionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomInstructionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-custominstructions.html#cfn-quicksight-topic-custominstructions-custominstructionsstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-custominstructions.html#cfn-quicksight-topic-custominstructions-custominstructionsstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCustomInstructionsString();

        /**
         * @return a {@link Builder} of {@link CustomInstructionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomInstructionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomInstructionsProperty> {
            java.lang.String customInstructionsString;

            /**
             * Sets the value of {@link CustomInstructionsProperty#getCustomInstructionsString}
             * @param customInstructionsString the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customInstructionsString(java.lang.String customInstructionsString) {
                this.customInstructionsString = customInstructionsString;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomInstructionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomInstructionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomInstructionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomInstructionsProperty {
            private final java.lang.String customInstructionsString;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customInstructionsString = software.amazon.jsii.Kernel.get(this, "customInstructionsString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customInstructionsString = java.util.Objects.requireNonNull(builder.customInstructionsString, "customInstructionsString is required");
            }

            @Override
            public final java.lang.String getCustomInstructionsString() {
                return this.customInstructionsString;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("customInstructionsString", om.valueToTree(this.getCustomInstructionsString()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.CustomInstructionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomInstructionsProperty.Jsii$Proxy that = (CustomInstructionsProperty.Jsii$Proxy) o;

                return this.customInstructionsString.equals(that.customInstructionsString);
            }

            @Override
            public final int hashCode() {
                int result = this.customInstructionsString.hashCode();
                return result;
            }
        }
    }
    /**
     * The definition of a data aggregation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DataAggregationProperty dataAggregationProperty = DataAggregationProperty.builder()
     *         .datasetRowDateGranularity("datasetRowDateGranularity")
     *         .defaultDateColumnName("defaultDateColumnName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-dataaggregation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-dataaggregation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.DataAggregationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataAggregationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataAggregationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-dataaggregation.html#cfn-quicksight-topic-dataaggregation-datasetrowdategranularity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-dataaggregation.html#cfn-quicksight-topic-dataaggregation-datasetrowdategranularity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatasetRowDateGranularity() {
            return null;
        }

        /**
         * The column name for the default date.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-dataaggregation.html#cfn-quicksight-topic-dataaggregation-defaultdatecolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-dataaggregation.html#cfn-quicksight-topic-dataaggregation-defaultdatecolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultDateColumnName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataAggregationProperty> {
            java.lang.String datasetRowDateGranularity;
            java.lang.String defaultDateColumnName;

            /**
             * Sets the value of {@link DataAggregationProperty#getDatasetRowDateGranularity}
             * @param datasetRowDateGranularity The level of time precision that is used to aggregate <code>DateTime</code> values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetRowDateGranularity(java.lang.String datasetRowDateGranularity) {
                this.datasetRowDateGranularity = datasetRowDateGranularity;
                return this;
            }

            /**
             * Sets the value of {@link DataAggregationProperty#getDefaultDateColumnName}
             * @param defaultDateColumnName The column name for the default date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultDateColumnName(java.lang.String defaultDateColumnName) {
                this.defaultDateColumnName = defaultDateColumnName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataAggregationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataAggregationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataAggregationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataAggregationProperty {
            private final java.lang.String datasetRowDateGranularity;
            private final java.lang.String defaultDateColumnName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datasetRowDateGranularity = software.amazon.jsii.Kernel.get(this, "datasetRowDateGranularity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultDateColumnName = software.amazon.jsii.Kernel.get(this, "defaultDateColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datasetRowDateGranularity = builder.datasetRowDateGranularity;
                this.defaultDateColumnName = builder.defaultDateColumnName;
            }

            @Override
            public final java.lang.String getDatasetRowDateGranularity() {
                return this.datasetRowDateGranularity;
            }

            @Override
            public final java.lang.String getDefaultDateColumnName() {
                return this.defaultDateColumnName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatasetRowDateGranularity() != null) {
                    data.set("datasetRowDateGranularity", om.valueToTree(this.getDatasetRowDateGranularity()));
                }
                if (this.getDefaultDateColumnName() != null) {
                    data.set("defaultDateColumnName", om.valueToTree(this.getDefaultDateColumnName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.DataAggregationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataAggregationProperty.Jsii$Proxy that = (DataAggregationProperty.Jsii$Proxy) o;

                if (this.datasetRowDateGranularity != null ? !this.datasetRowDateGranularity.equals(that.datasetRowDateGranularity) : that.datasetRowDateGranularity != null) return false;
                return this.defaultDateColumnName != null ? this.defaultDateColumnName.equals(that.defaultDateColumnName) : that.defaultDateColumnName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.datasetRowDateGranularity != null ? this.datasetRowDateGranularity.hashCode() : 0;
                result = 31 * result + (this.defaultDateColumnName != null ? this.defaultDateColumnName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DatasetMetadataProperty datasetMetadataProperty = DatasetMetadataProperty.builder()
     *         .datasetArn("datasetArn")
     *         // the properties below are optional
     *         .calculatedFields(List.of(TopicCalculatedFieldProperty.builder()
     *                 .calculatedFieldName("calculatedFieldName")
     *                 .expression("expression")
     *                 // the properties below are optional
     *                 .aggregation("aggregation")
     *                 .allowedAggregations(List.of("allowedAggregations"))
     *                 .calculatedFieldDescription("calculatedFieldDescription")
     *                 .calculatedFieldSynonyms(List.of("calculatedFieldSynonyms"))
     *                 .cellValueSynonyms(List.of(CellValueSynonymProperty.builder()
     *                         .cellValue("cellValue")
     *                         .synonyms(List.of("synonyms"))
     *                         .build()))
     *                 .columnDataRole("columnDataRole")
     *                 .comparativeOrder(ComparativeOrderProperty.builder()
     *                         .specifedOrder(List.of("specifedOrder"))
     *                         .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
     *                         .useOrdering("useOrdering")
     *                         .build())
     *                 .defaultFormatting(DefaultFormattingProperty.builder()
     *                         .displayFormat("displayFormat")
     *                         .displayFormatOptions(DisplayFormatOptionsProperty.builder()
     *                                 .blankCellFormat("blankCellFormat")
     *                                 .currencySymbol("currencySymbol")
     *                                 .dateFormat("dateFormat")
     *                                 .decimalSeparator("decimalSeparator")
     *                                 .fractionDigits(123)
     *                                 .groupingSeparator("groupingSeparator")
     *                                 .negativeFormat(NegativeFormatProperty.builder()
     *                                         .prefix("prefix")
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .prefix("prefix")
     *                                 .suffix("suffix")
     *                                 .unitScaler("unitScaler")
     *                                 .useBlankCellFormat(false)
     *                                 .useGrouping(false)
     *                                 .build())
     *                         .build())
     *                 .disableIndexing(false)
     *                 .isIncludedInTopic(false)
     *                 .neverAggregateInFilter(false)
     *                 .nonAdditive(false)
     *                 .notAllowedAggregations(List.of("notAllowedAggregations"))
     *                 .semanticType(SemanticTypeProperty.builder()
     *                         .falseyCellValue("falseyCellValue")
     *                         .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
     *                         .subTypeName("subTypeName")
     *                         .truthyCellValue("truthyCellValue")
     *                         .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
     *                         .typeName("typeName")
     *                         .typeParameters(Map.of(
     *                                 "typeParametersKey", "typeParameters"))
     *                         .build())
     *                 .timeGranularity("timeGranularity")
     *                 .build()))
     *         .columns(List.of(TopicColumnProperty.builder()
     *                 .columnName("columnName")
     *                 // the properties below are optional
     *                 .aggregation("aggregation")
     *                 .allowedAggregations(List.of("allowedAggregations"))
     *                 .cellValueSynonyms(List.of(CellValueSynonymProperty.builder()
     *                         .cellValue("cellValue")
     *                         .synonyms(List.of("synonyms"))
     *                         .build()))
     *                 .columnDataRole("columnDataRole")
     *                 .columnDescription("columnDescription")
     *                 .columnFriendlyName("columnFriendlyName")
     *                 .columnSynonyms(List.of("columnSynonyms"))
     *                 .comparativeOrder(ComparativeOrderProperty.builder()
     *                         .specifedOrder(List.of("specifedOrder"))
     *                         .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
     *                         .useOrdering("useOrdering")
     *                         .build())
     *                 .defaultFormatting(DefaultFormattingProperty.builder()
     *                         .displayFormat("displayFormat")
     *                         .displayFormatOptions(DisplayFormatOptionsProperty.builder()
     *                                 .blankCellFormat("blankCellFormat")
     *                                 .currencySymbol("currencySymbol")
     *                                 .dateFormat("dateFormat")
     *                                 .decimalSeparator("decimalSeparator")
     *                                 .fractionDigits(123)
     *                                 .groupingSeparator("groupingSeparator")
     *                                 .negativeFormat(NegativeFormatProperty.builder()
     *                                         .prefix("prefix")
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .prefix("prefix")
     *                                 .suffix("suffix")
     *                                 .unitScaler("unitScaler")
     *                                 .useBlankCellFormat(false)
     *                                 .useGrouping(false)
     *                                 .build())
     *                         .build())
     *                 .disableIndexing(false)
     *                 .isIncludedInTopic(false)
     *                 .neverAggregateInFilter(false)
     *                 .nonAdditive(false)
     *                 .notAllowedAggregations(List.of("notAllowedAggregations"))
     *                 .semanticType(SemanticTypeProperty.builder()
     *                         .falseyCellValue("falseyCellValue")
     *                         .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
     *                         .subTypeName("subTypeName")
     *                         .truthyCellValue("truthyCellValue")
     *                         .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
     *                         .typeName("typeName")
     *                         .typeParameters(Map.of(
     *                                 "typeParametersKey", "typeParameters"))
     *                         .build())
     *                 .timeGranularity("timeGranularity")
     *                 .build()))
     *         .dataAggregation(DataAggregationProperty.builder()
     *                 .datasetRowDateGranularity("datasetRowDateGranularity")
     *                 .defaultDateColumnName("defaultDateColumnName")
     *                 .build())
     *         .datasetDescription("datasetDescription")
     *         .datasetName("datasetName")
     *         .filters(List.of(TopicFilterProperty.builder()
     *                 .filterName("filterName")
     *                 .operandFieldName("operandFieldName")
     *                 // the properties below are optional
     *                 .categoryFilter(TopicCategoryFilterProperty.builder()
     *                         .categoryFilterFunction("categoryFilterFunction")
     *                         .categoryFilterType("categoryFilterType")
     *                         .constant(TopicCategoryFilterConstantProperty.builder()
     *                                 .collectiveConstant(CollectiveConstantProperty.builder()
     *                                         .valueList(List.of("valueList"))
     *                                         .build())
     *                                 .constantType("constantType")
     *                                 .singularConstant("singularConstant")
     *                                 .build())
     *                         .inverse(false)
     *                         .build())
     *                 .dateRangeFilter(TopicDateRangeFilterProperty.builder()
     *                         .constant(TopicRangeFilterConstantProperty.builder()
     *                                 .constantType("constantType")
     *                                 .rangeConstant(RangeConstantProperty.builder()
     *                                         .maximum("maximum")
     *                                         .minimum("minimum")
     *                                         .build())
     *                                 .build())
     *                         .inclusive(false)
     *                         .build())
     *                 .filterClass("filterClass")
     *                 .filterDescription("filterDescription")
     *                 .filterSynonyms(List.of("filterSynonyms"))
     *                 .filterType("filterType")
     *                 .numericEqualityFilter(TopicNumericEqualityFilterProperty.builder()
     *                         .aggregation("aggregation")
     *                         .constant(TopicSingularFilterConstantProperty.builder()
     *                                 .constantType("constantType")
     *                                 .singularConstant("singularConstant")
     *                                 .build())
     *                         .build())
     *                 .numericRangeFilter(TopicNumericRangeFilterProperty.builder()
     *                         .aggregation("aggregation")
     *                         .constant(TopicRangeFilterConstantProperty.builder()
     *                                 .constantType("constantType")
     *                                 .rangeConstant(RangeConstantProperty.builder()
     *                                         .maximum("maximum")
     *                                         .minimum("minimum")
     *                                         .build())
     *                                 .build())
     *                         .inclusive(false)
     *                         .build())
     *                 .relativeDateFilter(TopicRelativeDateFilterProperty.builder()
     *                         .constant(TopicSingularFilterConstantProperty.builder()
     *                                 .constantType("constantType")
     *                                 .singularConstant("singularConstant")
     *                                 .build())
     *                         .relativeDateFilterFunction("relativeDateFilterFunction")
     *                         .timeGranularity("timeGranularity")
     *                         .build())
     *                 .build()))
     *         .namedEntities(List.of(TopicNamedEntityProperty.builder()
     *                 .entityName("entityName")
     *                 // the properties below are optional
     *                 .definition(List.of(NamedEntityDefinitionProperty.builder()
     *                         .fieldName("fieldName")
     *                         .metric(NamedEntityDefinitionMetricProperty.builder()
     *                                 .aggregation("aggregation")
     *                                 .aggregationFunctionParameters(Map.of(
     *                                         "aggregationFunctionParametersKey", "aggregationFunctionParameters"))
     *                                 .build())
     *                         .propertyName("propertyName")
     *                         .propertyRole("propertyRole")
     *                         .propertyUsage("propertyUsage")
     *                         .build()))
     *                 .entityDescription("entityDescription")
     *                 .entitySynonyms(List.of("entitySynonyms"))
     *                 .semanticEntityType(SemanticEntityTypeProperty.builder()
     *                         .subTypeName("subTypeName")
     *                         .typeName("typeName")
     *                         .typeParameters(Map.of(
     *                                 "typeParametersKey", "typeParameters"))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.DatasetMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-datasetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-datasetarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatasetArn();

        /**
         * The list of calculated field definitions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicCalculatedFieldProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-calculatedfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-calculatedfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCalculatedFields() {
            return null;
        }

        /**
         * The list of column definitions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicColumnProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumns() {
            return null;
        }

        /**
         * The definition of a data aggregation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.DataAggregationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-dataaggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-dataaggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataAggregation() {
            return null;
        }

        /**
         * The description of the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-datasetdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-datasetdescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatasetDescription() {
            return null;
        }

        /**
         * The name of the dataset.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-datasetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-datasetname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatasetName() {
            return null;
        }

        /**
         * The list of filter definitions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicFilterProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-filters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-filters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilters() {
            return null;
        }

        /**
         * The list of named entities definitions.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicNamedEntityProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-namedentities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-datasetmetadata.html#cfn-quicksight-topic-datasetmetadata-namedentities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNamedEntities() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetMetadataProperty> {
            java.lang.String datasetArn;
            java.lang.Object calculatedFields;
            java.lang.Object columns;
            java.lang.Object dataAggregation;
            java.lang.String datasetDescription;
            java.lang.String datasetName;
            java.lang.Object filters;
            java.lang.Object namedEntities;

            /**
             * Sets the value of {@link DatasetMetadataProperty#getDatasetArn}
             * @param datasetArn The Amazon Resource Name (ARN) of the dataset. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetArn(java.lang.String datasetArn) {
                this.datasetArn = datasetArn;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getCalculatedFields}
             * @param calculatedFields The list of calculated field definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedFields(software.amazon.awscdk.IResolvable calculatedFields) {
                this.calculatedFields = calculatedFields;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getCalculatedFields}
             * @param calculatedFields The list of calculated field definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedFields(java.util.List<? extends java.lang.Object> calculatedFields) {
                this.calculatedFields = calculatedFields;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getColumns}
             * @param columns The list of column definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getColumns}
             * @param columns The list of column definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getDataAggregation}
             * @param dataAggregation The definition of a data aggregation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataAggregation(software.amazon.awscdk.IResolvable dataAggregation) {
                this.dataAggregation = dataAggregation;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getDataAggregation}
             * @param dataAggregation The definition of a data aggregation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataAggregation(software.amazon.awscdk.services.quicksight.CfnTopic.DataAggregationProperty dataAggregation) {
                this.dataAggregation = dataAggregation;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getDatasetDescription}
             * @param datasetDescription The description of the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetDescription(java.lang.String datasetDescription) {
                this.datasetDescription = datasetDescription;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getDatasetName}
             * @param datasetName The name of the dataset.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetName(java.lang.String datasetName) {
                this.datasetName = datasetName;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getFilters}
             * @param filters The list of filter definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(software.amazon.awscdk.IResolvable filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getFilters}
             * @param filters The list of filter definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filters(java.util.List<? extends java.lang.Object> filters) {
                this.filters = filters;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getNamedEntities}
             * @param namedEntities The list of named entities definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namedEntities(software.amazon.awscdk.IResolvable namedEntities) {
                this.namedEntities = namedEntities;
                return this;
            }

            /**
             * Sets the value of {@link DatasetMetadataProperty#getNamedEntities}
             * @param namedEntities The list of named entities definitions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namedEntities(java.util.List<? extends java.lang.Object> namedEntities) {
                this.namedEntities = namedEntities;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetMetadataProperty {
            private final java.lang.String datasetArn;
            private final java.lang.Object calculatedFields;
            private final java.lang.Object columns;
            private final java.lang.Object dataAggregation;
            private final java.lang.String datasetDescription;
            private final java.lang.String datasetName;
            private final java.lang.Object filters;
            private final java.lang.Object namedEntities;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datasetArn = software.amazon.jsii.Kernel.get(this, "datasetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.calculatedFields = software.amazon.jsii.Kernel.get(this, "calculatedFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataAggregation = software.amazon.jsii.Kernel.get(this, "dataAggregation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datasetDescription = software.amazon.jsii.Kernel.get(this, "datasetDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datasetName = software.amazon.jsii.Kernel.get(this, "datasetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filters = software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namedEntities = software.amazon.jsii.Kernel.get(this, "namedEntities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datasetArn = java.util.Objects.requireNonNull(builder.datasetArn, "datasetArn is required");
                this.calculatedFields = builder.calculatedFields;
                this.columns = builder.columns;
                this.dataAggregation = builder.dataAggregation;
                this.datasetDescription = builder.datasetDescription;
                this.datasetName = builder.datasetName;
                this.filters = builder.filters;
                this.namedEntities = builder.namedEntities;
            }

            @Override
            public final java.lang.String getDatasetArn() {
                return this.datasetArn;
            }

            @Override
            public final java.lang.Object getCalculatedFields() {
                return this.calculatedFields;
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.Object getDataAggregation() {
                return this.dataAggregation;
            }

            @Override
            public final java.lang.String getDatasetDescription() {
                return this.datasetDescription;
            }

            @Override
            public final java.lang.String getDatasetName() {
                return this.datasetName;
            }

            @Override
            public final java.lang.Object getFilters() {
                return this.filters;
            }

            @Override
            public final java.lang.Object getNamedEntities() {
                return this.namedEntities;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("datasetArn", om.valueToTree(this.getDatasetArn()));
                if (this.getCalculatedFields() != null) {
                    data.set("calculatedFields", om.valueToTree(this.getCalculatedFields()));
                }
                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }
                if (this.getDataAggregation() != null) {
                    data.set("dataAggregation", om.valueToTree(this.getDataAggregation()));
                }
                if (this.getDatasetDescription() != null) {
                    data.set("datasetDescription", om.valueToTree(this.getDatasetDescription()));
                }
                if (this.getDatasetName() != null) {
                    data.set("datasetName", om.valueToTree(this.getDatasetName()));
                }
                if (this.getFilters() != null) {
                    data.set("filters", om.valueToTree(this.getFilters()));
                }
                if (this.getNamedEntities() != null) {
                    data.set("namedEntities", om.valueToTree(this.getNamedEntities()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.DatasetMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetMetadataProperty.Jsii$Proxy that = (DatasetMetadataProperty.Jsii$Proxy) o;

                if (!datasetArn.equals(that.datasetArn)) return false;
                if (this.calculatedFields != null ? !this.calculatedFields.equals(that.calculatedFields) : that.calculatedFields != null) return false;
                if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
                if (this.dataAggregation != null ? !this.dataAggregation.equals(that.dataAggregation) : that.dataAggregation != null) return false;
                if (this.datasetDescription != null ? !this.datasetDescription.equals(that.datasetDescription) : that.datasetDescription != null) return false;
                if (this.datasetName != null ? !this.datasetName.equals(that.datasetName) : that.datasetName != null) return false;
                if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) return false;
                return this.namedEntities != null ? this.namedEntities.equals(that.namedEntities) : that.namedEntities == null;
            }

            @Override
            public final int hashCode() {
                int result = this.datasetArn.hashCode();
                result = 31 * result + (this.calculatedFields != null ? this.calculatedFields.hashCode() : 0);
                result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
                result = 31 * result + (this.dataAggregation != null ? this.dataAggregation.hashCode() : 0);
                result = 31 * result + (this.datasetDescription != null ? this.datasetDescription.hashCode() : 0);
                result = 31 * result + (this.datasetName != null ? this.datasetName.hashCode() : 0);
                result = 31 * result + (this.filters != null ? this.filters.hashCode() : 0);
                result = 31 * result + (this.namedEntities != null ? this.namedEntities.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a default formatting definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DefaultFormattingProperty defaultFormattingProperty = DefaultFormattingProperty.builder()
     *         .displayFormat("displayFormat")
     *         .displayFormatOptions(DisplayFormatOptionsProperty.builder()
     *                 .blankCellFormat("blankCellFormat")
     *                 .currencySymbol("currencySymbol")
     *                 .dateFormat("dateFormat")
     *                 .decimalSeparator("decimalSeparator")
     *                 .fractionDigits(123)
     *                 .groupingSeparator("groupingSeparator")
     *                 .negativeFormat(NegativeFormatProperty.builder()
     *                         .prefix("prefix")
     *                         .suffix("suffix")
     *                         .build())
     *                 .prefix("prefix")
     *                 .suffix("suffix")
     *                 .unitScaler("unitScaler")
     *                 .useBlankCellFormat(false)
     *                 .useGrouping(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-defaultformatting.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-defaultformatting.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.DefaultFormattingProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultFormattingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultFormattingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The display format.
         * <p>
         * Valid values for this structure are <code>AUTO</code> , <code>PERCENT</code> , <code>CURRENCY</code> , <code>NUMBER</code> , <code>DATE</code> , and <code>STRING</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-defaultformatting.html#cfn-quicksight-topic-defaultformatting-displayformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-defaultformatting.html#cfn-quicksight-topic-defaultformatting-displayformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisplayFormat() {
            return null;
        }

        /**
         * The additional options for display formatting.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.DisplayFormatOptionsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-defaultformatting.html#cfn-quicksight-topic-defaultformatting-displayformatoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-defaultformatting.html#cfn-quicksight-topic-defaultformatting-displayformatoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisplayFormatOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultFormattingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultFormattingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultFormattingProperty> {
            java.lang.String displayFormat;
            java.lang.Object displayFormatOptions;

            /**
             * Sets the value of {@link DefaultFormattingProperty#getDisplayFormat}
             * @param displayFormat The display format.
             *                      Valid values for this structure are <code>AUTO</code> , <code>PERCENT</code> , <code>CURRENCY</code> , <code>NUMBER</code> , <code>DATE</code> , and <code>STRING</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayFormat(java.lang.String displayFormat) {
                this.displayFormat = displayFormat;
                return this;
            }

            /**
             * Sets the value of {@link DefaultFormattingProperty#getDisplayFormatOptions}
             * @param displayFormatOptions The additional options for display formatting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayFormatOptions(software.amazon.awscdk.IResolvable displayFormatOptions) {
                this.displayFormatOptions = displayFormatOptions;
                return this;
            }

            /**
             * Sets the value of {@link DefaultFormattingProperty#getDisplayFormatOptions}
             * @param displayFormatOptions The additional options for display formatting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayFormatOptions(software.amazon.awscdk.services.quicksight.CfnTopic.DisplayFormatOptionsProperty displayFormatOptions) {
                this.displayFormatOptions = displayFormatOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultFormattingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultFormattingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultFormattingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultFormattingProperty {
            private final java.lang.String displayFormat;
            private final java.lang.Object displayFormatOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.displayFormat = software.amazon.jsii.Kernel.get(this, "displayFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.displayFormatOptions = software.amazon.jsii.Kernel.get(this, "displayFormatOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.displayFormat = builder.displayFormat;
                this.displayFormatOptions = builder.displayFormatOptions;
            }

            @Override
            public final java.lang.String getDisplayFormat() {
                return this.displayFormat;
            }

            @Override
            public final java.lang.Object getDisplayFormatOptions() {
                return this.displayFormatOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDisplayFormat() != null) {
                    data.set("displayFormat", om.valueToTree(this.getDisplayFormat()));
                }
                if (this.getDisplayFormatOptions() != null) {
                    data.set("displayFormatOptions", om.valueToTree(this.getDisplayFormatOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.DefaultFormattingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultFormattingProperty.Jsii$Proxy that = (DefaultFormattingProperty.Jsii$Proxy) o;

                if (this.displayFormat != null ? !this.displayFormat.equals(that.displayFormat) : that.displayFormat != null) return false;
                return this.displayFormatOptions != null ? this.displayFormatOptions.equals(that.displayFormatOptions) : that.displayFormatOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.displayFormat != null ? this.displayFormat.hashCode() : 0;
                result = 31 * result + (this.displayFormatOptions != null ? this.displayFormatOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents additional options for display formatting.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * DisplayFormatOptionsProperty displayFormatOptionsProperty = DisplayFormatOptionsProperty.builder()
     *         .blankCellFormat("blankCellFormat")
     *         .currencySymbol("currencySymbol")
     *         .dateFormat("dateFormat")
     *         .decimalSeparator("decimalSeparator")
     *         .fractionDigits(123)
     *         .groupingSeparator("groupingSeparator")
     *         .negativeFormat(NegativeFormatProperty.builder()
     *                 .prefix("prefix")
     *                 .suffix("suffix")
     *                 .build())
     *         .prefix("prefix")
     *         .suffix("suffix")
     *         .unitScaler("unitScaler")
     *         .useBlankCellFormat(false)
     *         .useGrouping(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.DisplayFormatOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DisplayFormatOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DisplayFormatOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the blank cell format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-blankcellformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-blankcellformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBlankCellFormat() {
            return null;
        }

        /**
         * The currency symbol, such as <code>USD</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-currencysymbol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-currencysymbol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCurrencySymbol() {
            return null;
        }

        /**
         * Determines the <code>DateTime</code> format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-dateformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-dateformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDateFormat() {
            return null;
        }

        /**
         * Determines the decimal separator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-decimalseparator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-decimalseparator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDecimalSeparator() {
            return null;
        }

        /**
         * Determines the number of fraction digits.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-fractiondigits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-fractiondigits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFractionDigits() {
            return null;
        }

        /**
         * Determines the grouping separator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-groupingseparator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-groupingseparator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupingSeparator() {
            return null;
        }

        /**
         * The negative format.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.NegativeFormatProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-negativeformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-negativeformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNegativeFormat() {
            return null;
        }

        /**
         * The prefix value for a display format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * The suffix value for a display format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-suffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-suffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuffix() {
            return null;
        }

        /**
         * The unit scaler.
         * <p>
         * Valid values for this structure are: <code>NONE</code> , <code>AUTO</code> , <code>THOUSANDS</code> , <code>MILLIONS</code> , <code>BILLIONS</code> , and <code>TRILLIONS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-unitscaler">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-unitscaler</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnitScaler() {
            return null;
        }

        /**
         * A Boolean value that indicates whether to use blank cell format.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-useblankcellformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-useblankcellformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseBlankCellFormat() {
            return null;
        }

        /**
         * A Boolean value that indicates whether to use grouping.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-usegrouping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-displayformatoptions.html#cfn-quicksight-topic-displayformatoptions-usegrouping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseGrouping() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DisplayFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DisplayFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DisplayFormatOptionsProperty> {
            java.lang.String blankCellFormat;
            java.lang.String currencySymbol;
            java.lang.String dateFormat;
            java.lang.String decimalSeparator;
            java.lang.Number fractionDigits;
            java.lang.String groupingSeparator;
            java.lang.Object negativeFormat;
            java.lang.String prefix;
            java.lang.String suffix;
            java.lang.String unitScaler;
            java.lang.Object useBlankCellFormat;
            java.lang.Object useGrouping;

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getBlankCellFormat}
             * @param blankCellFormat Determines the blank cell format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blankCellFormat(java.lang.String blankCellFormat) {
                this.blankCellFormat = blankCellFormat;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getCurrencySymbol}
             * @param currencySymbol The currency symbol, such as <code>USD</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currencySymbol(java.lang.String currencySymbol) {
                this.currencySymbol = currencySymbol;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getDateFormat}
             * @param dateFormat Determines the <code>DateTime</code> format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateFormat(java.lang.String dateFormat) {
                this.dateFormat = dateFormat;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getDecimalSeparator}
             * @param decimalSeparator Determines the decimal separator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decimalSeparator(java.lang.String decimalSeparator) {
                this.decimalSeparator = decimalSeparator;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getFractionDigits}
             * @param fractionDigits Determines the number of fraction digits.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fractionDigits(java.lang.Number fractionDigits) {
                this.fractionDigits = fractionDigits;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getGroupingSeparator}
             * @param groupingSeparator Determines the grouping separator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupingSeparator(java.lang.String groupingSeparator) {
                this.groupingSeparator = groupingSeparator;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getNegativeFormat}
             * @param negativeFormat The negative format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder negativeFormat(software.amazon.awscdk.IResolvable negativeFormat) {
                this.negativeFormat = negativeFormat;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getNegativeFormat}
             * @param negativeFormat The negative format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder negativeFormat(software.amazon.awscdk.services.quicksight.CfnTopic.NegativeFormatProperty negativeFormat) {
                this.negativeFormat = negativeFormat;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getPrefix}
             * @param prefix The prefix value for a display format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getSuffix}
             * @param suffix The suffix value for a display format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suffix(java.lang.String suffix) {
                this.suffix = suffix;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getUnitScaler}
             * @param unitScaler The unit scaler.
             *                   Valid values for this structure are: <code>NONE</code> , <code>AUTO</code> , <code>THOUSANDS</code> , <code>MILLIONS</code> , <code>BILLIONS</code> , and <code>TRILLIONS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unitScaler(java.lang.String unitScaler) {
                this.unitScaler = unitScaler;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getUseBlankCellFormat}
             * @param useBlankCellFormat A Boolean value that indicates whether to use blank cell format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBlankCellFormat(java.lang.Boolean useBlankCellFormat) {
                this.useBlankCellFormat = useBlankCellFormat;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getUseBlankCellFormat}
             * @param useBlankCellFormat A Boolean value that indicates whether to use blank cell format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useBlankCellFormat(software.amazon.awscdk.IResolvable useBlankCellFormat) {
                this.useBlankCellFormat = useBlankCellFormat;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getUseGrouping}
             * @param useGrouping A Boolean value that indicates whether to use grouping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useGrouping(java.lang.Boolean useGrouping) {
                this.useGrouping = useGrouping;
                return this;
            }

            /**
             * Sets the value of {@link DisplayFormatOptionsProperty#getUseGrouping}
             * @param useGrouping A Boolean value that indicates whether to use grouping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useGrouping(software.amazon.awscdk.IResolvable useGrouping) {
                this.useGrouping = useGrouping;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DisplayFormatOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DisplayFormatOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DisplayFormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DisplayFormatOptionsProperty {
            private final java.lang.String blankCellFormat;
            private final java.lang.String currencySymbol;
            private final java.lang.String dateFormat;
            private final java.lang.String decimalSeparator;
            private final java.lang.Number fractionDigits;
            private final java.lang.String groupingSeparator;
            private final java.lang.Object negativeFormat;
            private final java.lang.String prefix;
            private final java.lang.String suffix;
            private final java.lang.String unitScaler;
            private final java.lang.Object useBlankCellFormat;
            private final java.lang.Object useGrouping;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blankCellFormat = software.amazon.jsii.Kernel.get(this, "blankCellFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.currencySymbol = software.amazon.jsii.Kernel.get(this, "currencySymbol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dateFormat = software.amazon.jsii.Kernel.get(this, "dateFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.decimalSeparator = software.amazon.jsii.Kernel.get(this, "decimalSeparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fractionDigits = software.amazon.jsii.Kernel.get(this, "fractionDigits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.groupingSeparator = software.amazon.jsii.Kernel.get(this, "groupingSeparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.negativeFormat = software.amazon.jsii.Kernel.get(this, "negativeFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.suffix = software.amazon.jsii.Kernel.get(this, "suffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.unitScaler = software.amazon.jsii.Kernel.get(this, "unitScaler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.useBlankCellFormat = software.amazon.jsii.Kernel.get(this, "useBlankCellFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useGrouping = software.amazon.jsii.Kernel.get(this, "useGrouping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blankCellFormat = builder.blankCellFormat;
                this.currencySymbol = builder.currencySymbol;
                this.dateFormat = builder.dateFormat;
                this.decimalSeparator = builder.decimalSeparator;
                this.fractionDigits = builder.fractionDigits;
                this.groupingSeparator = builder.groupingSeparator;
                this.negativeFormat = builder.negativeFormat;
                this.prefix = builder.prefix;
                this.suffix = builder.suffix;
                this.unitScaler = builder.unitScaler;
                this.useBlankCellFormat = builder.useBlankCellFormat;
                this.useGrouping = builder.useGrouping;
            }

            @Override
            public final java.lang.String getBlankCellFormat() {
                return this.blankCellFormat;
            }

            @Override
            public final java.lang.String getCurrencySymbol() {
                return this.currencySymbol;
            }

            @Override
            public final java.lang.String getDateFormat() {
                return this.dateFormat;
            }

            @Override
            public final java.lang.String getDecimalSeparator() {
                return this.decimalSeparator;
            }

            @Override
            public final java.lang.Number getFractionDigits() {
                return this.fractionDigits;
            }

            @Override
            public final java.lang.String getGroupingSeparator() {
                return this.groupingSeparator;
            }

            @Override
            public final java.lang.Object getNegativeFormat() {
                return this.negativeFormat;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.String getSuffix() {
                return this.suffix;
            }

            @Override
            public final java.lang.String getUnitScaler() {
                return this.unitScaler;
            }

            @Override
            public final java.lang.Object getUseBlankCellFormat() {
                return this.useBlankCellFormat;
            }

            @Override
            public final java.lang.Object getUseGrouping() {
                return this.useGrouping;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlankCellFormat() != null) {
                    data.set("blankCellFormat", om.valueToTree(this.getBlankCellFormat()));
                }
                if (this.getCurrencySymbol() != null) {
                    data.set("currencySymbol", om.valueToTree(this.getCurrencySymbol()));
                }
                if (this.getDateFormat() != null) {
                    data.set("dateFormat", om.valueToTree(this.getDateFormat()));
                }
                if (this.getDecimalSeparator() != null) {
                    data.set("decimalSeparator", om.valueToTree(this.getDecimalSeparator()));
                }
                if (this.getFractionDigits() != null) {
                    data.set("fractionDigits", om.valueToTree(this.getFractionDigits()));
                }
                if (this.getGroupingSeparator() != null) {
                    data.set("groupingSeparator", om.valueToTree(this.getGroupingSeparator()));
                }
                if (this.getNegativeFormat() != null) {
                    data.set("negativeFormat", om.valueToTree(this.getNegativeFormat()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getSuffix() != null) {
                    data.set("suffix", om.valueToTree(this.getSuffix()));
                }
                if (this.getUnitScaler() != null) {
                    data.set("unitScaler", om.valueToTree(this.getUnitScaler()));
                }
                if (this.getUseBlankCellFormat() != null) {
                    data.set("useBlankCellFormat", om.valueToTree(this.getUseBlankCellFormat()));
                }
                if (this.getUseGrouping() != null) {
                    data.set("useGrouping", om.valueToTree(this.getUseGrouping()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.DisplayFormatOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DisplayFormatOptionsProperty.Jsii$Proxy that = (DisplayFormatOptionsProperty.Jsii$Proxy) o;

                if (this.blankCellFormat != null ? !this.blankCellFormat.equals(that.blankCellFormat) : that.blankCellFormat != null) return false;
                if (this.currencySymbol != null ? !this.currencySymbol.equals(that.currencySymbol) : that.currencySymbol != null) return false;
                if (this.dateFormat != null ? !this.dateFormat.equals(that.dateFormat) : that.dateFormat != null) return false;
                if (this.decimalSeparator != null ? !this.decimalSeparator.equals(that.decimalSeparator) : that.decimalSeparator != null) return false;
                if (this.fractionDigits != null ? !this.fractionDigits.equals(that.fractionDigits) : that.fractionDigits != null) return false;
                if (this.groupingSeparator != null ? !this.groupingSeparator.equals(that.groupingSeparator) : that.groupingSeparator != null) return false;
                if (this.negativeFormat != null ? !this.negativeFormat.equals(that.negativeFormat) : that.negativeFormat != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.suffix != null ? !this.suffix.equals(that.suffix) : that.suffix != null) return false;
                if (this.unitScaler != null ? !this.unitScaler.equals(that.unitScaler) : that.unitScaler != null) return false;
                if (this.useBlankCellFormat != null ? !this.useBlankCellFormat.equals(that.useBlankCellFormat) : that.useBlankCellFormat != null) return false;
                return this.useGrouping != null ? this.useGrouping.equals(that.useGrouping) : that.useGrouping == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blankCellFormat != null ? this.blankCellFormat.hashCode() : 0;
                result = 31 * result + (this.currencySymbol != null ? this.currencySymbol.hashCode() : 0);
                result = 31 * result + (this.dateFormat != null ? this.dateFormat.hashCode() : 0);
                result = 31 * result + (this.decimalSeparator != null ? this.decimalSeparator.hashCode() : 0);
                result = 31 * result + (this.fractionDigits != null ? this.fractionDigits.hashCode() : 0);
                result = 31 * result + (this.groupingSeparator != null ? this.groupingSeparator.hashCode() : 0);
                result = 31 * result + (this.negativeFormat != null ? this.negativeFormat.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
                result = 31 * result + (this.unitScaler != null ? this.unitScaler.hashCode() : 0);
                result = 31 * result + (this.useBlankCellFormat != null ? this.useBlankCellFormat.hashCode() : 0);
                result = 31 * result + (this.useGrouping != null ? this.useGrouping.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * NamedEntityDefinitionMetricProperty namedEntityDefinitionMetricProperty = NamedEntityDefinitionMetricProperty.builder()
     *         .aggregation("aggregation")
     *         .aggregationFunctionParameters(Map.of(
     *                 "aggregationFunctionParametersKey", "aggregationFunctionParameters"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinitionmetric.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinitionmetric.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.NamedEntityDefinitionMetricProperty")
    @software.amazon.jsii.Jsii.Proxy(NamedEntityDefinitionMetricProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NamedEntityDefinitionMetricProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The aggregation of a named entity.
         * <p>
         * Valid values for this structure are <code>SUM</code> , <code>MIN</code> , <code>MAX</code> , <code>COUNT</code> , <code>AVERAGE</code> , <code>DISTINCT_COUNT</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , <code>PERCENTILE</code> , <code>MEDIAN</code> , and <code>CUSTOM</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinitionmetric.html#cfn-quicksight-topic-namedentitydefinitionmetric-aggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinitionmetric.html#cfn-quicksight-topic-namedentitydefinitionmetric-aggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregation() {
            return null;
        }

        /**
         * The additional parameters for an aggregation function.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinitionmetric.html#cfn-quicksight-topic-namedentitydefinitionmetric-aggregationfunctionparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinitionmetric.html#cfn-quicksight-topic-namedentitydefinitionmetric-aggregationfunctionparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregationFunctionParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NamedEntityDefinitionMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NamedEntityDefinitionMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NamedEntityDefinitionMetricProperty> {
            java.lang.String aggregation;
            java.lang.Object aggregationFunctionParameters;

            /**
             * Sets the value of {@link NamedEntityDefinitionMetricProperty#getAggregation}
             * @param aggregation The aggregation of a named entity.
             *                    Valid values for this structure are <code>SUM</code> , <code>MIN</code> , <code>MAX</code> , <code>COUNT</code> , <code>AVERAGE</code> , <code>DISTINCT_COUNT</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , <code>PERCENTILE</code> , <code>MEDIAN</code> , and <code>CUSTOM</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(java.lang.String aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link NamedEntityDefinitionMetricProperty#getAggregationFunctionParameters}
             * @param aggregationFunctionParameters The additional parameters for an aggregation function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunctionParameters(java.util.Map<java.lang.String, java.lang.String> aggregationFunctionParameters) {
                this.aggregationFunctionParameters = aggregationFunctionParameters;
                return this;
            }

            /**
             * Sets the value of {@link NamedEntityDefinitionMetricProperty#getAggregationFunctionParameters}
             * @param aggregationFunctionParameters The additional parameters for an aggregation function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationFunctionParameters(software.amazon.awscdk.IResolvable aggregationFunctionParameters) {
                this.aggregationFunctionParameters = aggregationFunctionParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NamedEntityDefinitionMetricProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NamedEntityDefinitionMetricProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NamedEntityDefinitionMetricProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NamedEntityDefinitionMetricProperty {
            private final java.lang.String aggregation;
            private final java.lang.Object aggregationFunctionParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregation = software.amazon.jsii.Kernel.get(this, "aggregation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aggregationFunctionParameters = software.amazon.jsii.Kernel.get(this, "aggregationFunctionParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregation = builder.aggregation;
                this.aggregationFunctionParameters = builder.aggregationFunctionParameters;
            }

            @Override
            public final java.lang.String getAggregation() {
                return this.aggregation;
            }

            @Override
            public final java.lang.Object getAggregationFunctionParameters() {
                return this.aggregationFunctionParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregation() != null) {
                    data.set("aggregation", om.valueToTree(this.getAggregation()));
                }
                if (this.getAggregationFunctionParameters() != null) {
                    data.set("aggregationFunctionParameters", om.valueToTree(this.getAggregationFunctionParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.NamedEntityDefinitionMetricProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NamedEntityDefinitionMetricProperty.Jsii$Proxy that = (NamedEntityDefinitionMetricProperty.Jsii$Proxy) o;

                if (this.aggregation != null ? !this.aggregation.equals(that.aggregation) : that.aggregation != null) return false;
                return this.aggregationFunctionParameters != null ? this.aggregationFunctionParameters.equals(that.aggregationFunctionParameters) : that.aggregationFunctionParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregation != null ? this.aggregation.hashCode() : 0;
                result = 31 * result + (this.aggregationFunctionParameters != null ? this.aggregationFunctionParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a named entity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * NamedEntityDefinitionProperty namedEntityDefinitionProperty = NamedEntityDefinitionProperty.builder()
     *         .fieldName("fieldName")
     *         .metric(NamedEntityDefinitionMetricProperty.builder()
     *                 .aggregation("aggregation")
     *                 .aggregationFunctionParameters(Map.of(
     *                         "aggregationFunctionParametersKey", "aggregationFunctionParameters"))
     *                 .build())
     *         .propertyName("propertyName")
     *         .propertyRole("propertyRole")
     *         .propertyUsage("propertyUsage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.NamedEntityDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(NamedEntityDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NamedEntityDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the entity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-fieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-fieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldName() {
            return null;
        }

        /**
         * The definition of a metric.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.NamedEntityDefinitionMetricProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-metric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-metric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetric() {
            return null;
        }

        /**
         * The property name to be used for the named entity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-propertyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-propertyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyName() {
            return null;
        }

        /**
         * The property role.
         * <p>
         * Valid values for this structure are <code>PRIMARY</code> and <code>ID</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-propertyrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-propertyrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyRole() {
            return null;
        }

        /**
         * The property usage.
         * <p>
         * Valid values for this structure are <code>INHERIT</code> , <code>DIMENSION</code> , and <code>MEASURE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-propertyusage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-namedentitydefinition.html#cfn-quicksight-topic-namedentitydefinition-propertyusage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropertyUsage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NamedEntityDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NamedEntityDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NamedEntityDefinitionProperty> {
            java.lang.String fieldName;
            java.lang.Object metric;
            java.lang.String propertyName;
            java.lang.String propertyRole;
            java.lang.String propertyUsage;

            /**
             * Sets the value of {@link NamedEntityDefinitionProperty#getFieldName}
             * @param fieldName The name of the entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldName(java.lang.String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            /**
             * Sets the value of {@link NamedEntityDefinitionProperty#getMetric}
             * @param metric The definition of a metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.IResolvable metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link NamedEntityDefinitionProperty#getMetric}
             * @param metric The definition of a metric.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metric(software.amazon.awscdk.services.quicksight.CfnTopic.NamedEntityDefinitionMetricProperty metric) {
                this.metric = metric;
                return this;
            }

            /**
             * Sets the value of {@link NamedEntityDefinitionProperty#getPropertyName}
             * @param propertyName The property name to be used for the named entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyName(java.lang.String propertyName) {
                this.propertyName = propertyName;
                return this;
            }

            /**
             * Sets the value of {@link NamedEntityDefinitionProperty#getPropertyRole}
             * @param propertyRole The property role.
             *                     Valid values for this structure are <code>PRIMARY</code> and <code>ID</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyRole(java.lang.String propertyRole) {
                this.propertyRole = propertyRole;
                return this;
            }

            /**
             * Sets the value of {@link NamedEntityDefinitionProperty#getPropertyUsage}
             * @param propertyUsage The property usage.
             *                      Valid values for this structure are <code>INHERIT</code> , <code>DIMENSION</code> , and <code>MEASURE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyUsage(java.lang.String propertyUsage) {
                this.propertyUsage = propertyUsage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NamedEntityDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NamedEntityDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NamedEntityDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NamedEntityDefinitionProperty {
            private final java.lang.String fieldName;
            private final java.lang.Object metric;
            private final java.lang.String propertyName;
            private final java.lang.String propertyRole;
            private final java.lang.String propertyUsage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldName = software.amazon.jsii.Kernel.get(this, "fieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metric = software.amazon.jsii.Kernel.get(this, "metric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.propertyName = software.amazon.jsii.Kernel.get(this, "propertyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyRole = software.amazon.jsii.Kernel.get(this, "propertyRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyUsage = software.amazon.jsii.Kernel.get(this, "propertyUsage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldName = builder.fieldName;
                this.metric = builder.metric;
                this.propertyName = builder.propertyName;
                this.propertyRole = builder.propertyRole;
                this.propertyUsage = builder.propertyUsage;
            }

            @Override
            public final java.lang.String getFieldName() {
                return this.fieldName;
            }

            @Override
            public final java.lang.Object getMetric() {
                return this.metric;
            }

            @Override
            public final java.lang.String getPropertyName() {
                return this.propertyName;
            }

            @Override
            public final java.lang.String getPropertyRole() {
                return this.propertyRole;
            }

            @Override
            public final java.lang.String getPropertyUsage() {
                return this.propertyUsage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFieldName() != null) {
                    data.set("fieldName", om.valueToTree(this.getFieldName()));
                }
                if (this.getMetric() != null) {
                    data.set("metric", om.valueToTree(this.getMetric()));
                }
                if (this.getPropertyName() != null) {
                    data.set("propertyName", om.valueToTree(this.getPropertyName()));
                }
                if (this.getPropertyRole() != null) {
                    data.set("propertyRole", om.valueToTree(this.getPropertyRole()));
                }
                if (this.getPropertyUsage() != null) {
                    data.set("propertyUsage", om.valueToTree(this.getPropertyUsage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.NamedEntityDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NamedEntityDefinitionProperty.Jsii$Proxy that = (NamedEntityDefinitionProperty.Jsii$Proxy) o;

                if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) return false;
                if (this.metric != null ? !this.metric.equals(that.metric) : that.metric != null) return false;
                if (this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null) return false;
                if (this.propertyRole != null ? !this.propertyRole.equals(that.propertyRole) : that.propertyRole != null) return false;
                return this.propertyUsage != null ? this.propertyUsage.equals(that.propertyUsage) : that.propertyUsage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
                result = 31 * result + (this.metric != null ? this.metric.hashCode() : 0);
                result = 31 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
                result = 31 * result + (this.propertyRole != null ? this.propertyRole.hashCode() : 0);
                result = 31 * result + (this.propertyUsage != null ? this.propertyUsage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a negative format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * NegativeFormatProperty negativeFormatProperty = NegativeFormatProperty.builder()
     *         .prefix("prefix")
     *         .suffix("suffix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-negativeformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-negativeformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.NegativeFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(NegativeFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NegativeFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The prefix for a negative format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-negativeformat.html#cfn-quicksight-topic-negativeformat-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-negativeformat.html#cfn-quicksight-topic-negativeformat-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * The suffix for a negative format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-negativeformat.html#cfn-quicksight-topic-negativeformat-suffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-negativeformat.html#cfn-quicksight-topic-negativeformat-suffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuffix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NegativeFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NegativeFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NegativeFormatProperty> {
            java.lang.String prefix;
            java.lang.String suffix;

            /**
             * Sets the value of {@link NegativeFormatProperty#getPrefix}
             * @param prefix The prefix for a negative format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link NegativeFormatProperty#getSuffix}
             * @param suffix The suffix for a negative format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suffix(java.lang.String suffix) {
                this.suffix = suffix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NegativeFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NegativeFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NegativeFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NegativeFormatProperty {
            private final java.lang.String prefix;
            private final java.lang.String suffix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.suffix = software.amazon.jsii.Kernel.get(this, "suffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prefix = builder.prefix;
                this.suffix = builder.suffix;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.String getSuffix() {
                return this.suffix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getSuffix() != null) {
                    data.set("suffix", om.valueToTree(this.getSuffix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.NegativeFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NegativeFormatProperty.Jsii$Proxy that = (NegativeFormatProperty.Jsii$Proxy) o;

                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.suffix != null ? this.suffix.equals(that.suffix) : that.suffix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prefix != null ? this.prefix.hashCode() : 0;
                result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The value of the constant that is used to specify the endpoints of a range filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * RangeConstantProperty rangeConstantProperty = RangeConstantProperty.builder()
     *         .maximum("maximum")
     *         .minimum("minimum")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-rangeconstant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-rangeconstant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.RangeConstantProperty")
    @software.amazon.jsii.Jsii.Proxy(RangeConstantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RangeConstantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum value for a range constant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-rangeconstant.html#cfn-quicksight-topic-rangeconstant-maximum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-rangeconstant.html#cfn-quicksight-topic-rangeconstant-maximum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMaximum() {
            return null;
        }

        /**
         * The minimum value for a range constant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-rangeconstant.html#cfn-quicksight-topic-rangeconstant-minimum">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-rangeconstant.html#cfn-quicksight-topic-rangeconstant-minimum</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMinimum() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RangeConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RangeConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RangeConstantProperty> {
            java.lang.String maximum;
            java.lang.String minimum;

            /**
             * Sets the value of {@link RangeConstantProperty#getMaximum}
             * @param maximum The maximum value for a range constant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximum(java.lang.String maximum) {
                this.maximum = maximum;
                return this;
            }

            /**
             * Sets the value of {@link RangeConstantProperty#getMinimum}
             * @param minimum The minimum value for a range constant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimum(java.lang.String minimum) {
                this.minimum = minimum;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RangeConstantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RangeConstantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RangeConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RangeConstantProperty {
            private final java.lang.String maximum;
            private final java.lang.String minimum;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximum = software.amazon.jsii.Kernel.get(this, "maximum", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minimum = software.amazon.jsii.Kernel.get(this, "minimum", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximum = builder.maximum;
                this.minimum = builder.minimum;
            }

            @Override
            public final java.lang.String getMaximum() {
                return this.maximum;
            }

            @Override
            public final java.lang.String getMinimum() {
                return this.minimum;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximum() != null) {
                    data.set("maximum", om.valueToTree(this.getMaximum()));
                }
                if (this.getMinimum() != null) {
                    data.set("minimum", om.valueToTree(this.getMinimum()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.RangeConstantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RangeConstantProperty.Jsii$Proxy that = (RangeConstantProperty.Jsii$Proxy) o;

                if (this.maximum != null ? !this.maximum.equals(that.maximum) : that.maximum != null) return false;
                return this.minimum != null ? this.minimum.equals(that.minimum) : that.minimum == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximum != null ? this.maximum.hashCode() : 0;
                result = 31 * result + (this.minimum != null ? this.minimum.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a semantic entity type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SemanticEntityTypeProperty semanticEntityTypeProperty = SemanticEntityTypeProperty.builder()
     *         .subTypeName("subTypeName")
     *         .typeName("typeName")
     *         .typeParameters(Map.of(
     *                 "typeParametersKey", "typeParameters"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semanticentitytype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semanticentitytype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.SemanticEntityTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(SemanticEntityTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SemanticEntityTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The semantic entity sub type name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semanticentitytype.html#cfn-quicksight-topic-semanticentitytype-subtypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semanticentitytype.html#cfn-quicksight-topic-semanticentitytype-subtypename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubTypeName() {
            return null;
        }

        /**
         * The semantic entity type name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semanticentitytype.html#cfn-quicksight-topic-semanticentitytype-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semanticentitytype.html#cfn-quicksight-topic-semanticentitytype-typename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
            return null;
        }

        /**
         * The semantic entity type parameters.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semanticentitytype.html#cfn-quicksight-topic-semanticentitytype-typeparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semanticentitytype.html#cfn-quicksight-topic-semanticentitytype-typeparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTypeParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SemanticEntityTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SemanticEntityTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SemanticEntityTypeProperty> {
            java.lang.String subTypeName;
            java.lang.String typeName;
            java.lang.Object typeParameters;

            /**
             * Sets the value of {@link SemanticEntityTypeProperty#getSubTypeName}
             * @param subTypeName The semantic entity sub type name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subTypeName(java.lang.String subTypeName) {
                this.subTypeName = subTypeName;
                return this;
            }

            /**
             * Sets the value of {@link SemanticEntityTypeProperty#getTypeName}
             * @param typeName The semantic entity type name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeName(java.lang.String typeName) {
                this.typeName = typeName;
                return this;
            }

            /**
             * Sets the value of {@link SemanticEntityTypeProperty#getTypeParameters}
             * @param typeParameters The semantic entity type parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeParameters(java.util.Map<java.lang.String, java.lang.String> typeParameters) {
                this.typeParameters = typeParameters;
                return this;
            }

            /**
             * Sets the value of {@link SemanticEntityTypeProperty#getTypeParameters}
             * @param typeParameters The semantic entity type parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeParameters(software.amazon.awscdk.IResolvable typeParameters) {
                this.typeParameters = typeParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SemanticEntityTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SemanticEntityTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SemanticEntityTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SemanticEntityTypeProperty {
            private final java.lang.String subTypeName;
            private final java.lang.String typeName;
            private final java.lang.Object typeParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subTypeName = software.amazon.jsii.Kernel.get(this, "subTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeParameters = software.amazon.jsii.Kernel.get(this, "typeParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subTypeName = builder.subTypeName;
                this.typeName = builder.typeName;
                this.typeParameters = builder.typeParameters;
            }

            @Override
            public final java.lang.String getSubTypeName() {
                return this.subTypeName;
            }

            @Override
            public final java.lang.String getTypeName() {
                return this.typeName;
            }

            @Override
            public final java.lang.Object getTypeParameters() {
                return this.typeParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSubTypeName() != null) {
                    data.set("subTypeName", om.valueToTree(this.getSubTypeName()));
                }
                if (this.getTypeName() != null) {
                    data.set("typeName", om.valueToTree(this.getTypeName()));
                }
                if (this.getTypeParameters() != null) {
                    data.set("typeParameters", om.valueToTree(this.getTypeParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.SemanticEntityTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SemanticEntityTypeProperty.Jsii$Proxy that = (SemanticEntityTypeProperty.Jsii$Proxy) o;

                if (this.subTypeName != null ? !this.subTypeName.equals(that.subTypeName) : that.subTypeName != null) return false;
                if (this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null) return false;
                return this.typeParameters != null ? this.typeParameters.equals(that.typeParameters) : that.typeParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subTypeName != null ? this.subTypeName.hashCode() : 0;
                result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
                result = 31 * result + (this.typeParameters != null ? this.typeParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a semantic type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * SemanticTypeProperty semanticTypeProperty = SemanticTypeProperty.builder()
     *         .falseyCellValue("falseyCellValue")
     *         .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
     *         .subTypeName("subTypeName")
     *         .truthyCellValue("truthyCellValue")
     *         .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
     *         .typeName("typeName")
     *         .typeParameters(Map.of(
     *                 "typeParametersKey", "typeParameters"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.SemanticTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(SemanticTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SemanticTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The semantic type falsey cell value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-falseycellvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-falseycellvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFalseyCellValue() {
            return null;
        }

        /**
         * The other names or aliases for the false cell value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-falseycellvaluesynonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-falseycellvaluesynonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFalseyCellValueSynonyms() {
            return null;
        }

        /**
         * The semantic type sub type name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-subtypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-subtypename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubTypeName() {
            return null;
        }

        /**
         * The semantic type truthy cell value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-truthycellvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-truthycellvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTruthyCellValue() {
            return null;
        }

        /**
         * The other names or aliases for the true cell value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-truthycellvaluesynonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-truthycellvaluesynonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTruthyCellValueSynonyms() {
            return null;
        }

        /**
         * The semantic type name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-typename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
            return null;
        }

        /**
         * The semantic type parameters.
         * <p>
         * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-typeparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-semantictype.html#cfn-quicksight-topic-semantictype-typeparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTypeParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SemanticTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SemanticTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SemanticTypeProperty> {
            java.lang.String falseyCellValue;
            java.util.List<java.lang.String> falseyCellValueSynonyms;
            java.lang.String subTypeName;
            java.lang.String truthyCellValue;
            java.util.List<java.lang.String> truthyCellValueSynonyms;
            java.lang.String typeName;
            java.lang.Object typeParameters;

            /**
             * Sets the value of {@link SemanticTypeProperty#getFalseyCellValue}
             * @param falseyCellValue The semantic type falsey cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder falseyCellValue(java.lang.String falseyCellValue) {
                this.falseyCellValue = falseyCellValue;
                return this;
            }

            /**
             * Sets the value of {@link SemanticTypeProperty#getFalseyCellValueSynonyms}
             * @param falseyCellValueSynonyms The other names or aliases for the false cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder falseyCellValueSynonyms(java.util.List<java.lang.String> falseyCellValueSynonyms) {
                this.falseyCellValueSynonyms = falseyCellValueSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link SemanticTypeProperty#getSubTypeName}
             * @param subTypeName The semantic type sub type name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subTypeName(java.lang.String subTypeName) {
                this.subTypeName = subTypeName;
                return this;
            }

            /**
             * Sets the value of {@link SemanticTypeProperty#getTruthyCellValue}
             * @param truthyCellValue The semantic type truthy cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truthyCellValue(java.lang.String truthyCellValue) {
                this.truthyCellValue = truthyCellValue;
                return this;
            }

            /**
             * Sets the value of {@link SemanticTypeProperty#getTruthyCellValueSynonyms}
             * @param truthyCellValueSynonyms The other names or aliases for the true cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder truthyCellValueSynonyms(java.util.List<java.lang.String> truthyCellValueSynonyms) {
                this.truthyCellValueSynonyms = truthyCellValueSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link SemanticTypeProperty#getTypeName}
             * @param typeName The semantic type name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeName(java.lang.String typeName) {
                this.typeName = typeName;
                return this;
            }

            /**
             * Sets the value of {@link SemanticTypeProperty#getTypeParameters}
             * @param typeParameters The semantic type parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeParameters(java.util.Map<java.lang.String, java.lang.String> typeParameters) {
                this.typeParameters = typeParameters;
                return this;
            }

            /**
             * Sets the value of {@link SemanticTypeProperty#getTypeParameters}
             * @param typeParameters The semantic type parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeParameters(software.amazon.awscdk.IResolvable typeParameters) {
                this.typeParameters = typeParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SemanticTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SemanticTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SemanticTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SemanticTypeProperty {
            private final java.lang.String falseyCellValue;
            private final java.util.List<java.lang.String> falseyCellValueSynonyms;
            private final java.lang.String subTypeName;
            private final java.lang.String truthyCellValue;
            private final java.util.List<java.lang.String> truthyCellValueSynonyms;
            private final java.lang.String typeName;
            private final java.lang.Object typeParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.falseyCellValue = software.amazon.jsii.Kernel.get(this, "falseyCellValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.falseyCellValueSynonyms = software.amazon.jsii.Kernel.get(this, "falseyCellValueSynonyms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subTypeName = software.amazon.jsii.Kernel.get(this, "subTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.truthyCellValue = software.amazon.jsii.Kernel.get(this, "truthyCellValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.truthyCellValueSynonyms = software.amazon.jsii.Kernel.get(this, "truthyCellValueSynonyms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeParameters = software.amazon.jsii.Kernel.get(this, "typeParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.falseyCellValue = builder.falseyCellValue;
                this.falseyCellValueSynonyms = builder.falseyCellValueSynonyms;
                this.subTypeName = builder.subTypeName;
                this.truthyCellValue = builder.truthyCellValue;
                this.truthyCellValueSynonyms = builder.truthyCellValueSynonyms;
                this.typeName = builder.typeName;
                this.typeParameters = builder.typeParameters;
            }

            @Override
            public final java.lang.String getFalseyCellValue() {
                return this.falseyCellValue;
            }

            @Override
            public final java.util.List<java.lang.String> getFalseyCellValueSynonyms() {
                return this.falseyCellValueSynonyms;
            }

            @Override
            public final java.lang.String getSubTypeName() {
                return this.subTypeName;
            }

            @Override
            public final java.lang.String getTruthyCellValue() {
                return this.truthyCellValue;
            }

            @Override
            public final java.util.List<java.lang.String> getTruthyCellValueSynonyms() {
                return this.truthyCellValueSynonyms;
            }

            @Override
            public final java.lang.String getTypeName() {
                return this.typeName;
            }

            @Override
            public final java.lang.Object getTypeParameters() {
                return this.typeParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFalseyCellValue() != null) {
                    data.set("falseyCellValue", om.valueToTree(this.getFalseyCellValue()));
                }
                if (this.getFalseyCellValueSynonyms() != null) {
                    data.set("falseyCellValueSynonyms", om.valueToTree(this.getFalseyCellValueSynonyms()));
                }
                if (this.getSubTypeName() != null) {
                    data.set("subTypeName", om.valueToTree(this.getSubTypeName()));
                }
                if (this.getTruthyCellValue() != null) {
                    data.set("truthyCellValue", om.valueToTree(this.getTruthyCellValue()));
                }
                if (this.getTruthyCellValueSynonyms() != null) {
                    data.set("truthyCellValueSynonyms", om.valueToTree(this.getTruthyCellValueSynonyms()));
                }
                if (this.getTypeName() != null) {
                    data.set("typeName", om.valueToTree(this.getTypeName()));
                }
                if (this.getTypeParameters() != null) {
                    data.set("typeParameters", om.valueToTree(this.getTypeParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.SemanticTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SemanticTypeProperty.Jsii$Proxy that = (SemanticTypeProperty.Jsii$Proxy) o;

                if (this.falseyCellValue != null ? !this.falseyCellValue.equals(that.falseyCellValue) : that.falseyCellValue != null) return false;
                if (this.falseyCellValueSynonyms != null ? !this.falseyCellValueSynonyms.equals(that.falseyCellValueSynonyms) : that.falseyCellValueSynonyms != null) return false;
                if (this.subTypeName != null ? !this.subTypeName.equals(that.subTypeName) : that.subTypeName != null) return false;
                if (this.truthyCellValue != null ? !this.truthyCellValue.equals(that.truthyCellValue) : that.truthyCellValue != null) return false;
                if (this.truthyCellValueSynonyms != null ? !this.truthyCellValueSynonyms.equals(that.truthyCellValueSynonyms) : that.truthyCellValueSynonyms != null) return false;
                if (this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null) return false;
                return this.typeParameters != null ? this.typeParameters.equals(that.typeParameters) : that.typeParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.falseyCellValue != null ? this.falseyCellValue.hashCode() : 0;
                result = 31 * result + (this.falseyCellValueSynonyms != null ? this.falseyCellValueSynonyms.hashCode() : 0);
                result = 31 * result + (this.subTypeName != null ? this.subTypeName.hashCode() : 0);
                result = 31 * result + (this.truthyCellValue != null ? this.truthyCellValue.hashCode() : 0);
                result = 31 * result + (this.truthyCellValueSynonyms != null ? this.truthyCellValueSynonyms.hashCode() : 0);
                result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
                result = 31 * result + (this.typeParameters != null ? this.typeParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a calculated field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicCalculatedFieldProperty topicCalculatedFieldProperty = TopicCalculatedFieldProperty.builder()
     *         .calculatedFieldName("calculatedFieldName")
     *         .expression("expression")
     *         // the properties below are optional
     *         .aggregation("aggregation")
     *         .allowedAggregations(List.of("allowedAggregations"))
     *         .calculatedFieldDescription("calculatedFieldDescription")
     *         .calculatedFieldSynonyms(List.of("calculatedFieldSynonyms"))
     *         .cellValueSynonyms(List.of(CellValueSynonymProperty.builder()
     *                 .cellValue("cellValue")
     *                 .synonyms(List.of("synonyms"))
     *                 .build()))
     *         .columnDataRole("columnDataRole")
     *         .comparativeOrder(ComparativeOrderProperty.builder()
     *                 .specifedOrder(List.of("specifedOrder"))
     *                 .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
     *                 .useOrdering("useOrdering")
     *                 .build())
     *         .defaultFormatting(DefaultFormattingProperty.builder()
     *                 .displayFormat("displayFormat")
     *                 .displayFormatOptions(DisplayFormatOptionsProperty.builder()
     *                         .blankCellFormat("blankCellFormat")
     *                         .currencySymbol("currencySymbol")
     *                         .dateFormat("dateFormat")
     *                         .decimalSeparator("decimalSeparator")
     *                         .fractionDigits(123)
     *                         .groupingSeparator("groupingSeparator")
     *                         .negativeFormat(NegativeFormatProperty.builder()
     *                                 .prefix("prefix")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .prefix("prefix")
     *                         .suffix("suffix")
     *                         .unitScaler("unitScaler")
     *                         .useBlankCellFormat(false)
     *                         .useGrouping(false)
     *                         .build())
     *                 .build())
     *         .disableIndexing(false)
     *         .isIncludedInTopic(false)
     *         .neverAggregateInFilter(false)
     *         .nonAdditive(false)
     *         .notAllowedAggregations(List.of("notAllowedAggregations"))
     *         .semanticType(SemanticTypeProperty.builder()
     *                 .falseyCellValue("falseyCellValue")
     *                 .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
     *                 .subTypeName("subTypeName")
     *                 .truthyCellValue("truthyCellValue")
     *                 .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
     *                 .typeName("typeName")
     *                 .typeParameters(Map.of(
     *                         "typeParametersKey", "typeParameters"))
     *                 .build())
     *         .timeGranularity("timeGranularity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicCalculatedFieldProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicCalculatedFieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicCalculatedFieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The calculated field name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-calculatedfieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-calculatedfieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCalculatedFieldName();

        /**
         * The calculated field expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * The default aggregation.
         * <p>
         * Valid values for this structure are <code>SUM</code> , <code>MAX</code> , <code>MIN</code> , <code>COUNT</code> , <code>DISTINCT_COUNT</code> , and <code>AVERAGE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-aggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-aggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregation() {
            return null;
        }

        /**
         * The list of aggregation types that are allowed for the calculated field.
         * <p>
         * Valid values for this structure are <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , and <code>PERCENTILE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-allowedaggregations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-allowedaggregations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedAggregations() {
            return null;
        }

        /**
         * The calculated field description.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-calculatedfielddescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-calculatedfielddescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCalculatedFieldDescription() {
            return null;
        }

        /**
         * The other names or aliases for the calculated field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-calculatedfieldsynonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-calculatedfieldsynonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCalculatedFieldSynonyms() {
            return null;
        }

        /**
         * The other names or aliases for the calculated field cell value.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.CellValueSynonymProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-cellvaluesynonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-cellvaluesynonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCellValueSynonyms() {
            return null;
        }

        /**
         * The column data role for a calculated field.
         * <p>
         * Valid values for this structure are <code>DIMENSION</code> and <code>MEASURE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-columndatarole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-columndatarole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnDataRole() {
            return null;
        }

        /**
         * The order in which data is displayed for the calculated field when it's used in a comparative context.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.ComparativeOrderProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-comparativeorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-comparativeorder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComparativeOrder() {
            return null;
        }

        /**
         * The default formatting definition.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.DefaultFormattingProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-defaultformatting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-defaultformatting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultFormatting() {
            return null;
        }

        /**
         * A Boolean value that indicates if a calculated field is visible in the autocomplete.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-disableindexing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-disableindexing</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableIndexing() {
            return null;
        }

        /**
         * A boolean value that indicates if a calculated field is included in the topic.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-isincludedintopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-isincludedintopic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsIncludedInTopic() {
            return null;
        }

        /**
         * A Boolean value that indicates whether to never aggregate calculated field in filters.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-neveraggregateinfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-neveraggregateinfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNeverAggregateInFilter() {
            return null;
        }

        /**
         * The non additive for the table style target.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-nonadditive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-nonadditive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNonAdditive() {
            return null;
        }

        /**
         * The list of aggregation types that are not allowed for the calculated field.
         * <p>
         * Valid values for this structure are <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , and <code>PERCENTILE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-notallowedaggregations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-notallowedaggregations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotAllowedAggregations() {
            return null;
        }

        /**
         * The semantic type.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.SemanticTypeProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-semantictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-semantictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSemanticType() {
            return null;
        }

        /**
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-timegranularity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccalculatedfield.html#cfn-quicksight-topic-topiccalculatedfield-timegranularity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeGranularity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicCalculatedFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicCalculatedFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicCalculatedFieldProperty> {
            java.lang.String calculatedFieldName;
            java.lang.String expression;
            java.lang.String aggregation;
            java.util.List<java.lang.String> allowedAggregations;
            java.lang.String calculatedFieldDescription;
            java.util.List<java.lang.String> calculatedFieldSynonyms;
            java.lang.Object cellValueSynonyms;
            java.lang.String columnDataRole;
            java.lang.Object comparativeOrder;
            java.lang.Object defaultFormatting;
            java.lang.Object disableIndexing;
            java.lang.Object isIncludedInTopic;
            java.lang.Object neverAggregateInFilter;
            java.lang.Object nonAdditive;
            java.util.List<java.lang.String> notAllowedAggregations;
            java.lang.Object semanticType;
            java.lang.String timeGranularity;

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getCalculatedFieldName}
             * @param calculatedFieldName The calculated field name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedFieldName(java.lang.String calculatedFieldName) {
                this.calculatedFieldName = calculatedFieldName;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getExpression}
             * @param expression The calculated field expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getAggregation}
             * @param aggregation The default aggregation.
             *                    Valid values for this structure are <code>SUM</code> , <code>MAX</code> , <code>MIN</code> , <code>COUNT</code> , <code>DISTINCT_COUNT</code> , and <code>AVERAGE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(java.lang.String aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getAllowedAggregations}
             * @param allowedAggregations The list of aggregation types that are allowed for the calculated field.
             *                            Valid values for this structure are <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , and <code>PERCENTILE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedAggregations(java.util.List<java.lang.String> allowedAggregations) {
                this.allowedAggregations = allowedAggregations;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getCalculatedFieldDescription}
             * @param calculatedFieldDescription The calculated field description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedFieldDescription(java.lang.String calculatedFieldDescription) {
                this.calculatedFieldDescription = calculatedFieldDescription;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getCalculatedFieldSynonyms}
             * @param calculatedFieldSynonyms The other names or aliases for the calculated field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedFieldSynonyms(java.util.List<java.lang.String> calculatedFieldSynonyms) {
                this.calculatedFieldSynonyms = calculatedFieldSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getCellValueSynonyms}
             * @param cellValueSynonyms The other names or aliases for the calculated field cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cellValueSynonyms(software.amazon.awscdk.IResolvable cellValueSynonyms) {
                this.cellValueSynonyms = cellValueSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getCellValueSynonyms}
             * @param cellValueSynonyms The other names or aliases for the calculated field cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cellValueSynonyms(java.util.List<? extends java.lang.Object> cellValueSynonyms) {
                this.cellValueSynonyms = cellValueSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getColumnDataRole}
             * @param columnDataRole The column data role for a calculated field.
             *                       Valid values for this structure are <code>DIMENSION</code> and <code>MEASURE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDataRole(java.lang.String columnDataRole) {
                this.columnDataRole = columnDataRole;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getComparativeOrder}
             * @param comparativeOrder The order in which data is displayed for the calculated field when it's used in a comparative context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparativeOrder(software.amazon.awscdk.IResolvable comparativeOrder) {
                this.comparativeOrder = comparativeOrder;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getComparativeOrder}
             * @param comparativeOrder The order in which data is displayed for the calculated field when it's used in a comparative context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparativeOrder(software.amazon.awscdk.services.quicksight.CfnTopic.ComparativeOrderProperty comparativeOrder) {
                this.comparativeOrder = comparativeOrder;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getDefaultFormatting}
             * @param defaultFormatting The default formatting definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultFormatting(software.amazon.awscdk.IResolvable defaultFormatting) {
                this.defaultFormatting = defaultFormatting;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getDefaultFormatting}
             * @param defaultFormatting The default formatting definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultFormatting(software.amazon.awscdk.services.quicksight.CfnTopic.DefaultFormattingProperty defaultFormatting) {
                this.defaultFormatting = defaultFormatting;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getDisableIndexing}
             * @param disableIndexing A Boolean value that indicates if a calculated field is visible in the autocomplete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableIndexing(java.lang.Boolean disableIndexing) {
                this.disableIndexing = disableIndexing;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getDisableIndexing}
             * @param disableIndexing A Boolean value that indicates if a calculated field is visible in the autocomplete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableIndexing(software.amazon.awscdk.IResolvable disableIndexing) {
                this.disableIndexing = disableIndexing;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getIsIncludedInTopic}
             * @param isIncludedInTopic A boolean value that indicates if a calculated field is included in the topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isIncludedInTopic(java.lang.Boolean isIncludedInTopic) {
                this.isIncludedInTopic = isIncludedInTopic;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getIsIncludedInTopic}
             * @param isIncludedInTopic A boolean value that indicates if a calculated field is included in the topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isIncludedInTopic(software.amazon.awscdk.IResolvable isIncludedInTopic) {
                this.isIncludedInTopic = isIncludedInTopic;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getNeverAggregateInFilter}
             * @param neverAggregateInFilter A Boolean value that indicates whether to never aggregate calculated field in filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder neverAggregateInFilter(java.lang.Boolean neverAggregateInFilter) {
                this.neverAggregateInFilter = neverAggregateInFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getNeverAggregateInFilter}
             * @param neverAggregateInFilter A Boolean value that indicates whether to never aggregate calculated field in filters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder neverAggregateInFilter(software.amazon.awscdk.IResolvable neverAggregateInFilter) {
                this.neverAggregateInFilter = neverAggregateInFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getNonAdditive}
             * @param nonAdditive The non additive for the table style target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonAdditive(java.lang.Boolean nonAdditive) {
                this.nonAdditive = nonAdditive;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getNonAdditive}
             * @param nonAdditive The non additive for the table style target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonAdditive(software.amazon.awscdk.IResolvable nonAdditive) {
                this.nonAdditive = nonAdditive;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getNotAllowedAggregations}
             * @param notAllowedAggregations The list of aggregation types that are not allowed for the calculated field.
             *                               Valid values for this structure are <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , and <code>PERCENTILE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notAllowedAggregations(java.util.List<java.lang.String> notAllowedAggregations) {
                this.notAllowedAggregations = notAllowedAggregations;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getSemanticType}
             * @param semanticType The semantic type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticType(software.amazon.awscdk.IResolvable semanticType) {
                this.semanticType = semanticType;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getSemanticType}
             * @param semanticType The semantic type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticType(software.amazon.awscdk.services.quicksight.CfnTopic.SemanticTypeProperty semanticType) {
                this.semanticType = semanticType;
                return this;
            }

            /**
             * Sets the value of {@link TopicCalculatedFieldProperty#getTimeGranularity}
             * @param timeGranularity The level of time precision that is used to aggregate <code>DateTime</code> values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeGranularity(java.lang.String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicCalculatedFieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicCalculatedFieldProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicCalculatedFieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicCalculatedFieldProperty {
            private final java.lang.String calculatedFieldName;
            private final java.lang.String expression;
            private final java.lang.String aggregation;
            private final java.util.List<java.lang.String> allowedAggregations;
            private final java.lang.String calculatedFieldDescription;
            private final java.util.List<java.lang.String> calculatedFieldSynonyms;
            private final java.lang.Object cellValueSynonyms;
            private final java.lang.String columnDataRole;
            private final java.lang.Object comparativeOrder;
            private final java.lang.Object defaultFormatting;
            private final java.lang.Object disableIndexing;
            private final java.lang.Object isIncludedInTopic;
            private final java.lang.Object neverAggregateInFilter;
            private final java.lang.Object nonAdditive;
            private final java.util.List<java.lang.String> notAllowedAggregations;
            private final java.lang.Object semanticType;
            private final java.lang.String timeGranularity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.calculatedFieldName = software.amazon.jsii.Kernel.get(this, "calculatedFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aggregation = software.amazon.jsii.Kernel.get(this, "aggregation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedAggregations = software.amazon.jsii.Kernel.get(this, "allowedAggregations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.calculatedFieldDescription = software.amazon.jsii.Kernel.get(this, "calculatedFieldDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.calculatedFieldSynonyms = software.amazon.jsii.Kernel.get(this, "calculatedFieldSynonyms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cellValueSynonyms = software.amazon.jsii.Kernel.get(this, "cellValueSynonyms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnDataRole = software.amazon.jsii.Kernel.get(this, "columnDataRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.comparativeOrder = software.amazon.jsii.Kernel.get(this, "comparativeOrder", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultFormatting = software.amazon.jsii.Kernel.get(this, "defaultFormatting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableIndexing = software.amazon.jsii.Kernel.get(this, "disableIndexing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isIncludedInTopic = software.amazon.jsii.Kernel.get(this, "isIncludedInTopic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.neverAggregateInFilter = software.amazon.jsii.Kernel.get(this, "neverAggregateInFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nonAdditive = software.amazon.jsii.Kernel.get(this, "nonAdditive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.notAllowedAggregations = software.amazon.jsii.Kernel.get(this, "notAllowedAggregations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.semanticType = software.amazon.jsii.Kernel.get(this, "semanticType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeGranularity = software.amazon.jsii.Kernel.get(this, "timeGranularity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.calculatedFieldName = java.util.Objects.requireNonNull(builder.calculatedFieldName, "calculatedFieldName is required");
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.aggregation = builder.aggregation;
                this.allowedAggregations = builder.allowedAggregations;
                this.calculatedFieldDescription = builder.calculatedFieldDescription;
                this.calculatedFieldSynonyms = builder.calculatedFieldSynonyms;
                this.cellValueSynonyms = builder.cellValueSynonyms;
                this.columnDataRole = builder.columnDataRole;
                this.comparativeOrder = builder.comparativeOrder;
                this.defaultFormatting = builder.defaultFormatting;
                this.disableIndexing = builder.disableIndexing;
                this.isIncludedInTopic = builder.isIncludedInTopic;
                this.neverAggregateInFilter = builder.neverAggregateInFilter;
                this.nonAdditive = builder.nonAdditive;
                this.notAllowedAggregations = builder.notAllowedAggregations;
                this.semanticType = builder.semanticType;
                this.timeGranularity = builder.timeGranularity;
            }

            @Override
            public final java.lang.String getCalculatedFieldName() {
                return this.calculatedFieldName;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getAggregation() {
                return this.aggregation;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedAggregations() {
                return this.allowedAggregations;
            }

            @Override
            public final java.lang.String getCalculatedFieldDescription() {
                return this.calculatedFieldDescription;
            }

            @Override
            public final java.util.List<java.lang.String> getCalculatedFieldSynonyms() {
                return this.calculatedFieldSynonyms;
            }

            @Override
            public final java.lang.Object getCellValueSynonyms() {
                return this.cellValueSynonyms;
            }

            @Override
            public final java.lang.String getColumnDataRole() {
                return this.columnDataRole;
            }

            @Override
            public final java.lang.Object getComparativeOrder() {
                return this.comparativeOrder;
            }

            @Override
            public final java.lang.Object getDefaultFormatting() {
                return this.defaultFormatting;
            }

            @Override
            public final java.lang.Object getDisableIndexing() {
                return this.disableIndexing;
            }

            @Override
            public final java.lang.Object getIsIncludedInTopic() {
                return this.isIncludedInTopic;
            }

            @Override
            public final java.lang.Object getNeverAggregateInFilter() {
                return this.neverAggregateInFilter;
            }

            @Override
            public final java.lang.Object getNonAdditive() {
                return this.nonAdditive;
            }

            @Override
            public final java.util.List<java.lang.String> getNotAllowedAggregations() {
                return this.notAllowedAggregations;
            }

            @Override
            public final java.lang.Object getSemanticType() {
                return this.semanticType;
            }

            @Override
            public final java.lang.String getTimeGranularity() {
                return this.timeGranularity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("calculatedFieldName", om.valueToTree(this.getCalculatedFieldName()));
                data.set("expression", om.valueToTree(this.getExpression()));
                if (this.getAggregation() != null) {
                    data.set("aggregation", om.valueToTree(this.getAggregation()));
                }
                if (this.getAllowedAggregations() != null) {
                    data.set("allowedAggregations", om.valueToTree(this.getAllowedAggregations()));
                }
                if (this.getCalculatedFieldDescription() != null) {
                    data.set("calculatedFieldDescription", om.valueToTree(this.getCalculatedFieldDescription()));
                }
                if (this.getCalculatedFieldSynonyms() != null) {
                    data.set("calculatedFieldSynonyms", om.valueToTree(this.getCalculatedFieldSynonyms()));
                }
                if (this.getCellValueSynonyms() != null) {
                    data.set("cellValueSynonyms", om.valueToTree(this.getCellValueSynonyms()));
                }
                if (this.getColumnDataRole() != null) {
                    data.set("columnDataRole", om.valueToTree(this.getColumnDataRole()));
                }
                if (this.getComparativeOrder() != null) {
                    data.set("comparativeOrder", om.valueToTree(this.getComparativeOrder()));
                }
                if (this.getDefaultFormatting() != null) {
                    data.set("defaultFormatting", om.valueToTree(this.getDefaultFormatting()));
                }
                if (this.getDisableIndexing() != null) {
                    data.set("disableIndexing", om.valueToTree(this.getDisableIndexing()));
                }
                if (this.getIsIncludedInTopic() != null) {
                    data.set("isIncludedInTopic", om.valueToTree(this.getIsIncludedInTopic()));
                }
                if (this.getNeverAggregateInFilter() != null) {
                    data.set("neverAggregateInFilter", om.valueToTree(this.getNeverAggregateInFilter()));
                }
                if (this.getNonAdditive() != null) {
                    data.set("nonAdditive", om.valueToTree(this.getNonAdditive()));
                }
                if (this.getNotAllowedAggregations() != null) {
                    data.set("notAllowedAggregations", om.valueToTree(this.getNotAllowedAggregations()));
                }
                if (this.getSemanticType() != null) {
                    data.set("semanticType", om.valueToTree(this.getSemanticType()));
                }
                if (this.getTimeGranularity() != null) {
                    data.set("timeGranularity", om.valueToTree(this.getTimeGranularity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicCalculatedFieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicCalculatedFieldProperty.Jsii$Proxy that = (TopicCalculatedFieldProperty.Jsii$Proxy) o;

                if (!calculatedFieldName.equals(that.calculatedFieldName)) return false;
                if (!expression.equals(that.expression)) return false;
                if (this.aggregation != null ? !this.aggregation.equals(that.aggregation) : that.aggregation != null) return false;
                if (this.allowedAggregations != null ? !this.allowedAggregations.equals(that.allowedAggregations) : that.allowedAggregations != null) return false;
                if (this.calculatedFieldDescription != null ? !this.calculatedFieldDescription.equals(that.calculatedFieldDescription) : that.calculatedFieldDescription != null) return false;
                if (this.calculatedFieldSynonyms != null ? !this.calculatedFieldSynonyms.equals(that.calculatedFieldSynonyms) : that.calculatedFieldSynonyms != null) return false;
                if (this.cellValueSynonyms != null ? !this.cellValueSynonyms.equals(that.cellValueSynonyms) : that.cellValueSynonyms != null) return false;
                if (this.columnDataRole != null ? !this.columnDataRole.equals(that.columnDataRole) : that.columnDataRole != null) return false;
                if (this.comparativeOrder != null ? !this.comparativeOrder.equals(that.comparativeOrder) : that.comparativeOrder != null) return false;
                if (this.defaultFormatting != null ? !this.defaultFormatting.equals(that.defaultFormatting) : that.defaultFormatting != null) return false;
                if (this.disableIndexing != null ? !this.disableIndexing.equals(that.disableIndexing) : that.disableIndexing != null) return false;
                if (this.isIncludedInTopic != null ? !this.isIncludedInTopic.equals(that.isIncludedInTopic) : that.isIncludedInTopic != null) return false;
                if (this.neverAggregateInFilter != null ? !this.neverAggregateInFilter.equals(that.neverAggregateInFilter) : that.neverAggregateInFilter != null) return false;
                if (this.nonAdditive != null ? !this.nonAdditive.equals(that.nonAdditive) : that.nonAdditive != null) return false;
                if (this.notAllowedAggregations != null ? !this.notAllowedAggregations.equals(that.notAllowedAggregations) : that.notAllowedAggregations != null) return false;
                if (this.semanticType != null ? !this.semanticType.equals(that.semanticType) : that.semanticType != null) return false;
                return this.timeGranularity != null ? this.timeGranularity.equals(that.timeGranularity) : that.timeGranularity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.calculatedFieldName.hashCode();
                result = 31 * result + (this.expression.hashCode());
                result = 31 * result + (this.aggregation != null ? this.aggregation.hashCode() : 0);
                result = 31 * result + (this.allowedAggregations != null ? this.allowedAggregations.hashCode() : 0);
                result = 31 * result + (this.calculatedFieldDescription != null ? this.calculatedFieldDescription.hashCode() : 0);
                result = 31 * result + (this.calculatedFieldSynonyms != null ? this.calculatedFieldSynonyms.hashCode() : 0);
                result = 31 * result + (this.cellValueSynonyms != null ? this.cellValueSynonyms.hashCode() : 0);
                result = 31 * result + (this.columnDataRole != null ? this.columnDataRole.hashCode() : 0);
                result = 31 * result + (this.comparativeOrder != null ? this.comparativeOrder.hashCode() : 0);
                result = 31 * result + (this.defaultFormatting != null ? this.defaultFormatting.hashCode() : 0);
                result = 31 * result + (this.disableIndexing != null ? this.disableIndexing.hashCode() : 0);
                result = 31 * result + (this.isIncludedInTopic != null ? this.isIncludedInTopic.hashCode() : 0);
                result = 31 * result + (this.neverAggregateInFilter != null ? this.neverAggregateInFilter.hashCode() : 0);
                result = 31 * result + (this.nonAdditive != null ? this.nonAdditive.hashCode() : 0);
                result = 31 * result + (this.notAllowedAggregations != null ? this.notAllowedAggregations.hashCode() : 0);
                result = 31 * result + (this.semanticType != null ? this.semanticType.hashCode() : 0);
                result = 31 * result + (this.timeGranularity != null ? this.timeGranularity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A constant used in a category filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicCategoryFilterConstantProperty topicCategoryFilterConstantProperty = TopicCategoryFilterConstantProperty.builder()
     *         .collectiveConstant(CollectiveConstantProperty.builder()
     *                 .valueList(List.of("valueList"))
     *                 .build())
     *         .constantType("constantType")
     *         .singularConstant("singularConstant")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilterconstant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilterconstant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicCategoryFilterConstantProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicCategoryFilterConstantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicCategoryFilterConstantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A collective constant used in a category filter.
         * <p>
         * This element is used to specify a list of values for the constant.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.CollectiveConstantProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilterconstant.html#cfn-quicksight-topic-topiccategoryfilterconstant-collectiveconstant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilterconstant.html#cfn-quicksight-topic-topiccategoryfilterconstant-collectiveconstant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCollectiveConstant() {
            return null;
        }

        /**
         * The type of category filter constant.
         * <p>
         * This element is used to specify whether a constant is a singular or collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilterconstant.html#cfn-quicksight-topic-topiccategoryfilterconstant-constanttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilterconstant.html#cfn-quicksight-topic-topiccategoryfilterconstant-constanttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantType() {
            return null;
        }

        /**
         * A singular constant used in a category filter.
         * <p>
         * This element is used to specify a single value for the constant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilterconstant.html#cfn-quicksight-topic-topiccategoryfilterconstant-singularconstant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilterconstant.html#cfn-quicksight-topic-topiccategoryfilterconstant-singularconstant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSingularConstant() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicCategoryFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicCategoryFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicCategoryFilterConstantProperty> {
            java.lang.Object collectiveConstant;
            java.lang.String constantType;
            java.lang.String singularConstant;

            /**
             * Sets the value of {@link TopicCategoryFilterConstantProperty#getCollectiveConstant}
             * @param collectiveConstant A collective constant used in a category filter.
             *                           This element is used to specify a list of values for the constant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectiveConstant(software.amazon.awscdk.IResolvable collectiveConstant) {
                this.collectiveConstant = collectiveConstant;
                return this;
            }

            /**
             * Sets the value of {@link TopicCategoryFilterConstantProperty#getCollectiveConstant}
             * @param collectiveConstant A collective constant used in a category filter.
             *                           This element is used to specify a list of values for the constant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectiveConstant(software.amazon.awscdk.services.quicksight.CfnTopic.CollectiveConstantProperty collectiveConstant) {
                this.collectiveConstant = collectiveConstant;
                return this;
            }

            /**
             * Sets the value of {@link TopicCategoryFilterConstantProperty#getConstantType}
             * @param constantType The type of category filter constant.
             *                     This element is used to specify whether a constant is a singular or collective. Valid values are <code>SINGULAR</code> and <code>COLLECTIVE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantType(java.lang.String constantType) {
                this.constantType = constantType;
                return this;
            }

            /**
             * Sets the value of {@link TopicCategoryFilterConstantProperty#getSingularConstant}
             * @param singularConstant A singular constant used in a category filter.
             *                         This element is used to specify a single value for the constant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singularConstant(java.lang.String singularConstant) {
                this.singularConstant = singularConstant;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicCategoryFilterConstantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicCategoryFilterConstantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicCategoryFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicCategoryFilterConstantProperty {
            private final java.lang.Object collectiveConstant;
            private final java.lang.String constantType;
            private final java.lang.String singularConstant;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.collectiveConstant = software.amazon.jsii.Kernel.get(this, "collectiveConstant", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.constantType = software.amazon.jsii.Kernel.get(this, "constantType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.singularConstant = software.amazon.jsii.Kernel.get(this, "singularConstant", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.collectiveConstant = builder.collectiveConstant;
                this.constantType = builder.constantType;
                this.singularConstant = builder.singularConstant;
            }

            @Override
            public final java.lang.Object getCollectiveConstant() {
                return this.collectiveConstant;
            }

            @Override
            public final java.lang.String getConstantType() {
                return this.constantType;
            }

            @Override
            public final java.lang.String getSingularConstant() {
                return this.singularConstant;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCollectiveConstant() != null) {
                    data.set("collectiveConstant", om.valueToTree(this.getCollectiveConstant()));
                }
                if (this.getConstantType() != null) {
                    data.set("constantType", om.valueToTree(this.getConstantType()));
                }
                if (this.getSingularConstant() != null) {
                    data.set("singularConstant", om.valueToTree(this.getSingularConstant()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicCategoryFilterConstantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicCategoryFilterConstantProperty.Jsii$Proxy that = (TopicCategoryFilterConstantProperty.Jsii$Proxy) o;

                if (this.collectiveConstant != null ? !this.collectiveConstant.equals(that.collectiveConstant) : that.collectiveConstant != null) return false;
                if (this.constantType != null ? !this.constantType.equals(that.constantType) : that.constantType != null) return false;
                return this.singularConstant != null ? this.singularConstant.equals(that.singularConstant) : that.singularConstant == null;
            }

            @Override
            public final int hashCode() {
                int result = this.collectiveConstant != null ? this.collectiveConstant.hashCode() : 0;
                result = 31 * result + (this.constantType != null ? this.constantType.hashCode() : 0);
                result = 31 * result + (this.singularConstant != null ? this.singularConstant.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a category filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicCategoryFilterProperty topicCategoryFilterProperty = TopicCategoryFilterProperty.builder()
     *         .categoryFilterFunction("categoryFilterFunction")
     *         .categoryFilterType("categoryFilterType")
     *         .constant(TopicCategoryFilterConstantProperty.builder()
     *                 .collectiveConstant(CollectiveConstantProperty.builder()
     *                         .valueList(List.of("valueList"))
     *                         .build())
     *                 .constantType("constantType")
     *                 .singularConstant("singularConstant")
     *                 .build())
     *         .inverse(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicCategoryFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicCategoryFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicCategoryFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The category filter function.
         * <p>
         * Valid values for this structure are <code>EXACT</code> and <code>CONTAINS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html#cfn-quicksight-topic-topiccategoryfilter-categoryfilterfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html#cfn-quicksight-topic-topiccategoryfilter-categoryfilterfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCategoryFilterFunction() {
            return null;
        }

        /**
         * The category filter type.
         * <p>
         * This element is used to specify whether a filter is a simple category filter or an inverse category filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html#cfn-quicksight-topic-topiccategoryfilter-categoryfiltertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html#cfn-quicksight-topic-topiccategoryfilter-categoryfiltertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCategoryFilterType() {
            return null;
        }

        /**
         * The constant used in a category filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicCategoryFilterConstantProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html#cfn-quicksight-topic-topiccategoryfilter-constant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html#cfn-quicksight-topic-topiccategoryfilter-constant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstant() {
            return null;
        }

        /**
         * A Boolean value that indicates if the filter is inverse.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html#cfn-quicksight-topic-topiccategoryfilter-inverse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccategoryfilter.html#cfn-quicksight-topic-topiccategoryfilter-inverse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInverse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicCategoryFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicCategoryFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicCategoryFilterProperty> {
            java.lang.String categoryFilterFunction;
            java.lang.String categoryFilterType;
            java.lang.Object constant;
            java.lang.Object inverse;

            /**
             * Sets the value of {@link TopicCategoryFilterProperty#getCategoryFilterFunction}
             * @param categoryFilterFunction The category filter function.
             *                               Valid values for this structure are <code>EXACT</code> and <code>CONTAINS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryFilterFunction(java.lang.String categoryFilterFunction) {
                this.categoryFilterFunction = categoryFilterFunction;
                return this;
            }

            /**
             * Sets the value of {@link TopicCategoryFilterProperty#getCategoryFilterType}
             * @param categoryFilterType The category filter type.
             *                           This element is used to specify whether a filter is a simple category filter or an inverse category filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryFilterType(java.lang.String categoryFilterType) {
                this.categoryFilterType = categoryFilterType;
                return this;
            }

            /**
             * Sets the value of {@link TopicCategoryFilterProperty#getConstant}
             * @param constant The constant used in a category filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.IResolvable constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicCategoryFilterProperty#getConstant}
             * @param constant The constant used in a category filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.services.quicksight.CfnTopic.TopicCategoryFilterConstantProperty constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicCategoryFilterProperty#getInverse}
             * @param inverse A Boolean value that indicates if the filter is inverse.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inverse(java.lang.Boolean inverse) {
                this.inverse = inverse;
                return this;
            }

            /**
             * Sets the value of {@link TopicCategoryFilterProperty#getInverse}
             * @param inverse A Boolean value that indicates if the filter is inverse.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inverse(software.amazon.awscdk.IResolvable inverse) {
                this.inverse = inverse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicCategoryFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicCategoryFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicCategoryFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicCategoryFilterProperty {
            private final java.lang.String categoryFilterFunction;
            private final java.lang.String categoryFilterType;
            private final java.lang.Object constant;
            private final java.lang.Object inverse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.categoryFilterFunction = software.amazon.jsii.Kernel.get(this, "categoryFilterFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.categoryFilterType = software.amazon.jsii.Kernel.get(this, "categoryFilterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constant = software.amazon.jsii.Kernel.get(this, "constant", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inverse = software.amazon.jsii.Kernel.get(this, "inverse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.categoryFilterFunction = builder.categoryFilterFunction;
                this.categoryFilterType = builder.categoryFilterType;
                this.constant = builder.constant;
                this.inverse = builder.inverse;
            }

            @Override
            public final java.lang.String getCategoryFilterFunction() {
                return this.categoryFilterFunction;
            }

            @Override
            public final java.lang.String getCategoryFilterType() {
                return this.categoryFilterType;
            }

            @Override
            public final java.lang.Object getConstant() {
                return this.constant;
            }

            @Override
            public final java.lang.Object getInverse() {
                return this.inverse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCategoryFilterFunction() != null) {
                    data.set("categoryFilterFunction", om.valueToTree(this.getCategoryFilterFunction()));
                }
                if (this.getCategoryFilterType() != null) {
                    data.set("categoryFilterType", om.valueToTree(this.getCategoryFilterType()));
                }
                if (this.getConstant() != null) {
                    data.set("constant", om.valueToTree(this.getConstant()));
                }
                if (this.getInverse() != null) {
                    data.set("inverse", om.valueToTree(this.getInverse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicCategoryFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicCategoryFilterProperty.Jsii$Proxy that = (TopicCategoryFilterProperty.Jsii$Proxy) o;

                if (this.categoryFilterFunction != null ? !this.categoryFilterFunction.equals(that.categoryFilterFunction) : that.categoryFilterFunction != null) return false;
                if (this.categoryFilterType != null ? !this.categoryFilterType.equals(that.categoryFilterType) : that.categoryFilterType != null) return false;
                if (this.constant != null ? !this.constant.equals(that.constant) : that.constant != null) return false;
                return this.inverse != null ? this.inverse.equals(that.inverse) : that.inverse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.categoryFilterFunction != null ? this.categoryFilterFunction.hashCode() : 0;
                result = 31 * result + (this.categoryFilterType != null ? this.categoryFilterType.hashCode() : 0);
                result = 31 * result + (this.constant != null ? this.constant.hashCode() : 0);
                result = 31 * result + (this.inverse != null ? this.inverse.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a column in a dataset.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicColumnProperty topicColumnProperty = TopicColumnProperty.builder()
     *         .columnName("columnName")
     *         // the properties below are optional
     *         .aggregation("aggregation")
     *         .allowedAggregations(List.of("allowedAggregations"))
     *         .cellValueSynonyms(List.of(CellValueSynonymProperty.builder()
     *                 .cellValue("cellValue")
     *                 .synonyms(List.of("synonyms"))
     *                 .build()))
     *         .columnDataRole("columnDataRole")
     *         .columnDescription("columnDescription")
     *         .columnFriendlyName("columnFriendlyName")
     *         .columnSynonyms(List.of("columnSynonyms"))
     *         .comparativeOrder(ComparativeOrderProperty.builder()
     *                 .specifedOrder(List.of("specifedOrder"))
     *                 .treatUndefinedSpecifiedValues("treatUndefinedSpecifiedValues")
     *                 .useOrdering("useOrdering")
     *                 .build())
     *         .defaultFormatting(DefaultFormattingProperty.builder()
     *                 .displayFormat("displayFormat")
     *                 .displayFormatOptions(DisplayFormatOptionsProperty.builder()
     *                         .blankCellFormat("blankCellFormat")
     *                         .currencySymbol("currencySymbol")
     *                         .dateFormat("dateFormat")
     *                         .decimalSeparator("decimalSeparator")
     *                         .fractionDigits(123)
     *                         .groupingSeparator("groupingSeparator")
     *                         .negativeFormat(NegativeFormatProperty.builder()
     *                                 .prefix("prefix")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .prefix("prefix")
     *                         .suffix("suffix")
     *                         .unitScaler("unitScaler")
     *                         .useBlankCellFormat(false)
     *                         .useGrouping(false)
     *                         .build())
     *                 .build())
     *         .disableIndexing(false)
     *         .isIncludedInTopic(false)
     *         .neverAggregateInFilter(false)
     *         .nonAdditive(false)
     *         .notAllowedAggregations(List.of("notAllowedAggregations"))
     *         .semanticType(SemanticTypeProperty.builder()
     *                 .falseyCellValue("falseyCellValue")
     *                 .falseyCellValueSynonyms(List.of("falseyCellValueSynonyms"))
     *                 .subTypeName("subTypeName")
     *                 .truthyCellValue("truthyCellValue")
     *                 .truthyCellValueSynonyms(List.of("truthyCellValueSynonyms"))
     *                 .typeName("typeName")
     *                 .typeParameters(Map.of(
     *                         "typeParametersKey", "typeParameters"))
     *                 .build())
     *         .timeGranularity("timeGranularity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The type of aggregation that is performed on the column data when it's queried.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-aggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-aggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregation() {
            return null;
        }

        /**
         * The list of aggregation types that are allowed for the column.
         * <p>
         * Valid values for this structure are <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , and <code>PERCENTILE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-allowedaggregations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-allowedaggregations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedAggregations() {
            return null;
        }

        /**
         * The other names or aliases for the column cell value.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.CellValueSynonymProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-cellvaluesynonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-cellvaluesynonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCellValueSynonyms() {
            return null;
        }

        /**
         * The role of the column in the data.
         * <p>
         * Valid values are <code>DIMENSION</code> and <code>MEASURE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columndatarole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columndatarole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnDataRole() {
            return null;
        }

        /**
         * A description of the column and its contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columndescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columndescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnDescription() {
            return null;
        }

        /**
         * A user-friendly name for the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columnfriendlyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columnfriendlyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getColumnFriendlyName() {
            return null;
        }

        /**
         * The other names or aliases for the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columnsynonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-columnsynonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumnSynonyms() {
            return null;
        }

        /**
         * The order in which data is displayed for the column when it's used in a comparative context.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.ComparativeOrderProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-comparativeorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-comparativeorder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComparativeOrder() {
            return null;
        }

        /**
         * The default formatting used for values in the column.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.DefaultFormattingProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-defaultformatting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-defaultformatting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultFormatting() {
            return null;
        }

        /**
         * A Boolean value that indicates whether the column shows in the autocomplete functionality.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-disableindexing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-disableindexing</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableIndexing() {
            return null;
        }

        /**
         * A Boolean value that indicates whether the column is included in the query results.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-isincludedintopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-isincludedintopic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsIncludedInTopic() {
            return null;
        }

        /**
         * A Boolean value that indicates whether to aggregate the column data when it's used in a filter context.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-neveraggregateinfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-neveraggregateinfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNeverAggregateInFilter() {
            return null;
        }

        /**
         * The non additive value for the column.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-nonadditive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-nonadditive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNonAdditive() {
            return null;
        }

        /**
         * The list of aggregation types that are not allowed for the column.
         * <p>
         * Valid values for this structure are <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , and <code>PERCENTILE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-notallowedaggregations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-notallowedaggregations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotAllowedAggregations() {
            return null;
        }

        /**
         * The semantic type of data contained in the column.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.SemanticTypeProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-semantictype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-semantictype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSemanticType() {
            return null;
        }

        /**
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-timegranularity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topiccolumn.html#cfn-quicksight-topic-topiccolumn-timegranularity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeGranularity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicColumnProperty> {
            java.lang.String columnName;
            java.lang.String aggregation;
            java.util.List<java.lang.String> allowedAggregations;
            java.lang.Object cellValueSynonyms;
            java.lang.String columnDataRole;
            java.lang.String columnDescription;
            java.lang.String columnFriendlyName;
            java.util.List<java.lang.String> columnSynonyms;
            java.lang.Object comparativeOrder;
            java.lang.Object defaultFormatting;
            java.lang.Object disableIndexing;
            java.lang.Object isIncludedInTopic;
            java.lang.Object neverAggregateInFilter;
            java.lang.Object nonAdditive;
            java.util.List<java.lang.String> notAllowedAggregations;
            java.lang.Object semanticType;
            java.lang.String timeGranularity;

            /**
             * Sets the value of {@link TopicColumnProperty#getColumnName}
             * @param columnName The name of the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getAggregation}
             * @param aggregation The type of aggregation that is performed on the column data when it's queried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(java.lang.String aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getAllowedAggregations}
             * @param allowedAggregations The list of aggregation types that are allowed for the column.
             *                            Valid values for this structure are <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , and <code>PERCENTILE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedAggregations(java.util.List<java.lang.String> allowedAggregations) {
                this.allowedAggregations = allowedAggregations;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getCellValueSynonyms}
             * @param cellValueSynonyms The other names or aliases for the column cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cellValueSynonyms(software.amazon.awscdk.IResolvable cellValueSynonyms) {
                this.cellValueSynonyms = cellValueSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getCellValueSynonyms}
             * @param cellValueSynonyms The other names or aliases for the column cell value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cellValueSynonyms(java.util.List<? extends java.lang.Object> cellValueSynonyms) {
                this.cellValueSynonyms = cellValueSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getColumnDataRole}
             * @param columnDataRole The role of the column in the data.
             *                       Valid values are <code>DIMENSION</code> and <code>MEASURE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDataRole(java.lang.String columnDataRole) {
                this.columnDataRole = columnDataRole;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getColumnDescription}
             * @param columnDescription A description of the column and its contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnDescription(java.lang.String columnDescription) {
                this.columnDescription = columnDescription;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getColumnFriendlyName}
             * @param columnFriendlyName A user-friendly name for the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnFriendlyName(java.lang.String columnFriendlyName) {
                this.columnFriendlyName = columnFriendlyName;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getColumnSynonyms}
             * @param columnSynonyms The other names or aliases for the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnSynonyms(java.util.List<java.lang.String> columnSynonyms) {
                this.columnSynonyms = columnSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getComparativeOrder}
             * @param comparativeOrder The order in which data is displayed for the column when it's used in a comparative context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparativeOrder(software.amazon.awscdk.IResolvable comparativeOrder) {
                this.comparativeOrder = comparativeOrder;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getComparativeOrder}
             * @param comparativeOrder The order in which data is displayed for the column when it's used in a comparative context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparativeOrder(software.amazon.awscdk.services.quicksight.CfnTopic.ComparativeOrderProperty comparativeOrder) {
                this.comparativeOrder = comparativeOrder;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getDefaultFormatting}
             * @param defaultFormatting The default formatting used for values in the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultFormatting(software.amazon.awscdk.IResolvable defaultFormatting) {
                this.defaultFormatting = defaultFormatting;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getDefaultFormatting}
             * @param defaultFormatting The default formatting used for values in the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultFormatting(software.amazon.awscdk.services.quicksight.CfnTopic.DefaultFormattingProperty defaultFormatting) {
                this.defaultFormatting = defaultFormatting;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getDisableIndexing}
             * @param disableIndexing A Boolean value that indicates whether the column shows in the autocomplete functionality.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableIndexing(java.lang.Boolean disableIndexing) {
                this.disableIndexing = disableIndexing;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getDisableIndexing}
             * @param disableIndexing A Boolean value that indicates whether the column shows in the autocomplete functionality.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableIndexing(software.amazon.awscdk.IResolvable disableIndexing) {
                this.disableIndexing = disableIndexing;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getIsIncludedInTopic}
             * @param isIncludedInTopic A Boolean value that indicates whether the column is included in the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isIncludedInTopic(java.lang.Boolean isIncludedInTopic) {
                this.isIncludedInTopic = isIncludedInTopic;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getIsIncludedInTopic}
             * @param isIncludedInTopic A Boolean value that indicates whether the column is included in the query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isIncludedInTopic(software.amazon.awscdk.IResolvable isIncludedInTopic) {
                this.isIncludedInTopic = isIncludedInTopic;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getNeverAggregateInFilter}
             * @param neverAggregateInFilter A Boolean value that indicates whether to aggregate the column data when it's used in a filter context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder neverAggregateInFilter(java.lang.Boolean neverAggregateInFilter) {
                this.neverAggregateInFilter = neverAggregateInFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getNeverAggregateInFilter}
             * @param neverAggregateInFilter A Boolean value that indicates whether to aggregate the column data when it's used in a filter context.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder neverAggregateInFilter(software.amazon.awscdk.IResolvable neverAggregateInFilter) {
                this.neverAggregateInFilter = neverAggregateInFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getNonAdditive}
             * @param nonAdditive The non additive value for the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonAdditive(java.lang.Boolean nonAdditive) {
                this.nonAdditive = nonAdditive;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getNonAdditive}
             * @param nonAdditive The non additive value for the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonAdditive(software.amazon.awscdk.IResolvable nonAdditive) {
                this.nonAdditive = nonAdditive;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getNotAllowedAggregations}
             * @param notAllowedAggregations The list of aggregation types that are not allowed for the column.
             *                               Valid values for this structure are <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MIN</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , <code>VARP</code> , and <code>PERCENTILE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notAllowedAggregations(java.util.List<java.lang.String> notAllowedAggregations) {
                this.notAllowedAggregations = notAllowedAggregations;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getSemanticType}
             * @param semanticType The semantic type of data contained in the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticType(software.amazon.awscdk.IResolvable semanticType) {
                this.semanticType = semanticType;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getSemanticType}
             * @param semanticType The semantic type of data contained in the column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticType(software.amazon.awscdk.services.quicksight.CfnTopic.SemanticTypeProperty semanticType) {
                this.semanticType = semanticType;
                return this;
            }

            /**
             * Sets the value of {@link TopicColumnProperty#getTimeGranularity}
             * @param timeGranularity The level of time precision that is used to aggregate <code>DateTime</code> values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeGranularity(java.lang.String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicColumnProperty {
            private final java.lang.String columnName;
            private final java.lang.String aggregation;
            private final java.util.List<java.lang.String> allowedAggregations;
            private final java.lang.Object cellValueSynonyms;
            private final java.lang.String columnDataRole;
            private final java.lang.String columnDescription;
            private final java.lang.String columnFriendlyName;
            private final java.util.List<java.lang.String> columnSynonyms;
            private final java.lang.Object comparativeOrder;
            private final java.lang.Object defaultFormatting;
            private final java.lang.Object disableIndexing;
            private final java.lang.Object isIncludedInTopic;
            private final java.lang.Object neverAggregateInFilter;
            private final java.lang.Object nonAdditive;
            private final java.util.List<java.lang.String> notAllowedAggregations;
            private final java.lang.Object semanticType;
            private final java.lang.String timeGranularity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.aggregation = software.amazon.jsii.Kernel.get(this, "aggregation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedAggregations = software.amazon.jsii.Kernel.get(this, "allowedAggregations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cellValueSynonyms = software.amazon.jsii.Kernel.get(this, "cellValueSynonyms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnDataRole = software.amazon.jsii.Kernel.get(this, "columnDataRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnDescription = software.amazon.jsii.Kernel.get(this, "columnDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnFriendlyName = software.amazon.jsii.Kernel.get(this, "columnFriendlyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnSynonyms = software.amazon.jsii.Kernel.get(this, "columnSynonyms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.comparativeOrder = software.amazon.jsii.Kernel.get(this, "comparativeOrder", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultFormatting = software.amazon.jsii.Kernel.get(this, "defaultFormatting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableIndexing = software.amazon.jsii.Kernel.get(this, "disableIndexing", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isIncludedInTopic = software.amazon.jsii.Kernel.get(this, "isIncludedInTopic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.neverAggregateInFilter = software.amazon.jsii.Kernel.get(this, "neverAggregateInFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nonAdditive = software.amazon.jsii.Kernel.get(this, "nonAdditive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.notAllowedAggregations = software.amazon.jsii.Kernel.get(this, "notAllowedAggregations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.semanticType = software.amazon.jsii.Kernel.get(this, "semanticType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeGranularity = software.amazon.jsii.Kernel.get(this, "timeGranularity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.aggregation = builder.aggregation;
                this.allowedAggregations = builder.allowedAggregations;
                this.cellValueSynonyms = builder.cellValueSynonyms;
                this.columnDataRole = builder.columnDataRole;
                this.columnDescription = builder.columnDescription;
                this.columnFriendlyName = builder.columnFriendlyName;
                this.columnSynonyms = builder.columnSynonyms;
                this.comparativeOrder = builder.comparativeOrder;
                this.defaultFormatting = builder.defaultFormatting;
                this.disableIndexing = builder.disableIndexing;
                this.isIncludedInTopic = builder.isIncludedInTopic;
                this.neverAggregateInFilter = builder.neverAggregateInFilter;
                this.nonAdditive = builder.nonAdditive;
                this.notAllowedAggregations = builder.notAllowedAggregations;
                this.semanticType = builder.semanticType;
                this.timeGranularity = builder.timeGranularity;
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getAggregation() {
                return this.aggregation;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedAggregations() {
                return this.allowedAggregations;
            }

            @Override
            public final java.lang.Object getCellValueSynonyms() {
                return this.cellValueSynonyms;
            }

            @Override
            public final java.lang.String getColumnDataRole() {
                return this.columnDataRole;
            }

            @Override
            public final java.lang.String getColumnDescription() {
                return this.columnDescription;
            }

            @Override
            public final java.lang.String getColumnFriendlyName() {
                return this.columnFriendlyName;
            }

            @Override
            public final java.util.List<java.lang.String> getColumnSynonyms() {
                return this.columnSynonyms;
            }

            @Override
            public final java.lang.Object getComparativeOrder() {
                return this.comparativeOrder;
            }

            @Override
            public final java.lang.Object getDefaultFormatting() {
                return this.defaultFormatting;
            }

            @Override
            public final java.lang.Object getDisableIndexing() {
                return this.disableIndexing;
            }

            @Override
            public final java.lang.Object getIsIncludedInTopic() {
                return this.isIncludedInTopic;
            }

            @Override
            public final java.lang.Object getNeverAggregateInFilter() {
                return this.neverAggregateInFilter;
            }

            @Override
            public final java.lang.Object getNonAdditive() {
                return this.nonAdditive;
            }

            @Override
            public final java.util.List<java.lang.String> getNotAllowedAggregations() {
                return this.notAllowedAggregations;
            }

            @Override
            public final java.lang.Object getSemanticType() {
                return this.semanticType;
            }

            @Override
            public final java.lang.String getTimeGranularity() {
                return this.timeGranularity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                if (this.getAggregation() != null) {
                    data.set("aggregation", om.valueToTree(this.getAggregation()));
                }
                if (this.getAllowedAggregations() != null) {
                    data.set("allowedAggregations", om.valueToTree(this.getAllowedAggregations()));
                }
                if (this.getCellValueSynonyms() != null) {
                    data.set("cellValueSynonyms", om.valueToTree(this.getCellValueSynonyms()));
                }
                if (this.getColumnDataRole() != null) {
                    data.set("columnDataRole", om.valueToTree(this.getColumnDataRole()));
                }
                if (this.getColumnDescription() != null) {
                    data.set("columnDescription", om.valueToTree(this.getColumnDescription()));
                }
                if (this.getColumnFriendlyName() != null) {
                    data.set("columnFriendlyName", om.valueToTree(this.getColumnFriendlyName()));
                }
                if (this.getColumnSynonyms() != null) {
                    data.set("columnSynonyms", om.valueToTree(this.getColumnSynonyms()));
                }
                if (this.getComparativeOrder() != null) {
                    data.set("comparativeOrder", om.valueToTree(this.getComparativeOrder()));
                }
                if (this.getDefaultFormatting() != null) {
                    data.set("defaultFormatting", om.valueToTree(this.getDefaultFormatting()));
                }
                if (this.getDisableIndexing() != null) {
                    data.set("disableIndexing", om.valueToTree(this.getDisableIndexing()));
                }
                if (this.getIsIncludedInTopic() != null) {
                    data.set("isIncludedInTopic", om.valueToTree(this.getIsIncludedInTopic()));
                }
                if (this.getNeverAggregateInFilter() != null) {
                    data.set("neverAggregateInFilter", om.valueToTree(this.getNeverAggregateInFilter()));
                }
                if (this.getNonAdditive() != null) {
                    data.set("nonAdditive", om.valueToTree(this.getNonAdditive()));
                }
                if (this.getNotAllowedAggregations() != null) {
                    data.set("notAllowedAggregations", om.valueToTree(this.getNotAllowedAggregations()));
                }
                if (this.getSemanticType() != null) {
                    data.set("semanticType", om.valueToTree(this.getSemanticType()));
                }
                if (this.getTimeGranularity() != null) {
                    data.set("timeGranularity", om.valueToTree(this.getTimeGranularity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicColumnProperty.Jsii$Proxy that = (TopicColumnProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                if (this.aggregation != null ? !this.aggregation.equals(that.aggregation) : that.aggregation != null) return false;
                if (this.allowedAggregations != null ? !this.allowedAggregations.equals(that.allowedAggregations) : that.allowedAggregations != null) return false;
                if (this.cellValueSynonyms != null ? !this.cellValueSynonyms.equals(that.cellValueSynonyms) : that.cellValueSynonyms != null) return false;
                if (this.columnDataRole != null ? !this.columnDataRole.equals(that.columnDataRole) : that.columnDataRole != null) return false;
                if (this.columnDescription != null ? !this.columnDescription.equals(that.columnDescription) : that.columnDescription != null) return false;
                if (this.columnFriendlyName != null ? !this.columnFriendlyName.equals(that.columnFriendlyName) : that.columnFriendlyName != null) return false;
                if (this.columnSynonyms != null ? !this.columnSynonyms.equals(that.columnSynonyms) : that.columnSynonyms != null) return false;
                if (this.comparativeOrder != null ? !this.comparativeOrder.equals(that.comparativeOrder) : that.comparativeOrder != null) return false;
                if (this.defaultFormatting != null ? !this.defaultFormatting.equals(that.defaultFormatting) : that.defaultFormatting != null) return false;
                if (this.disableIndexing != null ? !this.disableIndexing.equals(that.disableIndexing) : that.disableIndexing != null) return false;
                if (this.isIncludedInTopic != null ? !this.isIncludedInTopic.equals(that.isIncludedInTopic) : that.isIncludedInTopic != null) return false;
                if (this.neverAggregateInFilter != null ? !this.neverAggregateInFilter.equals(that.neverAggregateInFilter) : that.neverAggregateInFilter != null) return false;
                if (this.nonAdditive != null ? !this.nonAdditive.equals(that.nonAdditive) : that.nonAdditive != null) return false;
                if (this.notAllowedAggregations != null ? !this.notAllowedAggregations.equals(that.notAllowedAggregations) : that.notAllowedAggregations != null) return false;
                if (this.semanticType != null ? !this.semanticType.equals(that.semanticType) : that.semanticType != null) return false;
                return this.timeGranularity != null ? this.timeGranularity.equals(that.timeGranularity) : that.timeGranularity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.aggregation != null ? this.aggregation.hashCode() : 0);
                result = 31 * result + (this.allowedAggregations != null ? this.allowedAggregations.hashCode() : 0);
                result = 31 * result + (this.cellValueSynonyms != null ? this.cellValueSynonyms.hashCode() : 0);
                result = 31 * result + (this.columnDataRole != null ? this.columnDataRole.hashCode() : 0);
                result = 31 * result + (this.columnDescription != null ? this.columnDescription.hashCode() : 0);
                result = 31 * result + (this.columnFriendlyName != null ? this.columnFriendlyName.hashCode() : 0);
                result = 31 * result + (this.columnSynonyms != null ? this.columnSynonyms.hashCode() : 0);
                result = 31 * result + (this.comparativeOrder != null ? this.comparativeOrder.hashCode() : 0);
                result = 31 * result + (this.defaultFormatting != null ? this.defaultFormatting.hashCode() : 0);
                result = 31 * result + (this.disableIndexing != null ? this.disableIndexing.hashCode() : 0);
                result = 31 * result + (this.isIncludedInTopic != null ? this.isIncludedInTopic.hashCode() : 0);
                result = 31 * result + (this.neverAggregateInFilter != null ? this.neverAggregateInFilter.hashCode() : 0);
                result = 31 * result + (this.nonAdditive != null ? this.nonAdditive.hashCode() : 0);
                result = 31 * result + (this.notAllowedAggregations != null ? this.notAllowedAggregations.hashCode() : 0);
                result = 31 * result + (this.semanticType != null ? this.semanticType.hashCode() : 0);
                result = 31 * result + (this.timeGranularity != null ? this.timeGranularity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration options for a <code>Topic</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicConfigOptionsProperty topicConfigOptionsProperty = TopicConfigOptionsProperty.builder()
     *         .qBusinessInsightsEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicconfigoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicconfigoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicConfigOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicConfigOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicConfigOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables Amazon Q Business Insights for a <code>Topic</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicconfigoptions.html#cfn-quicksight-topic-topicconfigoptions-qbusinessinsightsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicconfigoptions.html#cfn-quicksight-topic-topicconfigoptions-qbusinessinsightsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQBusinessInsightsEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicConfigOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicConfigOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicConfigOptionsProperty> {
            java.lang.Object qBusinessInsightsEnabled;

            /**
             * Sets the value of {@link TopicConfigOptionsProperty#getQBusinessInsightsEnabled}
             * @param qBusinessInsightsEnabled Enables Amazon Q Business Insights for a <code>Topic</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qBusinessInsightsEnabled(java.lang.Boolean qBusinessInsightsEnabled) {
                this.qBusinessInsightsEnabled = qBusinessInsightsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link TopicConfigOptionsProperty#getQBusinessInsightsEnabled}
             * @param qBusinessInsightsEnabled Enables Amazon Q Business Insights for a <code>Topic</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder qBusinessInsightsEnabled(software.amazon.awscdk.IResolvable qBusinessInsightsEnabled) {
                this.qBusinessInsightsEnabled = qBusinessInsightsEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicConfigOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicConfigOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicConfigOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicConfigOptionsProperty {
            private final java.lang.Object qBusinessInsightsEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.qBusinessInsightsEnabled = software.amazon.jsii.Kernel.get(this, "qBusinessInsightsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.qBusinessInsightsEnabled = builder.qBusinessInsightsEnabled;
            }

            @Override
            public final java.lang.Object getQBusinessInsightsEnabled() {
                return this.qBusinessInsightsEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getQBusinessInsightsEnabled() != null) {
                    data.set("qBusinessInsightsEnabled", om.valueToTree(this.getQBusinessInsightsEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicConfigOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicConfigOptionsProperty.Jsii$Proxy that = (TopicConfigOptionsProperty.Jsii$Proxy) o;

                return this.qBusinessInsightsEnabled != null ? this.qBusinessInsightsEnabled.equals(that.qBusinessInsightsEnabled) : that.qBusinessInsightsEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.qBusinessInsightsEnabled != null ? this.qBusinessInsightsEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A filter used to restrict data based on a range of dates or times.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicDateRangeFilterProperty topicDateRangeFilterProperty = TopicDateRangeFilterProperty.builder()
     *         .constant(TopicRangeFilterConstantProperty.builder()
     *                 .constantType("constantType")
     *                 .rangeConstant(RangeConstantProperty.builder()
     *                         .maximum("maximum")
     *                         .minimum("minimum")
     *                         .build())
     *                 .build())
     *         .inclusive(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicdaterangefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicdaterangefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicDateRangeFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicDateRangeFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicDateRangeFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The constant used in a date range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicRangeFilterConstantProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicdaterangefilter.html#cfn-quicksight-topic-topicdaterangefilter-constant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicdaterangefilter.html#cfn-quicksight-topic-topicdaterangefilter-constant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstant() {
            return null;
        }

        /**
         * A Boolean value that indicates whether the date range filter should include the boundary values.
         * <p>
         * If set to true, the filter includes the start and end dates. If set to false, the filter excludes them.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicdaterangefilter.html#cfn-quicksight-topic-topicdaterangefilter-inclusive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicdaterangefilter.html#cfn-quicksight-topic-topicdaterangefilter-inclusive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInclusive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicDateRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicDateRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicDateRangeFilterProperty> {
            java.lang.Object constant;
            java.lang.Object inclusive;

            /**
             * Sets the value of {@link TopicDateRangeFilterProperty#getConstant}
             * @param constant The constant used in a date range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.IResolvable constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicDateRangeFilterProperty#getConstant}
             * @param constant The constant used in a date range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.services.quicksight.CfnTopic.TopicRangeFilterConstantProperty constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicDateRangeFilterProperty#getInclusive}
             * @param inclusive A Boolean value that indicates whether the date range filter should include the boundary values.
             *                  If set to true, the filter includes the start and end dates. If set to false, the filter excludes them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusive(java.lang.Boolean inclusive) {
                this.inclusive = inclusive;
                return this;
            }

            /**
             * Sets the value of {@link TopicDateRangeFilterProperty#getInclusive}
             * @param inclusive A Boolean value that indicates whether the date range filter should include the boundary values.
             *                  If set to true, the filter includes the start and end dates. If set to false, the filter excludes them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusive(software.amazon.awscdk.IResolvable inclusive) {
                this.inclusive = inclusive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicDateRangeFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicDateRangeFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicDateRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicDateRangeFilterProperty {
            private final java.lang.Object constant;
            private final java.lang.Object inclusive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constant = software.amazon.jsii.Kernel.get(this, "constant", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inclusive = software.amazon.jsii.Kernel.get(this, "inclusive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constant = builder.constant;
                this.inclusive = builder.inclusive;
            }

            @Override
            public final java.lang.Object getConstant() {
                return this.constant;
            }

            @Override
            public final java.lang.Object getInclusive() {
                return this.inclusive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstant() != null) {
                    data.set("constant", om.valueToTree(this.getConstant()));
                }
                if (this.getInclusive() != null) {
                    data.set("inclusive", om.valueToTree(this.getInclusive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicDateRangeFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicDateRangeFilterProperty.Jsii$Proxy that = (TopicDateRangeFilterProperty.Jsii$Proxy) o;

                if (this.constant != null ? !this.constant.equals(that.constant) : that.constant != null) return false;
                return this.inclusive != null ? this.inclusive.equals(that.inclusive) : that.inclusive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constant != null ? this.constant.hashCode() : 0;
                result = 31 * result + (this.inclusive != null ? this.inclusive.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a filter used to select items for a topic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicFilterProperty topicFilterProperty = TopicFilterProperty.builder()
     *         .filterName("filterName")
     *         .operandFieldName("operandFieldName")
     *         // the properties below are optional
     *         .categoryFilter(TopicCategoryFilterProperty.builder()
     *                 .categoryFilterFunction("categoryFilterFunction")
     *                 .categoryFilterType("categoryFilterType")
     *                 .constant(TopicCategoryFilterConstantProperty.builder()
     *                         .collectiveConstant(CollectiveConstantProperty.builder()
     *                                 .valueList(List.of("valueList"))
     *                                 .build())
     *                         .constantType("constantType")
     *                         .singularConstant("singularConstant")
     *                         .build())
     *                 .inverse(false)
     *                 .build())
     *         .dateRangeFilter(TopicDateRangeFilterProperty.builder()
     *                 .constant(TopicRangeFilterConstantProperty.builder()
     *                         .constantType("constantType")
     *                         .rangeConstant(RangeConstantProperty.builder()
     *                                 .maximum("maximum")
     *                                 .minimum("minimum")
     *                                 .build())
     *                         .build())
     *                 .inclusive(false)
     *                 .build())
     *         .filterClass("filterClass")
     *         .filterDescription("filterDescription")
     *         .filterSynonyms(List.of("filterSynonyms"))
     *         .filterType("filterType")
     *         .numericEqualityFilter(TopicNumericEqualityFilterProperty.builder()
     *                 .aggregation("aggregation")
     *                 .constant(TopicSingularFilterConstantProperty.builder()
     *                         .constantType("constantType")
     *                         .singularConstant("singularConstant")
     *                         .build())
     *                 .build())
     *         .numericRangeFilter(TopicNumericRangeFilterProperty.builder()
     *                 .aggregation("aggregation")
     *                 .constant(TopicRangeFilterConstantProperty.builder()
     *                         .constantType("constantType")
     *                         .rangeConstant(RangeConstantProperty.builder()
     *                                 .maximum("maximum")
     *                                 .minimum("minimum")
     *                                 .build())
     *                         .build())
     *                 .inclusive(false)
     *                 .build())
     *         .relativeDateFilter(TopicRelativeDateFilterProperty.builder()
     *                 .constant(TopicSingularFilterConstantProperty.builder()
     *                         .constantType("constantType")
     *                         .singularConstant("singularConstant")
     *                         .build())
     *                 .relativeDateFilterFunction("relativeDateFilterFunction")
     *                 .timeGranularity("timeGranularity")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filtername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filtername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFilterName();

        /**
         * The name of the field that the filter operates on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-operandfieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-operandfieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOperandFieldName();

        /**
         * The category filter that is associated with this filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicCategoryFilterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-categoryfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-categoryfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCategoryFilter() {
            return null;
        }

        /**
         * The date range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicDateRangeFilterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-daterangefilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-daterangefilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateRangeFilter() {
            return null;
        }

        /**
         * The class of the filter.
         * <p>
         * Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code> , <code>CONDITIONAL_VALUE_FILTER</code> , and <code>NAMED_VALUE_FILTER</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filterclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filterclass</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilterClass() {
            return null;
        }

        /**
         * A description of the filter used to select items for a topic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filterdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filterdescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilterDescription() {
            return null;
        }

        /**
         * The other names or aliases for the filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filtersynonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filtersynonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFilterSynonyms() {
            return null;
        }

        /**
         * The type of the filter.
         * <p>
         * Valid values for this structure are <code>CATEGORY_FILTER</code> , <code>NUMERIC_EQUALITY_FILTER</code> , <code>NUMERIC_RANGE_FILTER</code> , <code>DATE_RANGE_FILTER</code> , and <code>RELATIVE_DATE_FILTER</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filtertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-filtertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilterType() {
            return null;
        }

        /**
         * The numeric equality filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicNumericEqualityFilterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-numericequalityfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-numericequalityfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumericEqualityFilter() {
            return null;
        }

        /**
         * The numeric range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicNumericRangeFilterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-numericrangefilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-numericrangefilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumericRangeFilter() {
            return null;
        }

        /**
         * The relative date filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicRelativeDateFilterProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-relativedatefilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicfilter.html#cfn-quicksight-topic-topicfilter-relativedatefilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelativeDateFilter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicFilterProperty> {
            java.lang.String filterName;
            java.lang.String operandFieldName;
            java.lang.Object categoryFilter;
            java.lang.Object dateRangeFilter;
            java.lang.String filterClass;
            java.lang.String filterDescription;
            java.util.List<java.lang.String> filterSynonyms;
            java.lang.String filterType;
            java.lang.Object numericEqualityFilter;
            java.lang.Object numericRangeFilter;
            java.lang.Object relativeDateFilter;

            /**
             * Sets the value of {@link TopicFilterProperty#getFilterName}
             * @param filterName The name of the filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterName(java.lang.String filterName) {
                this.filterName = filterName;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getOperandFieldName}
             * @param operandFieldName The name of the field that the filter operates on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operandFieldName(java.lang.String operandFieldName) {
                this.operandFieldName = operandFieldName;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getCategoryFilter}
             * @param categoryFilter The category filter that is associated with this filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryFilter(software.amazon.awscdk.IResolvable categoryFilter) {
                this.categoryFilter = categoryFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getCategoryFilter}
             * @param categoryFilter The category filter that is associated with this filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder categoryFilter(software.amazon.awscdk.services.quicksight.CfnTopic.TopicCategoryFilterProperty categoryFilter) {
                this.categoryFilter = categoryFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getDateRangeFilter}
             * @param dateRangeFilter The date range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateRangeFilter(software.amazon.awscdk.IResolvable dateRangeFilter) {
                this.dateRangeFilter = dateRangeFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getDateRangeFilter}
             * @param dateRangeFilter The date range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateRangeFilter(software.amazon.awscdk.services.quicksight.CfnTopic.TopicDateRangeFilterProperty dateRangeFilter) {
                this.dateRangeFilter = dateRangeFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getFilterClass}
             * @param filterClass The class of the filter.
             *                    Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code> , <code>CONDITIONAL_VALUE_FILTER</code> , and <code>NAMED_VALUE_FILTER</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterClass(java.lang.String filterClass) {
                this.filterClass = filterClass;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getFilterDescription}
             * @param filterDescription A description of the filter used to select items for a topic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterDescription(java.lang.String filterDescription) {
                this.filterDescription = filterDescription;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getFilterSynonyms}
             * @param filterSynonyms The other names or aliases for the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterSynonyms(java.util.List<java.lang.String> filterSynonyms) {
                this.filterSynonyms = filterSynonyms;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getFilterType}
             * @param filterType The type of the filter.
             *                   Valid values for this structure are <code>CATEGORY_FILTER</code> , <code>NUMERIC_EQUALITY_FILTER</code> , <code>NUMERIC_RANGE_FILTER</code> , <code>DATE_RANGE_FILTER</code> , and <code>RELATIVE_DATE_FILTER</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterType(java.lang.String filterType) {
                this.filterType = filterType;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getNumericEqualityFilter}
             * @param numericEqualityFilter The numeric equality filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericEqualityFilter(software.amazon.awscdk.IResolvable numericEqualityFilter) {
                this.numericEqualityFilter = numericEqualityFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getNumericEqualityFilter}
             * @param numericEqualityFilter The numeric equality filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericEqualityFilter(software.amazon.awscdk.services.quicksight.CfnTopic.TopicNumericEqualityFilterProperty numericEqualityFilter) {
                this.numericEqualityFilter = numericEqualityFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getNumericRangeFilter}
             * @param numericRangeFilter The numeric range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericRangeFilter(software.amazon.awscdk.IResolvable numericRangeFilter) {
                this.numericRangeFilter = numericRangeFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getNumericRangeFilter}
             * @param numericRangeFilter The numeric range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numericRangeFilter(software.amazon.awscdk.services.quicksight.CfnTopic.TopicNumericRangeFilterProperty numericRangeFilter) {
                this.numericRangeFilter = numericRangeFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getRelativeDateFilter}
             * @param relativeDateFilter The relative date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relativeDateFilter(software.amazon.awscdk.IResolvable relativeDateFilter) {
                this.relativeDateFilter = relativeDateFilter;
                return this;
            }

            /**
             * Sets the value of {@link TopicFilterProperty#getRelativeDateFilter}
             * @param relativeDateFilter The relative date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relativeDateFilter(software.amazon.awscdk.services.quicksight.CfnTopic.TopicRelativeDateFilterProperty relativeDateFilter) {
                this.relativeDateFilter = relativeDateFilter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicFilterProperty {
            private final java.lang.String filterName;
            private final java.lang.String operandFieldName;
            private final java.lang.Object categoryFilter;
            private final java.lang.Object dateRangeFilter;
            private final java.lang.String filterClass;
            private final java.lang.String filterDescription;
            private final java.util.List<java.lang.String> filterSynonyms;
            private final java.lang.String filterType;
            private final java.lang.Object numericEqualityFilter;
            private final java.lang.Object numericRangeFilter;
            private final java.lang.Object relativeDateFilter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterName = software.amazon.jsii.Kernel.get(this, "filterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operandFieldName = software.amazon.jsii.Kernel.get(this, "operandFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.categoryFilter = software.amazon.jsii.Kernel.get(this, "categoryFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dateRangeFilter = software.amazon.jsii.Kernel.get(this, "dateRangeFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filterClass = software.amazon.jsii.Kernel.get(this, "filterClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterDescription = software.amazon.jsii.Kernel.get(this, "filterDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.filterSynonyms = software.amazon.jsii.Kernel.get(this, "filterSynonyms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.filterType = software.amazon.jsii.Kernel.get(this, "filterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numericEqualityFilter = software.amazon.jsii.Kernel.get(this, "numericEqualityFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numericRangeFilter = software.amazon.jsii.Kernel.get(this, "numericRangeFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relativeDateFilter = software.amazon.jsii.Kernel.get(this, "relativeDateFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterName = java.util.Objects.requireNonNull(builder.filterName, "filterName is required");
                this.operandFieldName = java.util.Objects.requireNonNull(builder.operandFieldName, "operandFieldName is required");
                this.categoryFilter = builder.categoryFilter;
                this.dateRangeFilter = builder.dateRangeFilter;
                this.filterClass = builder.filterClass;
                this.filterDescription = builder.filterDescription;
                this.filterSynonyms = builder.filterSynonyms;
                this.filterType = builder.filterType;
                this.numericEqualityFilter = builder.numericEqualityFilter;
                this.numericRangeFilter = builder.numericRangeFilter;
                this.relativeDateFilter = builder.relativeDateFilter;
            }

            @Override
            public final java.lang.String getFilterName() {
                return this.filterName;
            }

            @Override
            public final java.lang.String getOperandFieldName() {
                return this.operandFieldName;
            }

            @Override
            public final java.lang.Object getCategoryFilter() {
                return this.categoryFilter;
            }

            @Override
            public final java.lang.Object getDateRangeFilter() {
                return this.dateRangeFilter;
            }

            @Override
            public final java.lang.String getFilterClass() {
                return this.filterClass;
            }

            @Override
            public final java.lang.String getFilterDescription() {
                return this.filterDescription;
            }

            @Override
            public final java.util.List<java.lang.String> getFilterSynonyms() {
                return this.filterSynonyms;
            }

            @Override
            public final java.lang.String getFilterType() {
                return this.filterType;
            }

            @Override
            public final java.lang.Object getNumericEqualityFilter() {
                return this.numericEqualityFilter;
            }

            @Override
            public final java.lang.Object getNumericRangeFilter() {
                return this.numericRangeFilter;
            }

            @Override
            public final java.lang.Object getRelativeDateFilter() {
                return this.relativeDateFilter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filterName", om.valueToTree(this.getFilterName()));
                data.set("operandFieldName", om.valueToTree(this.getOperandFieldName()));
                if (this.getCategoryFilter() != null) {
                    data.set("categoryFilter", om.valueToTree(this.getCategoryFilter()));
                }
                if (this.getDateRangeFilter() != null) {
                    data.set("dateRangeFilter", om.valueToTree(this.getDateRangeFilter()));
                }
                if (this.getFilterClass() != null) {
                    data.set("filterClass", om.valueToTree(this.getFilterClass()));
                }
                if (this.getFilterDescription() != null) {
                    data.set("filterDescription", om.valueToTree(this.getFilterDescription()));
                }
                if (this.getFilterSynonyms() != null) {
                    data.set("filterSynonyms", om.valueToTree(this.getFilterSynonyms()));
                }
                if (this.getFilterType() != null) {
                    data.set("filterType", om.valueToTree(this.getFilterType()));
                }
                if (this.getNumericEqualityFilter() != null) {
                    data.set("numericEqualityFilter", om.valueToTree(this.getNumericEqualityFilter()));
                }
                if (this.getNumericRangeFilter() != null) {
                    data.set("numericRangeFilter", om.valueToTree(this.getNumericRangeFilter()));
                }
                if (this.getRelativeDateFilter() != null) {
                    data.set("relativeDateFilter", om.valueToTree(this.getRelativeDateFilter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicFilterProperty.Jsii$Proxy that = (TopicFilterProperty.Jsii$Proxy) o;

                if (!filterName.equals(that.filterName)) return false;
                if (!operandFieldName.equals(that.operandFieldName)) return false;
                if (this.categoryFilter != null ? !this.categoryFilter.equals(that.categoryFilter) : that.categoryFilter != null) return false;
                if (this.dateRangeFilter != null ? !this.dateRangeFilter.equals(that.dateRangeFilter) : that.dateRangeFilter != null) return false;
                if (this.filterClass != null ? !this.filterClass.equals(that.filterClass) : that.filterClass != null) return false;
                if (this.filterDescription != null ? !this.filterDescription.equals(that.filterDescription) : that.filterDescription != null) return false;
                if (this.filterSynonyms != null ? !this.filterSynonyms.equals(that.filterSynonyms) : that.filterSynonyms != null) return false;
                if (this.filterType != null ? !this.filterType.equals(that.filterType) : that.filterType != null) return false;
                if (this.numericEqualityFilter != null ? !this.numericEqualityFilter.equals(that.numericEqualityFilter) : that.numericEqualityFilter != null) return false;
                if (this.numericRangeFilter != null ? !this.numericRangeFilter.equals(that.numericRangeFilter) : that.numericRangeFilter != null) return false;
                return this.relativeDateFilter != null ? this.relativeDateFilter.equals(that.relativeDateFilter) : that.relativeDateFilter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filterName.hashCode();
                result = 31 * result + (this.operandFieldName.hashCode());
                result = 31 * result + (this.categoryFilter != null ? this.categoryFilter.hashCode() : 0);
                result = 31 * result + (this.dateRangeFilter != null ? this.dateRangeFilter.hashCode() : 0);
                result = 31 * result + (this.filterClass != null ? this.filterClass.hashCode() : 0);
                result = 31 * result + (this.filterDescription != null ? this.filterDescription.hashCode() : 0);
                result = 31 * result + (this.filterSynonyms != null ? this.filterSynonyms.hashCode() : 0);
                result = 31 * result + (this.filterType != null ? this.filterType.hashCode() : 0);
                result = 31 * result + (this.numericEqualityFilter != null ? this.numericEqualityFilter.hashCode() : 0);
                result = 31 * result + (this.numericRangeFilter != null ? this.numericRangeFilter.hashCode() : 0);
                result = 31 * result + (this.relativeDateFilter != null ? this.relativeDateFilter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a named entity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicNamedEntityProperty topicNamedEntityProperty = TopicNamedEntityProperty.builder()
     *         .entityName("entityName")
     *         // the properties below are optional
     *         .definition(List.of(NamedEntityDefinitionProperty.builder()
     *                 .fieldName("fieldName")
     *                 .metric(NamedEntityDefinitionMetricProperty.builder()
     *                         .aggregation("aggregation")
     *                         .aggregationFunctionParameters(Map.of(
     *                                 "aggregationFunctionParametersKey", "aggregationFunctionParameters"))
     *                         .build())
     *                 .propertyName("propertyName")
     *                 .propertyRole("propertyRole")
     *                 .propertyUsage("propertyUsage")
     *                 .build()))
     *         .entityDescription("entityDescription")
     *         .entitySynonyms(List.of("entitySynonyms"))
     *         .semanticEntityType(SemanticEntityTypeProperty.builder()
     *                 .subTypeName("subTypeName")
     *                 .typeName("typeName")
     *                 .typeParameters(Map.of(
     *                         "typeParametersKey", "typeParameters"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicNamedEntityProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicNamedEntityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicNamedEntityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the named entity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-entityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-entityname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityName();

        /**
         * The definition of a named entity.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.NamedEntityDefinitionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-definition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
            return null;
        }

        /**
         * The description of the named entity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-entitydescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-entitydescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntityDescription() {
            return null;
        }

        /**
         * The other names or aliases for the named entity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-entitysynonyms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-entitysynonyms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEntitySynonyms() {
            return null;
        }

        /**
         * The type of named entity that a topic represents.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.SemanticEntityTypeProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-semanticentitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnamedentity.html#cfn-quicksight-topic-topicnamedentity-semanticentitytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSemanticEntityType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicNamedEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicNamedEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicNamedEntityProperty> {
            java.lang.String entityName;
            java.lang.Object definition;
            java.lang.String entityDescription;
            java.util.List<java.lang.String> entitySynonyms;
            java.lang.Object semanticEntityType;

            /**
             * Sets the value of {@link TopicNamedEntityProperty#getEntityName}
             * @param entityName The name of the named entity. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityName(java.lang.String entityName) {
                this.entityName = entityName;
                return this;
            }

            /**
             * Sets the value of {@link TopicNamedEntityProperty#getDefinition}
             * @param definition The definition of a named entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(software.amazon.awscdk.IResolvable definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Sets the value of {@link TopicNamedEntityProperty#getDefinition}
             * @param definition The definition of a named entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(java.util.List<? extends java.lang.Object> definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Sets the value of {@link TopicNamedEntityProperty#getEntityDescription}
             * @param entityDescription The description of the named entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityDescription(java.lang.String entityDescription) {
                this.entityDescription = entityDescription;
                return this;
            }

            /**
             * Sets the value of {@link TopicNamedEntityProperty#getEntitySynonyms}
             * @param entitySynonyms The other names or aliases for the named entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entitySynonyms(java.util.List<java.lang.String> entitySynonyms) {
                this.entitySynonyms = entitySynonyms;
                return this;
            }

            /**
             * Sets the value of {@link TopicNamedEntityProperty#getSemanticEntityType}
             * @param semanticEntityType The type of named entity that a topic represents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticEntityType(software.amazon.awscdk.IResolvable semanticEntityType) {
                this.semanticEntityType = semanticEntityType;
                return this;
            }

            /**
             * Sets the value of {@link TopicNamedEntityProperty#getSemanticEntityType}
             * @param semanticEntityType The type of named entity that a topic represents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder semanticEntityType(software.amazon.awscdk.services.quicksight.CfnTopic.SemanticEntityTypeProperty semanticEntityType) {
                this.semanticEntityType = semanticEntityType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicNamedEntityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicNamedEntityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicNamedEntityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicNamedEntityProperty {
            private final java.lang.String entityName;
            private final java.lang.Object definition;
            private final java.lang.String entityDescription;
            private final java.util.List<java.lang.String> entitySynonyms;
            private final java.lang.Object semanticEntityType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityName = software.amazon.jsii.Kernel.get(this, "entityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.entityDescription = software.amazon.jsii.Kernel.get(this, "entityDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entitySynonyms = software.amazon.jsii.Kernel.get(this, "entitySynonyms", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.semanticEntityType = software.amazon.jsii.Kernel.get(this, "semanticEntityType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityName = java.util.Objects.requireNonNull(builder.entityName, "entityName is required");
                this.definition = builder.definition;
                this.entityDescription = builder.entityDescription;
                this.entitySynonyms = builder.entitySynonyms;
                this.semanticEntityType = builder.semanticEntityType;
            }

            @Override
            public final java.lang.String getEntityName() {
                return this.entityName;
            }

            @Override
            public final java.lang.Object getDefinition() {
                return this.definition;
            }

            @Override
            public final java.lang.String getEntityDescription() {
                return this.entityDescription;
            }

            @Override
            public final java.util.List<java.lang.String> getEntitySynonyms() {
                return this.entitySynonyms;
            }

            @Override
            public final java.lang.Object getSemanticEntityType() {
                return this.semanticEntityType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityName", om.valueToTree(this.getEntityName()));
                if (this.getDefinition() != null) {
                    data.set("definition", om.valueToTree(this.getDefinition()));
                }
                if (this.getEntityDescription() != null) {
                    data.set("entityDescription", om.valueToTree(this.getEntityDescription()));
                }
                if (this.getEntitySynonyms() != null) {
                    data.set("entitySynonyms", om.valueToTree(this.getEntitySynonyms()));
                }
                if (this.getSemanticEntityType() != null) {
                    data.set("semanticEntityType", om.valueToTree(this.getSemanticEntityType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicNamedEntityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicNamedEntityProperty.Jsii$Proxy that = (TopicNamedEntityProperty.Jsii$Proxy) o;

                if (!entityName.equals(that.entityName)) return false;
                if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
                if (this.entityDescription != null ? !this.entityDescription.equals(that.entityDescription) : that.entityDescription != null) return false;
                if (this.entitySynonyms != null ? !this.entitySynonyms.equals(that.entitySynonyms) : that.entitySynonyms != null) return false;
                return this.semanticEntityType != null ? this.semanticEntityType.equals(that.semanticEntityType) : that.semanticEntityType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityName.hashCode();
                result = 31 * result + (this.definition != null ? this.definition.hashCode() : 0);
                result = 31 * result + (this.entityDescription != null ? this.entityDescription.hashCode() : 0);
                result = 31 * result + (this.entitySynonyms != null ? this.entitySynonyms.hashCode() : 0);
                result = 31 * result + (this.semanticEntityType != null ? this.semanticEntityType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter that filters topics based on the value of a numeric field.
     * <p>
     * The filter includes only topics whose numeric field value matches the specified value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicNumericEqualityFilterProperty topicNumericEqualityFilterProperty = TopicNumericEqualityFilterProperty.builder()
     *         .aggregation("aggregation")
     *         .constant(TopicSingularFilterConstantProperty.builder()
     *                 .constantType("constantType")
     *                 .singularConstant("singularConstant")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericequalityfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericequalityfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicNumericEqualityFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicNumericEqualityFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicNumericEqualityFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An aggregation function that specifies how to calculate the value of a numeric field for a topic.
         * <p>
         * Valid values for this structure are <code>NO_AGGREGATION</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>MIN</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , and <code>VARP</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericequalityfilter.html#cfn-quicksight-topic-topicnumericequalityfilter-aggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericequalityfilter.html#cfn-quicksight-topic-topicnumericequalityfilter-aggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregation() {
            return null;
        }

        /**
         * The constant used in a numeric equality filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicSingularFilterConstantProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericequalityfilter.html#cfn-quicksight-topic-topicnumericequalityfilter-constant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericequalityfilter.html#cfn-quicksight-topic-topicnumericequalityfilter-constant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstant() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicNumericEqualityFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicNumericEqualityFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicNumericEqualityFilterProperty> {
            java.lang.String aggregation;
            java.lang.Object constant;

            /**
             * Sets the value of {@link TopicNumericEqualityFilterProperty#getAggregation}
             * @param aggregation An aggregation function that specifies how to calculate the value of a numeric field for a topic.
             *                    Valid values for this structure are <code>NO_AGGREGATION</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>MIN</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , and <code>VARP</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(java.lang.String aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link TopicNumericEqualityFilterProperty#getConstant}
             * @param constant The constant used in a numeric equality filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.IResolvable constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicNumericEqualityFilterProperty#getConstant}
             * @param constant The constant used in a numeric equality filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.services.quicksight.CfnTopic.TopicSingularFilterConstantProperty constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicNumericEqualityFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicNumericEqualityFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicNumericEqualityFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicNumericEqualityFilterProperty {
            private final java.lang.String aggregation;
            private final java.lang.Object constant;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregation = software.amazon.jsii.Kernel.get(this, "aggregation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constant = software.amazon.jsii.Kernel.get(this, "constant", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregation = builder.aggregation;
                this.constant = builder.constant;
            }

            @Override
            public final java.lang.String getAggregation() {
                return this.aggregation;
            }

            @Override
            public final java.lang.Object getConstant() {
                return this.constant;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregation() != null) {
                    data.set("aggregation", om.valueToTree(this.getAggregation()));
                }
                if (this.getConstant() != null) {
                    data.set("constant", om.valueToTree(this.getConstant()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicNumericEqualityFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicNumericEqualityFilterProperty.Jsii$Proxy that = (TopicNumericEqualityFilterProperty.Jsii$Proxy) o;

                if (this.aggregation != null ? !this.aggregation.equals(that.aggregation) : that.aggregation != null) return false;
                return this.constant != null ? this.constant.equals(that.constant) : that.constant == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregation != null ? this.aggregation.hashCode() : 0;
                result = 31 * result + (this.constant != null ? this.constant.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A filter that filters topics based on the value of a numeric field.
     * <p>
     * The filter includes only topics whose numeric field value falls within the specified range.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicNumericRangeFilterProperty topicNumericRangeFilterProperty = TopicNumericRangeFilterProperty.builder()
     *         .aggregation("aggregation")
     *         .constant(TopicRangeFilterConstantProperty.builder()
     *                 .constantType("constantType")
     *                 .rangeConstant(RangeConstantProperty.builder()
     *                         .maximum("maximum")
     *                         .minimum("minimum")
     *                         .build())
     *                 .build())
     *         .inclusive(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericrangefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericrangefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicNumericRangeFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicNumericRangeFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicNumericRangeFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid values for this structure are <code>NO_AGGREGATION</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>MIN</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , and <code>VARP</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericrangefilter.html#cfn-quicksight-topic-topicnumericrangefilter-aggregation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericrangefilter.html#cfn-quicksight-topic-topicnumericrangefilter-aggregation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregation() {
            return null;
        }

        /**
         * The constant used in a numeric range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicRangeFilterConstantProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericrangefilter.html#cfn-quicksight-topic-topicnumericrangefilter-constant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericrangefilter.html#cfn-quicksight-topic-topicnumericrangefilter-constant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstant() {
            return null;
        }

        /**
         * A Boolean value that indicates whether the endpoints of the numeric range are included in the filter.
         * <p>
         * If set to true, topics whose numeric field value is equal to the endpoint values will be included in the filter. If set to false, topics whose numeric field value is equal to the endpoint values will be excluded from the filter.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericrangefilter.html#cfn-quicksight-topic-topicnumericrangefilter-inclusive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicnumericrangefilter.html#cfn-quicksight-topic-topicnumericrangefilter-inclusive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInclusive() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicNumericRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicNumericRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicNumericRangeFilterProperty> {
            java.lang.String aggregation;
            java.lang.Object constant;
            java.lang.Object inclusive;

            /**
             * Sets the value of {@link TopicNumericRangeFilterProperty#getAggregation}
             * @param aggregation An aggregation function that specifies how to calculate the value of a numeric field for a topic, Valid values for this structure are <code>NO_AGGREGATION</code> , <code>SUM</code> , <code>AVERAGE</code> , <code>COUNT</code> , <code>DISTINCT_COUNT</code> , <code>MAX</code> , <code>MEDIAN</code> , <code>MIN</code> , <code>STDEV</code> , <code>STDEVP</code> , <code>VAR</code> , and <code>VARP</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregation(java.lang.String aggregation) {
                this.aggregation = aggregation;
                return this;
            }

            /**
             * Sets the value of {@link TopicNumericRangeFilterProperty#getConstant}
             * @param constant The constant used in a numeric range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.IResolvable constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicNumericRangeFilterProperty#getConstant}
             * @param constant The constant used in a numeric range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.services.quicksight.CfnTopic.TopicRangeFilterConstantProperty constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicNumericRangeFilterProperty#getInclusive}
             * @param inclusive A Boolean value that indicates whether the endpoints of the numeric range are included in the filter.
             *                  If set to true, topics whose numeric field value is equal to the endpoint values will be included in the filter. If set to false, topics whose numeric field value is equal to the endpoint values will be excluded from the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusive(java.lang.Boolean inclusive) {
                this.inclusive = inclusive;
                return this;
            }

            /**
             * Sets the value of {@link TopicNumericRangeFilterProperty#getInclusive}
             * @param inclusive A Boolean value that indicates whether the endpoints of the numeric range are included in the filter.
             *                  If set to true, topics whose numeric field value is equal to the endpoint values will be included in the filter. If set to false, topics whose numeric field value is equal to the endpoint values will be excluded from the filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inclusive(software.amazon.awscdk.IResolvable inclusive) {
                this.inclusive = inclusive;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicNumericRangeFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicNumericRangeFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicNumericRangeFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicNumericRangeFilterProperty {
            private final java.lang.String aggregation;
            private final java.lang.Object constant;
            private final java.lang.Object inclusive;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregation = software.amazon.jsii.Kernel.get(this, "aggregation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.constant = software.amazon.jsii.Kernel.get(this, "constant", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inclusive = software.amazon.jsii.Kernel.get(this, "inclusive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregation = builder.aggregation;
                this.constant = builder.constant;
                this.inclusive = builder.inclusive;
            }

            @Override
            public final java.lang.String getAggregation() {
                return this.aggregation;
            }

            @Override
            public final java.lang.Object getConstant() {
                return this.constant;
            }

            @Override
            public final java.lang.Object getInclusive() {
                return this.inclusive;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregation() != null) {
                    data.set("aggregation", om.valueToTree(this.getAggregation()));
                }
                if (this.getConstant() != null) {
                    data.set("constant", om.valueToTree(this.getConstant()));
                }
                if (this.getInclusive() != null) {
                    data.set("inclusive", om.valueToTree(this.getInclusive()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicNumericRangeFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicNumericRangeFilterProperty.Jsii$Proxy that = (TopicNumericRangeFilterProperty.Jsii$Proxy) o;

                if (this.aggregation != null ? !this.aggregation.equals(that.aggregation) : that.aggregation != null) return false;
                if (this.constant != null ? !this.constant.equals(that.constant) : that.constant != null) return false;
                return this.inclusive != null ? this.inclusive.equals(that.inclusive) : that.inclusive == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregation != null ? this.aggregation.hashCode() : 0;
                result = 31 * result + (this.constant != null ? this.constant.hashCode() : 0);
                result = 31 * result + (this.inclusive != null ? this.inclusive.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A constant value that is used in a range filter to specify the endpoints of the range.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicRangeFilterConstantProperty topicRangeFilterConstantProperty = TopicRangeFilterConstantProperty.builder()
     *         .constantType("constantType")
     *         .rangeConstant(RangeConstantProperty.builder()
     *                 .maximum("maximum")
     *                 .minimum("minimum")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrangefilterconstant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrangefilterconstant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicRangeFilterConstantProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicRangeFilterConstantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicRangeFilterConstantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data type of the constant value that is used in a range filter.
         * <p>
         * Valid values for this structure are <code>RANGE</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrangefilterconstant.html#cfn-quicksight-topic-topicrangefilterconstant-constanttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrangefilterconstant.html#cfn-quicksight-topic-topicrangefilterconstant-constanttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantType() {
            return null;
        }

        /**
         * The value of the constant that is used to specify the endpoints of a range filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.RangeConstantProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrangefilterconstant.html#cfn-quicksight-topic-topicrangefilterconstant-rangeconstant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrangefilterconstant.html#cfn-quicksight-topic-topicrangefilterconstant-rangeconstant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRangeConstant() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicRangeFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicRangeFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicRangeFilterConstantProperty> {
            java.lang.String constantType;
            java.lang.Object rangeConstant;

            /**
             * Sets the value of {@link TopicRangeFilterConstantProperty#getConstantType}
             * @param constantType The data type of the constant value that is used in a range filter.
             *                     Valid values for this structure are <code>RANGE</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantType(java.lang.String constantType) {
                this.constantType = constantType;
                return this;
            }

            /**
             * Sets the value of {@link TopicRangeFilterConstantProperty#getRangeConstant}
             * @param rangeConstant The value of the constant that is used to specify the endpoints of a range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeConstant(software.amazon.awscdk.IResolvable rangeConstant) {
                this.rangeConstant = rangeConstant;
                return this;
            }

            /**
             * Sets the value of {@link TopicRangeFilterConstantProperty#getRangeConstant}
             * @param rangeConstant The value of the constant that is used to specify the endpoints of a range filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rangeConstant(software.amazon.awscdk.services.quicksight.CfnTopic.RangeConstantProperty rangeConstant) {
                this.rangeConstant = rangeConstant;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicRangeFilterConstantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicRangeFilterConstantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicRangeFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicRangeFilterConstantProperty {
            private final java.lang.String constantType;
            private final java.lang.Object rangeConstant;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constantType = software.amazon.jsii.Kernel.get(this, "constantType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rangeConstant = software.amazon.jsii.Kernel.get(this, "rangeConstant", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constantType = builder.constantType;
                this.rangeConstant = builder.rangeConstant;
            }

            @Override
            public final java.lang.String getConstantType() {
                return this.constantType;
            }

            @Override
            public final java.lang.Object getRangeConstant() {
                return this.rangeConstant;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstantType() != null) {
                    data.set("constantType", om.valueToTree(this.getConstantType()));
                }
                if (this.getRangeConstant() != null) {
                    data.set("rangeConstant", om.valueToTree(this.getRangeConstant()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicRangeFilterConstantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicRangeFilterConstantProperty.Jsii$Proxy that = (TopicRangeFilterConstantProperty.Jsii$Proxy) o;

                if (this.constantType != null ? !this.constantType.equals(that.constantType) : that.constantType != null) return false;
                return this.rangeConstant != null ? this.rangeConstant.equals(that.rangeConstant) : that.rangeConstant == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constantType != null ? this.constantType.hashCode() : 0;
                result = 31 * result + (this.rangeConstant != null ? this.rangeConstant.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a relative date filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicRelativeDateFilterProperty topicRelativeDateFilterProperty = TopicRelativeDateFilterProperty.builder()
     *         .constant(TopicSingularFilterConstantProperty.builder()
     *                 .constantType("constantType")
     *                 .singularConstant("singularConstant")
     *                 .build())
     *         .relativeDateFilterFunction("relativeDateFilterFunction")
     *         .timeGranularity("timeGranularity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrelativedatefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrelativedatefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicRelativeDateFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicRelativeDateFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicRelativeDateFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The constant used in a relative date filter.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.quicksight.CfnTopic.TopicSingularFilterConstantProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrelativedatefilter.html#cfn-quicksight-topic-topicrelativedatefilter-constant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrelativedatefilter.html#cfn-quicksight-topic-topicrelativedatefilter-constant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstant() {
            return null;
        }

        /**
         * The function to be used in a relative date filter to determine the range of dates to include in the results.
         * <p>
         * Valid values for this structure are <code>BEFORE</code> , <code>AFTER</code> , and <code>BETWEEN</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrelativedatefilter.html#cfn-quicksight-topic-topicrelativedatefilter-relativedatefilterfunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrelativedatefilter.html#cfn-quicksight-topic-topicrelativedatefilter-relativedatefilterfunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRelativeDateFilterFunction() {
            return null;
        }

        /**
         * The level of time precision that is used to aggregate <code>DateTime</code> values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrelativedatefilter.html#cfn-quicksight-topic-topicrelativedatefilter-timegranularity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicrelativedatefilter.html#cfn-quicksight-topic-topicrelativedatefilter-timegranularity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeGranularity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicRelativeDateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicRelativeDateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicRelativeDateFilterProperty> {
            java.lang.Object constant;
            java.lang.String relativeDateFilterFunction;
            java.lang.String timeGranularity;

            /**
             * Sets the value of {@link TopicRelativeDateFilterProperty#getConstant}
             * @param constant The constant used in a relative date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.IResolvable constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicRelativeDateFilterProperty#getConstant}
             * @param constant The constant used in a relative date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constant(software.amazon.awscdk.services.quicksight.CfnTopic.TopicSingularFilterConstantProperty constant) {
                this.constant = constant;
                return this;
            }

            /**
             * Sets the value of {@link TopicRelativeDateFilterProperty#getRelativeDateFilterFunction}
             * @param relativeDateFilterFunction The function to be used in a relative date filter to determine the range of dates to include in the results.
             *                                   Valid values for this structure are <code>BEFORE</code> , <code>AFTER</code> , and <code>BETWEEN</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relativeDateFilterFunction(java.lang.String relativeDateFilterFunction) {
                this.relativeDateFilterFunction = relativeDateFilterFunction;
                return this;
            }

            /**
             * Sets the value of {@link TopicRelativeDateFilterProperty#getTimeGranularity}
             * @param timeGranularity The level of time precision that is used to aggregate <code>DateTime</code> values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeGranularity(java.lang.String timeGranularity) {
                this.timeGranularity = timeGranularity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicRelativeDateFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicRelativeDateFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicRelativeDateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicRelativeDateFilterProperty {
            private final java.lang.Object constant;
            private final java.lang.String relativeDateFilterFunction;
            private final java.lang.String timeGranularity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constant = software.amazon.jsii.Kernel.get(this, "constant", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relativeDateFilterFunction = software.amazon.jsii.Kernel.get(this, "relativeDateFilterFunction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeGranularity = software.amazon.jsii.Kernel.get(this, "timeGranularity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constant = builder.constant;
                this.relativeDateFilterFunction = builder.relativeDateFilterFunction;
                this.timeGranularity = builder.timeGranularity;
            }

            @Override
            public final java.lang.Object getConstant() {
                return this.constant;
            }

            @Override
            public final java.lang.String getRelativeDateFilterFunction() {
                return this.relativeDateFilterFunction;
            }

            @Override
            public final java.lang.String getTimeGranularity() {
                return this.timeGranularity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstant() != null) {
                    data.set("constant", om.valueToTree(this.getConstant()));
                }
                if (this.getRelativeDateFilterFunction() != null) {
                    data.set("relativeDateFilterFunction", om.valueToTree(this.getRelativeDateFilterFunction()));
                }
                if (this.getTimeGranularity() != null) {
                    data.set("timeGranularity", om.valueToTree(this.getTimeGranularity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicRelativeDateFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicRelativeDateFilterProperty.Jsii$Proxy that = (TopicRelativeDateFilterProperty.Jsii$Proxy) o;

                if (this.constant != null ? !this.constant.equals(that.constant) : that.constant != null) return false;
                if (this.relativeDateFilterFunction != null ? !this.relativeDateFilterFunction.equals(that.relativeDateFilterFunction) : that.relativeDateFilterFunction != null) return false;
                return this.timeGranularity != null ? this.timeGranularity.equals(that.timeGranularity) : that.timeGranularity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constant != null ? this.constant.hashCode() : 0;
                result = 31 * result + (this.relativeDateFilterFunction != null ? this.relativeDateFilterFunction.hashCode() : 0);
                result = 31 * result + (this.timeGranularity != null ? this.timeGranularity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that represents a singular filter constant, used in filters to specify a single value to match against.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.quicksight.*;
     * TopicSingularFilterConstantProperty topicSingularFilterConstantProperty = TopicSingularFilterConstantProperty.builder()
     *         .constantType("constantType")
     *         .singularConstant("singularConstant")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicsingularfilterconstant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicsingularfilterconstant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnTopic.TopicSingularFilterConstantProperty")
    @software.amazon.jsii.Jsii.Proxy(TopicSingularFilterConstantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TopicSingularFilterConstantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the singular filter constant.
         * <p>
         * Valid values for this structure are <code>SINGULAR</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicsingularfilterconstant.html#cfn-quicksight-topic-topicsingularfilterconstant-constanttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicsingularfilterconstant.html#cfn-quicksight-topic-topicsingularfilterconstant-constanttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantType() {
            return null;
        }

        /**
         * The value of the singular filter constant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicsingularfilterconstant.html#cfn-quicksight-topic-topicsingularfilterconstant-singularconstant">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-topic-topicsingularfilterconstant.html#cfn-quicksight-topic-topicsingularfilterconstant-singularconstant</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSingularConstant() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TopicSingularFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TopicSingularFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TopicSingularFilterConstantProperty> {
            java.lang.String constantType;
            java.lang.String singularConstant;

            /**
             * Sets the value of {@link TopicSingularFilterConstantProperty#getConstantType}
             * @param constantType The type of the singular filter constant.
             *                     Valid values for this structure are <code>SINGULAR</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantType(java.lang.String constantType) {
                this.constantType = constantType;
                return this;
            }

            /**
             * Sets the value of {@link TopicSingularFilterConstantProperty#getSingularConstant}
             * @param singularConstant The value of the singular filter constant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singularConstant(java.lang.String singularConstant) {
                this.singularConstant = singularConstant;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TopicSingularFilterConstantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TopicSingularFilterConstantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TopicSingularFilterConstantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TopicSingularFilterConstantProperty {
            private final java.lang.String constantType;
            private final java.lang.String singularConstant;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constantType = software.amazon.jsii.Kernel.get(this, "constantType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.singularConstant = software.amazon.jsii.Kernel.get(this, "singularConstant", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constantType = builder.constantType;
                this.singularConstant = builder.singularConstant;
            }

            @Override
            public final java.lang.String getConstantType() {
                return this.constantType;
            }

            @Override
            public final java.lang.String getSingularConstant() {
                return this.singularConstant;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstantType() != null) {
                    data.set("constantType", om.valueToTree(this.getConstantType()));
                }
                if (this.getSingularConstant() != null) {
                    data.set("singularConstant", om.valueToTree(this.getSingularConstant()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnTopic.TopicSingularFilterConstantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TopicSingularFilterConstantProperty.Jsii$Proxy that = (TopicSingularFilterConstantProperty.Jsii$Proxy) o;

                if (this.constantType != null ? !this.constantType.equals(that.constantType) : that.constantType != null) return false;
                return this.singularConstant != null ? this.singularConstant.equals(that.singularConstant) : that.singularConstant == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constantType != null ? this.constantType.hashCode() : 0;
                result = 31 * result + (this.singularConstant != null ? this.singularConstant.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.quicksight.CfnTopic}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.quicksight.CfnTopic> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.quicksight.CfnTopicProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The ID of the AWS account that you want to create a topic in.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-awsaccountid</a>
         * @param awsAccountId The ID of the AWS account that you want to create a topic in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(final java.lang.String awsAccountId) {
            this.props().awsAccountId(awsAccountId);
            return this;
        }

        /**
         * Configuration options for a <code>Topic</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-configoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-configoptions</a>
         * @param configOptions Configuration options for a <code>Topic</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configOptions(final software.amazon.awscdk.IResolvable configOptions) {
            this.props().configOptions(configOptions);
            return this;
        }
        /**
         * Configuration options for a <code>Topic</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-configoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-configoptions</a>
         * @param configOptions Configuration options for a <code>Topic</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configOptions(final software.amazon.awscdk.services.quicksight.CfnTopic.TopicConfigOptionsProperty configOptions) {
            this.props().configOptions(configOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-custominstructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-custominstructions</a>
         * @param customInstructions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customInstructions(final software.amazon.awscdk.IResolvable customInstructions) {
            this.props().customInstructions(customInstructions);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-custominstructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-custominstructions</a>
         * @param customInstructions This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customInstructions(final software.amazon.awscdk.services.quicksight.CfnTopic.CustomInstructionsProperty customInstructions) {
            this.props().customInstructions(customInstructions);
            return this;
        }

        /**
         * The data sets that the topic is associated with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-datasets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-datasets</a>
         * @param dataSets The data sets that the topic is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSets(final software.amazon.awscdk.IResolvable dataSets) {
            this.props().dataSets(dataSets);
            return this;
        }
        /**
         * The data sets that the topic is associated with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-datasets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-datasets</a>
         * @param dataSets The data sets that the topic is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSets(final java.util.List<? extends java.lang.Object> dataSets) {
            this.props().dataSets(dataSets);
            return this;
        }

        /**
         * The description of the topic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-description</a>
         * @param description The description of the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-folderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-folderarns</a>
         * @param folderArns This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder folderArns(final java.util.List<java.lang.String> folderArns) {
            this.props().folderArns(folderArns);
            return this;
        }

        /**
         * The name of the topic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-name</a>
         * @param name The name of the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-tags</a>
         * @param tags This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The ID for the topic.
         * <p>
         * This ID is unique per AWS Region for each AWS account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-topicid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-topicid</a>
         * @param topicId The ID for the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicId(final java.lang.String topicId) {
            this.props().topicId(topicId);
            return this;
        }

        /**
         * The user experience version of the topic.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-userexperienceversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-topic.html#cfn-quicksight-topic-userexperienceversion</a>
         * @param userExperienceVersion The user experience version of the topic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userExperienceVersion(final java.lang.String userExperienceVersion) {
            this.props().userExperienceVersion(userExperienceVersion);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.quicksight.CfnTopic}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.quicksight.CfnTopic build() {
            return new software.amazon.awscdk.services.quicksight.CfnTopic(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.quicksight.CfnTopicProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.quicksight.CfnTopicProps.Builder();
            }
            return this.props;
        }
    }
}
