package software.amazon.awscdk.services.ram;

/**
 * A reference to a ResourceShare resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ram.*;
 * ResourceShareReference resourceShareReference = ResourceShareReference.builder()
 *         .resourceShareArn("resourceShareArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.064Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ram.ResourceShareReference")
@software.amazon.jsii.Jsii.Proxy(ResourceShareReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourceShareReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the ResourceShare resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceShareArn();

    /**
     * @return a {@link Builder} of {@link ResourceShareReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourceShareReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourceShareReference> {
        java.lang.String resourceShareArn;

        /**
         * Sets the value of {@link ResourceShareReference#getResourceShareArn}
         * @param resourceShareArn The Arn of the ResourceShare resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceShareArn(java.lang.String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourceShareReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourceShareReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourceShareReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceShareReference {
        private final java.lang.String resourceShareArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceShareArn = software.amazon.jsii.Kernel.get(this, "resourceShareArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceShareArn = java.util.Objects.requireNonNull(builder.resourceShareArn, "resourceShareArn is required");
        }

        @Override
        public final java.lang.String getResourceShareArn() {
            return this.resourceShareArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceShareArn", om.valueToTree(this.getResourceShareArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ram.ResourceShareReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourceShareReference.Jsii$Proxy that = (ResourceShareReference.Jsii$Proxy) o;

            return this.resourceShareArn.equals(that.resourceShareArn);
        }

        @Override
        public final int hashCode() {
            int result = this.resourceShareArn.hashCode();
            return result;
        }
    }
}
