package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnDBProxy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBProxyProps cfnDBProxyProps = CfnDBProxyProps.builder()
 *         .dbProxyName("dbProxyName")
 *         .engineFamily("engineFamily")
 *         .roleArn("roleArn")
 *         .vpcSubnetIds(List.of("vpcSubnetIds"))
 *         // the properties below are optional
 *         .auth(List.of(AuthFormatProperty.builder()
 *                 .authScheme("authScheme")
 *                 .clientPasswordAuthType("clientPasswordAuthType")
 *                 .description("description")
 *                 .iamAuth("iamAuth")
 *                 .secretArn("secretArn")
 *                 .build()))
 *         .debugLogging(false)
 *         .defaultAuthScheme("defaultAuthScheme")
 *         .endpointNetworkType("endpointNetworkType")
 *         .idleClientTimeout(123)
 *         .requireTls(false)
 *         .tags(List.of(TagFormatProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetConnectionNetworkType("targetConnectionNetworkType")
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.228Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBProxyProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBProxyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBProxyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier for the proxy.
     * <p>
     * This name must be unique for all proxies owned by your AWS account in the specified AWS Region . An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-dbproxyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-dbproxyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbProxyName();

    /**
     * The kinds of databases that the proxy can connect to.
     * <p>
     * This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code> . For Aurora PostgreSQL and RDS for PostgreSQL databases, specify <code>POSTGRESQL</code> . For RDS for Microsoft SQL Server, specify <code>SQLSERVER</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-enginefamily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-enginefamily</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngineFamily();

    /**
     * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsubnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsubnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getVpcSubnetIds();

    /**
     * The authorization mechanism that the proxy uses.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.rds.CfnDBProxy.AuthFormatProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-auth">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-auth</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuth() {
        return null;
    }

    /**
     * Specifies whether the proxy logs detailed connection and query information.
     * <p>
     * When you enable <code>DebugLogging</code> , the proxy captures connection details and connection pool behavior from your queries. Debug logging increases CloudWatch costs and can impact proxy performance. Enable this option only when you need to troubleshoot connection or performance issues.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-debuglogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-debuglogging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDebugLogging() {
        return null;
    }

    /**
     * The default authentication scheme that the proxy uses for client connections to the proxy and connections from the proxy to the underlying database.
     * <p>
     * Valid values are <code>NONE</code> and <code>IAM_AUTH</code> . When set to <code>IAM_AUTH</code> , the proxy uses end-to-end IAM authentication to connect to the database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-defaultauthscheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-defaultauthscheme</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAuthScheme() {
        return null;
    }

    /**
     * The network type of the DB proxy endpoint.
     * <p>
     * The network type determines the IP version that the proxy endpoint supports.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li><code>IPV4</code> - The proxy endpoint supports IPv4 only.</li>
     * <li><code>IPV6</code> - The proxy endpoint supports IPv6 only.</li>
     * <li><code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-endpointnetworktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-endpointnetworktype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointNetworkType() {
        return null;
    }

    /**
     * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
     * <p>
     * You can set this value higher or lower than the connection timeout limit for the associated database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-idleclienttimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-idleclienttimeout</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIdleClientTimeout() {
        return null;
    }

    /**
     * Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
     * <p>
     * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-requiretls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-requiretls</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequireTls() {
        return null;
    }

    /**
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty> getTags() {
        return null;
    }

    /**
     * The network type that the proxy uses to connect to the target database.
     * <p>
     * The network type determines the IP version that the proxy uses for connections to the database.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li><code>IPV4</code> - The proxy connects to the database using IPv4 only.</li>
     * <li><code>IPV6</code> - The proxy connects to the database using IPv6 only.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-targetconnectionnetworktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-targetconnectionnetworktype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetConnectionNetworkType() {
        return null;
    }

    /**
     * One or more VPC security group IDs to associate with the new proxy.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsecuritygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#cfn-rds-dbproxy-vpcsecuritygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBProxyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBProxyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBProxyProps> {
        java.lang.String dbProxyName;
        java.lang.String engineFamily;
        java.lang.String roleArn;
        java.util.List<java.lang.String> vpcSubnetIds;
        java.lang.Object auth;
        java.lang.Object debugLogging;
        java.lang.String defaultAuthScheme;
        java.lang.String endpointNetworkType;
        java.lang.Number idleClientTimeout;
        java.lang.Object requireTls;
        java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty> tags;
        java.lang.String targetConnectionNetworkType;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnDBProxyProps#getDbProxyName}
         * @param dbProxyName The identifier for the proxy. This parameter is required.
         *                    This name must be unique for all proxies owned by your AWS account in the specified AWS Region . An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyName(java.lang.String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getEngineFamily}
         * @param engineFamily The kinds of databases that the proxy can connect to. This parameter is required.
         *                     This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify <code>MYSQL</code> . For Aurora PostgreSQL and RDS for PostgreSQL databases, specify <code>POSTGRESQL</code> . For RDS for Microsoft SQL Server, specify <code>SQLSERVER</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineFamily(java.lang.String engineFamily) {
            this.engineFamily = engineFamily;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getVpcSubnetIds}
         * @param vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnetIds(java.util.List<java.lang.String> vpcSubnetIds) {
            this.vpcSubnetIds = vpcSubnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getAuth}
         * @param auth The authorization mechanism that the proxy uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(software.amazon.awscdk.IResolvable auth) {
            this.auth = auth;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getAuth}
         * @param auth The authorization mechanism that the proxy uses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auth(java.util.List<? extends java.lang.Object> auth) {
            this.auth = auth;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getDebugLogging}
         * @param debugLogging Specifies whether the proxy logs detailed connection and query information.
         *                     When you enable <code>DebugLogging</code> , the proxy captures connection details and connection pool behavior from your queries. Debug logging increases CloudWatch costs and can impact proxy performance. Enable this option only when you need to troubleshoot connection or performance issues.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder debugLogging(java.lang.Boolean debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getDebugLogging}
         * @param debugLogging Specifies whether the proxy logs detailed connection and query information.
         *                     When you enable <code>DebugLogging</code> , the proxy captures connection details and connection pool behavior from your queries. Debug logging increases CloudWatch costs and can impact proxy performance. Enable this option only when you need to troubleshoot connection or performance issues.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder debugLogging(software.amazon.awscdk.IResolvable debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getDefaultAuthScheme}
         * @param defaultAuthScheme The default authentication scheme that the proxy uses for client connections to the proxy and connections from the proxy to the underlying database.
         *                          Valid values are <code>NONE</code> and <code>IAM_AUTH</code> . When set to <code>IAM_AUTH</code> , the proxy uses end-to-end IAM authentication to connect to the database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAuthScheme(java.lang.String defaultAuthScheme) {
            this.defaultAuthScheme = defaultAuthScheme;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getEndpointNetworkType}
         * @param endpointNetworkType The network type of the DB proxy endpoint.
         *                            The network type determines the IP version that the proxy endpoint supports.
         *                            <p>
         *                            Valid values:
         *                            <p>
         *                            <ul>
         *                            <li><code>IPV4</code> - The proxy endpoint supports IPv4 only.</li>
         *                            <li><code>IPV6</code> - The proxy endpoint supports IPv6 only.</li>
         *                            <li><code>DUAL</code> - The proxy endpoint supports both IPv4 and IPv6.</li>
         *                            </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointNetworkType(java.lang.String endpointNetworkType) {
            this.endpointNetworkType = endpointNetworkType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getIdleClientTimeout}
         * @param idleClientTimeout The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it.
         *                          You can set this value higher or lower than the connection timeout limit for the associated database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleClientTimeout(java.lang.Number idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getRequireTls}
         * @param requireTls Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         *                   By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireTls(java.lang.Boolean requireTls) {
            this.requireTls = requireTls;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getRequireTls}
         * @param requireTls Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         *                   By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireTls(software.amazon.awscdk.IResolvable requireTls) {
            this.requireTls = requireTls;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getTags}
         * @param tags An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getTargetConnectionNetworkType}
         * @param targetConnectionNetworkType The network type that the proxy uses to connect to the target database.
         *                                    The network type determines the IP version that the proxy uses for connections to the database.
         *                                    <p>
         *                                    Valid values:
         *                                    <p>
         *                                    <ul>
         *                                    <li><code>IPV4</code> - The proxy connects to the database using IPv4 only.</li>
         *                                    <li><code>IPV6</code> - The proxy connects to the database using IPv6 only.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConnectionNetworkType(java.lang.String targetConnectionNetworkType) {
            this.targetConnectionNetworkType = targetConnectionNetworkType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBProxyProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
         *                            If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBProxyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBProxyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBProxyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBProxyProps {
        private final java.lang.String dbProxyName;
        private final java.lang.String engineFamily;
        private final java.lang.String roleArn;
        private final java.util.List<java.lang.String> vpcSubnetIds;
        private final java.lang.Object auth;
        private final java.lang.Object debugLogging;
        private final java.lang.String defaultAuthScheme;
        private final java.lang.String endpointNetworkType;
        private final java.lang.Number idleClientTimeout;
        private final java.lang.Object requireTls;
        private final java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty> tags;
        private final java.lang.String targetConnectionNetworkType;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbProxyName = software.amazon.jsii.Kernel.get(this, "dbProxyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineFamily = software.amazon.jsii.Kernel.get(this, "engineFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcSubnetIds = software.amazon.jsii.Kernel.get(this, "vpcSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.auth = software.amazon.jsii.Kernel.get(this, "auth", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.debugLogging = software.amazon.jsii.Kernel.get(this, "debugLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultAuthScheme = software.amazon.jsii.Kernel.get(this, "defaultAuthScheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointNetworkType = software.amazon.jsii.Kernel.get(this, "endpointNetworkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.idleClientTimeout = software.amazon.jsii.Kernel.get(this, "idleClientTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.requireTls = software.amazon.jsii.Kernel.get(this, "requireTls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty.class)));
            this.targetConnectionNetworkType = software.amazon.jsii.Kernel.get(this, "targetConnectionNetworkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbProxyName = java.util.Objects.requireNonNull(builder.dbProxyName, "dbProxyName is required");
            this.engineFamily = java.util.Objects.requireNonNull(builder.engineFamily, "engineFamily is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.vpcSubnetIds = java.util.Objects.requireNonNull(builder.vpcSubnetIds, "vpcSubnetIds is required");
            this.auth = builder.auth;
            this.debugLogging = builder.debugLogging;
            this.defaultAuthScheme = builder.defaultAuthScheme;
            this.endpointNetworkType = builder.endpointNetworkType;
            this.idleClientTimeout = builder.idleClientTimeout;
            this.requireTls = builder.requireTls;
            this.tags = (java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty>)builder.tags;
            this.targetConnectionNetworkType = builder.targetConnectionNetworkType;
            this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        }

        @Override
        public final java.lang.String getDbProxyName() {
            return this.dbProxyName;
        }

        @Override
        public final java.lang.String getEngineFamily() {
            return this.engineFamily;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSubnetIds() {
            return this.vpcSubnetIds;
        }

        @Override
        public final java.lang.Object getAuth() {
            return this.auth;
        }

        @Override
        public final java.lang.Object getDebugLogging() {
            return this.debugLogging;
        }

        @Override
        public final java.lang.String getDefaultAuthScheme() {
            return this.defaultAuthScheme;
        }

        @Override
        public final java.lang.String getEndpointNetworkType() {
            return this.endpointNetworkType;
        }

        @Override
        public final java.lang.Number getIdleClientTimeout() {
            return this.idleClientTimeout;
        }

        @Override
        public final java.lang.Object getRequireTls() {
            return this.requireTls;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.rds.CfnDBProxy.TagFormatProperty> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTargetConnectionNetworkType() {
            return this.targetConnectionNetworkType;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbProxyName", om.valueToTree(this.getDbProxyName()));
            data.set("engineFamily", om.valueToTree(this.getEngineFamily()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("vpcSubnetIds", om.valueToTree(this.getVpcSubnetIds()));
            if (this.getAuth() != null) {
                data.set("auth", om.valueToTree(this.getAuth()));
            }
            if (this.getDebugLogging() != null) {
                data.set("debugLogging", om.valueToTree(this.getDebugLogging()));
            }
            if (this.getDefaultAuthScheme() != null) {
                data.set("defaultAuthScheme", om.valueToTree(this.getDefaultAuthScheme()));
            }
            if (this.getEndpointNetworkType() != null) {
                data.set("endpointNetworkType", om.valueToTree(this.getEndpointNetworkType()));
            }
            if (this.getIdleClientTimeout() != null) {
                data.set("idleClientTimeout", om.valueToTree(this.getIdleClientTimeout()));
            }
            if (this.getRequireTls() != null) {
                data.set("requireTls", om.valueToTree(this.getRequireTls()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetConnectionNetworkType() != null) {
                data.set("targetConnectionNetworkType", om.valueToTree(this.getTargetConnectionNetworkType()));
            }
            if (this.getVpcSecurityGroupIds() != null) {
                data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBProxyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBProxyProps.Jsii$Proxy that = (CfnDBProxyProps.Jsii$Proxy) o;

            if (!dbProxyName.equals(that.dbProxyName)) return false;
            if (!engineFamily.equals(that.engineFamily)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!vpcSubnetIds.equals(that.vpcSubnetIds)) return false;
            if (this.auth != null ? !this.auth.equals(that.auth) : that.auth != null) return false;
            if (this.debugLogging != null ? !this.debugLogging.equals(that.debugLogging) : that.debugLogging != null) return false;
            if (this.defaultAuthScheme != null ? !this.defaultAuthScheme.equals(that.defaultAuthScheme) : that.defaultAuthScheme != null) return false;
            if (this.endpointNetworkType != null ? !this.endpointNetworkType.equals(that.endpointNetworkType) : that.endpointNetworkType != null) return false;
            if (this.idleClientTimeout != null ? !this.idleClientTimeout.equals(that.idleClientTimeout) : that.idleClientTimeout != null) return false;
            if (this.requireTls != null ? !this.requireTls.equals(that.requireTls) : that.requireTls != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.targetConnectionNetworkType != null ? !this.targetConnectionNetworkType.equals(that.targetConnectionNetworkType) : that.targetConnectionNetworkType != null) return false;
            return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dbProxyName.hashCode();
            result = 31 * result + (this.engineFamily.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.vpcSubnetIds.hashCode());
            result = 31 * result + (this.auth != null ? this.auth.hashCode() : 0);
            result = 31 * result + (this.debugLogging != null ? this.debugLogging.hashCode() : 0);
            result = 31 * result + (this.defaultAuthScheme != null ? this.defaultAuthScheme.hashCode() : 0);
            result = 31 * result + (this.endpointNetworkType != null ? this.endpointNetworkType.hashCode() : 0);
            result = 31 * result + (this.idleClientTimeout != null ? this.idleClientTimeout.hashCode() : 0);
            result = 31 * result + (this.requireTls != null ? this.requireTls.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetConnectionNetworkType != null ? this.targetConnectionNetworkType.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
            return result;
        }
    }
}
