package software.amazon.awscdk.services.rds;

/**
 * Properties that describe an existing DB Proxy Endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * DatabaseProxyEndpointAttributes databaseProxyEndpointAttributes = DatabaseProxyEndpointAttributes.builder()
 *         .dbProxyEndpointArn("dbProxyEndpointArn")
 *         .dbProxyEndpointName("dbProxyEndpointName")
 *         .endpoint("endpoint")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.345Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseProxyEndpointAttributes")
@software.amazon.jsii.Jsii.Proxy(DatabaseProxyEndpointAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseProxyEndpointAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * DB Proxy Endpoint ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbProxyEndpointArn();

    /**
     * DB Proxy Endpoint Name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbProxyEndpointName();

    /**
     * The endpoint that you can use to connect to the DB proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

    /**
     * @return a {@link Builder} of {@link DatabaseProxyEndpointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseProxyEndpointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseProxyEndpointAttributes> {
        java.lang.String dbProxyEndpointArn;
        java.lang.String dbProxyEndpointName;
        java.lang.String endpoint;

        /**
         * Sets the value of {@link DatabaseProxyEndpointAttributes#getDbProxyEndpointArn}
         * @param dbProxyEndpointArn DB Proxy Endpoint ARN. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyEndpointArn(java.lang.String dbProxyEndpointArn) {
            this.dbProxyEndpointArn = dbProxyEndpointArn;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyEndpointAttributes#getDbProxyEndpointName}
         * @param dbProxyEndpointName DB Proxy Endpoint Name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbProxyEndpointName(java.lang.String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseProxyEndpointAttributes#getEndpoint}
         * @param endpoint The endpoint that you can use to connect to the DB proxy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseProxyEndpointAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseProxyEndpointAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseProxyEndpointAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseProxyEndpointAttributes {
        private final java.lang.String dbProxyEndpointArn;
        private final java.lang.String dbProxyEndpointName;
        private final java.lang.String endpoint;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbProxyEndpointArn = software.amazon.jsii.Kernel.get(this, "dbProxyEndpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbProxyEndpointName = software.amazon.jsii.Kernel.get(this, "dbProxyEndpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbProxyEndpointArn = java.util.Objects.requireNonNull(builder.dbProxyEndpointArn, "dbProxyEndpointArn is required");
            this.dbProxyEndpointName = java.util.Objects.requireNonNull(builder.dbProxyEndpointName, "dbProxyEndpointName is required");
            this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
        }

        @Override
        public final java.lang.String getDbProxyEndpointArn() {
            return this.dbProxyEndpointArn;
        }

        @Override
        public final java.lang.String getDbProxyEndpointName() {
            return this.dbProxyEndpointName;
        }

        @Override
        public final java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbProxyEndpointArn", om.valueToTree(this.getDbProxyEndpointArn()));
            data.set("dbProxyEndpointName", om.valueToTree(this.getDbProxyEndpointName()));
            data.set("endpoint", om.valueToTree(this.getEndpoint()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.DatabaseProxyEndpointAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseProxyEndpointAttributes.Jsii$Proxy that = (DatabaseProxyEndpointAttributes.Jsii$Proxy) o;

            if (!dbProxyEndpointArn.equals(that.dbProxyEndpointArn)) return false;
            if (!dbProxyEndpointName.equals(that.dbProxyEndpointName)) return false;
            return this.endpoint.equals(that.endpoint);
        }

        @Override
        public final int hashCode() {
            int result = this.dbProxyEndpointArn.hashCode();
            result = 31 * result + (this.dbProxyEndpointName.hashCode());
            result = 31 * result + (this.endpoint.hashCode());
            return result;
        }
    }
}
