package software.amazon.awscdk.services.refactorspaces;

/**
 * A reference to a Environment resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.refactorspaces.*;
 * EnvironmentReference environmentReference = EnvironmentReference.builder()
 *         .environmentArn("environmentArn")
 *         .environmentIdentifier("environmentIdentifier")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.552Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_refactorspaces.EnvironmentReference")
@software.amazon.jsii.Jsii.Proxy(EnvironmentReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EnvironmentReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Environment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentArn();

    /**
     * The EnvironmentIdentifier of the Environment resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentIdentifier();

    /**
     * @return a {@link Builder} of {@link EnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EnvironmentReference> {
        java.lang.String environmentArn;
        java.lang.String environmentIdentifier;

        /**
         * Sets the value of {@link EnvironmentReference#getEnvironmentArn}
         * @param environmentArn The ARN of the Environment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentArn(java.lang.String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        /**
         * Sets the value of {@link EnvironmentReference#getEnvironmentIdentifier}
         * @param environmentIdentifier The EnvironmentIdentifier of the Environment resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(java.lang.String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EnvironmentReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EnvironmentReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EnvironmentReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentReference {
        private final java.lang.String environmentArn;
        private final java.lang.String environmentIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.environmentArn = software.amazon.jsii.Kernel.get(this, "environmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentIdentifier = software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.environmentArn = java.util.Objects.requireNonNull(builder.environmentArn, "environmentArn is required");
            this.environmentIdentifier = java.util.Objects.requireNonNull(builder.environmentIdentifier, "environmentIdentifier is required");
        }

        @Override
        public final java.lang.String getEnvironmentArn() {
            return this.environmentArn;
        }

        @Override
        public final java.lang.String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("environmentArn", om.valueToTree(this.getEnvironmentArn()));
            data.set("environmentIdentifier", om.valueToTree(this.getEnvironmentIdentifier()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_refactorspaces.EnvironmentReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EnvironmentReference.Jsii$Proxy that = (EnvironmentReference.Jsii$Proxy) o;

            if (!environmentArn.equals(that.environmentArn)) return false;
            return this.environmentIdentifier.equals(that.environmentIdentifier);
        }

        @Override
        public final int hashCode() {
            int result = this.environmentArn.hashCode();
            result = 31 * result + (this.environmentIdentifier.hashCode());
            return result;
        }
    }
}
