package software.amazon.awscdk.services.rekognition;

/**
 * A reference to a Collection resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rekognition.*;
 * CollectionReference collectionReference = CollectionReference.builder()
 *         .collectionArn("collectionArn")
 *         .collectionId("collectionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.565Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.CollectionReference")
@software.amazon.jsii.Jsii.Proxy(CollectionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CollectionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Collection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCollectionArn();

    /**
     * The CollectionId of the Collection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCollectionId();

    /**
     * @return a {@link Builder} of {@link CollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CollectionReference> {
        java.lang.String collectionArn;
        java.lang.String collectionId;

        /**
         * Sets the value of {@link CollectionReference#getCollectionArn}
         * @param collectionArn The ARN of the Collection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionArn(java.lang.String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        /**
         * Sets the value of {@link CollectionReference#getCollectionId}
         * @param collectionId The CollectionId of the Collection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionId(java.lang.String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CollectionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CollectionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CollectionReference {
        private final java.lang.String collectionArn;
        private final java.lang.String collectionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.collectionArn = software.amazon.jsii.Kernel.get(this, "collectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.collectionId = software.amazon.jsii.Kernel.get(this, "collectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.collectionArn = java.util.Objects.requireNonNull(builder.collectionArn, "collectionArn is required");
            this.collectionId = java.util.Objects.requireNonNull(builder.collectionId, "collectionId is required");
        }

        @Override
        public final java.lang.String getCollectionArn() {
            return this.collectionArn;
        }

        @Override
        public final java.lang.String getCollectionId() {
            return this.collectionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("collectionArn", om.valueToTree(this.getCollectionArn()));
            data.set("collectionId", om.valueToTree(this.getCollectionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.CollectionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CollectionReference.Jsii$Proxy that = (CollectionReference.Jsii$Proxy) o;

            if (!collectionArn.equals(that.collectionArn)) return false;
            return this.collectionId.equals(that.collectionId);
        }

        @Override
        public final int hashCode() {
            int result = this.collectionArn.hashCode();
            result = 31 * result + (this.collectionId.hashCode());
            return result;
        }
    }
}
