package software.amazon.awscdk.services.rekognition;

/**
 * A reference to a StreamProcessor resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rekognition.*;
 * StreamProcessorReference streamProcessorReference = StreamProcessorReference.builder()
 *         .streamProcessorArn("streamProcessorArn")
 *         .streamProcessorName("streamProcessorName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.567Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rekognition.StreamProcessorReference")
@software.amazon.jsii.Jsii.Proxy(StreamProcessorReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StreamProcessorReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the StreamProcessor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamProcessorArn();

    /**
     * The Name of the StreamProcessor resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamProcessorName();

    /**
     * @return a {@link Builder} of {@link StreamProcessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamProcessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StreamProcessorReference> {
        java.lang.String streamProcessorArn;
        java.lang.String streamProcessorName;

        /**
         * Sets the value of {@link StreamProcessorReference#getStreamProcessorArn}
         * @param streamProcessorArn The ARN of the StreamProcessor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamProcessorArn(java.lang.String streamProcessorArn) {
            this.streamProcessorArn = streamProcessorArn;
            return this;
        }

        /**
         * Sets the value of {@link StreamProcessorReference#getStreamProcessorName}
         * @param streamProcessorName The Name of the StreamProcessor resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamProcessorName(java.lang.String streamProcessorName) {
            this.streamProcessorName = streamProcessorName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamProcessorReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StreamProcessorReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StreamProcessorReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamProcessorReference {
        private final java.lang.String streamProcessorArn;
        private final java.lang.String streamProcessorName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.streamProcessorArn = software.amazon.jsii.Kernel.get(this, "streamProcessorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.streamProcessorName = software.amazon.jsii.Kernel.get(this, "streamProcessorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.streamProcessorArn = java.util.Objects.requireNonNull(builder.streamProcessorArn, "streamProcessorArn is required");
            this.streamProcessorName = java.util.Objects.requireNonNull(builder.streamProcessorName, "streamProcessorName is required");
        }

        @Override
        public final java.lang.String getStreamProcessorArn() {
            return this.streamProcessorArn;
        }

        @Override
        public final java.lang.String getStreamProcessorName() {
            return this.streamProcessorName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("streamProcessorArn", om.valueToTree(this.getStreamProcessorArn()));
            data.set("streamProcessorName", om.valueToTree(this.getStreamProcessorName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rekognition.StreamProcessorReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamProcessorReference.Jsii$Proxy that = (StreamProcessorReference.Jsii$Proxy) o;

            if (!streamProcessorArn.equals(that.streamProcessorArn)) return false;
            return this.streamProcessorName.equals(that.streamProcessorName);
        }

        @Override
        public final int hashCode() {
            int result = this.streamProcessorArn.hashCode();
            result = 31 * result + (this.streamProcessorName.hashCode());
            return result;
        }
    }
}
