package software.amazon.awscdk.services.route53;

/**
 * A reference to a CidrCollection resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53.*;
 * CidrCollectionReference cidrCollectionReference = CidrCollectionReference.builder()
 *         .cidrCollectionArn("cidrCollectionArn")
 *         .cidrCollectionId("cidrCollectionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.756Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CidrCollectionReference")
@software.amazon.jsii.Jsii.Proxy(CidrCollectionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CidrCollectionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the CidrCollection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCidrCollectionArn();

    /**
     * The Id of the CidrCollection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCidrCollectionId();

    /**
     * @return a {@link Builder} of {@link CidrCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CidrCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CidrCollectionReference> {
        java.lang.String cidrCollectionArn;
        java.lang.String cidrCollectionId;

        /**
         * Sets the value of {@link CidrCollectionReference#getCidrCollectionArn}
         * @param cidrCollectionArn The ARN of the CidrCollection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrCollectionArn(java.lang.String cidrCollectionArn) {
            this.cidrCollectionArn = cidrCollectionArn;
            return this;
        }

        /**
         * Sets the value of {@link CidrCollectionReference#getCidrCollectionId}
         * @param cidrCollectionId The Id of the CidrCollection resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrCollectionId(java.lang.String cidrCollectionId) {
            this.cidrCollectionId = cidrCollectionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CidrCollectionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CidrCollectionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CidrCollectionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CidrCollectionReference {
        private final java.lang.String cidrCollectionArn;
        private final java.lang.String cidrCollectionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cidrCollectionArn = software.amazon.jsii.Kernel.get(this, "cidrCollectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrCollectionId = software.amazon.jsii.Kernel.get(this, "cidrCollectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidrCollectionArn = java.util.Objects.requireNonNull(builder.cidrCollectionArn, "cidrCollectionArn is required");
            this.cidrCollectionId = java.util.Objects.requireNonNull(builder.cidrCollectionId, "cidrCollectionId is required");
        }

        @Override
        public final java.lang.String getCidrCollectionArn() {
            return this.cidrCollectionArn;
        }

        @Override
        public final java.lang.String getCidrCollectionId() {
            return this.cidrCollectionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cidrCollectionArn", om.valueToTree(this.getCidrCollectionArn()));
            data.set("cidrCollectionId", om.valueToTree(this.getCidrCollectionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.CidrCollectionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CidrCollectionReference.Jsii$Proxy that = (CidrCollectionReference.Jsii$Proxy) o;

            if (!cidrCollectionArn.equals(that.cidrCollectionArn)) return false;
            return this.cidrCollectionId.equals(that.cidrCollectionId);
        }

        @Override
        public final int hashCode() {
            int result = this.cidrCollectionArn.hashCode();
            result = 31 * result + (this.cidrCollectionId.hashCode());
            return result;
        }
    }
}
