package software.amazon.awscdk.services.route53recoveryreadiness;

/**
 * Creates a resource set in Amazon Route 53 Application Recovery Controller.
 * <p>
 * A resource set is a set of resources of one type, such as Network Load Balancers, that span multiple cells. You can associate a resource set with a readiness check to have Route 53 ARC continually monitor the resources in the set for failover readiness.
 * <p>
 * You typically create a resource set and a readiness check for each supported type of AWS resource in your application.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.recovery-groups.readiness-scope.html">Readiness checks, resource sets, and readiness scopes</a> in the Amazon Route 53 Application Recovery Controller Developer Guide.
 * <p>
 * Route 53 ARC Readiness supports us-east-1 and us-west-2 AWS Regions only.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53recoveryreadiness.*;
 * CfnResourceSet cfnResourceSet = CfnResourceSet.Builder.create(this, "MyCfnResourceSet")
 *         .resources(List.of(ResourceProperty.builder()
 *                 .componentId("componentId")
 *                 .dnsTargetResource(DNSTargetResourceProperty.builder()
 *                         .domainName("domainName")
 *                         .hostedZoneArn("hostedZoneArn")
 *                         .recordSetId("recordSetId")
 *                         .recordType("recordType")
 *                         .targetResource(TargetResourceProperty.builder()
 *                                 .nlbResource(NLBResourceProperty.builder()
 *                                         .arn("arn")
 *                                         .build())
 *                                 .r53Resource(R53ResourceRecordProperty.builder()
 *                                         .domainName("domainName")
 *                                         .recordSetId("recordSetId")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .readinessScopes(List.of("readinessScopes"))
 *                 .resourceArn("resourceArn")
 *                 .build()))
 *         .resourceSetType("resourceSetType")
 *         // the properties below are optional
 *         .resourceSetName("resourceSetName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.875Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet")
public class CfnResourceSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.route53recoveryreadiness.IResourceSetRef, software.amazon.awscdk.ITaggable {

    protected CfnResourceSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResourceSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the resource set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceSetArn() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ResourceSet resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53recoveryreadiness.ResourceSetReference getResourceSetRef() {
        return software.amazon.jsii.Kernel.get(this, "resourceSetRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53recoveryreadiness.ResourceSetReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of resource objects in the resource set.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.ResourceProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResources() {
        return software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of resource objects in the resource set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resources", java.util.Objects.requireNonNull(value, "resources is required"));
    }

    /**
     * A list of resource objects in the resource set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResources(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.ResourceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.ResourceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "resources", java.util.Objects.requireNonNull(value, "resources is required"));
    }

    /**
     * The resource type of the resources in the resource set.
     * <p>
     * Enter one of the following values for resource type:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceSetType() {
        return software.amazon.jsii.Kernel.get(this, "resourceSetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource type of the resources in the resource set.
     * <p>
     * Enter one of the following values for resource type:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceSetType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceSetType", java.util.Objects.requireNonNull(value, "resourceSetType is required"));
    }

    /**
     * The name of the resource set to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceSetName() {
        return software.amazon.jsii.Kernel.get(this, "resourceSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the resource set to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceSetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceSetName", value);
    }

    /**
     * A tag to associate with the parameters for a resource set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A tag to associate with the parameters for a resource set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A component for DNS/routing control readiness checks and architecture checks.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53recoveryreadiness.*;
     * DNSTargetResourceProperty dNSTargetResourceProperty = DNSTargetResourceProperty.builder()
     *         .domainName("domainName")
     *         .hostedZoneArn("hostedZoneArn")
     *         .recordSetId("recordSetId")
     *         .recordType("recordType")
     *         .targetResource(TargetResourceProperty.builder()
     *                 .nlbResource(NLBResourceProperty.builder()
     *                         .arn("arn")
     *                         .build())
     *                 .r53Resource(R53ResourceRecordProperty.builder()
     *                         .domainName("domainName")
     *                         .recordSetId("recordSetId")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.DNSTargetResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DNSTargetResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DNSTargetResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain name that acts as an ingress point to a portion of the customer application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-domainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
            return null;
        }

        /**
         * The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-hostedzonearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-hostedzonearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostedZoneArn() {
            return null;
        }

        /**
         * The Amazon Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-recordsetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-recordsetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordSetId() {
            return null;
        }

        /**
         * The type of DNS record of the target resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-recordtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-recordtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordType() {
            return null;
        }

        /**
         * The target resource that the Route 53 record points to.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.TargetResourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-targetresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-dnstargetresource.html#cfn-route53recoveryreadiness-resourceset-dnstargetresource-targetresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DNSTargetResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DNSTargetResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DNSTargetResourceProperty> {
            java.lang.String domainName;
            java.lang.String hostedZoneArn;
            java.lang.String recordSetId;
            java.lang.String recordType;
            java.lang.Object targetResource;

            /**
             * Sets the value of {@link DNSTargetResourceProperty#getDomainName}
             * @param domainName The domain name that acts as an ingress point to a portion of the customer application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link DNSTargetResourceProperty#getHostedZoneArn}
             * @param hostedZoneArn The hosted zone Amazon Resource Name (ARN) that contains the DNS record with the provided name of the target resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneArn(java.lang.String hostedZoneArn) {
                this.hostedZoneArn = hostedZoneArn;
                return this;
            }

            /**
             * Sets the value of {@link DNSTargetResourceProperty#getRecordSetId}
             * @param recordSetId The Amazon Route 53 record set ID that uniquely identifies a DNS record, given a name and a type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordSetId(java.lang.String recordSetId) {
                this.recordSetId = recordSetId;
                return this;
            }

            /**
             * Sets the value of {@link DNSTargetResourceProperty#getRecordType}
             * @param recordType The type of DNS record of the target resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordType(java.lang.String recordType) {
                this.recordType = recordType;
                return this;
            }

            /**
             * Sets the value of {@link DNSTargetResourceProperty#getTargetResource}
             * @param targetResource The target resource that the Route 53 record points to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetResource(software.amazon.awscdk.IResolvable targetResource) {
                this.targetResource = targetResource;
                return this;
            }

            /**
             * Sets the value of {@link DNSTargetResourceProperty#getTargetResource}
             * @param targetResource The target resource that the Route 53 record points to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetResource(software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.TargetResourceProperty targetResource) {
                this.targetResource = targetResource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DNSTargetResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DNSTargetResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DNSTargetResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DNSTargetResourceProperty {
            private final java.lang.String domainName;
            private final java.lang.String hostedZoneArn;
            private final java.lang.String recordSetId;
            private final java.lang.String recordType;
            private final java.lang.Object targetResource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostedZoneArn = software.amazon.jsii.Kernel.get(this, "hostedZoneArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordSetId = software.amazon.jsii.Kernel.get(this, "recordSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordType = software.amazon.jsii.Kernel.get(this, "recordType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetResource = software.amazon.jsii.Kernel.get(this, "targetResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = builder.domainName;
                this.hostedZoneArn = builder.hostedZoneArn;
                this.recordSetId = builder.recordSetId;
                this.recordType = builder.recordType;
                this.targetResource = builder.targetResource;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getHostedZoneArn() {
                return this.hostedZoneArn;
            }

            @Override
            public final java.lang.String getRecordSetId() {
                return this.recordSetId;
            }

            @Override
            public final java.lang.String getRecordType() {
                return this.recordType;
            }

            @Override
            public final java.lang.Object getTargetResource() {
                return this.targetResource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainName() != null) {
                    data.set("domainName", om.valueToTree(this.getDomainName()));
                }
                if (this.getHostedZoneArn() != null) {
                    data.set("hostedZoneArn", om.valueToTree(this.getHostedZoneArn()));
                }
                if (this.getRecordSetId() != null) {
                    data.set("recordSetId", om.valueToTree(this.getRecordSetId()));
                }
                if (this.getRecordType() != null) {
                    data.set("recordType", om.valueToTree(this.getRecordType()));
                }
                if (this.getTargetResource() != null) {
                    data.set("targetResource", om.valueToTree(this.getTargetResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.DNSTargetResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DNSTargetResourceProperty.Jsii$Proxy that = (DNSTargetResourceProperty.Jsii$Proxy) o;

                if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
                if (this.hostedZoneArn != null ? !this.hostedZoneArn.equals(that.hostedZoneArn) : that.hostedZoneArn != null) return false;
                if (this.recordSetId != null ? !this.recordSetId.equals(that.recordSetId) : that.recordSetId != null) return false;
                if (this.recordType != null ? !this.recordType.equals(that.recordType) : that.recordType != null) return false;
                return this.targetResource != null ? this.targetResource.equals(that.targetResource) : that.targetResource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainName != null ? this.domainName.hashCode() : 0;
                result = 31 * result + (this.hostedZoneArn != null ? this.hostedZoneArn.hashCode() : 0);
                result = 31 * result + (this.recordSetId != null ? this.recordSetId.hashCode() : 0);
                result = 31 * result + (this.recordType != null ? this.recordType.hashCode() : 0);
                result = 31 * result + (this.targetResource != null ? this.targetResource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Network Load Balancer resource that a DNS target resource points to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53recoveryreadiness.*;
     * NLBResourceProperty nLBResourceProperty = NLBResourceProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-nlbresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-nlbresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.NLBResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(NLBResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NLBResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Network Load Balancer resource Amazon Resource Name (ARN).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-nlbresource.html#cfn-route53recoveryreadiness-resourceset-nlbresource-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-nlbresource.html#cfn-route53recoveryreadiness-resourceset-nlbresource-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NLBResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NLBResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NLBResourceProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link NLBResourceProperty#getArn}
             * @param arn The Network Load Balancer resource Amazon Resource Name (ARN).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NLBResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NLBResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NLBResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NLBResourceProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.NLBResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NLBResourceProperty.Jsii$Proxy that = (NLBResourceProperty.Jsii$Proxy) o;

                return this.arn != null ? this.arn.equals(that.arn) : that.arn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The Amazon Route 53 resource that a DNS target resource record points to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53recoveryreadiness.*;
     * R53ResourceRecordProperty r53ResourceRecordProperty = R53ResourceRecordProperty.builder()
     *         .domainName("domainName")
     *         .recordSetId("recordSetId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-r53resourcerecord.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-r53resourcerecord.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.R53ResourceRecordProperty")
    @software.amazon.jsii.Jsii.Proxy(R53ResourceRecordProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface R53ResourceRecordProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DNS target domain name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-r53resourcerecord.html#cfn-route53recoveryreadiness-resourceset-r53resourcerecord-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-r53resourcerecord.html#cfn-route53recoveryreadiness-resourceset-r53resourcerecord-domainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
            return null;
        }

        /**
         * The Amazon Route 53 Resource Record Set ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-r53resourcerecord.html#cfn-route53recoveryreadiness-resourceset-r53resourcerecord-recordsetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-r53resourcerecord.html#cfn-route53recoveryreadiness-resourceset-r53resourcerecord-recordsetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordSetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link R53ResourceRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link R53ResourceRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<R53ResourceRecordProperty> {
            java.lang.String domainName;
            java.lang.String recordSetId;

            /**
             * Sets the value of {@link R53ResourceRecordProperty#getDomainName}
             * @param domainName The DNS target domain name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link R53ResourceRecordProperty#getRecordSetId}
             * @param recordSetId The Amazon Route 53 Resource Record Set ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordSetId(java.lang.String recordSetId) {
                this.recordSetId = recordSetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link R53ResourceRecordProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public R53ResourceRecordProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link R53ResourceRecordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements R53ResourceRecordProperty {
            private final java.lang.String domainName;
            private final java.lang.String recordSetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordSetId = software.amazon.jsii.Kernel.get(this, "recordSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = builder.domainName;
                this.recordSetId = builder.recordSetId;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getRecordSetId() {
                return this.recordSetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainName() != null) {
                    data.set("domainName", om.valueToTree(this.getDomainName()));
                }
                if (this.getRecordSetId() != null) {
                    data.set("recordSetId", om.valueToTree(this.getRecordSetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.R53ResourceRecordProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                R53ResourceRecordProperty.Jsii$Proxy that = (R53ResourceRecordProperty.Jsii$Proxy) o;

                if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
                return this.recordSetId != null ? this.recordSetId.equals(that.recordSetId) : that.recordSetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainName != null ? this.domainName.hashCode() : 0;
                result = 31 * result + (this.recordSetId != null ? this.recordSetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The resource element of a resource set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53recoveryreadiness.*;
     * ResourceProperty resourceProperty = ResourceProperty.builder()
     *         .componentId("componentId")
     *         .dnsTargetResource(DNSTargetResourceProperty.builder()
     *                 .domainName("domainName")
     *                 .hostedZoneArn("hostedZoneArn")
     *                 .recordSetId("recordSetId")
     *                 .recordType("recordType")
     *                 .targetResource(TargetResourceProperty.builder()
     *                         .nlbResource(NLBResourceProperty.builder()
     *                                 .arn("arn")
     *                                 .build())
     *                         .r53Resource(R53ResourceRecordProperty.builder()
     *                                 .domainName("domainName")
     *                                 .recordSetId("recordSetId")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .readinessScopes(List.of("readinessScopes"))
     *         .resourceArn("resourceArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.ResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The component identifier of the resource, generated when DNS target resource is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html#cfn-route53recoveryreadiness-resourceset-resource-componentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html#cfn-route53recoveryreadiness-resourceset-resource-componentid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentId() {
            return null;
        }

        /**
         * A component for DNS/routing control readiness checks.
         * <p>
         * This is a required setting when <code>ResourceSet</code> <code>ResourceSetType</code> is set to <code>AWS::Route53RecoveryReadiness::DNSTargetResource</code> . Do not set it for any other <code>ResourceSetType</code> setting.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.DNSTargetResourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html#cfn-route53recoveryreadiness-resourceset-resource-dnstargetresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html#cfn-route53recoveryreadiness-resourceset-resource-dnstargetresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDnsTargetResource() {
            return null;
        }

        /**
         * The recovery group Amazon Resource Name (ARN) or the cell ARN that the readiness checks for this resource set are scoped to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html#cfn-route53recoveryreadiness-resourceset-resource-readinessscopes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html#cfn-route53recoveryreadiness-resourceset-resource-readinessscopes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReadinessScopes() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the AWS resource.
         * <p>
         * This is a required setting for all <code>ResourceSet</code> <code>ResourceSetType</code> settings except <code>AWS::Route53RecoveryReadiness::DNSTargetResource</code> . Do not set this when <code>ResourceSetType</code> is set to <code>AWS::Route53RecoveryReadiness::DNSTargetResource</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html#cfn-route53recoveryreadiness-resourceset-resource-resourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-resource.html#cfn-route53recoveryreadiness-resourceset-resource-resourcearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceProperty> {
            java.lang.String componentId;
            java.lang.Object dnsTargetResource;
            java.util.List<java.lang.String> readinessScopes;
            java.lang.String resourceArn;

            /**
             * Sets the value of {@link ResourceProperty#getComponentId}
             * @param componentId The component identifier of the resource, generated when DNS target resource is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentId(java.lang.String componentId) {
                this.componentId = componentId;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDnsTargetResource}
             * @param dnsTargetResource A component for DNS/routing control readiness checks.
             *                          This is a required setting when <code>ResourceSet</code> <code>ResourceSetType</code> is set to <code>AWS::Route53RecoveryReadiness::DNSTargetResource</code> . Do not set it for any other <code>ResourceSetType</code> setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsTargetResource(software.amazon.awscdk.IResolvable dnsTargetResource) {
                this.dnsTargetResource = dnsTargetResource;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDnsTargetResource}
             * @param dnsTargetResource A component for DNS/routing control readiness checks.
             *                          This is a required setting when <code>ResourceSet</code> <code>ResourceSetType</code> is set to <code>AWS::Route53RecoveryReadiness::DNSTargetResource</code> . Do not set it for any other <code>ResourceSetType</code> setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsTargetResource(software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.DNSTargetResourceProperty dnsTargetResource) {
                this.dnsTargetResource = dnsTargetResource;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getReadinessScopes}
             * @param readinessScopes The recovery group Amazon Resource Name (ARN) or the cell ARN that the readiness checks for this resource set are scoped to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readinessScopes(java.util.List<java.lang.String> readinessScopes) {
                this.readinessScopes = readinessScopes;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getResourceArn}
             * @param resourceArn The Amazon Resource Name (ARN) of the AWS resource.
             *                    This is a required setting for all <code>ResourceSet</code> <code>ResourceSetType</code> settings except <code>AWS::Route53RecoveryReadiness::DNSTargetResource</code> . Do not set this when <code>ResourceSetType</code> is set to <code>AWS::Route53RecoveryReadiness::DNSTargetResource</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceArn(java.lang.String resourceArn) {
                this.resourceArn = resourceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceProperty {
            private final java.lang.String componentId;
            private final java.lang.Object dnsTargetResource;
            private final java.util.List<java.lang.String> readinessScopes;
            private final java.lang.String resourceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentId = software.amazon.jsii.Kernel.get(this, "componentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dnsTargetResource = software.amazon.jsii.Kernel.get(this, "dnsTargetResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readinessScopes = software.amazon.jsii.Kernel.get(this, "readinessScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.resourceArn = software.amazon.jsii.Kernel.get(this, "resourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentId = builder.componentId;
                this.dnsTargetResource = builder.dnsTargetResource;
                this.readinessScopes = builder.readinessScopes;
                this.resourceArn = builder.resourceArn;
            }

            @Override
            public final java.lang.String getComponentId() {
                return this.componentId;
            }

            @Override
            public final java.lang.Object getDnsTargetResource() {
                return this.dnsTargetResource;
            }

            @Override
            public final java.util.List<java.lang.String> getReadinessScopes() {
                return this.readinessScopes;
            }

            @Override
            public final java.lang.String getResourceArn() {
                return this.resourceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentId() != null) {
                    data.set("componentId", om.valueToTree(this.getComponentId()));
                }
                if (this.getDnsTargetResource() != null) {
                    data.set("dnsTargetResource", om.valueToTree(this.getDnsTargetResource()));
                }
                if (this.getReadinessScopes() != null) {
                    data.set("readinessScopes", om.valueToTree(this.getReadinessScopes()));
                }
                if (this.getResourceArn() != null) {
                    data.set("resourceArn", om.valueToTree(this.getResourceArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.ResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceProperty.Jsii$Proxy that = (ResourceProperty.Jsii$Proxy) o;

                if (this.componentId != null ? !this.componentId.equals(that.componentId) : that.componentId != null) return false;
                if (this.dnsTargetResource != null ? !this.dnsTargetResource.equals(that.dnsTargetResource) : that.dnsTargetResource != null) return false;
                if (this.readinessScopes != null ? !this.readinessScopes.equals(that.readinessScopes) : that.readinessScopes != null) return false;
                return this.resourceArn != null ? this.resourceArn.equals(that.resourceArn) : that.resourceArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentId != null ? this.componentId.hashCode() : 0;
                result = 31 * result + (this.dnsTargetResource != null ? this.dnsTargetResource.hashCode() : 0);
                result = 31 * result + (this.readinessScopes != null ? this.readinessScopes.hashCode() : 0);
                result = 31 * result + (this.resourceArn != null ? this.resourceArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The target resource that the Route 53 record points to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.route53recoveryreadiness.*;
     * TargetResourceProperty targetResourceProperty = TargetResourceProperty.builder()
     *         .nlbResource(NLBResourceProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .r53Resource(R53ResourceRecordProperty.builder()
     *                 .domainName("domainName")
     *                 .recordSetId("recordSetId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-targetresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-targetresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.TargetResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Network Load Balancer resource that a DNS target resource points to.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.NLBResourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-targetresource.html#cfn-route53recoveryreadiness-resourceset-targetresource-nlbresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-targetresource.html#cfn-route53recoveryreadiness-resourceset-targetresource-nlbresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNlbResource() {
            return null;
        }

        /**
         * The Route 53 resource that a DNS target resource record points to.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.R53ResourceRecordProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-targetresource.html#cfn-route53recoveryreadiness-resourceset-targetresource-r53resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53recoveryreadiness-resourceset-targetresource.html#cfn-route53recoveryreadiness-resourceset-targetresource-r53resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getR53Resource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetResourceProperty> {
            java.lang.Object nlbResource;
            java.lang.Object r53Resource;

            /**
             * Sets the value of {@link TargetResourceProperty#getNlbResource}
             * @param nlbResource The Network Load Balancer resource that a DNS target resource points to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nlbResource(software.amazon.awscdk.IResolvable nlbResource) {
                this.nlbResource = nlbResource;
                return this;
            }

            /**
             * Sets the value of {@link TargetResourceProperty#getNlbResource}
             * @param nlbResource The Network Load Balancer resource that a DNS target resource points to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nlbResource(software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.NLBResourceProperty nlbResource) {
                this.nlbResource = nlbResource;
                return this;
            }

            /**
             * Sets the value of {@link TargetResourceProperty#getR53Resource}
             * @param r53Resource The Route 53 resource that a DNS target resource record points to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder r53Resource(software.amazon.awscdk.IResolvable r53Resource) {
                this.r53Resource = r53Resource;
                return this;
            }

            /**
             * Sets the value of {@link TargetResourceProperty#getR53Resource}
             * @param r53Resource The Route 53 resource that a DNS target resource record points to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder r53Resource(software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet.R53ResourceRecordProperty r53Resource) {
                this.r53Resource = r53Resource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetResourceProperty {
            private final java.lang.Object nlbResource;
            private final java.lang.Object r53Resource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nlbResource = software.amazon.jsii.Kernel.get(this, "nlbResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.r53Resource = software.amazon.jsii.Kernel.get(this, "r53Resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nlbResource = builder.nlbResource;
                this.r53Resource = builder.r53Resource;
            }

            @Override
            public final java.lang.Object getNlbResource() {
                return this.nlbResource;
            }

            @Override
            public final java.lang.Object getR53Resource() {
                return this.r53Resource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNlbResource() != null) {
                    data.set("nlbResource", om.valueToTree(this.getNlbResource()));
                }
                if (this.getR53Resource() != null) {
                    data.set("r53Resource", om.valueToTree(this.getR53Resource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoveryreadiness.CfnResourceSet.TargetResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetResourceProperty.Jsii$Proxy that = (TargetResourceProperty.Jsii$Proxy) o;

                if (this.nlbResource != null ? !this.nlbResource.equals(that.nlbResource) : that.nlbResource != null) return false;
                return this.r53Resource != null ? this.r53Resource.equals(that.r53Resource) : that.r53Resource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nlbResource != null ? this.nlbResource.hashCode() : 0;
                result = 31 * result + (this.r53Resource != null ? this.r53Resource.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSetProps.Builder();
        }

        /**
         * A list of resource objects in the resource set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-resources</a>
         * @param resources A list of resource objects in the resource set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final software.amazon.awscdk.IResolvable resources) {
            this.props.resources(resources);
            return this;
        }
        /**
         * A list of resource objects in the resource set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-resources</a>
         * @param resources A list of resource objects in the resource set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final java.util.List<? extends java.lang.Object> resources) {
            this.props.resources(resources);
            return this;
        }

        /**
         * The resource type of the resources in the resource set. Enter one of the following values for resource type:.
         * <p>
         * AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage, AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm, AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume, AWS::ElasticLoadBalancing::LoadBalancer, AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function, AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck, AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC, AWS::EC2::VPNConnection, AWS::EC2::VPNGateway, AWS::Route53RecoveryReadiness::DNSTargetResource.
         * <p>
         * Note that AWS::Route53RecoveryReadiness::DNSTargetResource is only used for this setting. It isn't an actual AWS CloudFormation resource type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-resourcesettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-resourcesettype</a>
         * @param resourceSetType The resource type of the resources in the resource set. Enter one of the following values for resource type:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSetType(final java.lang.String resourceSetType) {
            this.props.resourceSetType(resourceSetType);
            return this;
        }

        /**
         * The name of the resource set to create.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-resourcesetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-resourcesetname</a>
         * @param resourceSetName The name of the resource set to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSetName(final java.lang.String resourceSetName) {
            this.props.resourceSetName(resourceSetName);
            return this;
        }

        /**
         * A tag to associate with the parameters for a resource set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53recoveryreadiness-resourceset.html#cfn-route53recoveryreadiness-resourceset-tags</a>
         * @param tags A tag to associate with the parameters for a resource set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet build() {
            return new software.amazon.awscdk.services.route53recoveryreadiness.CfnResourceSet(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
