package software.amazon.awscdk.services.route53recoveryreadiness;

/**
 * A reference to a RecoveryGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53recoveryreadiness.*;
 * RecoveryGroupReference recoveryGroupReference = RecoveryGroupReference.builder()
 *         .recoveryGroupArn("recoveryGroupArn")
 *         .recoveryGroupName("recoveryGroupName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.880Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53recoveryreadiness.RecoveryGroupReference")
@software.amazon.jsii.Jsii.Proxy(RecoveryGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RecoveryGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the RecoveryGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRecoveryGroupArn();

    /**
     * The RecoveryGroupName of the RecoveryGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRecoveryGroupName();

    /**
     * @return a {@link Builder} of {@link RecoveryGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RecoveryGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RecoveryGroupReference> {
        java.lang.String recoveryGroupArn;
        java.lang.String recoveryGroupName;

        /**
         * Sets the value of {@link RecoveryGroupReference#getRecoveryGroupArn}
         * @param recoveryGroupArn The ARN of the RecoveryGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryGroupArn(java.lang.String recoveryGroupArn) {
            this.recoveryGroupArn = recoveryGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link RecoveryGroupReference#getRecoveryGroupName}
         * @param recoveryGroupName The RecoveryGroupName of the RecoveryGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryGroupName(java.lang.String recoveryGroupName) {
            this.recoveryGroupName = recoveryGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RecoveryGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RecoveryGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RecoveryGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecoveryGroupReference {
        private final java.lang.String recoveryGroupArn;
        private final java.lang.String recoveryGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.recoveryGroupArn = software.amazon.jsii.Kernel.get(this, "recoveryGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recoveryGroupName = software.amazon.jsii.Kernel.get(this, "recoveryGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.recoveryGroupArn = java.util.Objects.requireNonNull(builder.recoveryGroupArn, "recoveryGroupArn is required");
            this.recoveryGroupName = java.util.Objects.requireNonNull(builder.recoveryGroupName, "recoveryGroupName is required");
        }

        @Override
        public final java.lang.String getRecoveryGroupArn() {
            return this.recoveryGroupArn;
        }

        @Override
        public final java.lang.String getRecoveryGroupName() {
            return this.recoveryGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("recoveryGroupArn", om.valueToTree(this.getRecoveryGroupArn()));
            data.set("recoveryGroupName", om.valueToTree(this.getRecoveryGroupName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53recoveryreadiness.RecoveryGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RecoveryGroupReference.Jsii$Proxy that = (RecoveryGroupReference.Jsii$Proxy) o;

            if (!recoveryGroupArn.equals(that.recoveryGroupArn)) return false;
            return this.recoveryGroupName.equals(that.recoveryGroupName);
        }

        @Override
        public final int hashCode() {
            int result = this.recoveryGroupArn.hashCode();
            result = 31 * result + (this.recoveryGroupName.hashCode());
            return result;
        }
    }
}
