package software.amazon.awscdk.services.route53resolver;

/**
 * Properties for defining a <code>CfnResolverEndpoint</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.*;
 * CfnResolverEndpointProps cfnResolverEndpointProps = CfnResolverEndpointProps.builder()
 *         .direction("direction")
 *         .ipAddresses(List.of(IpAddressRequestProperty.builder()
 *                 .subnetId("subnetId")
 *                 // the properties below are optional
 *                 .ip("ip")
 *                 .ipv6("ipv6")
 *                 .build()))
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         // the properties below are optional
 *         .name("name")
 *         .outpostArn("outpostArn")
 *         .preferredInstanceType("preferredInstanceType")
 *         .protocols(List.of("protocols"))
 *         .resolverEndpointType("resolverEndpointType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.908Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53resolver.CfnResolverEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnResolverEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResolverEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:.
     * <p>
     * <ul>
     * <li><code>INBOUND</code> : allows DNS queries to your VPC from your network</li>
     * <li><code>OUTBOUND</code> : allows DNS queries from your VPC to your network</li>
     * <li><code>INBOUND_DELEGATION</code> : Resolver delegates queries to Route 53 private hosted zones from your network.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-direction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-direction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirection();

    /**
     * The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints).
     * <p>
     * The subnet ID uniquely identifies a VPC.
     * <p>
     * <blockquote>
     * <p>
     * Even though the minimum is 1, Route 53 requires that you create at least two.
     * <p>
     * </blockquote>
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.route53resolver.CfnResolverEndpoint.IpAddressRequestProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-ipaddresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-ipaddresses</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getIpAddresses();

    /**
     * The ID of one or more security groups that control access to this VPC.
     * <p>
     * The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

    /**
     * A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The ARN (Amazon Resource Name) for the Outpost.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-outpostarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-outpostarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutpostArn() {
        return null;
    }

    /**
     * The Amazon EC2 instance type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-preferredinstancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-preferredinstancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredInstanceType() {
        return null;
    }

    /**
     * Protocols used for the endpoint. DoH-FIPS is applicable for a default inbound endpoints only.
     * <p>
     * For an inbound endpoint you can apply the protocols as follows:
     * <p>
     * <ul>
     * <li>Do53 and DoH in combination.</li>
     * <li>Do53 and DoH-FIPS in combination.</li>
     * <li>Do53 alone.</li>
     * <li>DoH alone.</li>
     * <li>DoH-FIPS alone.</li>
     * <li>None, which is treated as Do53.</li>
     * </ul>
     * <p>
     * For a delegation inbound endpoint you can use Do53 only.
     * <p>
     * For an outbound endpoint you can apply the protocols as follows:
     * <p>
     * <ul>
     * <li>Do53 and DoH in combination.</li>
     * <li>Do53 alone.</li>
     * <li>DoH alone.</li>
     * <li>None, which is treated as Do53.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-protocols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-protocols</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProtocols() {
        return null;
    }

    /**
     * The Resolver endpoint IP address type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-resolverendpointtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-resolverendpointtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResolverEndpointType() {
        return null;
    }

    /**
     * Route 53 Resolver doesn't support updating tags through CloudFormation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53resolver-resolverendpoint.html#cfn-route53resolver-resolverendpoint-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResolverEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResolverEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResolverEndpointProps> {
        java.lang.String direction;
        java.lang.Object ipAddresses;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String name;
        java.lang.String outpostArn;
        java.lang.String preferredInstanceType;
        java.util.List<java.lang.String> protocols;
        java.lang.String resolverEndpointType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getDirection}
         * @param direction Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:. This parameter is required.
         *                  <ul>
         *                  <li><code>INBOUND</code> : allows DNS queries to your VPC from your network</li>
         *                  <li><code>OUTBOUND</code> : allows DNS queries from your VPC to your network</li>
         *                  <li><code>INBOUND_DELEGATION</code> : Resolver delegates queries to Route 53 private hosted zones from your network.</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder direction(java.lang.String direction) {
            this.direction = direction;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getIpAddresses}
         * @param ipAddresses The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). This parameter is required.
         *                    The subnet ID uniquely identifies a VPC.
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    Even though the minimum is 1, Route 53 requires that you create at least two.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddresses(software.amazon.awscdk.IResolvable ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getIpAddresses}
         * @param ipAddresses The subnets and IP addresses in your VPC that DNS queries originate from (for outbound endpoints) or that you forward DNS queries to (for inbound endpoints). This parameter is required.
         *                    The subnet ID uniquely identifies a VPC.
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    Even though the minimum is 1, Route 53 requires that you create at least two.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddresses(java.util.List<? extends java.lang.Object> ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getSecurityGroupIds}
         * @param securityGroupIds The ID of one or more security groups that control access to this VPC. This parameter is required.
         *                         The security group must include one or more inbound rules (for inbound endpoints) or outbound rules (for outbound endpoints). Inbound and outbound rules must allow TCP and UDP access. For inbound access, open port 53. For outbound access, open the port that you're using for DNS queries on your network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getName}
         * @param name A friendly name that lets you easily find a configuration in the Resolver dashboard in the Route 53 console.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getOutpostArn}
         * @param outpostArn The ARN (Amazon Resource Name) for the Outpost.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostArn(java.lang.String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getPreferredInstanceType}
         * @param preferredInstanceType The Amazon EC2 instance type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredInstanceType(java.lang.String preferredInstanceType) {
            this.preferredInstanceType = preferredInstanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getProtocols}
         * @param protocols Protocols used for the endpoint. DoH-FIPS is applicable for a default inbound endpoints only.
         *                  For an inbound endpoint you can apply the protocols as follows:
         *                  <p>
         *                  <ul>
         *                  <li>Do53 and DoH in combination.</li>
         *                  <li>Do53 and DoH-FIPS in combination.</li>
         *                  <li>Do53 alone.</li>
         *                  <li>DoH alone.</li>
         *                  <li>DoH-FIPS alone.</li>
         *                  <li>None, which is treated as Do53.</li>
         *                  </ul>
         *                  <p>
         *                  For a delegation inbound endpoint you can use Do53 only.
         *                  <p>
         *                  For an outbound endpoint you can apply the protocols as follows:
         *                  <p>
         *                  <ul>
         *                  <li>Do53 and DoH in combination.</li>
         *                  <li>Do53 alone.</li>
         *                  <li>DoH alone.</li>
         *                  <li>None, which is treated as Do53.</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocols(java.util.List<java.lang.String> protocols) {
            this.protocols = protocols;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getResolverEndpointType}
         * @param resolverEndpointType The Resolver endpoint IP address type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverEndpointType(java.lang.String resolverEndpointType) {
            this.resolverEndpointType = resolverEndpointType;
            return this;
        }

        /**
         * Sets the value of {@link CfnResolverEndpointProps#getTags}
         * @param tags Route 53 Resolver doesn't support updating tags through CloudFormation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResolverEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResolverEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResolverEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResolverEndpointProps {
        private final java.lang.String direction;
        private final java.lang.Object ipAddresses;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String name;
        private final java.lang.String outpostArn;
        private final java.lang.String preferredInstanceType;
        private final java.util.List<java.lang.String> protocols;
        private final java.lang.String resolverEndpointType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.direction = software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddresses = software.amazon.jsii.Kernel.get(this, "ipAddresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outpostArn = software.amazon.jsii.Kernel.get(this, "outpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredInstanceType = software.amazon.jsii.Kernel.get(this, "preferredInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocols = software.amazon.jsii.Kernel.get(this, "protocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.resolverEndpointType = software.amazon.jsii.Kernel.get(this, "resolverEndpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.direction = java.util.Objects.requireNonNull(builder.direction, "direction is required");
            this.ipAddresses = java.util.Objects.requireNonNull(builder.ipAddresses, "ipAddresses is required");
            this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
            this.name = builder.name;
            this.outpostArn = builder.outpostArn;
            this.preferredInstanceType = builder.preferredInstanceType;
            this.protocols = builder.protocols;
            this.resolverEndpointType = builder.resolverEndpointType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDirection() {
            return this.direction;
        }

        @Override
        public final java.lang.Object getIpAddresses() {
            return this.ipAddresses;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        public final java.lang.String getPreferredInstanceType() {
            return this.preferredInstanceType;
        }

        @Override
        public final java.util.List<java.lang.String> getProtocols() {
            return this.protocols;
        }

        @Override
        public final java.lang.String getResolverEndpointType() {
            return this.resolverEndpointType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("direction", om.valueToTree(this.getDirection()));
            data.set("ipAddresses", om.valueToTree(this.getIpAddresses()));
            data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOutpostArn() != null) {
                data.set("outpostArn", om.valueToTree(this.getOutpostArn()));
            }
            if (this.getPreferredInstanceType() != null) {
                data.set("preferredInstanceType", om.valueToTree(this.getPreferredInstanceType()));
            }
            if (this.getProtocols() != null) {
                data.set("protocols", om.valueToTree(this.getProtocols()));
            }
            if (this.getResolverEndpointType() != null) {
                data.set("resolverEndpointType", om.valueToTree(this.getResolverEndpointType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53resolver.CfnResolverEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResolverEndpointProps.Jsii$Proxy that = (CfnResolverEndpointProps.Jsii$Proxy) o;

            if (!direction.equals(that.direction)) return false;
            if (!ipAddresses.equals(that.ipAddresses)) return false;
            if (!securityGroupIds.equals(that.securityGroupIds)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.outpostArn != null ? !this.outpostArn.equals(that.outpostArn) : that.outpostArn != null) return false;
            if (this.preferredInstanceType != null ? !this.preferredInstanceType.equals(that.preferredInstanceType) : that.preferredInstanceType != null) return false;
            if (this.protocols != null ? !this.protocols.equals(that.protocols) : that.protocols != null) return false;
            if (this.resolverEndpointType != null ? !this.resolverEndpointType.equals(that.resolverEndpointType) : that.resolverEndpointType != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.direction.hashCode();
            result = 31 * result + (this.ipAddresses.hashCode());
            result = 31 * result + (this.securityGroupIds.hashCode());
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.outpostArn != null ? this.outpostArn.hashCode() : 0);
            result = 31 * result + (this.preferredInstanceType != null ? this.preferredInstanceType.hashCode() : 0);
            result = 31 * result + (this.protocols != null ? this.protocols.hashCode() : 0);
            result = 31 * result + (this.resolverEndpointType != null ? this.resolverEndpointType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
