package software.amazon.awscdk.services.route53resolver;

/**
 * A reference to a ResolverRule resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.*;
 * ResolverRuleReference resolverRuleReference = ResolverRuleReference.builder()
 *         .resolverRuleArn("resolverRuleArn")
 *         .resolverRuleId("resolverRuleId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:13.922Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53resolver.ResolverRuleReference")
@software.amazon.jsii.Jsii.Proxy(ResolverRuleReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResolverRuleReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ResolverRule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResolverRuleArn();

    /**
     * The ResolverRuleId of the ResolverRule resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResolverRuleId();

    /**
     * @return a {@link Builder} of {@link ResolverRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResolverRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResolverRuleReference> {
        java.lang.String resolverRuleArn;
        java.lang.String resolverRuleId;

        /**
         * Sets the value of {@link ResolverRuleReference#getResolverRuleArn}
         * @param resolverRuleArn The ARN of the ResolverRule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverRuleArn(java.lang.String resolverRuleArn) {
            this.resolverRuleArn = resolverRuleArn;
            return this;
        }

        /**
         * Sets the value of {@link ResolverRuleReference#getResolverRuleId}
         * @param resolverRuleId The ResolverRuleId of the ResolverRule resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolverRuleId(java.lang.String resolverRuleId) {
            this.resolverRuleId = resolverRuleId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResolverRuleReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResolverRuleReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResolverRuleReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResolverRuleReference {
        private final java.lang.String resolverRuleArn;
        private final java.lang.String resolverRuleId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resolverRuleArn = software.amazon.jsii.Kernel.get(this, "resolverRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resolverRuleId = software.amazon.jsii.Kernel.get(this, "resolverRuleId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resolverRuleArn = java.util.Objects.requireNonNull(builder.resolverRuleArn, "resolverRuleArn is required");
            this.resolverRuleId = java.util.Objects.requireNonNull(builder.resolverRuleId, "resolverRuleId is required");
        }

        @Override
        public final java.lang.String getResolverRuleArn() {
            return this.resolverRuleArn;
        }

        @Override
        public final java.lang.String getResolverRuleId() {
            return this.resolverRuleId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resolverRuleArn", om.valueToTree(this.getResolverRuleArn()));
            data.set("resolverRuleId", om.valueToTree(this.getResolverRuleId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53resolver.ResolverRuleReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResolverRuleReference.Jsii$Proxy that = (ResolverRuleReference.Jsii$Proxy) o;

            if (!resolverRuleArn.equals(that.resolverRuleArn)) return false;
            return this.resolverRuleId.equals(that.resolverRuleId);
        }

        @Override
        public final int hashCode() {
            int result = this.resolverRuleArn.hashCode();
            result = 31 * result + (this.resolverRuleId.hashCode());
            return result;
        }
    }
}
