package software.amazon.awscdk.services.s3;

/**
 * A reference to a MultiRegionAccessPoint resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * MultiRegionAccessPointReference multiRegionAccessPointReference = MultiRegionAccessPointReference.builder()
 *         .multiRegionAccessPointName("multiRegionAccessPointName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.141Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.MultiRegionAccessPointReference")
@software.amazon.jsii.Jsii.Proxy(MultiRegionAccessPointReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MultiRegionAccessPointReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Name of the MultiRegionAccessPoint resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMultiRegionAccessPointName();

    /**
     * @return a {@link Builder} of {@link MultiRegionAccessPointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MultiRegionAccessPointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MultiRegionAccessPointReference> {
        java.lang.String multiRegionAccessPointName;

        /**
         * Sets the value of {@link MultiRegionAccessPointReference#getMultiRegionAccessPointName}
         * @param multiRegionAccessPointName The Name of the MultiRegionAccessPoint resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionAccessPointName(java.lang.String multiRegionAccessPointName) {
            this.multiRegionAccessPointName = multiRegionAccessPointName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MultiRegionAccessPointReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MultiRegionAccessPointReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MultiRegionAccessPointReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiRegionAccessPointReference {
        private final java.lang.String multiRegionAccessPointName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.multiRegionAccessPointName = software.amazon.jsii.Kernel.get(this, "multiRegionAccessPointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.multiRegionAccessPointName = java.util.Objects.requireNonNull(builder.multiRegionAccessPointName, "multiRegionAccessPointName is required");
        }

        @Override
        public final java.lang.String getMultiRegionAccessPointName() {
            return this.multiRegionAccessPointName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("multiRegionAccessPointName", om.valueToTree(this.getMultiRegionAccessPointName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.MultiRegionAccessPointReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MultiRegionAccessPointReference.Jsii$Proxy that = (MultiRegionAccessPointReference.Jsii$Proxy) o;

            return this.multiRegionAccessPointName.equals(that.multiRegionAccessPointName);
        }

        @Override
        public final int hashCode() {
            int result = this.multiRegionAccessPointName.hashCode();
            return result;
        }
    }
}
