package software.amazon.awscdk.services.s3;

/**
 * A reference to a StorageLensGroup resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * StorageLensGroupReference storageLensGroupReference = StorageLensGroupReference.builder()
 *         .storageLensGroupArn("storageLensGroupArn")
 *         .storageLensGroupName("storageLensGroupName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.148Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.StorageLensGroupReference")
@software.amazon.jsii.Jsii.Proxy(StorageLensGroupReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StorageLensGroupReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the StorageLensGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStorageLensGroupArn();

    /**
     * The Name of the StorageLensGroup resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStorageLensGroupName();

    /**
     * @return a {@link Builder} of {@link StorageLensGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StorageLensGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StorageLensGroupReference> {
        java.lang.String storageLensGroupArn;
        java.lang.String storageLensGroupName;

        /**
         * Sets the value of {@link StorageLensGroupReference#getStorageLensGroupArn}
         * @param storageLensGroupArn The ARN of the StorageLensGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageLensGroupArn(java.lang.String storageLensGroupArn) {
            this.storageLensGroupArn = storageLensGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link StorageLensGroupReference#getStorageLensGroupName}
         * @param storageLensGroupName The Name of the StorageLensGroup resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageLensGroupName(java.lang.String storageLensGroupName) {
            this.storageLensGroupName = storageLensGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StorageLensGroupReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StorageLensGroupReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StorageLensGroupReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageLensGroupReference {
        private final java.lang.String storageLensGroupArn;
        private final java.lang.String storageLensGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.storageLensGroupArn = software.amazon.jsii.Kernel.get(this, "storageLensGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageLensGroupName = software.amazon.jsii.Kernel.get(this, "storageLensGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.storageLensGroupArn = java.util.Objects.requireNonNull(builder.storageLensGroupArn, "storageLensGroupArn is required");
            this.storageLensGroupName = java.util.Objects.requireNonNull(builder.storageLensGroupName, "storageLensGroupName is required");
        }

        @Override
        public final java.lang.String getStorageLensGroupArn() {
            return this.storageLensGroupArn;
        }

        @Override
        public final java.lang.String getStorageLensGroupName() {
            return this.storageLensGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("storageLensGroupArn", om.valueToTree(this.getStorageLensGroupArn()));
            data.set("storageLensGroupName", om.valueToTree(this.getStorageLensGroupName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.StorageLensGroupReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StorageLensGroupReference.Jsii$Proxy that = (StorageLensGroupReference.Jsii$Proxy) o;

            if (!storageLensGroupArn.equals(that.storageLensGroupArn)) return false;
            return this.storageLensGroupName.equals(that.storageLensGroupName);
        }

        @Override
        public final int hashCode() {
            int result = this.storageLensGroupArn.hashCode();
            result = 31 * result + (this.storageLensGroupName.hashCode());
            return result;
        }
    }
}
