package software.amazon.awscdk.services.s3vectors;

/**
 * Properties for defining a <code>CfnVectorBucket</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3vectors.*;
 * CfnVectorBucketProps cfnVectorBucketProps = CfnVectorBucketProps.builder()
 *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .sseType("sseType")
 *                 .build())
 *         .vectorBucketName("vectorBucketName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucket.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucket.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.264Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3vectors.CfnVectorBucketProps")
@software.amazon.jsii.Jsii.Proxy(CfnVectorBucketProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVectorBucketProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The encryption configuration for the vector bucket.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.s3vectors.CfnVectorBucket.EncryptionConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucket.html#cfn-s3vectors-vectorbucket-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucket.html#cfn-s3vectors-vectorbucket-encryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
        return null;
    }

    /**
     * The name of the vector bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucket.html#cfn-s3vectors-vectorbucket-vectorbucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3vectors-vectorbucket.html#cfn-s3vectors-vectorbucket-vectorbucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVectorBucketName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVectorBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVectorBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVectorBucketProps> {
        java.lang.Object encryptionConfiguration;
        java.lang.String vectorBucketName;

        /**
         * Sets the value of {@link CfnVectorBucketProps#getEncryptionConfiguration}
         * @param encryptionConfiguration The encryption configuration for the vector bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnVectorBucketProps#getEncryptionConfiguration}
         * @param encryptionConfiguration The encryption configuration for the vector bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionConfiguration(software.amazon.awscdk.services.s3vectors.CfnVectorBucket.EncryptionConfigurationProperty encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnVectorBucketProps#getVectorBucketName}
         * @param vectorBucketName The name of the vector bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorBucketName(java.lang.String vectorBucketName) {
            this.vectorBucketName = vectorBucketName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVectorBucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVectorBucketProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVectorBucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVectorBucketProps {
        private final java.lang.Object encryptionConfiguration;
        private final java.lang.String vectorBucketName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vectorBucketName = software.amazon.jsii.Kernel.get(this, "vectorBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryptionConfiguration = builder.encryptionConfiguration;
            this.vectorBucketName = builder.vectorBucketName;
        }

        @Override
        public final java.lang.Object getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Override
        public final java.lang.String getVectorBucketName() {
            return this.vectorBucketName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryptionConfiguration() != null) {
                data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
            }
            if (this.getVectorBucketName() != null) {
                data.set("vectorBucketName", om.valueToTree(this.getVectorBucketName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3vectors.CfnVectorBucketProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVectorBucketProps.Jsii$Proxy that = (CfnVectorBucketProps.Jsii$Proxy) o;

            if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
            return this.vectorBucketName != null ? this.vectorBucketName.equals(that.vectorBucketName) : that.vectorBucketName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0;
            result = 31 * result + (this.vectorBucketName != null ? this.vectorBucketName.hashCode() : 0);
            return result;
        }
    }
}
