package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .autoScaling(ClusterAutoScalingConfigProperty.builder()
 *                 .mode("mode")
 *                 // the properties below are optional
 *                 .autoScalerType("autoScalerType")
 *                 .build())
 *         .clusterName("clusterName")
 *         .clusterRole("clusterRole")
 *         .instanceGroups(List.of(ClusterInstanceGroupProperty.builder()
 *                 .executionRole("executionRole")
 *                 .instanceCount(123)
 *                 .instanceGroupName("instanceGroupName")
 *                 .instanceType("instanceType")
 *                 .lifeCycleConfig(ClusterLifeCycleConfigProperty.builder()
 *                         .onCreate("onCreate")
 *                         .sourceS3Uri("sourceS3Uri")
 *                         .build())
 *                 // the properties below are optional
 *                 .currentCount(123)
 *                 .imageId("imageId")
 *                 .instanceStorageConfigs(List.of(ClusterInstanceStorageConfigProperty.builder()
 *                         .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
 *                                 .rootVolume(false)
 *                                 .volumeKmsKeyId("volumeKmsKeyId")
 *                                 .volumeSizeInGb(123)
 *                                 .build())
 *                         .build()))
 *                 .onStartDeepHealthChecks(List.of("onStartDeepHealthChecks"))
 *                 .overrideVpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .scheduledUpdateConfig(ScheduledUpdateConfigProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         // the properties below are optional
 *                         .deploymentConfig(DeploymentConfigProperty.builder()
 *                                 .autoRollbackConfiguration(List.of(AlarmDetailsProperty.builder()
 *                                         .alarmName("alarmName")
 *                                         .build()))
 *                                 .rollingUpdatePolicy(RollingUpdatePolicyProperty.builder()
 *                                         .maximumBatchSize(CapacitySizeConfigProperty.builder()
 *                                                 .type("type")
 *                                                 .value(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .rollbackMaximumBatchSize(CapacitySizeConfigProperty.builder()
 *                                                 .type("type")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .waitIntervalInSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .threadsPerCore(123)
 *                 .trainingPlanArn("trainingPlanArn")
 *                 .build()))
 *         .nodeProvisioningMode("nodeProvisioningMode")
 *         .nodeRecovery("nodeRecovery")
 *         .orchestrator(OrchestratorProperty.builder()
 *                 .eks(ClusterOrchestratorEksConfigProperty.builder()
 *                         .clusterArn("clusterArn")
 *                         .build())
 *                 .build())
 *         .restrictedInstanceGroups(List.of(ClusterRestrictedInstanceGroupProperty.builder()
 *                 .environmentConfig(EnvironmentConfigProperty.builder()
 *                         .fSxLustreConfig(FSxLustreConfigProperty.builder()
 *                                 .perUnitStorageThroughput(123)
 *                                 .sizeInGiB(123)
 *                                 .build())
 *                         .build())
 *                 .executionRole("executionRole")
 *                 .instanceCount(123)
 *                 .instanceGroupName("instanceGroupName")
 *                 .instanceType("instanceType")
 *                 // the properties below are optional
 *                 .currentCount(123)
 *                 .instanceStorageConfigs(List.of(ClusterInstanceStorageConfigProperty.builder()
 *                         .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
 *                                 .rootVolume(false)
 *                                 .volumeKmsKeyId("volumeKmsKeyId")
 *                                 .volumeSizeInGb(123)
 *                                 .build())
 *                         .build()))
 *                 .onStartDeepHealthChecks(List.of("onStartDeepHealthChecks"))
 *                 .overrideVpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .threadsPerCore(123)
 *                 .trainingPlanArn("trainingPlanArn")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tieredStorageConfig(TieredStorageConfigProperty.builder()
 *                 .mode("mode")
 *                 // the properties below are optional
 *                 .instanceMemoryAllocationPercentage(123)
 *                 .build())
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.300Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Configuration for cluster auto-scaling.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterAutoScalingConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-autoscaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-autoscaling</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoScaling() {
        return null;
    }

    /**
     * The name of the SageMaker HyperPod cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return null;
    }

    /**
     * The cluster role for the autoscaler to assume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clusterrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clusterrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterRole() {
        return null;
    }

    /**
     * The instance groups of the SageMaker HyperPod cluster.
     * <p>
     * To delete an instance group, remove it from the array.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterInstanceGroupProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceGroups() {
        return null;
    }

    /**
     * Determines the scaling strategy for the SageMaker HyperPod cluster.
     * <p>
     * When set to 'Continuous', enables continuous scaling which dynamically manages node provisioning. If the parameter is omitted, uses the standard scaling approach in previous release.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-nodeprovisioningmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-nodeprovisioningmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNodeProvisioningMode() {
        return null;
    }

    /**
     * Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.
     * <p>
     * Available values are <code>Automatic</code> for enabling and <code>None</code> for disabling.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-noderecovery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-noderecovery</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNodeRecovery() {
        return null;
    }

    /**
     * The orchestrator type for the SageMaker HyperPod cluster.
     * <p>
     * Currently, <code>'eks'</code> is the only available option.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnCluster.OrchestratorProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOrchestrator() {
        return null;
    }

    /**
     * The restricted instance groups of the SageMaker HyperPod cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterRestrictedInstanceGroupProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-restrictedinstancegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-restrictedinstancegroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictedInstanceGroups() {
        return null;
    }

    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.
     * <p>
     * You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to SageMaker resources, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html">AddTags</a> .
     * <p>
     * For more information on adding metadata to your AWS resources with tagging, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> . For advice on best practices for managing AWS resources with tagging, see <a href="https://docs.aws.amazon.com/https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging Best Practices: Implement an Effective AWS Resource Tagging Strategy</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Configuration for tiered storage in the SageMaker HyperPod cluster.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnCluster.TieredStorageConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tieredstorageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tieredstorageconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTieredStorageConfig() {
        return null;
    }

    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     * <p>
     * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnCluster.VpcConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.Object autoScaling;
        java.lang.String clusterName;
        java.lang.String clusterRole;
        java.lang.Object instanceGroups;
        java.lang.String nodeProvisioningMode;
        java.lang.String nodeRecovery;
        java.lang.Object orchestrator;
        java.lang.Object restrictedInstanceGroups;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object tieredStorageConfig;
        java.lang.Object vpcConfig;

        /**
         * Sets the value of {@link CfnClusterProps#getAutoScaling}
         * @param autoScaling Configuration for cluster auto-scaling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScaling(software.amazon.awscdk.IResolvable autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getAutoScaling}
         * @param autoScaling Configuration for cluster auto-scaling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScaling(software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterAutoScalingConfigProperty autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterName}
         * @param clusterName The name of the SageMaker HyperPod cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterRole}
         * @param clusterRole The cluster role for the autoscaler to assume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterRole(java.lang.String clusterRole) {
            this.clusterRole = clusterRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getInstanceGroups}
         * @param instanceGroups The instance groups of the SageMaker HyperPod cluster.
         *                       To delete an instance group, remove it from the array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroups(software.amazon.awscdk.IResolvable instanceGroups) {
            this.instanceGroups = instanceGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getInstanceGroups}
         * @param instanceGroups The instance groups of the SageMaker HyperPod cluster.
         *                       To delete an instance group, remove it from the array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroups(java.util.List<? extends java.lang.Object> instanceGroups) {
            this.instanceGroups = instanceGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNodeProvisioningMode}
         * @param nodeProvisioningMode Determines the scaling strategy for the SageMaker HyperPod cluster.
         *                             When set to 'Continuous', enables continuous scaling which dynamically manages node provisioning. If the parameter is omitted, uses the standard scaling approach in previous release.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProvisioningMode(java.lang.String nodeProvisioningMode) {
            this.nodeProvisioningMode = nodeProvisioningMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNodeRecovery}
         * @param nodeRecovery Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.
         *                     Available values are <code>Automatic</code> for enabling and <code>None</code> for disabling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeRecovery(java.lang.String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOrchestrator}
         * @param orchestrator The orchestrator type for the SageMaker HyperPod cluster.
         *                     Currently, <code>'eks'</code> is the only available option.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder orchestrator(software.amazon.awscdk.IResolvable orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOrchestrator}
         * @param orchestrator The orchestrator type for the SageMaker HyperPod cluster.
         *                     Currently, <code>'eks'</code> is the only available option.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder orchestrator(software.amazon.awscdk.services.sagemaker.CfnCluster.OrchestratorProperty orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRestrictedInstanceGroups}
         * @param restrictedInstanceGroups The restricted instance groups of the SageMaker HyperPod cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restrictedInstanceGroups(software.amazon.awscdk.IResolvable restrictedInstanceGroups) {
            this.restrictedInstanceGroups = restrictedInstanceGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getRestrictedInstanceGroups}
         * @param restrictedInstanceGroups The restricted instance groups of the SageMaker HyperPod cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restrictedInstanceGroups(java.util.List<? extends java.lang.Object> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = restrictedInstanceGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.
         *             You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to SageMaker resources, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html">AddTags</a> .
         *             <p>
         *             For more information on adding metadata to your AWS resources with tagging, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> . For advice on best practices for managing AWS resources with tagging, see <a href="https://docs.aws.amazon.com/https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging Best Practices: Implement an Effective AWS Resource Tagging Strategy</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTieredStorageConfig}
         * @param tieredStorageConfig Configuration for tiered storage in the SageMaker HyperPod cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tieredStorageConfig(software.amazon.awscdk.IResolvable tieredStorageConfig) {
            this.tieredStorageConfig = tieredStorageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTieredStorageConfig}
         * @param tieredStorageConfig Configuration for tiered storage in the SageMaker HyperPod cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tieredStorageConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.TieredStorageConfigProperty tieredStorageConfig) {
            this.tieredStorageConfig = tieredStorageConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVpcConfig}
         * @param vpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
         *                  You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getVpcConfig}
         * @param vpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
         *                  You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.VpcConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.Object autoScaling;
        private final java.lang.String clusterName;
        private final java.lang.String clusterRole;
        private final java.lang.Object instanceGroups;
        private final java.lang.String nodeProvisioningMode;
        private final java.lang.String nodeRecovery;
        private final java.lang.Object orchestrator;
        private final java.lang.Object restrictedInstanceGroups;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object tieredStorageConfig;
        private final java.lang.Object vpcConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScaling = software.amazon.jsii.Kernel.get(this, "autoScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterRole = software.amazon.jsii.Kernel.get(this, "clusterRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceGroups = software.amazon.jsii.Kernel.get(this, "instanceGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.nodeProvisioningMode = software.amazon.jsii.Kernel.get(this, "nodeProvisioningMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nodeRecovery = software.amazon.jsii.Kernel.get(this, "nodeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.orchestrator = software.amazon.jsii.Kernel.get(this, "orchestrator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.restrictedInstanceGroups = software.amazon.jsii.Kernel.get(this, "restrictedInstanceGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.tieredStorageConfig = software.amazon.jsii.Kernel.get(this, "tieredStorageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScaling = builder.autoScaling;
            this.clusterName = builder.clusterName;
            this.clusterRole = builder.clusterRole;
            this.instanceGroups = builder.instanceGroups;
            this.nodeProvisioningMode = builder.nodeProvisioningMode;
            this.nodeRecovery = builder.nodeRecovery;
            this.orchestrator = builder.orchestrator;
            this.restrictedInstanceGroups = builder.restrictedInstanceGroups;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.tieredStorageConfig = builder.tieredStorageConfig;
            this.vpcConfig = builder.vpcConfig;
        }

        @Override
        public final java.lang.Object getAutoScaling() {
            return this.autoScaling;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getClusterRole() {
            return this.clusterRole;
        }

        @Override
        public final java.lang.Object getInstanceGroups() {
            return this.instanceGroups;
        }

        @Override
        public final java.lang.String getNodeProvisioningMode() {
            return this.nodeProvisioningMode;
        }

        @Override
        public final java.lang.String getNodeRecovery() {
            return this.nodeRecovery;
        }

        @Override
        public final java.lang.Object getOrchestrator() {
            return this.orchestrator;
        }

        @Override
        public final java.lang.Object getRestrictedInstanceGroups() {
            return this.restrictedInstanceGroups;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTieredStorageConfig() {
            return this.tieredStorageConfig;
        }

        @Override
        public final java.lang.Object getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoScaling() != null) {
                data.set("autoScaling", om.valueToTree(this.getAutoScaling()));
            }
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getClusterRole() != null) {
                data.set("clusterRole", om.valueToTree(this.getClusterRole()));
            }
            if (this.getInstanceGroups() != null) {
                data.set("instanceGroups", om.valueToTree(this.getInstanceGroups()));
            }
            if (this.getNodeProvisioningMode() != null) {
                data.set("nodeProvisioningMode", om.valueToTree(this.getNodeProvisioningMode()));
            }
            if (this.getNodeRecovery() != null) {
                data.set("nodeRecovery", om.valueToTree(this.getNodeRecovery()));
            }
            if (this.getOrchestrator() != null) {
                data.set("orchestrator", om.valueToTree(this.getOrchestrator()));
            }
            if (this.getRestrictedInstanceGroups() != null) {
                data.set("restrictedInstanceGroups", om.valueToTree(this.getRestrictedInstanceGroups()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTieredStorageConfig() != null) {
                data.set("tieredStorageConfig", om.valueToTree(this.getTieredStorageConfig()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (this.autoScaling != null ? !this.autoScaling.equals(that.autoScaling) : that.autoScaling != null) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.clusterRole != null ? !this.clusterRole.equals(that.clusterRole) : that.clusterRole != null) return false;
            if (this.instanceGroups != null ? !this.instanceGroups.equals(that.instanceGroups) : that.instanceGroups != null) return false;
            if (this.nodeProvisioningMode != null ? !this.nodeProvisioningMode.equals(that.nodeProvisioningMode) : that.nodeProvisioningMode != null) return false;
            if (this.nodeRecovery != null ? !this.nodeRecovery.equals(that.nodeRecovery) : that.nodeRecovery != null) return false;
            if (this.orchestrator != null ? !this.orchestrator.equals(that.orchestrator) : that.orchestrator != null) return false;
            if (this.restrictedInstanceGroups != null ? !this.restrictedInstanceGroups.equals(that.restrictedInstanceGroups) : that.restrictedInstanceGroups != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tieredStorageConfig != null ? !this.tieredStorageConfig.equals(that.tieredStorageConfig) : that.tieredStorageConfig != null) return false;
            return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScaling != null ? this.autoScaling.hashCode() : 0;
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.clusterRole != null ? this.clusterRole.hashCode() : 0);
            result = 31 * result + (this.instanceGroups != null ? this.instanceGroups.hashCode() : 0);
            result = 31 * result + (this.nodeProvisioningMode != null ? this.nodeProvisioningMode.hashCode() : 0);
            result = 31 * result + (this.nodeRecovery != null ? this.nodeRecovery.hashCode() : 0);
            result = 31 * result + (this.orchestrator != null ? this.orchestrator.hashCode() : 0);
            result = 31 * result + (this.restrictedInstanceGroups != null ? this.restrictedInstanceGroups.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tieredStorageConfig != null ? this.tieredStorageConfig.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            return result;
        }
    }
}
