package software.amazon.awscdk.services.sagemaker;

/**
 * The <code>AWS::SageMaker::EndpointConfig</code> resource creates a configuration for an Amazon SageMaker endpoint.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html">CreateEndpointConfig</a> in the <em>SageMaker Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnEndpointConfig cfnEndpointConfig = CfnEndpointConfig.Builder.create(this, "MyCfnEndpointConfig")
 *         .productionVariants(List.of(ProductionVariantProperty.builder()
 *                 .variantName("variantName")
 *                 // the properties below are optional
 *                 .acceleratorType("acceleratorType")
 *                 .capacityReservationConfig(CapacityReservationConfigProperty.builder()
 *                         .capacityReservationPreference("capacityReservationPreference")
 *                         .mlReservationArn("mlReservationArn")
 *                         .build())
 *                 .containerStartupHealthCheckTimeoutInSeconds(123)
 *                 .enableSsmAccess(false)
 *                 .inferenceAmiVersion("inferenceAmiVersion")
 *                 .initialInstanceCount(123)
 *                 .initialVariantWeight(123)
 *                 .instanceType("instanceType")
 *                 .managedInstanceScaling(ManagedInstanceScalingProperty.builder()
 *                         .maxInstanceCount(123)
 *                         .minInstanceCount(123)
 *                         .status("status")
 *                         .build())
 *                 .modelDataDownloadTimeoutInSeconds(123)
 *                 .modelName("modelName")
 *                 .routingConfig(RoutingConfigProperty.builder()
 *                         .routingStrategy("routingStrategy")
 *                         .build())
 *                 .serverlessConfig(ServerlessConfigProperty.builder()
 *                         .maxConcurrency(123)
 *                         .memorySizeInMb(123)
 *                         // the properties below are optional
 *                         .provisionedConcurrency(123)
 *                         .build())
 *                 .volumeSizeInGb(123)
 *                 .build()))
 *         // the properties below are optional
 *         .asyncInferenceConfig(AsyncInferenceConfigProperty.builder()
 *                 .outputConfig(AsyncInferenceOutputConfigProperty.builder()
 *                         .kmsKeyId("kmsKeyId")
 *                         .notificationConfig(AsyncInferenceNotificationConfigProperty.builder()
 *                                 .errorTopic("errorTopic")
 *                                 .includeInferenceResponseIn(List.of("includeInferenceResponseIn"))
 *                                 .successTopic("successTopic")
 *                                 .build())
 *                         .s3FailurePath("s3FailurePath")
 *                         .s3OutputPath("s3OutputPath")
 *                         .build())
 *                 // the properties below are optional
 *                 .clientConfig(AsyncInferenceClientConfigProperty.builder()
 *                         .maxConcurrentInvocationsPerInstance(123)
 *                         .build())
 *                 .build())
 *         .dataCaptureConfig(DataCaptureConfigProperty.builder()
 *                 .captureOptions(List.of(CaptureOptionProperty.builder()
 *                         .captureMode("captureMode")
 *                         .build()))
 *                 .destinationS3Uri("destinationS3Uri")
 *                 .initialSamplingPercentage(123)
 *                 // the properties below are optional
 *                 .captureContentTypeHeader(CaptureContentTypeHeaderProperty.builder()
 *                         .csvContentTypes(List.of("csvContentTypes"))
 *                         .jsonContentTypes(List.of("jsonContentTypes"))
 *                         .build())
 *                 .enableCapture(false)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .enableNetworkIsolation(false)
 *         .endpointConfigName("endpointConfigName")
 *         .executionRoleArn("executionRoleArn")
 *         .explainerConfig(ExplainerConfigProperty.builder()
 *                 .clarifyExplainerConfig(ClarifyExplainerConfigProperty.builder()
 *                         .shapConfig(ClarifyShapConfigProperty.builder()
 *                                 .shapBaselineConfig(ClarifyShapBaselineConfigProperty.builder()
 *                                         .mimeType("mimeType")
 *                                         .shapBaseline("shapBaseline")
 *                                         .shapBaselineUri("shapBaselineUri")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .numberOfSamples(123)
 *                                 .seed(123)
 *                                 .textConfig(ClarifyTextConfigProperty.builder()
 *                                         .granularity("granularity")
 *                                         .language("language")
 *                                         .build())
 *                                 .useLogit(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .enableExplanations("enableExplanations")
 *                         .inferenceConfig(ClarifyInferenceConfigProperty.builder()
 *                                 .contentTemplate("contentTemplate")
 *                                 .featureHeaders(List.of("featureHeaders"))
 *                                 .featuresAttribute("featuresAttribute")
 *                                 .featureTypes(List.of("featureTypes"))
 *                                 .labelAttribute("labelAttribute")
 *                                 .labelHeaders(List.of("labelHeaders"))
 *                                 .labelIndex(123)
 *                                 .maxPayloadInMb(123)
 *                                 .maxRecordCount(123)
 *                                 .probabilityAttribute("probabilityAttribute")
 *                                 .probabilityIndex(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .shadowProductionVariants(List.of(ProductionVariantProperty.builder()
 *                 .variantName("variantName")
 *                 // the properties below are optional
 *                 .acceleratorType("acceleratorType")
 *                 .capacityReservationConfig(CapacityReservationConfigProperty.builder()
 *                         .capacityReservationPreference("capacityReservationPreference")
 *                         .mlReservationArn("mlReservationArn")
 *                         .build())
 *                 .containerStartupHealthCheckTimeoutInSeconds(123)
 *                 .enableSsmAccess(false)
 *                 .inferenceAmiVersion("inferenceAmiVersion")
 *                 .initialInstanceCount(123)
 *                 .initialVariantWeight(123)
 *                 .instanceType("instanceType")
 *                 .managedInstanceScaling(ManagedInstanceScalingProperty.builder()
 *                         .maxInstanceCount(123)
 *                         .minInstanceCount(123)
 *                         .status("status")
 *                         .build())
 *                 .modelDataDownloadTimeoutInSeconds(123)
 *                 .modelName("modelName")
 *                 .routingConfig(RoutingConfigProperty.builder()
 *                         .routingStrategy("routingStrategy")
 *                         .build())
 *                 .serverlessConfig(ServerlessConfigProperty.builder()
 *                         .maxConcurrency(123)
 *                         .memorySizeInMb(123)
 *                         // the properties below are optional
 *                         .provisionedConcurrency(123)
 *                         .build())
 *                 .volumeSizeInGb(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.375Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig")
public class CfnEndpointConfig extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.sagemaker.IEndpointConfigRef, software.amazon.awscdk.ITaggable {

    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEndpointConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEndpointConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The name of the endpoint configuration, such as <code>MyEndpointConfiguration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointConfigName() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a EndpointConfig resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.EndpointConfigReference getEndpointConfigRef() {
        return software.amazon.jsii.Kernel.get(this, "endpointConfigRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sagemaker.EndpointConfigReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getProductionVariants() {
        return software.amazon.jsii.Kernel.get(this, "productionVariants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProductionVariants(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "productionVariants", java.util.Objects.requireNonNull(value, "productionVariants is required"));
    }

    /**
     * A list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProductionVariants(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "productionVariants", java.util.Objects.requireNonNull(value, "productionVariants is required"));
    }

    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAsyncInferenceConfig() {
        return software.amazon.jsii.Kernel.get(this, "asyncInferenceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAsyncInferenceConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "asyncInferenceConfig", value);
    }

    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAsyncInferenceConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "asyncInferenceConfig", value);
    }

    /**
     * Specifies how to capture endpoint data for model monitor.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataCaptureConfig() {
        return software.amazon.jsii.Kernel.get(this, "dataCaptureConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies how to capture endpoint data for model monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCaptureConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataCaptureConfig", value);
    }

    /**
     * Specifies how to capture endpoint data for model monitor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataCaptureConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataCaptureConfig", value);
    }

    /**
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableNetworkIsolation() {
        return software.amazon.jsii.Kernel.get(this, "enableNetworkIsolation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableNetworkIsolation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableNetworkIsolation", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableNetworkIsolation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableNetworkIsolation", value);
    }

    /**
     * The name of the endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointConfigName() {
        return software.amazon.jsii.Kernel.get(this, "endpointConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointConfigName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointConfigName", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", value);
    }

    /**
     * A parameter to activate explainers.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ExplainerConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExplainerConfig() {
        return software.amazon.jsii.Kernel.get(this, "explainerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A parameter to activate explainers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExplainerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "explainerConfig", value);
    }

    /**
     * A parameter to activate explainers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExplainerConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ExplainerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "explainerConfig", value);
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Array of <code>ProductionVariant</code> objects.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getShadowProductionVariants() {
        return software.amazon.jsii.Kernel.get(this, "shadowProductionVariants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Array of <code>ProductionVariant</code> objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setShadowProductionVariants(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "shadowProductionVariants", value);
    }

    /**
     * Array of <code>ProductionVariant</code> objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setShadowProductionVariants(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ProductionVariantProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "shadowProductionVariants", value);
    }

    /**
     * A list of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.VpcConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.VpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AsyncInferenceClientConfigProperty asyncInferenceClientConfigProperty = AsyncInferenceClientConfigProperty.builder()
     *         .maxConcurrentInvocationsPerInstance(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AsyncInferenceClientConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsyncInferenceClientConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of concurrent requests sent by the SageMaker client to the model container.
         * <p>
         * If no value is provided, SageMaker will choose an optimal value for you.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceclientconfig-maxconcurrentinvocationsperinstance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceclientconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceclientconfig-maxconcurrentinvocationsperinstance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentInvocationsPerInstance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsyncInferenceClientConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsyncInferenceClientConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsyncInferenceClientConfigProperty> {
            java.lang.Number maxConcurrentInvocationsPerInstance;

            /**
             * Sets the value of {@link AsyncInferenceClientConfigProperty#getMaxConcurrentInvocationsPerInstance}
             * @param maxConcurrentInvocationsPerInstance The maximum number of concurrent requests sent by the SageMaker client to the model container.
             *                                            If no value is provided, SageMaker will choose an optimal value for you.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrentInvocationsPerInstance(java.lang.Number maxConcurrentInvocationsPerInstance) {
                this.maxConcurrentInvocationsPerInstance = maxConcurrentInvocationsPerInstance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsyncInferenceClientConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsyncInferenceClientConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsyncInferenceClientConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsyncInferenceClientConfigProperty {
            private final java.lang.Number maxConcurrentInvocationsPerInstance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxConcurrentInvocationsPerInstance = software.amazon.jsii.Kernel.get(this, "maxConcurrentInvocationsPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxConcurrentInvocationsPerInstance = builder.maxConcurrentInvocationsPerInstance;
            }

            @Override
            public final java.lang.Number getMaxConcurrentInvocationsPerInstance() {
                return this.maxConcurrentInvocationsPerInstance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxConcurrentInvocationsPerInstance() != null) {
                    data.set("maxConcurrentInvocationsPerInstance", om.valueToTree(this.getMaxConcurrentInvocationsPerInstance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsyncInferenceClientConfigProperty.Jsii$Proxy that = (AsyncInferenceClientConfigProperty.Jsii$Proxy) o;

                return this.maxConcurrentInvocationsPerInstance != null ? this.maxConcurrentInvocationsPerInstance.equals(that.maxConcurrentInvocationsPerInstance) : that.maxConcurrentInvocationsPerInstance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxConcurrentInvocationsPerInstance != null ? this.maxConcurrentInvocationsPerInstance.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies configuration for how an endpoint performs asynchronous inference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AsyncInferenceConfigProperty asyncInferenceConfigProperty = AsyncInferenceConfigProperty.builder()
     *         .outputConfig(AsyncInferenceOutputConfigProperty.builder()
     *                 .kmsKeyId("kmsKeyId")
     *                 .notificationConfig(AsyncInferenceNotificationConfigProperty.builder()
     *                         .errorTopic("errorTopic")
     *                         .includeInferenceResponseIn(List.of("includeInferenceResponseIn"))
     *                         .successTopic("successTopic")
     *                         .build())
     *                 .s3FailurePath("s3FailurePath")
     *                 .s3OutputPath("s3OutputPath")
     *                 .build())
     *         // the properties below are optional
     *         .clientConfig(AsyncInferenceClientConfigProperty.builder()
     *                 .maxConcurrentInvocationsPerInstance(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AsyncInferenceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsyncInferenceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the configuration for asynchronous inference invocation outputs.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-outputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-outputconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutputConfig();

        /**
         * Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-clientconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig-clientconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClientConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsyncInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsyncInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsyncInferenceConfigProperty> {
            java.lang.Object outputConfig;
            java.lang.Object clientConfig;

            /**
             * Sets the value of {@link AsyncInferenceConfigProperty#getOutputConfig}
             * @param outputConfig Specifies the configuration for asynchronous inference invocation outputs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputConfig(software.amazon.awscdk.IResolvable outputConfig) {
                this.outputConfig = outputConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceConfigProperty#getOutputConfig}
             * @param outputConfig Specifies the configuration for asynchronous inference invocation outputs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty outputConfig) {
                this.outputConfig = outputConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceConfigProperty#getClientConfig}
             * @param clientConfig Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfig(software.amazon.awscdk.IResolvable clientConfig) {
                this.clientConfig = clientConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceConfigProperty#getClientConfig}
             * @param clientConfig Configures the behavior of the client used by SageMaker to interact with the model container during asynchronous inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceClientConfigProperty clientConfig) {
                this.clientConfig = clientConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsyncInferenceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsyncInferenceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsyncInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsyncInferenceConfigProperty {
            private final java.lang.Object outputConfig;
            private final java.lang.Object clientConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputConfig = software.amazon.jsii.Kernel.get(this, "outputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clientConfig = software.amazon.jsii.Kernel.get(this, "clientConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputConfig = java.util.Objects.requireNonNull(builder.outputConfig, "outputConfig is required");
                this.clientConfig = builder.clientConfig;
            }

            @Override
            public final java.lang.Object getOutputConfig() {
                return this.outputConfig;
            }

            @Override
            public final java.lang.Object getClientConfig() {
                return this.clientConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputConfig", om.valueToTree(this.getOutputConfig()));
                if (this.getClientConfig() != null) {
                    data.set("clientConfig", om.valueToTree(this.getClientConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsyncInferenceConfigProperty.Jsii$Proxy that = (AsyncInferenceConfigProperty.Jsii$Proxy) o;

                if (!outputConfig.equals(that.outputConfig)) return false;
                return this.clientConfig != null ? this.clientConfig.equals(that.clientConfig) : that.clientConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputConfig.hashCode();
                result = 31 * result + (this.clientConfig != null ? this.clientConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for notifications of inference results for asynchronous inference.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AsyncInferenceNotificationConfigProperty asyncInferenceNotificationConfigProperty = AsyncInferenceNotificationConfigProperty.builder()
     *         .errorTopic("errorTopic")
     *         .includeInferenceResponseIn(List.of("includeInferenceResponseIn"))
     *         .successTopic("successTopic")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AsyncInferenceNotificationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsyncInferenceNotificationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Amazon SNS topic to post a notification to when an inference fails.
         * <p>
         * If no topic is provided, no notification is sent on failure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-errortopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-errortopic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getErrorTopic() {
            return null;
        }

        /**
         * The Amazon SNS topics where you want the inference response to be included.
         * <p>
         * <blockquote>
         * <p>
         * The inference response is included only if the response size is less than or equal to 128 KB.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-includeinferenceresponsein">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-includeinferenceresponsein</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludeInferenceResponseIn() {
            return null;
        }

        /**
         * Amazon SNS topic to post a notification to when an inference completes successfully.
         * <p>
         * If no topic is provided, no notification is sent on success.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-successtopic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferencenotificationconfig.html#cfn-sagemaker-endpointconfig-asyncinferencenotificationconfig-successtopic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuccessTopic() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsyncInferenceNotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsyncInferenceNotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsyncInferenceNotificationConfigProperty> {
            java.lang.String errorTopic;
            java.util.List<java.lang.String> includeInferenceResponseIn;
            java.lang.String successTopic;

            /**
             * Sets the value of {@link AsyncInferenceNotificationConfigProperty#getErrorTopic}
             * @param errorTopic Amazon SNS topic to post a notification to when an inference fails.
             *                   If no topic is provided, no notification is sent on failure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorTopic(java.lang.String errorTopic) {
                this.errorTopic = errorTopic;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceNotificationConfigProperty#getIncludeInferenceResponseIn}
             * @param includeInferenceResponseIn The Amazon SNS topics where you want the inference response to be included.
             *                                   <blockquote>
             *                                   <p>
             *                                   The inference response is included only if the response size is less than or equal to 128 KB.
             *                                   <p>
             *                                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeInferenceResponseIn(java.util.List<java.lang.String> includeInferenceResponseIn) {
                this.includeInferenceResponseIn = includeInferenceResponseIn;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceNotificationConfigProperty#getSuccessTopic}
             * @param successTopic Amazon SNS topic to post a notification to when an inference completes successfully.
             *                     If no topic is provided, no notification is sent on success.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successTopic(java.lang.String successTopic) {
                this.successTopic = successTopic;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsyncInferenceNotificationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsyncInferenceNotificationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsyncInferenceNotificationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsyncInferenceNotificationConfigProperty {
            private final java.lang.String errorTopic;
            private final java.util.List<java.lang.String> includeInferenceResponseIn;
            private final java.lang.String successTopic;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorTopic = software.amazon.jsii.Kernel.get(this, "errorTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeInferenceResponseIn = software.amazon.jsii.Kernel.get(this, "includeInferenceResponseIn", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.successTopic = software.amazon.jsii.Kernel.get(this, "successTopic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorTopic = builder.errorTopic;
                this.includeInferenceResponseIn = builder.includeInferenceResponseIn;
                this.successTopic = builder.successTopic;
            }

            @Override
            public final java.lang.String getErrorTopic() {
                return this.errorTopic;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludeInferenceResponseIn() {
                return this.includeInferenceResponseIn;
            }

            @Override
            public final java.lang.String getSuccessTopic() {
                return this.successTopic;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getErrorTopic() != null) {
                    data.set("errorTopic", om.valueToTree(this.getErrorTopic()));
                }
                if (this.getIncludeInferenceResponseIn() != null) {
                    data.set("includeInferenceResponseIn", om.valueToTree(this.getIncludeInferenceResponseIn()));
                }
                if (this.getSuccessTopic() != null) {
                    data.set("successTopic", om.valueToTree(this.getSuccessTopic()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsyncInferenceNotificationConfigProperty.Jsii$Proxy that = (AsyncInferenceNotificationConfigProperty.Jsii$Proxy) o;

                if (this.errorTopic != null ? !this.errorTopic.equals(that.errorTopic) : that.errorTopic != null) return false;
                if (this.includeInferenceResponseIn != null ? !this.includeInferenceResponseIn.equals(that.includeInferenceResponseIn) : that.includeInferenceResponseIn != null) return false;
                return this.successTopic != null ? this.successTopic.equals(that.successTopic) : that.successTopic == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorTopic != null ? this.errorTopic.hashCode() : 0;
                result = 31 * result + (this.includeInferenceResponseIn != null ? this.includeInferenceResponseIn.hashCode() : 0);
                result = 31 * result + (this.successTopic != null ? this.successTopic.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration for asynchronous inference invocation outputs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AsyncInferenceOutputConfigProperty asyncInferenceOutputConfigProperty = AsyncInferenceOutputConfigProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .notificationConfig(AsyncInferenceNotificationConfigProperty.builder()
     *                 .errorTopic("errorTopic")
     *                 .includeInferenceResponseIn(List.of("includeInferenceResponseIn"))
     *                 .successTopic("successTopic")
     *                 .build())
     *         .s3FailurePath("s3FailurePath")
     *         .s3OutputPath("s3OutputPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AsyncInferenceOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsyncInferenceOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * Specifies the configuration for notifications of inference results for asynchronous inference.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-notificationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-notificationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfig() {
            return null;
        }

        /**
         * The Amazon S3 location to upload failure inference responses to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3failurepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3failurepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3FailurePath() {
            return null;
        }

        /**
         * The Amazon S3 location to upload inference responses to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3outputpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-asyncinferenceoutputconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceoutputconfig-s3outputpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3OutputPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsyncInferenceOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsyncInferenceOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsyncInferenceOutputConfigProperty> {
            java.lang.String kmsKeyId;
            java.lang.Object notificationConfig;
            java.lang.String s3FailurePath;
            java.lang.String s3OutputPath;

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getNotificationConfig}
             * @param notificationConfig Specifies the configuration for notifications of inference results for asynchronous inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationConfig(software.amazon.awscdk.IResolvable notificationConfig) {
                this.notificationConfig = notificationConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getNotificationConfig}
             * @param notificationConfig Specifies the configuration for notifications of inference results for asynchronous inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notificationConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceNotificationConfigProperty notificationConfig) {
                this.notificationConfig = notificationConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getS3FailurePath}
             * @param s3FailurePath The Amazon S3 location to upload failure inference responses to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3FailurePath(java.lang.String s3FailurePath) {
                this.s3FailurePath = s3FailurePath;
                return this;
            }

            /**
             * Sets the value of {@link AsyncInferenceOutputConfigProperty#getS3OutputPath}
             * @param s3OutputPath The Amazon S3 location to upload inference responses to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputPath(java.lang.String s3OutputPath) {
                this.s3OutputPath = s3OutputPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsyncInferenceOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsyncInferenceOutputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsyncInferenceOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsyncInferenceOutputConfigProperty {
            private final java.lang.String kmsKeyId;
            private final java.lang.Object notificationConfig;
            private final java.lang.String s3FailurePath;
            private final java.lang.String s3OutputPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notificationConfig = software.amazon.jsii.Kernel.get(this, "notificationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3FailurePath = software.amazon.jsii.Kernel.get(this, "s3FailurePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3OutputPath = software.amazon.jsii.Kernel.get(this, "s3OutputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
                this.notificationConfig = builder.notificationConfig;
                this.s3FailurePath = builder.s3FailurePath;
                this.s3OutputPath = builder.s3OutputPath;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.Object getNotificationConfig() {
                return this.notificationConfig;
            }

            @Override
            public final java.lang.String getS3FailurePath() {
                return this.s3FailurePath;
            }

            @Override
            public final java.lang.String getS3OutputPath() {
                return this.s3OutputPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getNotificationConfig() != null) {
                    data.set("notificationConfig", om.valueToTree(this.getNotificationConfig()));
                }
                if (this.getS3FailurePath() != null) {
                    data.set("s3FailurePath", om.valueToTree(this.getS3FailurePath()));
                }
                if (this.getS3OutputPath() != null) {
                    data.set("s3OutputPath", om.valueToTree(this.getS3OutputPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.AsyncInferenceOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsyncInferenceOutputConfigProperty.Jsii$Proxy that = (AsyncInferenceOutputConfigProperty.Jsii$Proxy) o;

                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.notificationConfig != null ? !this.notificationConfig.equals(that.notificationConfig) : that.notificationConfig != null) return false;
                if (this.s3FailurePath != null ? !this.s3FailurePath.equals(that.s3FailurePath) : that.s3FailurePath != null) return false;
                return this.s3OutputPath != null ? this.s3OutputPath.equals(that.s3OutputPath) : that.s3OutputPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                result = 31 * result + (this.notificationConfig != null ? this.notificationConfig.hashCode() : 0);
                result = 31 * result + (this.s3FailurePath != null ? this.s3FailurePath.hashCode() : 0);
                result = 31 * result + (this.s3OutputPath != null ? this.s3OutputPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CapacityReservationConfigProperty capacityReservationConfigProperty = CapacityReservationConfigProperty.builder()
     *         .capacityReservationPreference("capacityReservationPreference")
     *         .mlReservationArn("mlReservationArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capacityreservationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capacityreservationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CapacityReservationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityReservationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityReservationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capacityreservationconfig.html#cfn-sagemaker-endpointconfig-capacityreservationconfig-capacityreservationpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capacityreservationconfig.html#cfn-sagemaker-endpointconfig-capacityreservationconfig-capacityreservationpreference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationPreference() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capacityreservationconfig.html#cfn-sagemaker-endpointconfig-capacityreservationconfig-mlreservationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capacityreservationconfig.html#cfn-sagemaker-endpointconfig-capacityreservationconfig-mlreservationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMlReservationArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityReservationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityReservationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityReservationConfigProperty> {
            java.lang.String capacityReservationPreference;
            java.lang.String mlReservationArn;

            /**
             * Sets the value of {@link CapacityReservationConfigProperty#getCapacityReservationPreference}
             * @param capacityReservationPreference the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationPreference(java.lang.String capacityReservationPreference) {
                this.capacityReservationPreference = capacityReservationPreference;
                return this;
            }

            /**
             * Sets the value of {@link CapacityReservationConfigProperty#getMlReservationArn}
             * @param mlReservationArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mlReservationArn(java.lang.String mlReservationArn) {
                this.mlReservationArn = mlReservationArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityReservationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityReservationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityReservationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityReservationConfigProperty {
            private final java.lang.String capacityReservationPreference;
            private final java.lang.String mlReservationArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityReservationPreference = software.amazon.jsii.Kernel.get(this, "capacityReservationPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mlReservationArn = software.amazon.jsii.Kernel.get(this, "mlReservationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityReservationPreference = builder.capacityReservationPreference;
                this.mlReservationArn = builder.mlReservationArn;
            }

            @Override
            public final java.lang.String getCapacityReservationPreference() {
                return this.capacityReservationPreference;
            }

            @Override
            public final java.lang.String getMlReservationArn() {
                return this.mlReservationArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityReservationPreference() != null) {
                    data.set("capacityReservationPreference", om.valueToTree(this.getCapacityReservationPreference()));
                }
                if (this.getMlReservationArn() != null) {
                    data.set("mlReservationArn", om.valueToTree(this.getMlReservationArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CapacityReservationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityReservationConfigProperty.Jsii$Proxy that = (CapacityReservationConfigProperty.Jsii$Proxy) o;

                if (this.capacityReservationPreference != null ? !this.capacityReservationPreference.equals(that.capacityReservationPreference) : that.capacityReservationPreference != null) return false;
                return this.mlReservationArn != null ? this.mlReservationArn.equals(that.mlReservationArn) : that.mlReservationArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityReservationPreference != null ? this.capacityReservationPreference.hashCode() : 0;
                result = 31 * result + (this.mlReservationArn != null ? this.mlReservationArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the JSON and CSV content types of the data that the endpoint captures.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CaptureContentTypeHeaderProperty captureContentTypeHeaderProperty = CaptureContentTypeHeaderProperty.builder()
     *         .csvContentTypes(List.of("csvContentTypes"))
     *         .jsonContentTypes(List.of("jsonContentTypes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptureContentTypeHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptureContentTypeHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of the CSV content types of the data that the endpoint captures.
         * <p>
         * For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-capturecontenttypeheader-csvcontenttypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-capturecontenttypeheader-csvcontenttypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCsvContentTypes() {
            return null;
        }

        /**
         * A list of the JSON content types of the data that the endpoint captures.
         * <p>
         * For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-capturecontenttypeheader-jsoncontenttypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-capturecontenttypeheader.html#cfn-sagemaker-endpointconfig-capturecontenttypeheader-jsoncontenttypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getJsonContentTypes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptureContentTypeHeaderProperty> {
            java.util.List<java.lang.String> csvContentTypes;
            java.util.List<java.lang.String> jsonContentTypes;

            /**
             * Sets the value of {@link CaptureContentTypeHeaderProperty#getCsvContentTypes}
             * @param csvContentTypes A list of the CSV content types of the data that the endpoint captures.
             *                        For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csvContentTypes(java.util.List<java.lang.String> csvContentTypes) {
                this.csvContentTypes = csvContentTypes;
                return this;
            }

            /**
             * Sets the value of {@link CaptureContentTypeHeaderProperty#getJsonContentTypes}
             * @param jsonContentTypes A list of the JSON content types of the data that the endpoint captures.
             *                         For the endpoint to capture the data, you must also specify the content type when you invoke the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonContentTypes(java.util.List<java.lang.String> jsonContentTypes) {
                this.jsonContentTypes = jsonContentTypes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptureContentTypeHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptureContentTypeHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptureContentTypeHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptureContentTypeHeaderProperty {
            private final java.util.List<java.lang.String> csvContentTypes;
            private final java.util.List<java.lang.String> jsonContentTypes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csvContentTypes = software.amazon.jsii.Kernel.get(this, "csvContentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.jsonContentTypes = software.amazon.jsii.Kernel.get(this, "jsonContentTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csvContentTypes = builder.csvContentTypes;
                this.jsonContentTypes = builder.jsonContentTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getCsvContentTypes() {
                return this.csvContentTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getJsonContentTypes() {
                return this.jsonContentTypes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsvContentTypes() != null) {
                    data.set("csvContentTypes", om.valueToTree(this.getCsvContentTypes()));
                }
                if (this.getJsonContentTypes() != null) {
                    data.set("jsonContentTypes", om.valueToTree(this.getJsonContentTypes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptureContentTypeHeaderProperty.Jsii$Proxy that = (CaptureContentTypeHeaderProperty.Jsii$Proxy) o;

                if (this.csvContentTypes != null ? !this.csvContentTypes.equals(that.csvContentTypes) : that.csvContentTypes != null) return false;
                return this.jsonContentTypes != null ? this.jsonContentTypes.equals(that.jsonContentTypes) : that.jsonContentTypes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csvContentTypes != null ? this.csvContentTypes.hashCode() : 0;
                result = 31 * result + (this.jsonContentTypes != null ? this.jsonContentTypes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies whether the endpoint captures input data or output data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CaptureOptionProperty captureOptionProperty = CaptureOptionProperty.builder()
     *         .captureMode("captureMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CaptureOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptureOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptureOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the endpoint captures input data or output data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-captureoption.html#cfn-sagemaker-endpointconfig-captureoption-capturemode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCaptureMode();

        /**
         * @return a {@link Builder} of {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptureOptionProperty> {
            java.lang.String captureMode;

            /**
             * Sets the value of {@link CaptureOptionProperty#getCaptureMode}
             * @param captureMode Specifies whether the endpoint captures input data or output data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureMode(java.lang.String captureMode) {
                this.captureMode = captureMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptureOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptureOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptureOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptureOptionProperty {
            private final java.lang.String captureMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureMode = software.amazon.jsii.Kernel.get(this, "captureMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureMode = java.util.Objects.requireNonNull(builder.captureMode, "captureMode is required");
            }

            @Override
            public final java.lang.String getCaptureMode() {
                return this.captureMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("captureMode", om.valueToTree(this.getCaptureMode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.CaptureOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptureOptionProperty.Jsii$Proxy that = (CaptureOptionProperty.Jsii$Proxy) o;

                return this.captureMode.equals(that.captureMode);
            }

            @Override
            public final int hashCode() {
                int result = this.captureMode.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration parameters for the SageMaker Clarify explainer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClarifyExplainerConfigProperty clarifyExplainerConfigProperty = ClarifyExplainerConfigProperty.builder()
     *         .shapConfig(ClarifyShapConfigProperty.builder()
     *                 .shapBaselineConfig(ClarifyShapBaselineConfigProperty.builder()
     *                         .mimeType("mimeType")
     *                         .shapBaseline("shapBaseline")
     *                         .shapBaselineUri("shapBaselineUri")
     *                         .build())
     *                 // the properties below are optional
     *                 .numberOfSamples(123)
     *                 .seed(123)
     *                 .textConfig(ClarifyTextConfigProperty.builder()
     *                         .granularity("granularity")
     *                         .language("language")
     *                         .build())
     *                 .useLogit(false)
     *                 .build())
     *         // the properties below are optional
     *         .enableExplanations("enableExplanations")
     *         .inferenceConfig(ClarifyInferenceConfigProperty.builder()
     *                 .contentTemplate("contentTemplate")
     *                 .featureHeaders(List.of("featureHeaders"))
     *                 .featuresAttribute("featuresAttribute")
     *                 .featureTypes(List.of("featureTypes"))
     *                 .labelAttribute("labelAttribute")
     *                 .labelHeaders(List.of("labelHeaders"))
     *                 .labelIndex(123)
     *                 .maxPayloadInMb(123)
     *                 .maxRecordCount(123)
     *                 .probabilityAttribute("probabilityAttribute")
     *                 .probabilityIndex(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClarifyExplainerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClarifyExplainerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for SHAP analysis.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-shapconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-shapconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getShapConfig();

        /**
         * A JMESPath boolean expression used to filter which records to explain.
         * <p>
         * Explanations are activated by default. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable"><code>EnableExplanations</code></a> for additional information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-enableexplanations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-enableexplanations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnableExplanations() {
            return null;
        }

        /**
         * The inference configuration parameter for the model container.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-inferenceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyexplainerconfig.html#cfn-sagemaker-endpointconfig-clarifyexplainerconfig-inferenceconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClarifyExplainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClarifyExplainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClarifyExplainerConfigProperty> {
            java.lang.Object shapConfig;
            java.lang.String enableExplanations;
            java.lang.Object inferenceConfig;

            /**
             * Sets the value of {@link ClarifyExplainerConfigProperty#getShapConfig}
             * @param shapConfig The configuration for SHAP analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shapConfig(software.amazon.awscdk.IResolvable shapConfig) {
                this.shapConfig = shapConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyExplainerConfigProperty#getShapConfig}
             * @param shapConfig The configuration for SHAP analysis. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shapConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty shapConfig) {
                this.shapConfig = shapConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyExplainerConfigProperty#getEnableExplanations}
             * @param enableExplanations A JMESPath boolean expression used to filter which records to explain.
             *                           Explanations are activated by default. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable"><code>EnableExplanations</code></a> for additional information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableExplanations(java.lang.String enableExplanations) {
                this.enableExplanations = enableExplanations;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyExplainerConfigProperty#getInferenceConfig}
             * @param inferenceConfig The inference configuration parameter for the model container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfig(software.amazon.awscdk.IResolvable inferenceConfig) {
                this.inferenceConfig = inferenceConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyExplainerConfigProperty#getInferenceConfig}
             * @param inferenceConfig The inference configuration parameter for the model container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty inferenceConfig) {
                this.inferenceConfig = inferenceConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClarifyExplainerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClarifyExplainerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClarifyExplainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClarifyExplainerConfigProperty {
            private final java.lang.Object shapConfig;
            private final java.lang.String enableExplanations;
            private final java.lang.Object inferenceConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.shapConfig = software.amazon.jsii.Kernel.get(this, "shapConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableExplanations = software.amazon.jsii.Kernel.get(this, "enableExplanations", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceConfig = software.amazon.jsii.Kernel.get(this, "inferenceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.shapConfig = java.util.Objects.requireNonNull(builder.shapConfig, "shapConfig is required");
                this.enableExplanations = builder.enableExplanations;
                this.inferenceConfig = builder.inferenceConfig;
            }

            @Override
            public final java.lang.Object getShapConfig() {
                return this.shapConfig;
            }

            @Override
            public final java.lang.String getEnableExplanations() {
                return this.enableExplanations;
            }

            @Override
            public final java.lang.Object getInferenceConfig() {
                return this.inferenceConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("shapConfig", om.valueToTree(this.getShapConfig()));
                if (this.getEnableExplanations() != null) {
                    data.set("enableExplanations", om.valueToTree(this.getEnableExplanations()));
                }
                if (this.getInferenceConfig() != null) {
                    data.set("inferenceConfig", om.valueToTree(this.getInferenceConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClarifyExplainerConfigProperty.Jsii$Proxy that = (ClarifyExplainerConfigProperty.Jsii$Proxy) o;

                if (!shapConfig.equals(that.shapConfig)) return false;
                if (this.enableExplanations != null ? !this.enableExplanations.equals(that.enableExplanations) : that.enableExplanations != null) return false;
                return this.inferenceConfig != null ? this.inferenceConfig.equals(that.inferenceConfig) : that.inferenceConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.shapConfig.hashCode();
                result = 31 * result + (this.enableExplanations != null ? this.enableExplanations.hashCode() : 0);
                result = 31 * result + (this.inferenceConfig != null ? this.inferenceConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The inference configuration parameter for the model container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClarifyInferenceConfigProperty clarifyInferenceConfigProperty = ClarifyInferenceConfigProperty.builder()
     *         .contentTemplate("contentTemplate")
     *         .featureHeaders(List.of("featureHeaders"))
     *         .featuresAttribute("featuresAttribute")
     *         .featureTypes(List.of("featureTypes"))
     *         .labelAttribute("labelAttribute")
     *         .labelHeaders(List.of("labelHeaders"))
     *         .labelIndex(123)
     *         .maxPayloadInMb(123)
     *         .maxRecordCount(123)
     *         .probabilityAttribute("probabilityAttribute")
     *         .probabilityIndex(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClarifyInferenceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClarifyInferenceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A template string used to format a JSON record into an acceptable model container input.
         * <p>
         * For example, a <code>ContentTemplate</code> string <code>'{"myfeatures":$features}'</code> will format a list of features <code>[1,2,3]</code> into the record string <code>'{"myfeatures":[1,2,3]}'</code> . Required only when the model container input is in JSON Lines format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-contenttemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-contenttemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentTemplate() {
            return null;
        }

        /**
         * The names of the features.
         * <p>
         * If provided, these are included in the endpoint response payload to help readability of the <code>InvokeEndpoint</code> output. See the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">Response</a> section under <em>Invoke the endpoint</em> in the Developer Guide for more information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featureheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featureheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFeatureHeaders() {
            return null;
        }

        /**
         * Provides the JMESPath expression to extract the features from a model container input in JSON Lines format.
         * <p>
         * For example, if <code>FeaturesAttribute</code> is the JMESPath expression <code>'myfeatures'</code> , it extracts a list of features <code>[1,2,3]</code> from request data <code>'{"myfeatures":[1,2,3]}'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuresattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuresattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFeaturesAttribute() {
            return null;
        }

        /**
         * A list of data types of the features (optional).
         * <p>
         * Applicable only to NLP explainability. If provided, <code>FeatureTypes</code> must have at least one <code>'text'</code> string (for example, <code>['text']</code> ). If <code>FeatureTypes</code> is not provided, the explainer infers the feature types based on the baseline data. The feature types are included in the endpoint response payload. For additional information see the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">response</a> section under <em>Invoke the endpoint</em> in the Developer Guide for more information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuretypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-featuretypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFeatureTypes() {
            return null;
        }

        /**
         * A JMESPath expression used to locate the list of label headers in the model container output.
         * <p>
         * <em>Example</em> : If the model container output of a batch request is <code>'{"labels":["cat","dog","fish"],"probability":[0.6,0.3,0.1]}'</code> , then set <code>LabelAttribute</code> to <code>'labels'</code> to extract the list of label headers <code>["cat","dog","fish"]</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabelAttribute() {
            return null;
        }

        /**
         * For multiclass classification problems, the label headers are the names of the classes.
         * <p>
         * Otherwise, the label header is the name of the predicted label. These are used to help readability for the output of the <code>InvokeEndpoint</code> API. See the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">response</a> section under <em>Invoke the endpoint</em> in the Developer Guide for more information. If there are no label headers in the model container output, provide them manually using this parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLabelHeaders() {
            return null;
        }

        /**
         * A zero-based index used to extract a label header or list of label headers from model container output in CSV format.
         * <p>
         * <em>Example for a multiclass model:</em> If the model container output consists of label headers followed by probabilities: <code>'"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"'</code> , set <code>LabelIndex</code> to <code>0</code> to select the label headers <code>['cat','dog','fish']</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelindex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-labelindex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLabelIndex() {
            return null;
        }

        /**
         * The maximum payload size (MB) allowed of a request from the explainer to the model container.
         * <p>
         * Defaults to <code>6</code> MB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxpayloadinmb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxpayloadinmb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPayloadInMb() {
            return null;
        }

        /**
         * The maximum number of records in a request that the model container can process when querying the model container for the predictions of a <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-synthetic">synthetic dataset</a> . A record is a unit of input data that inference can be made on, for example, a single line in CSV data. If <code>MaxRecordCount</code> is <code>1</code> , the model container expects one record per request. A value of 2 or greater means that the model expects batch requests, which can reduce overhead and speed up the inferencing process. If this parameter is not provided, the explainer will tune the record count per request according to the model container's capacity at runtime.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxrecordcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-maxrecordcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRecordCount() {
            return null;
        }

        /**
         * A JMESPath expression used to extract the probability (or score) from the model container output if the model container is in JSON Lines format.
         * <p>
         * <em>Example</em> : If the model container output of a single request is <code>'{"predicted_label":1,"probability":0.6}'</code> , then set <code>ProbabilityAttribute</code> to <code>'probability'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProbabilityAttribute() {
            return null;
        }

        /**
         * A zero-based index used to extract a probability value (score) or list from model container output in CSV format.
         * <p>
         * If this value is not provided, the entire model container output will be treated as a probability value (score) or list.
         * <p>
         * <em>Example for a single class model:</em> If the model container output consists of a string-formatted prediction label followed by its probability: <code>'1,0.6'</code> , set <code>ProbabilityIndex</code> to <code>1</code> to select the probability value <code>0.6</code> .
         * <p>
         * <em>Example for a multiclass model:</em> If the model container output consists of a string-formatted prediction label followed by its probability: <code>'"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"'</code> , set <code>ProbabilityIndex</code> to <code>1</code> to select the probability values <code>[0.1,0.6,0.3]</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityindex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyinferenceconfig.html#cfn-sagemaker-endpointconfig-clarifyinferenceconfig-probabilityindex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProbabilityIndex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClarifyInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClarifyInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClarifyInferenceConfigProperty> {
            java.lang.String contentTemplate;
            java.util.List<java.lang.String> featureHeaders;
            java.lang.String featuresAttribute;
            java.util.List<java.lang.String> featureTypes;
            java.lang.String labelAttribute;
            java.util.List<java.lang.String> labelHeaders;
            java.lang.Number labelIndex;
            java.lang.Number maxPayloadInMb;
            java.lang.Number maxRecordCount;
            java.lang.String probabilityAttribute;
            java.lang.Number probabilityIndex;

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getContentTemplate}
             * @param contentTemplate A template string used to format a JSON record into an acceptable model container input.
             *                        For example, a <code>ContentTemplate</code> string <code>'{"myfeatures":$features}'</code> will format a list of features <code>[1,2,3]</code> into the record string <code>'{"myfeatures":[1,2,3]}'</code> . Required only when the model container input is in JSON Lines format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentTemplate(java.lang.String contentTemplate) {
                this.contentTemplate = contentTemplate;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getFeatureHeaders}
             * @param featureHeaders The names of the features.
             *                       If provided, these are included in the endpoint response payload to help readability of the <code>InvokeEndpoint</code> output. See the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">Response</a> section under <em>Invoke the endpoint</em> in the Developer Guide for more information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureHeaders(java.util.List<java.lang.String> featureHeaders) {
                this.featureHeaders = featureHeaders;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getFeaturesAttribute}
             * @param featuresAttribute Provides the JMESPath expression to extract the features from a model container input in JSON Lines format.
             *                          For example, if <code>FeaturesAttribute</code> is the JMESPath expression <code>'myfeatures'</code> , it extracts a list of features <code>[1,2,3]</code> from request data <code>'{"myfeatures":[1,2,3]}'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featuresAttribute(java.lang.String featuresAttribute) {
                this.featuresAttribute = featuresAttribute;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getFeatureTypes}
             * @param featureTypes A list of data types of the features (optional).
             *                     Applicable only to NLP explainability. If provided, <code>FeatureTypes</code> must have at least one <code>'text'</code> string (for example, <code>['text']</code> ). If <code>FeatureTypes</code> is not provided, the explainer infers the feature types based on the baseline data. The feature types are included in the endpoint response payload. For additional information see the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">response</a> section under <em>Invoke the endpoint</em> in the Developer Guide for more information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureTypes(java.util.List<java.lang.String> featureTypes) {
                this.featureTypes = featureTypes;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getLabelAttribute}
             * @param labelAttribute A JMESPath expression used to locate the list of label headers in the model container output.
             *                       <em>Example</em> : If the model container output of a batch request is <code>'{"labels":["cat","dog","fish"],"probability":[0.6,0.3,0.1]}'</code> , then set <code>LabelAttribute</code> to <code>'labels'</code> to extract the list of label headers <code>["cat","dog","fish"]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelAttribute(java.lang.String labelAttribute) {
                this.labelAttribute = labelAttribute;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getLabelHeaders}
             * @param labelHeaders For multiclass classification problems, the label headers are the names of the classes.
             *                     Otherwise, the label header is the name of the predicted label. These are used to help readability for the output of the <code>InvokeEndpoint</code> API. See the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response">response</a> section under <em>Invoke the endpoint</em> in the Developer Guide for more information. If there are no label headers in the model container output, provide them manually using this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelHeaders(java.util.List<java.lang.String> labelHeaders) {
                this.labelHeaders = labelHeaders;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getLabelIndex}
             * @param labelIndex A zero-based index used to extract a label header or list of label headers from model container output in CSV format.
             *                   <em>Example for a multiclass model:</em> If the model container output consists of label headers followed by probabilities: <code>'"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"'</code> , set <code>LabelIndex</code> to <code>0</code> to select the label headers <code>['cat','dog','fish']</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelIndex(java.lang.Number labelIndex) {
                this.labelIndex = labelIndex;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getMaxPayloadInMb}
             * @param maxPayloadInMb The maximum payload size (MB) allowed of a request from the explainer to the model container.
             *                       Defaults to <code>6</code> MB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPayloadInMb(java.lang.Number maxPayloadInMb) {
                this.maxPayloadInMb = maxPayloadInMb;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getMaxRecordCount}
             * @param maxRecordCount The maximum number of records in a request that the model container can process when querying the model container for the predictions of a <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-synthetic">synthetic dataset</a> . A record is a unit of input data that inference can be made on, for example, a single line in CSV data. If <code>MaxRecordCount</code> is <code>1</code> , the model container expects one record per request. A value of 2 or greater means that the model expects batch requests, which can reduce overhead and speed up the inferencing process. If this parameter is not provided, the explainer will tune the record count per request according to the model container's capacity at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRecordCount(java.lang.Number maxRecordCount) {
                this.maxRecordCount = maxRecordCount;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getProbabilityAttribute}
             * @param probabilityAttribute A JMESPath expression used to extract the probability (or score) from the model container output if the model container is in JSON Lines format.
             *                             <em>Example</em> : If the model container output of a single request is <code>'{"predicted_label":1,"probability":0.6}'</code> , then set <code>ProbabilityAttribute</code> to <code>'probability'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probabilityAttribute(java.lang.String probabilityAttribute) {
                this.probabilityAttribute = probabilityAttribute;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyInferenceConfigProperty#getProbabilityIndex}
             * @param probabilityIndex A zero-based index used to extract a probability value (score) or list from model container output in CSV format.
             *                         If this value is not provided, the entire model container output will be treated as a probability value (score) or list.
             *                         <p>
             *                         <em>Example for a single class model:</em> If the model container output consists of a string-formatted prediction label followed by its probability: <code>'1,0.6'</code> , set <code>ProbabilityIndex</code> to <code>1</code> to select the probability value <code>0.6</code> .
             *                         <p>
             *                         <em>Example for a multiclass model:</em> If the model container output consists of a string-formatted prediction label followed by its probability: <code>'"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"'</code> , set <code>ProbabilityIndex</code> to <code>1</code> to select the probability values <code>[0.1,0.6,0.3]</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder probabilityIndex(java.lang.Number probabilityIndex) {
                this.probabilityIndex = probabilityIndex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClarifyInferenceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClarifyInferenceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClarifyInferenceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClarifyInferenceConfigProperty {
            private final java.lang.String contentTemplate;
            private final java.util.List<java.lang.String> featureHeaders;
            private final java.lang.String featuresAttribute;
            private final java.util.List<java.lang.String> featureTypes;
            private final java.lang.String labelAttribute;
            private final java.util.List<java.lang.String> labelHeaders;
            private final java.lang.Number labelIndex;
            private final java.lang.Number maxPayloadInMb;
            private final java.lang.Number maxRecordCount;
            private final java.lang.String probabilityAttribute;
            private final java.lang.Number probabilityIndex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contentTemplate = software.amazon.jsii.Kernel.get(this, "contentTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureHeaders = software.amazon.jsii.Kernel.get(this, "featureHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.featuresAttribute = software.amazon.jsii.Kernel.get(this, "featuresAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureTypes = software.amazon.jsii.Kernel.get(this, "featureTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.labelAttribute = software.amazon.jsii.Kernel.get(this, "labelAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.labelHeaders = software.amazon.jsii.Kernel.get(this, "labelHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.labelIndex = software.amazon.jsii.Kernel.get(this, "labelIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxPayloadInMb = software.amazon.jsii.Kernel.get(this, "maxPayloadInMb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxRecordCount = software.amazon.jsii.Kernel.get(this, "maxRecordCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.probabilityAttribute = software.amazon.jsii.Kernel.get(this, "probabilityAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.probabilityIndex = software.amazon.jsii.Kernel.get(this, "probabilityIndex", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contentTemplate = builder.contentTemplate;
                this.featureHeaders = builder.featureHeaders;
                this.featuresAttribute = builder.featuresAttribute;
                this.featureTypes = builder.featureTypes;
                this.labelAttribute = builder.labelAttribute;
                this.labelHeaders = builder.labelHeaders;
                this.labelIndex = builder.labelIndex;
                this.maxPayloadInMb = builder.maxPayloadInMb;
                this.maxRecordCount = builder.maxRecordCount;
                this.probabilityAttribute = builder.probabilityAttribute;
                this.probabilityIndex = builder.probabilityIndex;
            }

            @Override
            public final java.lang.String getContentTemplate() {
                return this.contentTemplate;
            }

            @Override
            public final java.util.List<java.lang.String> getFeatureHeaders() {
                return this.featureHeaders;
            }

            @Override
            public final java.lang.String getFeaturesAttribute() {
                return this.featuresAttribute;
            }

            @Override
            public final java.util.List<java.lang.String> getFeatureTypes() {
                return this.featureTypes;
            }

            @Override
            public final java.lang.String getLabelAttribute() {
                return this.labelAttribute;
            }

            @Override
            public final java.util.List<java.lang.String> getLabelHeaders() {
                return this.labelHeaders;
            }

            @Override
            public final java.lang.Number getLabelIndex() {
                return this.labelIndex;
            }

            @Override
            public final java.lang.Number getMaxPayloadInMb() {
                return this.maxPayloadInMb;
            }

            @Override
            public final java.lang.Number getMaxRecordCount() {
                return this.maxRecordCount;
            }

            @Override
            public final java.lang.String getProbabilityAttribute() {
                return this.probabilityAttribute;
            }

            @Override
            public final java.lang.Number getProbabilityIndex() {
                return this.probabilityIndex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContentTemplate() != null) {
                    data.set("contentTemplate", om.valueToTree(this.getContentTemplate()));
                }
                if (this.getFeatureHeaders() != null) {
                    data.set("featureHeaders", om.valueToTree(this.getFeatureHeaders()));
                }
                if (this.getFeaturesAttribute() != null) {
                    data.set("featuresAttribute", om.valueToTree(this.getFeaturesAttribute()));
                }
                if (this.getFeatureTypes() != null) {
                    data.set("featureTypes", om.valueToTree(this.getFeatureTypes()));
                }
                if (this.getLabelAttribute() != null) {
                    data.set("labelAttribute", om.valueToTree(this.getLabelAttribute()));
                }
                if (this.getLabelHeaders() != null) {
                    data.set("labelHeaders", om.valueToTree(this.getLabelHeaders()));
                }
                if (this.getLabelIndex() != null) {
                    data.set("labelIndex", om.valueToTree(this.getLabelIndex()));
                }
                if (this.getMaxPayloadInMb() != null) {
                    data.set("maxPayloadInMb", om.valueToTree(this.getMaxPayloadInMb()));
                }
                if (this.getMaxRecordCount() != null) {
                    data.set("maxRecordCount", om.valueToTree(this.getMaxRecordCount()));
                }
                if (this.getProbabilityAttribute() != null) {
                    data.set("probabilityAttribute", om.valueToTree(this.getProbabilityAttribute()));
                }
                if (this.getProbabilityIndex() != null) {
                    data.set("probabilityIndex", om.valueToTree(this.getProbabilityIndex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyInferenceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClarifyInferenceConfigProperty.Jsii$Proxy that = (ClarifyInferenceConfigProperty.Jsii$Proxy) o;

                if (this.contentTemplate != null ? !this.contentTemplate.equals(that.contentTemplate) : that.contentTemplate != null) return false;
                if (this.featureHeaders != null ? !this.featureHeaders.equals(that.featureHeaders) : that.featureHeaders != null) return false;
                if (this.featuresAttribute != null ? !this.featuresAttribute.equals(that.featuresAttribute) : that.featuresAttribute != null) return false;
                if (this.featureTypes != null ? !this.featureTypes.equals(that.featureTypes) : that.featureTypes != null) return false;
                if (this.labelAttribute != null ? !this.labelAttribute.equals(that.labelAttribute) : that.labelAttribute != null) return false;
                if (this.labelHeaders != null ? !this.labelHeaders.equals(that.labelHeaders) : that.labelHeaders != null) return false;
                if (this.labelIndex != null ? !this.labelIndex.equals(that.labelIndex) : that.labelIndex != null) return false;
                if (this.maxPayloadInMb != null ? !this.maxPayloadInMb.equals(that.maxPayloadInMb) : that.maxPayloadInMb != null) return false;
                if (this.maxRecordCount != null ? !this.maxRecordCount.equals(that.maxRecordCount) : that.maxRecordCount != null) return false;
                if (this.probabilityAttribute != null ? !this.probabilityAttribute.equals(that.probabilityAttribute) : that.probabilityAttribute != null) return false;
                return this.probabilityIndex != null ? this.probabilityIndex.equals(that.probabilityIndex) : that.probabilityIndex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.contentTemplate != null ? this.contentTemplate.hashCode() : 0;
                result = 31 * result + (this.featureHeaders != null ? this.featureHeaders.hashCode() : 0);
                result = 31 * result + (this.featuresAttribute != null ? this.featuresAttribute.hashCode() : 0);
                result = 31 * result + (this.featureTypes != null ? this.featureTypes.hashCode() : 0);
                result = 31 * result + (this.labelAttribute != null ? this.labelAttribute.hashCode() : 0);
                result = 31 * result + (this.labelHeaders != null ? this.labelHeaders.hashCode() : 0);
                result = 31 * result + (this.labelIndex != null ? this.labelIndex.hashCode() : 0);
                result = 31 * result + (this.maxPayloadInMb != null ? this.maxPayloadInMb.hashCode() : 0);
                result = 31 * result + (this.maxRecordCount != null ? this.maxRecordCount.hashCode() : 0);
                result = 31 * result + (this.probabilityAttribute != null ? this.probabilityAttribute.hashCode() : 0);
                result = 31 * result + (this.probabilityIndex != null ? this.probabilityIndex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-feature-attribute-shap-baselines.html">SHAP baseline</a> (also called the background or reference dataset) of the Kernal SHAP algorithm.
     * <p>
     * <blockquote>
     * <p>
     * <ul>
     * <li>The number of records in the baseline data determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the <em>Synthetic data</em> of <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html">Configure and create an endpoint</a> .</li>
     * <li><code>ShapBaseline</code> and <code>ShapBaselineUri</code> are mutually exclusive parameters. One or the either is required to configure a SHAP baseline.</li>
     * </ul>
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClarifyShapBaselineConfigProperty clarifyShapBaselineConfigProperty = ClarifyShapBaselineConfigProperty.builder()
     *         .mimeType("mimeType")
     *         .shapBaseline("shapBaseline")
     *         .shapBaselineUri("shapBaselineUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClarifyShapBaselineConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClarifyShapBaselineConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The MIME type of the baseline data.
         * <p>
         * Choose from <code>'text/csv'</code> or <code>'application/jsonlines'</code> . Defaults to <code>'text/csv'</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-mimetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-mimetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMimeType() {
            return null;
        }

        /**
         * The inline SHAP baseline data in string format.
         * <p>
         * <code>ShapBaseline</code> can have one or multiple records to be used as the baseline dataset. The format of the SHAP baseline file should be the same format as the training dataset. For example, if the training dataset is in CSV format and each record contains four features, and all features are numerical, then the format of the baseline data should also share these characteristics. For natural language processing (NLP) of text columns, the baseline value should be the value used to replace the unit of text specified by the <code>Granularity</code> of the <code>TextConfig</code> parameter. The size limit for <code>ShapBasline</code> is 4 KB. Use the <code>ShapBaselineUri</code> parameter if you want to provide more than 4 KB of baseline data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaseline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaseline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShapBaseline() {
            return null;
        }

        /**
         * The uniform resource identifier (URI) of the S3 bucket where the SHAP baseline file is stored.
         * <p>
         * The format of the SHAP baseline file should be the same format as the format of the training dataset. For example, if the training dataset is in CSV format, and each record in the training dataset has four features, and all features are numerical, then the baseline file should also have this same format. Each record should contain only the features. If you are using a virtual private cloud (VPC), the <code>ShapBaselineUri</code> should be accessible to the VPC. For more information about setting up endpoints with Amazon Virtual Private Cloud, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker access to Resources in your Amazon Virtual Private Cloud</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaselineuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapbaselineconfig.html#cfn-sagemaker-endpointconfig-clarifyshapbaselineconfig-shapbaselineuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShapBaselineUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClarifyShapBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClarifyShapBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClarifyShapBaselineConfigProperty> {
            java.lang.String mimeType;
            java.lang.String shapBaseline;
            java.lang.String shapBaselineUri;

            /**
             * Sets the value of {@link ClarifyShapBaselineConfigProperty#getMimeType}
             * @param mimeType The MIME type of the baseline data.
             *                 Choose from <code>'text/csv'</code> or <code>'application/jsonlines'</code> . Defaults to <code>'text/csv'</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mimeType(java.lang.String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapBaselineConfigProperty#getShapBaseline}
             * @param shapBaseline The inline SHAP baseline data in string format.
             *                     <code>ShapBaseline</code> can have one or multiple records to be used as the baseline dataset. The format of the SHAP baseline file should be the same format as the training dataset. For example, if the training dataset is in CSV format and each record contains four features, and all features are numerical, then the format of the baseline data should also share these characteristics. For natural language processing (NLP) of text columns, the baseline value should be the value used to replace the unit of text specified by the <code>Granularity</code> of the <code>TextConfig</code> parameter. The size limit for <code>ShapBasline</code> is 4 KB. Use the <code>ShapBaselineUri</code> parameter if you want to provide more than 4 KB of baseline data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shapBaseline(java.lang.String shapBaseline) {
                this.shapBaseline = shapBaseline;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapBaselineConfigProperty#getShapBaselineUri}
             * @param shapBaselineUri The uniform resource identifier (URI) of the S3 bucket where the SHAP baseline file is stored.
             *                        The format of the SHAP baseline file should be the same format as the format of the training dataset. For example, if the training dataset is in CSV format, and each record in the training dataset has four features, and all features are numerical, then the baseline file should also have this same format. Each record should contain only the features. If you are using a virtual private cloud (VPC), the <code>ShapBaselineUri</code> should be accessible to the VPC. For more information about setting up endpoints with Amazon Virtual Private Cloud, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker access to Resources in your Amazon Virtual Private Cloud</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shapBaselineUri(java.lang.String shapBaselineUri) {
                this.shapBaselineUri = shapBaselineUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClarifyShapBaselineConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClarifyShapBaselineConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClarifyShapBaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClarifyShapBaselineConfigProperty {
            private final java.lang.String mimeType;
            private final java.lang.String shapBaseline;
            private final java.lang.String shapBaselineUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mimeType = software.amazon.jsii.Kernel.get(this, "mimeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shapBaseline = software.amazon.jsii.Kernel.get(this, "shapBaseline", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shapBaselineUri = software.amazon.jsii.Kernel.get(this, "shapBaselineUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mimeType = builder.mimeType;
                this.shapBaseline = builder.shapBaseline;
                this.shapBaselineUri = builder.shapBaselineUri;
            }

            @Override
            public final java.lang.String getMimeType() {
                return this.mimeType;
            }

            @Override
            public final java.lang.String getShapBaseline() {
                return this.shapBaseline;
            }

            @Override
            public final java.lang.String getShapBaselineUri() {
                return this.shapBaselineUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMimeType() != null) {
                    data.set("mimeType", om.valueToTree(this.getMimeType()));
                }
                if (this.getShapBaseline() != null) {
                    data.set("shapBaseline", om.valueToTree(this.getShapBaseline()));
                }
                if (this.getShapBaselineUri() != null) {
                    data.set("shapBaselineUri", om.valueToTree(this.getShapBaselineUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClarifyShapBaselineConfigProperty.Jsii$Proxy that = (ClarifyShapBaselineConfigProperty.Jsii$Proxy) o;

                if (this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null) return false;
                if (this.shapBaseline != null ? !this.shapBaseline.equals(that.shapBaseline) : that.shapBaseline != null) return false;
                return this.shapBaselineUri != null ? this.shapBaselineUri.equals(that.shapBaselineUri) : that.shapBaselineUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mimeType != null ? this.mimeType.hashCode() : 0;
                result = 31 * result + (this.shapBaseline != null ? this.shapBaseline.hashCode() : 0);
                result = 31 * result + (this.shapBaselineUri != null ? this.shapBaselineUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for SHAP analysis using SageMaker Clarify Explainer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClarifyShapConfigProperty clarifyShapConfigProperty = ClarifyShapConfigProperty.builder()
     *         .shapBaselineConfig(ClarifyShapBaselineConfigProperty.builder()
     *                 .mimeType("mimeType")
     *                 .shapBaseline("shapBaseline")
     *                 .shapBaselineUri("shapBaselineUri")
     *                 .build())
     *         // the properties below are optional
     *         .numberOfSamples(123)
     *         .seed(123)
     *         .textConfig(ClarifyTextConfigProperty.builder()
     *                 .granularity("granularity")
     *                 .language("language")
     *                 .build())
     *         .useLogit(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClarifyShapConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClarifyShapConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for the SHAP baseline of the Kernal SHAP algorithm.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-shapbaselineconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-shapbaselineconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getShapBaselineConfig();

        /**
         * The number of samples to be used for analysis by the Kernal SHAP algorithm.
         * <p>
         * <blockquote>
         * <p>
         * The number of samples determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the <em>Synthetic data</em> of <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html">Configure and create an endpoint</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-numberofsamples">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-numberofsamples</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfSamples() {
            return null;
        }

        /**
         * The starting value used to initialize the random number generator in the explainer.
         * <p>
         * Provide a value for this parameter to obtain a deterministic SHAP result.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-seed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-seed</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSeed() {
            return null;
        }

        /**
         * A parameter that indicates if text features are treated as text and explanations are provided for individual units of text.
         * <p>
         * Required for natural language processing (NLP) explainability only.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-textconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-textconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTextConfig() {
            return null;
        }

        /**
         * A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model predictions.
         * <p>
         * Defaults to false.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-uselogit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifyshapconfig.html#cfn-sagemaker-endpointconfig-clarifyshapconfig-uselogit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseLogit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClarifyShapConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClarifyShapConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClarifyShapConfigProperty> {
            java.lang.Object shapBaselineConfig;
            java.lang.Number numberOfSamples;
            java.lang.Number seed;
            java.lang.Object textConfig;
            java.lang.Object useLogit;

            /**
             * Sets the value of {@link ClarifyShapConfigProperty#getShapBaselineConfig}
             * @param shapBaselineConfig The configuration for the SHAP baseline of the Kernal SHAP algorithm. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shapBaselineConfig(software.amazon.awscdk.IResolvable shapBaselineConfig) {
                this.shapBaselineConfig = shapBaselineConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapConfigProperty#getShapBaselineConfig}
             * @param shapBaselineConfig The configuration for the SHAP baseline of the Kernal SHAP algorithm. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shapBaselineConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyShapBaselineConfigProperty shapBaselineConfig) {
                this.shapBaselineConfig = shapBaselineConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapConfigProperty#getNumberOfSamples}
             * @param numberOfSamples The number of samples to be used for analysis by the Kernal SHAP algorithm.
             *                        <blockquote>
             *                        <p>
             *                        The number of samples determines the size of the synthetic dataset, which has an impact on latency of explainability requests. For more information, see the <em>Synthetic data</em> of <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html">Configure and create an endpoint</a> .
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfSamples(java.lang.Number numberOfSamples) {
                this.numberOfSamples = numberOfSamples;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapConfigProperty#getSeed}
             * @param seed The starting value used to initialize the random number generator in the explainer.
             *             Provide a value for this parameter to obtain a deterministic SHAP result.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder seed(java.lang.Number seed) {
                this.seed = seed;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapConfigProperty#getTextConfig}
             * @param textConfig A parameter that indicates if text features are treated as text and explanations are provided for individual units of text.
             *                   Required for natural language processing (NLP) explainability only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textConfig(software.amazon.awscdk.IResolvable textConfig) {
                this.textConfig = textConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapConfigProperty#getTextConfig}
             * @param textConfig A parameter that indicates if text features are treated as text and explanations are provided for individual units of text.
             *                   Required for natural language processing (NLP) explainability only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty textConfig) {
                this.textConfig = textConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapConfigProperty#getUseLogit}
             * @param useLogit A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model predictions.
             *                 Defaults to false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useLogit(java.lang.Boolean useLogit) {
                this.useLogit = useLogit;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyShapConfigProperty#getUseLogit}
             * @param useLogit A Boolean toggle to indicate if you want to use the logit function (true) or log-odds units (false) for model predictions.
             *                 Defaults to false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useLogit(software.amazon.awscdk.IResolvable useLogit) {
                this.useLogit = useLogit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClarifyShapConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClarifyShapConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClarifyShapConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClarifyShapConfigProperty {
            private final java.lang.Object shapBaselineConfig;
            private final java.lang.Number numberOfSamples;
            private final java.lang.Number seed;
            private final java.lang.Object textConfig;
            private final java.lang.Object useLogit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.shapBaselineConfig = software.amazon.jsii.Kernel.get(this, "shapBaselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numberOfSamples = software.amazon.jsii.Kernel.get(this, "numberOfSamples", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.seed = software.amazon.jsii.Kernel.get(this, "seed", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.textConfig = software.amazon.jsii.Kernel.get(this, "textConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useLogit = software.amazon.jsii.Kernel.get(this, "useLogit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.shapBaselineConfig = java.util.Objects.requireNonNull(builder.shapBaselineConfig, "shapBaselineConfig is required");
                this.numberOfSamples = builder.numberOfSamples;
                this.seed = builder.seed;
                this.textConfig = builder.textConfig;
                this.useLogit = builder.useLogit;
            }

            @Override
            public final java.lang.Object getShapBaselineConfig() {
                return this.shapBaselineConfig;
            }

            @Override
            public final java.lang.Number getNumberOfSamples() {
                return this.numberOfSamples;
            }

            @Override
            public final java.lang.Number getSeed() {
                return this.seed;
            }

            @Override
            public final java.lang.Object getTextConfig() {
                return this.textConfig;
            }

            @Override
            public final java.lang.Object getUseLogit() {
                return this.useLogit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("shapBaselineConfig", om.valueToTree(this.getShapBaselineConfig()));
                if (this.getNumberOfSamples() != null) {
                    data.set("numberOfSamples", om.valueToTree(this.getNumberOfSamples()));
                }
                if (this.getSeed() != null) {
                    data.set("seed", om.valueToTree(this.getSeed()));
                }
                if (this.getTextConfig() != null) {
                    data.set("textConfig", om.valueToTree(this.getTextConfig()));
                }
                if (this.getUseLogit() != null) {
                    data.set("useLogit", om.valueToTree(this.getUseLogit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyShapConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClarifyShapConfigProperty.Jsii$Proxy that = (ClarifyShapConfigProperty.Jsii$Proxy) o;

                if (!shapBaselineConfig.equals(that.shapBaselineConfig)) return false;
                if (this.numberOfSamples != null ? !this.numberOfSamples.equals(that.numberOfSamples) : that.numberOfSamples != null) return false;
                if (this.seed != null ? !this.seed.equals(that.seed) : that.seed != null) return false;
                if (this.textConfig != null ? !this.textConfig.equals(that.textConfig) : that.textConfig != null) return false;
                return this.useLogit != null ? this.useLogit.equals(that.useLogit) : that.useLogit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.shapBaselineConfig.hashCode();
                result = 31 * result + (this.numberOfSamples != null ? this.numberOfSamples.hashCode() : 0);
                result = 31 * result + (this.seed != null ? this.seed.hashCode() : 0);
                result = 31 * result + (this.textConfig != null ? this.textConfig.hashCode() : 0);
                result = 31 * result + (this.useLogit != null ? this.useLogit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A parameter used to configure the SageMaker Clarify explainer to treat text features as text so that explanations are provided for individual units of text.
     * <p>
     * Required only for natural language processing (NLP) explainability.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClarifyTextConfigProperty clarifyTextConfigProperty = ClarifyTextConfigProperty.builder()
     *         .granularity("granularity")
     *         .language("language")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClarifyTextConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClarifyTextConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unit of granularity for the analysis of text features.
         * <p>
         * For example, if the unit is <code>'token'</code> , then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each unit/feature.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-granularity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-granularity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGranularity();

        /**
         * Specifies the language of the text features in [ISO 639-1](https://docs.aws.amazon.com/ https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) or <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language.
         * <p>
         * <blockquote>
         * <p>
         * For a mix of multiple languages, use code <code>'xx'</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-language">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-clarifytextconfig.html#cfn-sagemaker-endpointconfig-clarifytextconfig-language</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLanguage();

        /**
         * @return a {@link Builder} of {@link ClarifyTextConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClarifyTextConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClarifyTextConfigProperty> {
            java.lang.String granularity;
            java.lang.String language;

            /**
             * Sets the value of {@link ClarifyTextConfigProperty#getGranularity}
             * @param granularity The unit of granularity for the analysis of text features. This parameter is required.
             *                    For example, if the unit is <code>'token'</code> , then each token (like a word in English) of the text is treated as a feature. SHAP values are computed for each unit/feature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder granularity(java.lang.String granularity) {
                this.granularity = granularity;
                return this;
            }

            /**
             * Sets the value of {@link ClarifyTextConfigProperty#getLanguage}
             * @param language Specifies the language of the text features in [ISO 639-1](https://docs.aws.amazon.com/ https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) or <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/ISO_639-3">ISO 639-3</a> code of a supported language. This parameter is required.
             *                 <blockquote>
             *                 <p>
             *                 For a mix of multiple languages, use code <code>'xx'</code> .
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder language(java.lang.String language) {
                this.language = language;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClarifyTextConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClarifyTextConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClarifyTextConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClarifyTextConfigProperty {
            private final java.lang.String granularity;
            private final java.lang.String language;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.granularity = software.amazon.jsii.Kernel.get(this, "granularity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.language = software.amazon.jsii.Kernel.get(this, "language", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.granularity = java.util.Objects.requireNonNull(builder.granularity, "granularity is required");
                this.language = java.util.Objects.requireNonNull(builder.language, "language is required");
            }

            @Override
            public final java.lang.String getGranularity() {
                return this.granularity;
            }

            @Override
            public final java.lang.String getLanguage() {
                return this.language;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("granularity", om.valueToTree(this.getGranularity()));
                data.set("language", om.valueToTree(this.getLanguage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ClarifyTextConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClarifyTextConfigProperty.Jsii$Proxy that = (ClarifyTextConfigProperty.Jsii$Proxy) o;

                if (!granularity.equals(that.granularity)) return false;
                return this.language.equals(that.language);
            }

            @Override
            public final int hashCode() {
                int result = this.granularity.hashCode();
                result = 31 * result + (this.language.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of your endpoint for model monitor data capture.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DataCaptureConfigProperty dataCaptureConfigProperty = DataCaptureConfigProperty.builder()
     *         .captureOptions(List.of(CaptureOptionProperty.builder()
     *                 .captureMode("captureMode")
     *                 .build()))
     *         .destinationS3Uri("destinationS3Uri")
     *         .initialSamplingPercentage(123)
     *         // the properties below are optional
     *         .captureContentTypeHeader(CaptureContentTypeHeaderProperty.builder()
     *                 .csvContentTypes(List.of("csvContentTypes"))
     *                 .jsonContentTypes(List.of("jsonContentTypes"))
     *                 .build())
     *         .enableCapture(false)
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.DataCaptureConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCaptureConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCaptureConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the endpoint captures input data to your model, output data from your model, or both.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CaptureOptionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-captureoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCaptureOptions();

        /**
         * The S3 bucket where model monitor stores captured data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-destinations3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationS3Uri();

        /**
         * The percentage of data to capture.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-initialsamplingpercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInitialSamplingPercentage();

        /**
         * A list of the JSON and CSV content type that the endpoint captures.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-capturecontenttypeheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaptureContentTypeHeader() {
            return null;
        }

        /**
         * Set to <code>True</code> to enable data capture.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-enablecapture</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableCapture() {
            return null;
        }

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption.
         * <p>
         * The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-datacaptureconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCaptureConfigProperty> {
            java.lang.Object captureOptions;
            java.lang.String destinationS3Uri;
            java.lang.Number initialSamplingPercentage;
            java.lang.Object captureContentTypeHeader;
            java.lang.Object enableCapture;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureOptions}
             * @param captureOptions Specifies whether the endpoint captures input data to your model, output data from your model, or both. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureOptions(software.amazon.awscdk.IResolvable captureOptions) {
                this.captureOptions = captureOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureOptions}
             * @param captureOptions Specifies whether the endpoint captures input data to your model, output data from your model, or both. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureOptions(java.util.List<? extends java.lang.Object> captureOptions) {
                this.captureOptions = captureOptions;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getDestinationS3Uri}
             * @param destinationS3Uri The S3 bucket where model monitor stores captured data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationS3Uri(java.lang.String destinationS3Uri) {
                this.destinationS3Uri = destinationS3Uri;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getInitialSamplingPercentage}
             * @param initialSamplingPercentage The percentage of data to capture. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialSamplingPercentage(java.lang.Number initialSamplingPercentage) {
                this.initialSamplingPercentage = initialSamplingPercentage;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureContentTypeHeader}
             * @param captureContentTypeHeader A list of the JSON and CSV content type that the endpoint captures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureContentTypeHeader(software.amazon.awscdk.IResolvable captureContentTypeHeader) {
                this.captureContentTypeHeader = captureContentTypeHeader;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getCaptureContentTypeHeader}
             * @param captureContentTypeHeader A list of the JSON and CSV content type that the endpoint captures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureContentTypeHeader(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CaptureContentTypeHeaderProperty captureContentTypeHeader) {
                this.captureContentTypeHeader = captureContentTypeHeader;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getEnableCapture}
             * @param enableCapture Set to <code>True</code> to enable data capture.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCapture(java.lang.Boolean enableCapture) {
                this.enableCapture = enableCapture;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getEnableCapture}
             * @param enableCapture Set to <code>True</code> to enable data capture.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableCapture(software.amazon.awscdk.IResolvable enableCapture) {
                this.enableCapture = enableCapture;
                return this;
            }

            /**
             * Sets the value of {@link DataCaptureConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the captured data at rest using Amazon S3 server-side encryption.
             *                 The KmsKeyId can be any of the following formats: Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab Alias name: alias/ExampleAlias Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account. For more information, see KMS-Managed Encryption Keys (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the Amazon Simple Storage Service Developer Guide. The KMS key policy must grant permission to the IAM role that you specify in your CreateModel (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html) request. For more information, see Using Key Policies in AWS KMS (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the AWS Key Management Service Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCaptureConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCaptureConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCaptureConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCaptureConfigProperty {
            private final java.lang.Object captureOptions;
            private final java.lang.String destinationS3Uri;
            private final java.lang.Number initialSamplingPercentage;
            private final java.lang.Object captureContentTypeHeader;
            private final java.lang.Object enableCapture;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureOptions = software.amazon.jsii.Kernel.get(this, "captureOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationS3Uri = software.amazon.jsii.Kernel.get(this, "destinationS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.initialSamplingPercentage = software.amazon.jsii.Kernel.get(this, "initialSamplingPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.captureContentTypeHeader = software.amazon.jsii.Kernel.get(this, "captureContentTypeHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableCapture = software.amazon.jsii.Kernel.get(this, "enableCapture", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureOptions = java.util.Objects.requireNonNull(builder.captureOptions, "captureOptions is required");
                this.destinationS3Uri = java.util.Objects.requireNonNull(builder.destinationS3Uri, "destinationS3Uri is required");
                this.initialSamplingPercentage = java.util.Objects.requireNonNull(builder.initialSamplingPercentage, "initialSamplingPercentage is required");
                this.captureContentTypeHeader = builder.captureContentTypeHeader;
                this.enableCapture = builder.enableCapture;
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getCaptureOptions() {
                return this.captureOptions;
            }

            @Override
            public final java.lang.String getDestinationS3Uri() {
                return this.destinationS3Uri;
            }

            @Override
            public final java.lang.Number getInitialSamplingPercentage() {
                return this.initialSamplingPercentage;
            }

            @Override
            public final java.lang.Object getCaptureContentTypeHeader() {
                return this.captureContentTypeHeader;
            }

            @Override
            public final java.lang.Object getEnableCapture() {
                return this.enableCapture;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("captureOptions", om.valueToTree(this.getCaptureOptions()));
                data.set("destinationS3Uri", om.valueToTree(this.getDestinationS3Uri()));
                data.set("initialSamplingPercentage", om.valueToTree(this.getInitialSamplingPercentage()));
                if (this.getCaptureContentTypeHeader() != null) {
                    data.set("captureContentTypeHeader", om.valueToTree(this.getCaptureContentTypeHeader()));
                }
                if (this.getEnableCapture() != null) {
                    data.set("enableCapture", om.valueToTree(this.getEnableCapture()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.DataCaptureConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCaptureConfigProperty.Jsii$Proxy that = (DataCaptureConfigProperty.Jsii$Proxy) o;

                if (!captureOptions.equals(that.captureOptions)) return false;
                if (!destinationS3Uri.equals(that.destinationS3Uri)) return false;
                if (!initialSamplingPercentage.equals(that.initialSamplingPercentage)) return false;
                if (this.captureContentTypeHeader != null ? !this.captureContentTypeHeader.equals(that.captureContentTypeHeader) : that.captureContentTypeHeader != null) return false;
                if (this.enableCapture != null ? !this.enableCapture.equals(that.enableCapture) : that.enableCapture != null) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.captureOptions.hashCode();
                result = 31 * result + (this.destinationS3Uri.hashCode());
                result = 31 * result + (this.initialSamplingPercentage.hashCode());
                result = 31 * result + (this.captureContentTypeHeader != null ? this.captureContentTypeHeader.hashCode() : 0);
                result = 31 * result + (this.enableCapture != null ? this.enableCapture.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A parameter to activate explainers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ExplainerConfigProperty explainerConfigProperty = ExplainerConfigProperty.builder()
     *         .clarifyExplainerConfig(ClarifyExplainerConfigProperty.builder()
     *                 .shapConfig(ClarifyShapConfigProperty.builder()
     *                         .shapBaselineConfig(ClarifyShapBaselineConfigProperty.builder()
     *                                 .mimeType("mimeType")
     *                                 .shapBaseline("shapBaseline")
     *                                 .shapBaselineUri("shapBaselineUri")
     *                                 .build())
     *                         // the properties below are optional
     *                         .numberOfSamples(123)
     *                         .seed(123)
     *                         .textConfig(ClarifyTextConfigProperty.builder()
     *                                 .granularity("granularity")
     *                                 .language("language")
     *                                 .build())
     *                         .useLogit(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .enableExplanations("enableExplanations")
     *                 .inferenceConfig(ClarifyInferenceConfigProperty.builder()
     *                         .contentTemplate("contentTemplate")
     *                         .featureHeaders(List.of("featureHeaders"))
     *                         .featuresAttribute("featuresAttribute")
     *                         .featureTypes(List.of("featureTypes"))
     *                         .labelAttribute("labelAttribute")
     *                         .labelHeaders(List.of("labelHeaders"))
     *                         .labelIndex(123)
     *                         .maxPayloadInMb(123)
     *                         .maxRecordCount(123)
     *                         .probabilityAttribute("probabilityAttribute")
     *                         .probabilityIndex(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ExplainerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ExplainerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExplainerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker Clarify explainer.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html#cfn-sagemaker-endpointconfig-explainerconfig-clarifyexplainerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-explainerconfig.html#cfn-sagemaker-endpointconfig-explainerconfig-clarifyexplainerconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClarifyExplainerConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExplainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExplainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExplainerConfigProperty> {
            java.lang.Object clarifyExplainerConfig;

            /**
             * Sets the value of {@link ExplainerConfigProperty#getClarifyExplainerConfig}
             * @param clarifyExplainerConfig A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker Clarify explainer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clarifyExplainerConfig(software.amazon.awscdk.IResolvable clarifyExplainerConfig) {
                this.clarifyExplainerConfig = clarifyExplainerConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExplainerConfigProperty#getClarifyExplainerConfig}
             * @param clarifyExplainerConfig A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker Clarify explainer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clarifyExplainerConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ClarifyExplainerConfigProperty clarifyExplainerConfig) {
                this.clarifyExplainerConfig = clarifyExplainerConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExplainerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExplainerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExplainerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExplainerConfigProperty {
            private final java.lang.Object clarifyExplainerConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clarifyExplainerConfig = software.amazon.jsii.Kernel.get(this, "clarifyExplainerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clarifyExplainerConfig = builder.clarifyExplainerConfig;
            }

            @Override
            public final java.lang.Object getClarifyExplainerConfig() {
                return this.clarifyExplainerConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClarifyExplainerConfig() != null) {
                    data.set("clarifyExplainerConfig", om.valueToTree(this.getClarifyExplainerConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ExplainerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExplainerConfigProperty.Jsii$Proxy that = (ExplainerConfigProperty.Jsii$Proxy) o;

                return this.clarifyExplainerConfig != null ? this.clarifyExplainerConfig.equals(that.clarifyExplainerConfig) : that.clarifyExplainerConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clarifyExplainerConfig != null ? this.clarifyExplainerConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ManagedInstanceScalingProperty managedInstanceScalingProperty = ManagedInstanceScalingProperty.builder()
     *         .maxInstanceCount(123)
     *         .minInstanceCount(123)
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedInstanceScalingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedInstanceScalingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-maxinstancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-maxinstancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxInstanceCount() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-mininstancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-mininstancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinInstanceCount() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-managedinstancescaling.html#cfn-sagemaker-endpointconfig-managedinstancescaling-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedInstanceScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedInstanceScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedInstanceScalingProperty> {
            java.lang.Number maxInstanceCount;
            java.lang.Number minInstanceCount;
            java.lang.String status;

            /**
             * Sets the value of {@link ManagedInstanceScalingProperty#getMaxInstanceCount}
             * @param maxInstanceCount the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxInstanceCount(java.lang.Number maxInstanceCount) {
                this.maxInstanceCount = maxInstanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ManagedInstanceScalingProperty#getMinInstanceCount}
             * @param minInstanceCount the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minInstanceCount(java.lang.Number minInstanceCount) {
                this.minInstanceCount = minInstanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ManagedInstanceScalingProperty#getStatus}
             * @param status the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedInstanceScalingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedInstanceScalingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedInstanceScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedInstanceScalingProperty {
            private final java.lang.Number maxInstanceCount;
            private final java.lang.Number minInstanceCount;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxInstanceCount = software.amazon.jsii.Kernel.get(this, "maxInstanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minInstanceCount = software.amazon.jsii.Kernel.get(this, "minInstanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxInstanceCount = builder.maxInstanceCount;
                this.minInstanceCount = builder.minInstanceCount;
                this.status = builder.status;
            }

            @Override
            public final java.lang.Number getMaxInstanceCount() {
                return this.maxInstanceCount;
            }

            @Override
            public final java.lang.Number getMinInstanceCount() {
                return this.minInstanceCount;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxInstanceCount() != null) {
                    data.set("maxInstanceCount", om.valueToTree(this.getMaxInstanceCount()));
                }
                if (this.getMinInstanceCount() != null) {
                    data.set("minInstanceCount", om.valueToTree(this.getMinInstanceCount()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedInstanceScalingProperty.Jsii$Proxy that = (ManagedInstanceScalingProperty.Jsii$Proxy) o;

                if (this.maxInstanceCount != null ? !this.maxInstanceCount.equals(that.maxInstanceCount) : that.maxInstanceCount != null) return false;
                if (this.minInstanceCount != null ? !this.minInstanceCount.equals(that.minInstanceCount) : that.minInstanceCount != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxInstanceCount != null ? this.maxInstanceCount.hashCode() : 0;
                result = 31 * result + (this.minInstanceCount != null ? this.minInstanceCount.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a model that you want to host and the resources to deploy for hosting it.
     * <p>
     * If you are deploying multiple models, tell Amazon SageMaker how to distribute traffic among the models by specifying the <code>InitialVariantWeight</code> objects.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ProductionVariantProperty productionVariantProperty = ProductionVariantProperty.builder()
     *         .variantName("variantName")
     *         // the properties below are optional
     *         .acceleratorType("acceleratorType")
     *         .capacityReservationConfig(CapacityReservationConfigProperty.builder()
     *                 .capacityReservationPreference("capacityReservationPreference")
     *                 .mlReservationArn("mlReservationArn")
     *                 .build())
     *         .containerStartupHealthCheckTimeoutInSeconds(123)
     *         .enableSsmAccess(false)
     *         .inferenceAmiVersion("inferenceAmiVersion")
     *         .initialInstanceCount(123)
     *         .initialVariantWeight(123)
     *         .instanceType("instanceType")
     *         .managedInstanceScaling(ManagedInstanceScalingProperty.builder()
     *                 .maxInstanceCount(123)
     *                 .minInstanceCount(123)
     *                 .status("status")
     *                 .build())
     *         .modelDataDownloadTimeoutInSeconds(123)
     *         .modelName("modelName")
     *         .routingConfig(RoutingConfigProperty.builder()
     *                 .routingStrategy("routingStrategy")
     *                 .build())
     *         .serverlessConfig(ServerlessConfigProperty.builder()
     *                 .maxConcurrency(123)
     *                 .memorySizeInMb(123)
     *                 // the properties below are optional
     *                 .provisionedConcurrency(123)
     *                 .build())
     *         .volumeSizeInGb(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ProductionVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(ProductionVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProductionVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the production variant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVariantName();

        /**
         * The size of the Elastic Inference (EI) instance to use for the production variant.
         * <p>
         * EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> . For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAcceleratorType() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CapacityReservationConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-capacityreservationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-capacityreservationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationConfig() {
            return null;
        }

        /**
         * The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting.
         * <p>
         * For more information about health check, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests">How Your Container Should Respond to Health Check (Ping) Requests</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-containerstartuphealthchecktimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-containerstartuphealthchecktimeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerStartupHealthCheckTimeoutInSeconds() {
            return null;
        }

        /**
         * You can use this parameter to turn on native AWS Systems Manager (SSM) access for a production variant behind an endpoint.
         * <p>
         * By default, SSM access is disabled for all production variants behind an endpoint. You can turn on or turn off SSM access for a production variant behind an existing endpoint by creating a new endpoint configuration and calling <code>UpdateEndpoint</code> .
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-enablessmaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-enablessmaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableSsmAccess() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-inferenceamiversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-inferenceamiversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInferenceAmiVersion() {
            return null;
        }

        /**
         * Number of instances to launch initially.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInitialInstanceCount() {
            return null;
        }

        /**
         * Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.
         * <p>
         * The traffic to a production variant is determined by the ratio of the <code>VariantWeight</code> to the sum of all <code>VariantWeight</code> values across all ProductionVariants. If unspecified, it defaults to 1.0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInitialVariantWeight() {
            return null;
        }

        /**
         * The ML compute instance type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-managedinstancescaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-managedinstancescaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedInstanceScaling() {
            return null;
        }

        /**
         * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modeldatadownloadtimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modeldatadownloadtimeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getModelDataDownloadTimeoutInSeconds() {
            return null;
        }

        /**
         * The name of the model that you want to host.
         * <p>
         * This is the name that you specified when creating the model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModelName() {
            return null;
        }

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.RoutingConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-routingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-routingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoutingConfig() {
            return null;
        }

        /**
         * The serverless configuration for an endpoint.
         * <p>
         * Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ServerlessConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-serverlessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServerlessConfig() {
            return null;
        }

        /**
         * The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant.
         * <p>
         * Currently only Amazon EBS gp2 storage volumes are supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-volumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-volumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSizeInGb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProductionVariantProperty> {
            java.lang.String variantName;
            java.lang.String acceleratorType;
            java.lang.Object capacityReservationConfig;
            java.lang.Number containerStartupHealthCheckTimeoutInSeconds;
            java.lang.Object enableSsmAccess;
            java.lang.String inferenceAmiVersion;
            java.lang.Number initialInstanceCount;
            java.lang.Number initialVariantWeight;
            java.lang.String instanceType;
            java.lang.Object managedInstanceScaling;
            java.lang.Number modelDataDownloadTimeoutInSeconds;
            java.lang.String modelName;
            java.lang.Object routingConfig;
            java.lang.Object serverlessConfig;
            java.lang.Number volumeSizeInGb;

            /**
             * Sets the value of {@link ProductionVariantProperty#getVariantName}
             * @param variantName The name of the production variant. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variantName(java.lang.String variantName) {
                this.variantName = variantName;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getAcceleratorType}
             * @param acceleratorType The size of the Elastic Inference (EI) instance to use for the production variant.
             *                        EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> . For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorType(java.lang.String acceleratorType) {
                this.acceleratorType = acceleratorType;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getCapacityReservationConfig}
             * @param capacityReservationConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationConfig(software.amazon.awscdk.IResolvable capacityReservationConfig) {
                this.capacityReservationConfig = capacityReservationConfig;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getCapacityReservationConfig}
             * @param capacityReservationConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.CapacityReservationConfigProperty capacityReservationConfig) {
                this.capacityReservationConfig = capacityReservationConfig;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getContainerStartupHealthCheckTimeoutInSeconds}
             * @param containerStartupHealthCheckTimeoutInSeconds The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting.
             *                                                    For more information about health check, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests">How Your Container Should Respond to Health Check (Ping) Requests</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerStartupHealthCheckTimeoutInSeconds(java.lang.Number containerStartupHealthCheckTimeoutInSeconds) {
                this.containerStartupHealthCheckTimeoutInSeconds = containerStartupHealthCheckTimeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getEnableSsmAccess}
             * @param enableSsmAccess You can use this parameter to turn on native AWS Systems Manager (SSM) access for a production variant behind an endpoint.
             *                        By default, SSM access is disabled for all production variants behind an endpoint. You can turn on or turn off SSM access for a production variant behind an existing endpoint by creating a new endpoint configuration and calling <code>UpdateEndpoint</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableSsmAccess(java.lang.Boolean enableSsmAccess) {
                this.enableSsmAccess = enableSsmAccess;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getEnableSsmAccess}
             * @param enableSsmAccess You can use this parameter to turn on native AWS Systems Manager (SSM) access for a production variant behind an endpoint.
             *                        By default, SSM access is disabled for all production variants behind an endpoint. You can turn on or turn off SSM access for a production variant behind an existing endpoint by creating a new endpoint configuration and calling <code>UpdateEndpoint</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableSsmAccess(software.amazon.awscdk.IResolvable enableSsmAccess) {
                this.enableSsmAccess = enableSsmAccess;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInferenceAmiVersion}
             * @param inferenceAmiVersion the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceAmiVersion(java.lang.String inferenceAmiVersion) {
                this.inferenceAmiVersion = inferenceAmiVersion;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInitialInstanceCount}
             * @param initialInstanceCount Number of instances to launch initially.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialInstanceCount(java.lang.Number initialInstanceCount) {
                this.initialInstanceCount = initialInstanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInitialVariantWeight}
             * @param initialVariantWeight Determines initial traffic distribution among all of the models that you specify in the endpoint configuration.
             *                             The traffic to a production variant is determined by the ratio of the <code>VariantWeight</code> to the sum of all <code>VariantWeight</code> values across all ProductionVariants. If unspecified, it defaults to 1.0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initialVariantWeight(java.lang.Number initialVariantWeight) {
                this.initialVariantWeight = initialVariantWeight;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getInstanceType}
             * @param instanceType The ML compute instance type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getManagedInstanceScaling}
             * @param managedInstanceScaling the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedInstanceScaling(software.amazon.awscdk.IResolvable managedInstanceScaling) {
                this.managedInstanceScaling = managedInstanceScaling;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getManagedInstanceScaling}
             * @param managedInstanceScaling the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedInstanceScaling(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ManagedInstanceScalingProperty managedInstanceScaling) {
                this.managedInstanceScaling = managedInstanceScaling;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getModelDataDownloadTimeoutInSeconds}
             * @param modelDataDownloadTimeoutInSeconds The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelDataDownloadTimeoutInSeconds(java.lang.Number modelDataDownloadTimeoutInSeconds) {
                this.modelDataDownloadTimeoutInSeconds = modelDataDownloadTimeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getModelName}
             * @param modelName The name of the model that you want to host.
             *                  This is the name that you specified when creating the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelName(java.lang.String modelName) {
                this.modelName = modelName;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getRoutingConfig}
             * @param routingConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingConfig(software.amazon.awscdk.IResolvable routingConfig) {
                this.routingConfig = routingConfig;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getRoutingConfig}
             * @param routingConfig the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.RoutingConfigProperty routingConfig) {
                this.routingConfig = routingConfig;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getServerlessConfig}
             * @param serverlessConfig The serverless configuration for an endpoint.
             *                         Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverlessConfig(software.amazon.awscdk.IResolvable serverlessConfig) {
                this.serverlessConfig = serverlessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getServerlessConfig}
             * @param serverlessConfig The serverless configuration for an endpoint.
             *                         Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverlessConfig(software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ServerlessConfigProperty serverlessConfig) {
                this.serverlessConfig = serverlessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ProductionVariantProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant.
             *                       Currently only Amazon EBS gp2 storage volumes are supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProductionVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProductionVariantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProductionVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProductionVariantProperty {
            private final java.lang.String variantName;
            private final java.lang.String acceleratorType;
            private final java.lang.Object capacityReservationConfig;
            private final java.lang.Number containerStartupHealthCheckTimeoutInSeconds;
            private final java.lang.Object enableSsmAccess;
            private final java.lang.String inferenceAmiVersion;
            private final java.lang.Number initialInstanceCount;
            private final java.lang.Number initialVariantWeight;
            private final java.lang.String instanceType;
            private final java.lang.Object managedInstanceScaling;
            private final java.lang.Number modelDataDownloadTimeoutInSeconds;
            private final java.lang.String modelName;
            private final java.lang.Object routingConfig;
            private final java.lang.Object serverlessConfig;
            private final java.lang.Number volumeSizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.variantName = software.amazon.jsii.Kernel.get(this, "variantName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.acceleratorType = software.amazon.jsii.Kernel.get(this, "acceleratorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationConfig = software.amazon.jsii.Kernel.get(this, "capacityReservationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.containerStartupHealthCheckTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "containerStartupHealthCheckTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enableSsmAccess = software.amazon.jsii.Kernel.get(this, "enableSsmAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inferenceAmiVersion = software.amazon.jsii.Kernel.get(this, "inferenceAmiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.initialInstanceCount = software.amazon.jsii.Kernel.get(this, "initialInstanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.initialVariantWeight = software.amazon.jsii.Kernel.get(this, "initialVariantWeight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.managedInstanceScaling = software.amazon.jsii.Kernel.get(this, "managedInstanceScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelDataDownloadTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "modelDataDownloadTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.routingConfig = software.amazon.jsii.Kernel.get(this, "routingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serverlessConfig = software.amazon.jsii.Kernel.get(this, "serverlessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.variantName = java.util.Objects.requireNonNull(builder.variantName, "variantName is required");
                this.acceleratorType = builder.acceleratorType;
                this.capacityReservationConfig = builder.capacityReservationConfig;
                this.containerStartupHealthCheckTimeoutInSeconds = builder.containerStartupHealthCheckTimeoutInSeconds;
                this.enableSsmAccess = builder.enableSsmAccess;
                this.inferenceAmiVersion = builder.inferenceAmiVersion;
                this.initialInstanceCount = builder.initialInstanceCount;
                this.initialVariantWeight = builder.initialVariantWeight;
                this.instanceType = builder.instanceType;
                this.managedInstanceScaling = builder.managedInstanceScaling;
                this.modelDataDownloadTimeoutInSeconds = builder.modelDataDownloadTimeoutInSeconds;
                this.modelName = builder.modelName;
                this.routingConfig = builder.routingConfig;
                this.serverlessConfig = builder.serverlessConfig;
                this.volumeSizeInGb = builder.volumeSizeInGb;
            }

            @Override
            public final java.lang.String getVariantName() {
                return this.variantName;
            }

            @Override
            public final java.lang.String getAcceleratorType() {
                return this.acceleratorType;
            }

            @Override
            public final java.lang.Object getCapacityReservationConfig() {
                return this.capacityReservationConfig;
            }

            @Override
            public final java.lang.Number getContainerStartupHealthCheckTimeoutInSeconds() {
                return this.containerStartupHealthCheckTimeoutInSeconds;
            }

            @Override
            public final java.lang.Object getEnableSsmAccess() {
                return this.enableSsmAccess;
            }

            @Override
            public final java.lang.String getInferenceAmiVersion() {
                return this.inferenceAmiVersion;
            }

            @Override
            public final java.lang.Number getInitialInstanceCount() {
                return this.initialInstanceCount;
            }

            @Override
            public final java.lang.Number getInitialVariantWeight() {
                return this.initialVariantWeight;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Object getManagedInstanceScaling() {
                return this.managedInstanceScaling;
            }

            @Override
            public final java.lang.Number getModelDataDownloadTimeoutInSeconds() {
                return this.modelDataDownloadTimeoutInSeconds;
            }

            @Override
            public final java.lang.String getModelName() {
                return this.modelName;
            }

            @Override
            public final java.lang.Object getRoutingConfig() {
                return this.routingConfig;
            }

            @Override
            public final java.lang.Object getServerlessConfig() {
                return this.serverlessConfig;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("variantName", om.valueToTree(this.getVariantName()));
                if (this.getAcceleratorType() != null) {
                    data.set("acceleratorType", om.valueToTree(this.getAcceleratorType()));
                }
                if (this.getCapacityReservationConfig() != null) {
                    data.set("capacityReservationConfig", om.valueToTree(this.getCapacityReservationConfig()));
                }
                if (this.getContainerStartupHealthCheckTimeoutInSeconds() != null) {
                    data.set("containerStartupHealthCheckTimeoutInSeconds", om.valueToTree(this.getContainerStartupHealthCheckTimeoutInSeconds()));
                }
                if (this.getEnableSsmAccess() != null) {
                    data.set("enableSsmAccess", om.valueToTree(this.getEnableSsmAccess()));
                }
                if (this.getInferenceAmiVersion() != null) {
                    data.set("inferenceAmiVersion", om.valueToTree(this.getInferenceAmiVersion()));
                }
                if (this.getInitialInstanceCount() != null) {
                    data.set("initialInstanceCount", om.valueToTree(this.getInitialInstanceCount()));
                }
                if (this.getInitialVariantWeight() != null) {
                    data.set("initialVariantWeight", om.valueToTree(this.getInitialVariantWeight()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getManagedInstanceScaling() != null) {
                    data.set("managedInstanceScaling", om.valueToTree(this.getManagedInstanceScaling()));
                }
                if (this.getModelDataDownloadTimeoutInSeconds() != null) {
                    data.set("modelDataDownloadTimeoutInSeconds", om.valueToTree(this.getModelDataDownloadTimeoutInSeconds()));
                }
                if (this.getModelName() != null) {
                    data.set("modelName", om.valueToTree(this.getModelName()));
                }
                if (this.getRoutingConfig() != null) {
                    data.set("routingConfig", om.valueToTree(this.getRoutingConfig()));
                }
                if (this.getServerlessConfig() != null) {
                    data.set("serverlessConfig", om.valueToTree(this.getServerlessConfig()));
                }
                if (this.getVolumeSizeInGb() != null) {
                    data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ProductionVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProductionVariantProperty.Jsii$Proxy that = (ProductionVariantProperty.Jsii$Proxy) o;

                if (!variantName.equals(that.variantName)) return false;
                if (this.acceleratorType != null ? !this.acceleratorType.equals(that.acceleratorType) : that.acceleratorType != null) return false;
                if (this.capacityReservationConfig != null ? !this.capacityReservationConfig.equals(that.capacityReservationConfig) : that.capacityReservationConfig != null) return false;
                if (this.containerStartupHealthCheckTimeoutInSeconds != null ? !this.containerStartupHealthCheckTimeoutInSeconds.equals(that.containerStartupHealthCheckTimeoutInSeconds) : that.containerStartupHealthCheckTimeoutInSeconds != null) return false;
                if (this.enableSsmAccess != null ? !this.enableSsmAccess.equals(that.enableSsmAccess) : that.enableSsmAccess != null) return false;
                if (this.inferenceAmiVersion != null ? !this.inferenceAmiVersion.equals(that.inferenceAmiVersion) : that.inferenceAmiVersion != null) return false;
                if (this.initialInstanceCount != null ? !this.initialInstanceCount.equals(that.initialInstanceCount) : that.initialInstanceCount != null) return false;
                if (this.initialVariantWeight != null ? !this.initialVariantWeight.equals(that.initialVariantWeight) : that.initialVariantWeight != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.managedInstanceScaling != null ? !this.managedInstanceScaling.equals(that.managedInstanceScaling) : that.managedInstanceScaling != null) return false;
                if (this.modelDataDownloadTimeoutInSeconds != null ? !this.modelDataDownloadTimeoutInSeconds.equals(that.modelDataDownloadTimeoutInSeconds) : that.modelDataDownloadTimeoutInSeconds != null) return false;
                if (this.modelName != null ? !this.modelName.equals(that.modelName) : that.modelName != null) return false;
                if (this.routingConfig != null ? !this.routingConfig.equals(that.routingConfig) : that.routingConfig != null) return false;
                if (this.serverlessConfig != null ? !this.serverlessConfig.equals(that.serverlessConfig) : that.serverlessConfig != null) return false;
                return this.volumeSizeInGb != null ? this.volumeSizeInGb.equals(that.volumeSizeInGb) : that.volumeSizeInGb == null;
            }

            @Override
            public final int hashCode() {
                int result = this.variantName.hashCode();
                result = 31 * result + (this.acceleratorType != null ? this.acceleratorType.hashCode() : 0);
                result = 31 * result + (this.capacityReservationConfig != null ? this.capacityReservationConfig.hashCode() : 0);
                result = 31 * result + (this.containerStartupHealthCheckTimeoutInSeconds != null ? this.containerStartupHealthCheckTimeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.enableSsmAccess != null ? this.enableSsmAccess.hashCode() : 0);
                result = 31 * result + (this.inferenceAmiVersion != null ? this.inferenceAmiVersion.hashCode() : 0);
                result = 31 * result + (this.initialInstanceCount != null ? this.initialInstanceCount.hashCode() : 0);
                result = 31 * result + (this.initialVariantWeight != null ? this.initialVariantWeight.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.managedInstanceScaling != null ? this.managedInstanceScaling.hashCode() : 0);
                result = 31 * result + (this.modelDataDownloadTimeoutInSeconds != null ? this.modelDataDownloadTimeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.modelName != null ? this.modelName.hashCode() : 0);
                result = 31 * result + (this.routingConfig != null ? this.routingConfig.hashCode() : 0);
                result = 31 * result + (this.serverlessConfig != null ? this.serverlessConfig.hashCode() : 0);
                result = 31 * result + (this.volumeSizeInGb != null ? this.volumeSizeInGb.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * RoutingConfigProperty routingConfigProperty = RoutingConfigProperty.builder()
     *         .routingStrategy("routingStrategy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-routingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-routingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.RoutingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RoutingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoutingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-routingconfig.html#cfn-sagemaker-endpointconfig-routingconfig-routingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-routingconfig.html#cfn-sagemaker-endpointconfig-routingconfig-routingstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoutingStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoutingConfigProperty> {
            java.lang.String routingStrategy;

            /**
             * Sets the value of {@link RoutingConfigProperty#getRoutingStrategy}
             * @param routingStrategy the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingStrategy(java.lang.String routingStrategy) {
                this.routingStrategy = routingStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoutingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoutingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RoutingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoutingConfigProperty {
            private final java.lang.String routingStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.routingStrategy = software.amazon.jsii.Kernel.get(this, "routingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.routingStrategy = builder.routingStrategy;
            }

            @Override
            public final java.lang.String getRoutingStrategy() {
                return this.routingStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRoutingStrategy() != null) {
                    data.set("routingStrategy", om.valueToTree(this.getRoutingStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.RoutingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoutingConfigProperty.Jsii$Proxy that = (RoutingConfigProperty.Jsii$Proxy) o;

                return this.routingStrategy != null ? this.routingStrategy.equals(that.routingStrategy) : that.routingStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.routingStrategy != null ? this.routingStrategy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the serverless configuration for an endpoint variant.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ServerlessConfigProperty serverlessConfigProperty = ServerlessConfigProperty.builder()
     *         .maxConcurrency(123)
     *         .memorySizeInMb(123)
     *         // the properties below are optional
     *         .provisionedConcurrency(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ServerlessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ServerlessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServerlessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of concurrent invocations your serverless endpoint can process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-maxconcurrency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-maxconcurrency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxConcurrency();

        /**
         * The memory size of your serverless endpoint.
         * <p>
         * Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-memorysizeinmb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-memorysizeinmb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMemorySizeInMb();

        /**
         * The amount of provisioned concurrency to allocate for the serverless endpoint.
         * <p>
         * Should be less than or equal to <code>MaxConcurrency</code> .
         * <p>
         * <blockquote>
         * <p>
         * This field is not supported for serverless endpoint recommendations for Inference Recommender jobs. For more information about creating an Inference Recommender job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html">CreateInferenceRecommendationsJobs</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-provisionedconcurrency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-serverlessconfig.html#cfn-sagemaker-endpointconfig-serverlessconfig-provisionedconcurrency</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProvisionedConcurrency() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServerlessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServerlessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServerlessConfigProperty> {
            java.lang.Number maxConcurrency;
            java.lang.Number memorySizeInMb;
            java.lang.Number provisionedConcurrency;

            /**
             * Sets the value of {@link ServerlessConfigProperty#getMaxConcurrency}
             * @param maxConcurrency The maximum number of concurrent invocations your serverless endpoint can process. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrency(java.lang.Number maxConcurrency) {
                this.maxConcurrency = maxConcurrency;
                return this;
            }

            /**
             * Sets the value of {@link ServerlessConfigProperty#getMemorySizeInMb}
             * @param memorySizeInMb The memory size of your serverless endpoint. This parameter is required.
             *                       Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memorySizeInMb(java.lang.Number memorySizeInMb) {
                this.memorySizeInMb = memorySizeInMb;
                return this;
            }

            /**
             * Sets the value of {@link ServerlessConfigProperty#getProvisionedConcurrency}
             * @param provisionedConcurrency The amount of provisioned concurrency to allocate for the serverless endpoint.
             *                               Should be less than or equal to <code>MaxConcurrency</code> .
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               This field is not supported for serverless endpoint recommendations for Inference Recommender jobs. For more information about creating an Inference Recommender job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html">CreateInferenceRecommendationsJobs</a> .
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedConcurrency(java.lang.Number provisionedConcurrency) {
                this.provisionedConcurrency = provisionedConcurrency;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServerlessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServerlessConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServerlessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServerlessConfigProperty {
            private final java.lang.Number maxConcurrency;
            private final java.lang.Number memorySizeInMb;
            private final java.lang.Number provisionedConcurrency;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memorySizeInMb = software.amazon.jsii.Kernel.get(this, "memorySizeInMb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.provisionedConcurrency = software.amazon.jsii.Kernel.get(this, "provisionedConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxConcurrency = java.util.Objects.requireNonNull(builder.maxConcurrency, "maxConcurrency is required");
                this.memorySizeInMb = java.util.Objects.requireNonNull(builder.memorySizeInMb, "memorySizeInMb is required");
                this.provisionedConcurrency = builder.provisionedConcurrency;
            }

            @Override
            public final java.lang.Number getMaxConcurrency() {
                return this.maxConcurrency;
            }

            @Override
            public final java.lang.Number getMemorySizeInMb() {
                return this.memorySizeInMb;
            }

            @Override
            public final java.lang.Number getProvisionedConcurrency() {
                return this.provisionedConcurrency;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
                data.set("memorySizeInMb", om.valueToTree(this.getMemorySizeInMb()));
                if (this.getProvisionedConcurrency() != null) {
                    data.set("provisionedConcurrency", om.valueToTree(this.getProvisionedConcurrency()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.ServerlessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServerlessConfigProperty.Jsii$Proxy that = (ServerlessConfigProperty.Jsii$Proxy) o;

                if (!maxConcurrency.equals(that.maxConcurrency)) return false;
                if (!memorySizeInMb.equals(that.memorySizeInMb)) return false;
                return this.provisionedConcurrency != null ? this.provisionedConcurrency.equals(that.provisionedConcurrency) : that.provisionedConcurrency == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxConcurrency.hashCode();
                result = 31 * result + (this.memorySizeInMb.hashCode());
                result = 31 * result + (this.provisionedConcurrency != null ? this.provisionedConcurrency.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html#cfn-sagemaker-endpointconfig-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html#cfn-sagemaker-endpointconfig-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html#cfn-sagemaker-endpointconfig-vpcconfig-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-vpcconfig.html#cfn-sagemaker-endpointconfig-vpcconfig-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnEndpointConfig.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnEndpointConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnEndpointConfigProps.Builder();
        }

        /**
         * A list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants</a>
         * @param productionVariants A list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(final software.amazon.awscdk.IResolvable productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }
        /**
         * A list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants</a>
         * @param productionVariants A list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder productionVariants(final java.util.List<? extends java.lang.Object> productionVariants) {
            this.props.productionVariants(productionVariants);
            return this;
        }

        /**
         * Specifies configuration for how an endpoint performs asynchronous inference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig</a>
         * @param asyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous inference. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asyncInferenceConfig(final software.amazon.awscdk.IResolvable asyncInferenceConfig) {
            this.props.asyncInferenceConfig(asyncInferenceConfig);
            return this;
        }
        /**
         * Specifies configuration for how an endpoint performs asynchronous inference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-asyncinferenceconfig</a>
         * @param asyncInferenceConfig Specifies configuration for how an endpoint performs asynchronous inference. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder asyncInferenceConfig(final software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.AsyncInferenceConfigProperty asyncInferenceConfig) {
            this.props.asyncInferenceConfig(asyncInferenceConfig);
            return this;
        }

        /**
         * Specifies how to capture endpoint data for model monitor.
         * <p>
         * The data capture configuration applies to all production variants hosted at the endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig</a>
         * @param dataCaptureConfig Specifies how to capture endpoint data for model monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(final software.amazon.awscdk.IResolvable dataCaptureConfig) {
            this.props.dataCaptureConfig(dataCaptureConfig);
            return this;
        }
        /**
         * Specifies how to capture endpoint data for model monitor.
         * <p>
         * The data capture configuration applies to all production variants hosted at the endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-datacaptureconfig</a>
         * @param dataCaptureConfig Specifies how to capture endpoint data for model monitor. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCaptureConfig(final software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.DataCaptureConfigProperty dataCaptureConfig) {
            this.props.dataCaptureConfig(dataCaptureConfig);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-enablenetworkisolation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-enablenetworkisolation</a>
         * @param enableNetworkIsolation This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableNetworkIsolation(final java.lang.Boolean enableNetworkIsolation) {
            this.props.enableNetworkIsolation(enableNetworkIsolation);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-enablenetworkisolation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-enablenetworkisolation</a>
         * @param enableNetworkIsolation This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableNetworkIsolation(final software.amazon.awscdk.IResolvable enableNetworkIsolation) {
            this.props.enableNetworkIsolation(enableNetworkIsolation);
            return this;
        }

        /**
         * The name of the endpoint configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname</a>
         * @param endpointConfigName The name of the endpoint configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointConfigName(final java.lang.String endpointConfigName) {
            this.props.endpointConfigName(endpointConfigName);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-executionrolearn</a>
         * @param executionRoleArn This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * A parameter to activate explainers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig</a>
         * @param explainerConfig A parameter to activate explainers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder explainerConfig(final software.amazon.awscdk.IResolvable explainerConfig) {
            this.props.explainerConfig(explainerConfig);
            return this;
        }
        /**
         * A parameter to activate explainers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-explainerconfig</a>
         * @param explainerConfig A parameter to activate explainers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder explainerConfig(final software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.ExplainerConfigProperty explainerConfig) {
            this.props.explainerConfig(explainerConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
         * <p>
         * <ul>
         * <li>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></li>
         * <li>Alias name: <code>alias/ExampleAlias</code></li>
         * <li>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code></li>
         * </ul>
         * <p>
         * The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> , <code>UpdateEndpoint</code> requests. For more information, refer to the AWS Key Management Service section <a href="https://docs.aws.amazon.com//kms/latest/developerguide/key-policies.html">Using Key Policies in AWS KMS</a>
         * <p>
         * <blockquote>
         * <p>
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.
         * <p>
         * For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
         * <p>
         * For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid</a>
         * @param kmsKeyId The Amazon Resource Name (ARN) of an AWS Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Array of <code>ProductionVariant</code> objects.
         * <p>
         * There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on <code>ProductionVariants</code> . If you use this field, you can only specify one variant for <code>ProductionVariants</code> and one variant for <code>ShadowProductionVariants</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants</a>
         * @param shadowProductionVariants Array of <code>ProductionVariant</code> objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shadowProductionVariants(final software.amazon.awscdk.IResolvable shadowProductionVariants) {
            this.props.shadowProductionVariants(shadowProductionVariants);
            return this;
        }
        /**
         * Array of <code>ProductionVariant</code> objects.
         * <p>
         * There is one for each model that you want to host at this endpoint in shadow mode with production traffic replicated from the model specified on <code>ProductionVariants</code> . If you use this field, you can only specify one variant for <code>ProductionVariants</code> and one variant for <code>ShadowProductionVariants</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-shadowproductionvariants</a>
         * @param shadowProductionVariants Array of <code>ProductionVariant</code> objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shadowProductionVariants(final java.util.List<? extends java.lang.Object> shadowProductionVariants) {
            this.props.shadowProductionVariants(shadowProductionVariants);
            return this;
        }

        /**
         * A list of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags</a>
         * @param tags A list of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-vpcconfig</a>
         * @param vpcConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-vpcconfig</a>
         * @param vpcConfig This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.sagemaker.CfnEndpointConfig.VpcConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnEndpointConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnEndpointConfig build() {
            return new software.amazon.awscdk.services.sagemaker.CfnEndpointConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
