package software.amazon.awscdk.services.sagemaker;

/**
 * An Amazon SageMaker processing job that is used to analyze data and evaluate models.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html">Process Data and Evaluate Models</a> .
 * <p>
 * Also, note the following details specific to processing jobs created using CloudFormation stacks:
 * <p>
 * <ul>
 * <li>When you delete a CloudFormation stack with a processing job resource, the processing job is stopped using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopProcessingJob.html">StopProcessingJob</a> API but not deleted. Any tags associated with the processing job are deleted using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteTags.html">DeleteTags</a> API.</li>
 * <li>If any part of your CloudFormation stack deployment fails and a rollback initiates, processing jobs with a specified <code>ProcessingJobName</code> value might cause the stack to become stuck in a failed state. This occurs because during a rollback, CloudFormation attempts to recreate the stack resources. Processing job names must be unique, so when CloudFormation attempts to recreate a processing job using the already defined name, this results in an <code>AlreadyExists</code> error. To prevent this, we recommend that you don't specify the optional <code>ProcessingJobName</code> property, thereby allowing SageMaker to auto-generate a unique name for your processing job. This ensures successful stack rollbacks when necessary. If you must use custom job names, you have to manually modify the <code>ProcessingJobName</code> and redeploy the stack to recover from a failed rollback.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnProcessingJob cfnProcessingJob = CfnProcessingJob.Builder.create(this, "MyCfnProcessingJob")
 *         .appSpecification(AppSpecificationProperty.builder()
 *                 .imageUri("imageUri")
 *                 // the properties below are optional
 *                 .containerArguments(List.of("containerArguments"))
 *                 .containerEntrypoint(List.of("containerEntrypoint"))
 *                 .build())
 *         .processingResources(ProcessingResourcesProperty.builder()
 *                 .clusterConfig(ClusterConfigProperty.builder()
 *                         .instanceCount(123)
 *                         .instanceType("instanceType")
 *                         .volumeSizeInGb(123)
 *                         // the properties below are optional
 *                         .volumeKmsKeyId("volumeKmsKeyId")
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .experimentConfig(ExperimentConfigProperty.builder()
 *                 .experimentName("experimentName")
 *                 .runName("runName")
 *                 .trialComponentDisplayName("trialComponentDisplayName")
 *                 .trialName("trialName")
 *                 .build())
 *         .networkConfig(NetworkConfigProperty.builder()
 *                 .enableInterContainerTrafficEncryption(false)
 *                 .enableNetworkIsolation(false)
 *                 .vpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .processingInputs(List.of(ProcessingInputsObjectProperty.builder()
 *                 .inputName("inputName")
 *                 // the properties below are optional
 *                 .appManaged(false)
 *                 .datasetDefinition(DatasetDefinitionProperty.builder()
 *                         .athenaDatasetDefinition(AthenaDatasetDefinitionProperty.builder()
 *                                 .catalog("catalog")
 *                                 .database("database")
 *                                 .outputFormat("outputFormat")
 *                                 .outputS3Uri("outputS3Uri")
 *                                 .queryString("queryString")
 *                                 // the properties below are optional
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .outputCompression("outputCompression")
 *                                 .workGroup("workGroup")
 *                                 .build())
 *                         .dataDistributionType("dataDistributionType")
 *                         .inputMode("inputMode")
 *                         .localPath("localPath")
 *                         .redshiftDatasetDefinition(RedshiftDatasetDefinitionProperty.builder()
 *                                 .clusterId("clusterId")
 *                                 .clusterRoleArn("clusterRoleArn")
 *                                 .database("database")
 *                                 .dbUser("dbUser")
 *                                 .outputFormat("outputFormat")
 *                                 .outputS3Uri("outputS3Uri")
 *                                 .queryString("queryString")
 *                                 // the properties below are optional
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .outputCompression("outputCompression")
 *                                 .build())
 *                         .build())
 *                 .s3Input(S3InputProperty.builder()
 *                         .s3DataType("s3DataType")
 *                         .s3Uri("s3Uri")
 *                         // the properties below are optional
 *                         .localPath("localPath")
 *                         .s3CompressionType("s3CompressionType")
 *                         .s3DataDistributionType("s3DataDistributionType")
 *                         .s3InputMode("s3InputMode")
 *                         .build())
 *                 .build()))
 *         .processingJobName("processingJobName")
 *         .processingOutputConfig(ProcessingOutputConfigProperty.builder()
 *                 .outputs(List.of(ProcessingOutputsObjectProperty.builder()
 *                         .outputName("outputName")
 *                         // the properties below are optional
 *                         .appManaged(false)
 *                         .featureStoreOutput(FeatureStoreOutputProperty.builder()
 *                                 .featureGroupName("featureGroupName")
 *                                 .build())
 *                         .s3Output(S3OutputProperty.builder()
 *                                 .s3UploadMode("s3UploadMode")
 *                                 .s3Uri("s3Uri")
 *                                 // the properties below are optional
 *                                 .localPath("localPath")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .stoppingCondition(StoppingConditionProperty.builder()
 *                 .maxRuntimeInSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.618Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob")
public class CfnProcessingJob extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.sagemaker.IProcessingJobRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnProcessingJob(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProcessingJob(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnProcessingJob(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnProcessingJobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AutoML job associated with this processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAutoMlJobArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAutoMlJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the processing job was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string, up to one KB in size, that contains metadata from the processing container when the processing job exits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrExitMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrExitMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFailureReason() {
        return software.amazon.jsii.Kernel.get(this, "attrFailureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time the processing job was last modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of a monitoring schedule for an endpoint associated with this processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMonitoringScheduleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMonitoringScheduleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time that the processing job ended.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProcessingEndTime() {
        return software.amazon.jsii.Kernel.get(this, "attrProcessingEndTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProcessingJobArn() {
        return software.amazon.jsii.Kernel.get(this, "attrProcessingJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProcessingJobStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrProcessingJobStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time that the processing job started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProcessingStartTime() {
        return software.amazon.jsii.Kernel.get(this, "attrProcessingStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the training job associated with this processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTrainingJobArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTrainingJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ProcessingJob resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.ProcessingJobReference getProcessingJobRef() {
        return software.amazon.jsii.Kernel.get(this, "processingJobRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sagemaker.ProcessingJobReference.class));
    }

    /**
     * Configuration to run a processing job in a specified container image.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.AppSpecificationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAppSpecification() {
        return software.amazon.jsii.Kernel.get(this, "appSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration to run a processing job in a specified container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppSpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "appSpecification", java.util.Objects.requireNonNull(value, "appSpecification is required"));
    }

    /**
     * Configuration to run a processing job in a specified container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppSpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnProcessingJob.AppSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "appSpecification", java.util.Objects.requireNonNull(value, "appSpecification is required"));
    }

    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingResourcesProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getProcessingResources() {
        return software.amazon.jsii.Kernel.get(this, "processingResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessingResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "processingResources", java.util.Objects.requireNonNull(value, "processingResources is required"));
    }

    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessingResources(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingResourcesProperty value) {
        software.amazon.jsii.Kernel.set(this, "processingResources", java.util.Objects.requireNonNull(value, "processingResources is required"));
    }

    /**
     * The ARN of the role used to create the processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the role used to create the processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * Sets the environment variables in the Docker container.
     * <p>
     * Returns union: either Map<String, {@link java.lang.String}> or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
        return software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Sets the environment variables in the Docker container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     * Sets the environment variables in the Docker container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironment(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "environment", value);
    }

    /**
     * Associates a SageMaker job as a trial component with an experiment and trial.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ExperimentConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExperimentConfig() {
        return software.amazon.jsii.Kernel.get(this, "experimentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Associates a SageMaker job as a trial component with an experiment and trial.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExperimentConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "experimentConfig", value);
    }

    /**
     * Associates a SageMaker job as a trial component with an experiment and trial.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExperimentConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ExperimentConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "experimentConfig", value);
    }

    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.NetworkConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
        return software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfig", value);
    }

    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnProcessingJob.NetworkConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfig", value);
    }

    /**
     * List of input configurations for the processing job.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingInputsObjectProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProcessingInputs() {
        return software.amazon.jsii.Kernel.get(this, "processingInputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * List of input configurations for the processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessingInputs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "processingInputs", value);
    }

    /**
     * List of input configurations for the processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessingInputs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingInputsObjectProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingInputsObjectProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "processingInputs", value);
    }

    /**
     * The name of the processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProcessingJobName() {
        return software.amazon.jsii.Kernel.get(this, "processingJobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the processing job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessingJobName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "processingJobName", value);
    }

    /**
     * Contains information about the output location for the compiled model and the target device that the model runs on.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingOutputConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProcessingOutputConfig() {
        return software.amazon.jsii.Kernel.get(this, "processingOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about the output location for the compiled model and the target device that the model runs on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessingOutputConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "processingOutputConfig", value);
    }

    /**
     * Contains information about the output location for the compiled model and the target device that the model runs on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProcessingOutputConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingOutputConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "processingOutputConfig", value);
    }

    /**
     * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.StoppingConditionProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
        return software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStoppingCondition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stoppingCondition", value);
    }

    /**
     * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStoppingCondition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnProcessingJob.StoppingConditionProperty value) {
        software.amazon.jsii.Kernel.set(this, "stoppingCondition", value);
    }

    /**
     * An array of key-value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Configuration to run a processing job in a specified container image.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AppSpecificationProperty appSpecificationProperty = AppSpecificationProperty.builder()
     *         .imageUri("imageUri")
     *         // the properties below are optional
     *         .containerArguments(List.of("containerArguments"))
     *         .containerEntrypoint(List.of("containerEntrypoint"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-appspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-appspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.AppSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(AppSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AppSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The container image to be run by the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-appspecification.html#cfn-sagemaker-processingjob-appspecification-imageuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-appspecification.html#cfn-sagemaker-processingjob-appspecification-imageuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

        /**
         * The arguments for a container used to run a processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-appspecification.html#cfn-sagemaker-processingjob-appspecification-containerarguments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-appspecification.html#cfn-sagemaker-processingjob-appspecification-containerarguments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerArguments() {
            return null;
        }

        /**
         * The entrypoint for a container used to run a processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-appspecification.html#cfn-sagemaker-processingjob-appspecification-containerentrypoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-appspecification.html#cfn-sagemaker-processingjob-appspecification-containerentrypoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerEntrypoint() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AppSpecificationProperty> {
            java.lang.String imageUri;
            java.util.List<java.lang.String> containerArguments;
            java.util.List<java.lang.String> containerEntrypoint;

            /**
             * Sets the value of {@link AppSpecificationProperty#getImageUri}
             * @param imageUri The container image to be run by the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Sets the value of {@link AppSpecificationProperty#getContainerArguments}
             * @param containerArguments The arguments for a container used to run a processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerArguments(java.util.List<java.lang.String> containerArguments) {
                this.containerArguments = containerArguments;
                return this;
            }

            /**
             * Sets the value of {@link AppSpecificationProperty#getContainerEntrypoint}
             * @param containerEntrypoint The entrypoint for a container used to run a processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerEntrypoint(java.util.List<java.lang.String> containerEntrypoint) {
                this.containerEntrypoint = containerEntrypoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AppSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AppSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppSpecificationProperty {
            private final java.lang.String imageUri;
            private final java.util.List<java.lang.String> containerArguments;
            private final java.util.List<java.lang.String> containerEntrypoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerArguments = software.amazon.jsii.Kernel.get(this, "containerArguments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containerEntrypoint = software.amazon.jsii.Kernel.get(this, "containerEntrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageUri = java.util.Objects.requireNonNull(builder.imageUri, "imageUri is required");
                this.containerArguments = builder.containerArguments;
                this.containerEntrypoint = builder.containerEntrypoint;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerArguments() {
                return this.containerArguments;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerEntrypoint() {
                return this.containerEntrypoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageUri", om.valueToTree(this.getImageUri()));
                if (this.getContainerArguments() != null) {
                    data.set("containerArguments", om.valueToTree(this.getContainerArguments()));
                }
                if (this.getContainerEntrypoint() != null) {
                    data.set("containerEntrypoint", om.valueToTree(this.getContainerEntrypoint()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.AppSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AppSpecificationProperty.Jsii$Proxy that = (AppSpecificationProperty.Jsii$Proxy) o;

                if (!imageUri.equals(that.imageUri)) return false;
                if (this.containerArguments != null ? !this.containerArguments.equals(that.containerArguments) : that.containerArguments != null) return false;
                return this.containerEntrypoint != null ? this.containerEntrypoint.equals(that.containerEntrypoint) : that.containerEntrypoint == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageUri.hashCode();
                result = 31 * result + (this.containerArguments != null ? this.containerArguments.hashCode() : 0);
                result = 31 * result + (this.containerEntrypoint != null ? this.containerEntrypoint.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for Athena Dataset Definition input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AthenaDatasetDefinitionProperty athenaDatasetDefinitionProperty = AthenaDatasetDefinitionProperty.builder()
     *         .catalog("catalog")
     *         .database("database")
     *         .outputFormat("outputFormat")
     *         .outputS3Uri("outputS3Uri")
     *         .queryString("queryString")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .outputCompression("outputCompression")
     *         .workGroup("workGroup")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.AthenaDatasetDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(AthenaDatasetDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AthenaDatasetDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the data catalog used in Athena query execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-catalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalog();

        /**
         * The name of the database used in the Athena query execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * The data storage format for Athena query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-outputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-outputformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputFormat();

        /**
         * The location in Amazon S3 where Athena query results are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-outputs3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-outputs3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputS3Uri();

        /**
         * The SQL query statements, to be executed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-querystring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueryString();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data generated from an Athena query execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The compression used for Athena query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-outputcompression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-outputcompression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputCompression() {
            return null;
        }

        /**
         * The name of the workgroup in which the Athena query is being started.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-workgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-athenadatasetdefinition.html#cfn-sagemaker-processingjob-athenadatasetdefinition-workgroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AthenaDatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AthenaDatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AthenaDatasetDefinitionProperty> {
            java.lang.String catalog;
            java.lang.String database;
            java.lang.String outputFormat;
            java.lang.String outputS3Uri;
            java.lang.String queryString;
            java.lang.String kmsKeyId;
            java.lang.String outputCompression;
            java.lang.String workGroup;

            /**
             * Sets the value of {@link AthenaDatasetDefinitionProperty#getCatalog}
             * @param catalog The name of the data catalog used in Athena query execution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.String catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link AthenaDatasetDefinitionProperty#getDatabase}
             * @param database The name of the database used in the Athena query execution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link AthenaDatasetDefinitionProperty#getOutputFormat}
             * @param outputFormat The data storage format for Athena query results. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormat(java.lang.String outputFormat) {
                this.outputFormat = outputFormat;
                return this;
            }

            /**
             * Sets the value of {@link AthenaDatasetDefinitionProperty#getOutputS3Uri}
             * @param outputS3Uri The location in Amazon S3 where Athena query results are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3Uri(java.lang.String outputS3Uri) {
                this.outputS3Uri = outputS3Uri;
                return this;
            }

            /**
             * Sets the value of {@link AthenaDatasetDefinitionProperty#getQueryString}
             * @param queryString The SQL query statements, to be executed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.String queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link AthenaDatasetDefinitionProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data generated from an Athena query execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link AthenaDatasetDefinitionProperty#getOutputCompression}
             * @param outputCompression The compression used for Athena query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputCompression(java.lang.String outputCompression) {
                this.outputCompression = outputCompression;
                return this;
            }

            /**
             * Sets the value of {@link AthenaDatasetDefinitionProperty#getWorkGroup}
             * @param workGroup The name of the workgroup in which the Athena query is being started.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workGroup(java.lang.String workGroup) {
                this.workGroup = workGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AthenaDatasetDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AthenaDatasetDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AthenaDatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AthenaDatasetDefinitionProperty {
            private final java.lang.String catalog;
            private final java.lang.String database;
            private final java.lang.String outputFormat;
            private final java.lang.String outputS3Uri;
            private final java.lang.String queryString;
            private final java.lang.String kmsKeyId;
            private final java.lang.String outputCompression;
            private final java.lang.String workGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputFormat = software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputS3Uri = software.amazon.jsii.Kernel.get(this, "outputS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputCompression = software.amazon.jsii.Kernel.get(this, "outputCompression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workGroup = software.amazon.jsii.Kernel.get(this, "workGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalog = java.util.Objects.requireNonNull(builder.catalog, "catalog is required");
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.outputFormat = java.util.Objects.requireNonNull(builder.outputFormat, "outputFormat is required");
                this.outputS3Uri = java.util.Objects.requireNonNull(builder.outputS3Uri, "outputS3Uri is required");
                this.queryString = java.util.Objects.requireNonNull(builder.queryString, "queryString is required");
                this.kmsKeyId = builder.kmsKeyId;
                this.outputCompression = builder.outputCompression;
                this.workGroup = builder.workGroup;
            }

            @Override
            public final java.lang.String getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getOutputFormat() {
                return this.outputFormat;
            }

            @Override
            public final java.lang.String getOutputS3Uri() {
                return this.outputS3Uri;
            }

            @Override
            public final java.lang.String getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getOutputCompression() {
                return this.outputCompression;
            }

            @Override
            public final java.lang.String getWorkGroup() {
                return this.workGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalog", om.valueToTree(this.getCatalog()));
                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("outputFormat", om.valueToTree(this.getOutputFormat()));
                data.set("outputS3Uri", om.valueToTree(this.getOutputS3Uri()));
                data.set("queryString", om.valueToTree(this.getQueryString()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getOutputCompression() != null) {
                    data.set("outputCompression", om.valueToTree(this.getOutputCompression()));
                }
                if (this.getWorkGroup() != null) {
                    data.set("workGroup", om.valueToTree(this.getWorkGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.AthenaDatasetDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AthenaDatasetDefinitionProperty.Jsii$Proxy that = (AthenaDatasetDefinitionProperty.Jsii$Proxy) o;

                if (!catalog.equals(that.catalog)) return false;
                if (!database.equals(that.database)) return false;
                if (!outputFormat.equals(that.outputFormat)) return false;
                if (!outputS3Uri.equals(that.outputS3Uri)) return false;
                if (!queryString.equals(that.queryString)) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.outputCompression != null ? !this.outputCompression.equals(that.outputCompression) : that.outputCompression != null) return false;
                return this.workGroup != null ? this.workGroup.equals(that.workGroup) : that.workGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalog.hashCode();
                result = 31 * result + (this.database.hashCode());
                result = 31 * result + (this.outputFormat.hashCode());
                result = 31 * result + (this.outputS3Uri.hashCode());
                result = 31 * result + (this.queryString.hashCode());
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.outputCompression != null ? this.outputCompression.hashCode() : 0);
                result = 31 * result + (this.workGroup != null ? this.workGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for the cluster used to run a processing job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterConfigProperty clusterConfigProperty = ClusterConfigProperty.builder()
     *         .instanceCount(123)
     *         .instanceType("instanceType")
     *         .volumeSizeInGb(123)
     *         // the properties below are optional
     *         .volumeKmsKeyId("volumeKmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ClusterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of ML compute instances to use in the processing job.
         * <p>
         * For distributed processing jobs, specify a value greater than 1. The default value is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html#cfn-sagemaker-processingjob-clusterconfig-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html#cfn-sagemaker-processingjob-clusterconfig-instancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The ML compute instance type for the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html#cfn-sagemaker-processingjob-clusterconfig-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html#cfn-sagemaker-processingjob-clusterconfig-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The size of the ML storage volume in gigabytes that you want to provision.
         * <p>
         * You must specify sufficient ML storage for your scenario.
         * <p>
         * <blockquote>
         * <p>
         * Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When using these instances for processing, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage. You can't request a <code>VolumeSizeInGB</code> greater than the total size of the local instance storage.
         * <p>
         * For a list of instance types that support local instance storage, including the total size per instance type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html#cfn-sagemaker-processingjob-clusterconfig-volumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html#cfn-sagemaker-processingjob-clusterconfig-volumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVolumeSizeInGb();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the processing job.
         * <p>
         * <blockquote>
         * <p>
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.
         * <p>
         * For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
         * <p>
         * For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html#cfn-sagemaker-processingjob-clusterconfig-volumekmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-clusterconfig.html#cfn-sagemaker-processingjob-clusterconfig-volumekmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterConfigProperty> {
            java.lang.Number instanceCount;
            java.lang.String instanceType;
            java.lang.Number volumeSizeInGb;
            java.lang.String volumeKmsKeyId;

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceCount}
             * @param instanceCount The number of ML compute instances to use in the processing job. This parameter is required.
             *                      For distributed processing jobs, specify a value greater than 1. The default value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceType}
             * @param instanceType The ML compute instance type for the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb The size of the ML storage volume in gigabytes that you want to provision. This parameter is required.
             *                       You must specify sufficient ML storage for your scenario.
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When using these instances for processing, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage. You can't request a <code>VolumeSizeInGB</code> greater than the total size of the local instance storage.
             *                       <p>
             *                       For a list of instance types that support local instance storage, including the total size per instance type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeKmsKeyId}
             * @param volumeKmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the processing job.
             *                       <blockquote>
             *                       <p>
             *                       Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can't request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.
             *                       <p>
             *                       For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a> .
             *                       <p>
             *                       For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeKmsKeyId(java.lang.String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterConfigProperty {
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Number volumeSizeInGb;
            private final java.lang.String volumeKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeKmsKeyId = software.amazon.jsii.Kernel.get(this, "volumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.volumeSizeInGb = java.util.Objects.requireNonNull(builder.volumeSizeInGb, "volumeSizeInGb is required");
                this.volumeKmsKeyId = builder.volumeKmsKeyId;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            public final java.lang.String getVolumeKmsKeyId() {
                return this.volumeKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                if (this.getVolumeKmsKeyId() != null) {
                    data.set("volumeKmsKeyId", om.valueToTree(this.getVolumeKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ClusterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterConfigProperty.Jsii$Proxy that = (ClusterConfigProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!volumeSizeInGb.equals(that.volumeSizeInGb)) return false;
                return this.volumeKmsKeyId != null ? this.volumeKmsKeyId.equals(that.volumeKmsKeyId) : that.volumeKmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.volumeSizeInGb.hashCode());
                result = 31 * result + (this.volumeKmsKeyId != null ? this.volumeKmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for Dataset Definition inputs.
     * <p>
     * The Dataset Definition input must specify exactly one of either <code>AthenaDatasetDefinition</code> or <code>RedshiftDatasetDefinition</code> types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DatasetDefinitionProperty datasetDefinitionProperty = DatasetDefinitionProperty.builder()
     *         .athenaDatasetDefinition(AthenaDatasetDefinitionProperty.builder()
     *                 .catalog("catalog")
     *                 .database("database")
     *                 .outputFormat("outputFormat")
     *                 .outputS3Uri("outputS3Uri")
     *                 .queryString("queryString")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .outputCompression("outputCompression")
     *                 .workGroup("workGroup")
     *                 .build())
     *         .dataDistributionType("dataDistributionType")
     *         .inputMode("inputMode")
     *         .localPath("localPath")
     *         .redshiftDatasetDefinition(RedshiftDatasetDefinitionProperty.builder()
     *                 .clusterId("clusterId")
     *                 .clusterRoleArn("clusterRoleArn")
     *                 .database("database")
     *                 .dbUser("dbUser")
     *                 .outputFormat("outputFormat")
     *                 .outputS3Uri("outputS3Uri")
     *                 .queryString("queryString")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .outputCompression("outputCompression")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.DatasetDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration for Athena Dataset Definition input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.AthenaDatasetDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-athenadatasetdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-athenadatasetdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAthenaDatasetDefinition() {
            return null;
        }

        /**
         * Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-datadistributiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-datadistributiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataDistributionType() {
            return null;
        }

        /**
         * Whether to use <code>File</code> or <code>Pipe</code> input mode.
         * <p>
         * In <code>File</code> (default) mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-inputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-inputmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputMode() {
            return null;
        }

        /**
         * The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing job.
         * <p>
         * <code>LocalPath</code> is an absolute path to the input data. This is a required parameter when <code>AppManaged</code> is <code>False</code> (default).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalPath() {
            return null;
        }

        /**
         * Configuration for Redshift Dataset Definition input.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.RedshiftDatasetDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-redshiftdatasetdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-datasetdefinition.html#cfn-sagemaker-processingjob-datasetdefinition-redshiftdatasetdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftDatasetDefinition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetDefinitionProperty> {
            java.lang.Object athenaDatasetDefinition;
            java.lang.String dataDistributionType;
            java.lang.String inputMode;
            java.lang.String localPath;
            java.lang.Object redshiftDatasetDefinition;

            /**
             * Sets the value of {@link DatasetDefinitionProperty#getAthenaDatasetDefinition}
             * @param athenaDatasetDefinition Configuration for Athena Dataset Definition input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaDatasetDefinition(software.amazon.awscdk.IResolvable athenaDatasetDefinition) {
                this.athenaDatasetDefinition = athenaDatasetDefinition;
                return this;
            }

            /**
             * Sets the value of {@link DatasetDefinitionProperty#getAthenaDatasetDefinition}
             * @param athenaDatasetDefinition Configuration for Athena Dataset Definition input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder athenaDatasetDefinition(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.AthenaDatasetDefinitionProperty athenaDatasetDefinition) {
                this.athenaDatasetDefinition = athenaDatasetDefinition;
                return this;
            }

            /**
             * Sets the value of {@link DatasetDefinitionProperty#getDataDistributionType}
             * @param dataDistributionType Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataDistributionType(java.lang.String dataDistributionType) {
                this.dataDistributionType = dataDistributionType;
                return this;
            }

            /**
             * Sets the value of {@link DatasetDefinitionProperty#getInputMode}
             * @param inputMode Whether to use <code>File</code> or <code>Pipe</code> input mode.
             *                  In <code>File</code> (default) mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputMode(java.lang.String inputMode) {
                this.inputMode = inputMode;
                return this;
            }

            /**
             * Sets the value of {@link DatasetDefinitionProperty#getLocalPath}
             * @param localPath The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing job.
             *                  <code>LocalPath</code> is an absolute path to the input data. This is a required parameter when <code>AppManaged</code> is <code>False</code> (default).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link DatasetDefinitionProperty#getRedshiftDatasetDefinition}
             * @param redshiftDatasetDefinition Configuration for Redshift Dataset Definition input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftDatasetDefinition(software.amazon.awscdk.IResolvable redshiftDatasetDefinition) {
                this.redshiftDatasetDefinition = redshiftDatasetDefinition;
                return this;
            }

            /**
             * Sets the value of {@link DatasetDefinitionProperty#getRedshiftDatasetDefinition}
             * @param redshiftDatasetDefinition Configuration for Redshift Dataset Definition input.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshiftDatasetDefinition(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.RedshiftDatasetDefinitionProperty redshiftDatasetDefinition) {
                this.redshiftDatasetDefinition = redshiftDatasetDefinition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetDefinitionProperty {
            private final java.lang.Object athenaDatasetDefinition;
            private final java.lang.String dataDistributionType;
            private final java.lang.String inputMode;
            private final java.lang.String localPath;
            private final java.lang.Object redshiftDatasetDefinition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.athenaDatasetDefinition = software.amazon.jsii.Kernel.get(this, "athenaDatasetDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataDistributionType = software.amazon.jsii.Kernel.get(this, "dataDistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputMode = software.amazon.jsii.Kernel.get(this, "inputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redshiftDatasetDefinition = software.amazon.jsii.Kernel.get(this, "redshiftDatasetDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.athenaDatasetDefinition = builder.athenaDatasetDefinition;
                this.dataDistributionType = builder.dataDistributionType;
                this.inputMode = builder.inputMode;
                this.localPath = builder.localPath;
                this.redshiftDatasetDefinition = builder.redshiftDatasetDefinition;
            }

            @Override
            public final java.lang.Object getAthenaDatasetDefinition() {
                return this.athenaDatasetDefinition;
            }

            @Override
            public final java.lang.String getDataDistributionType() {
                return this.dataDistributionType;
            }

            @Override
            public final java.lang.String getInputMode() {
                return this.inputMode;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.Object getRedshiftDatasetDefinition() {
                return this.redshiftDatasetDefinition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAthenaDatasetDefinition() != null) {
                    data.set("athenaDatasetDefinition", om.valueToTree(this.getAthenaDatasetDefinition()));
                }
                if (this.getDataDistributionType() != null) {
                    data.set("dataDistributionType", om.valueToTree(this.getDataDistributionType()));
                }
                if (this.getInputMode() != null) {
                    data.set("inputMode", om.valueToTree(this.getInputMode()));
                }
                if (this.getLocalPath() != null) {
                    data.set("localPath", om.valueToTree(this.getLocalPath()));
                }
                if (this.getRedshiftDatasetDefinition() != null) {
                    data.set("redshiftDatasetDefinition", om.valueToTree(this.getRedshiftDatasetDefinition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.DatasetDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetDefinitionProperty.Jsii$Proxy that = (DatasetDefinitionProperty.Jsii$Proxy) o;

                if (this.athenaDatasetDefinition != null ? !this.athenaDatasetDefinition.equals(that.athenaDatasetDefinition) : that.athenaDatasetDefinition != null) return false;
                if (this.dataDistributionType != null ? !this.dataDistributionType.equals(that.dataDistributionType) : that.dataDistributionType != null) return false;
                if (this.inputMode != null ? !this.inputMode.equals(that.inputMode) : that.inputMode != null) return false;
                if (this.localPath != null ? !this.localPath.equals(that.localPath) : that.localPath != null) return false;
                return this.redshiftDatasetDefinition != null ? this.redshiftDatasetDefinition.equals(that.redshiftDatasetDefinition) : that.redshiftDatasetDefinition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.athenaDatasetDefinition != null ? this.athenaDatasetDefinition.hashCode() : 0;
                result = 31 * result + (this.dataDistributionType != null ? this.dataDistributionType.hashCode() : 0);
                result = 31 * result + (this.inputMode != null ? this.inputMode.hashCode() : 0);
                result = 31 * result + (this.localPath != null ? this.localPath.hashCode() : 0);
                result = 31 * result + (this.redshiftDatasetDefinition != null ? this.redshiftDatasetDefinition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Associates a SageMaker job as a trial component with an experiment and trial.
     * <p>
     * Specified when you call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html">CreateProcessingJob</a> API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ExperimentConfigProperty experimentConfigProperty = ExperimentConfigProperty.builder()
     *         .experimentName("experimentName")
     *         .runName("runName")
     *         .trialComponentDisplayName("trialComponentDisplayName")
     *         .trialName("trialName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ExperimentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ExperimentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExperimentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an existing experiment to associate with the trial component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html#cfn-sagemaker-processingjob-experimentconfig-experimentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html#cfn-sagemaker-processingjob-experimentconfig-experimentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExperimentName() {
            return null;
        }

        /**
         * The name of the experiment run to associate with the trial component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html#cfn-sagemaker-processingjob-experimentconfig-runname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html#cfn-sagemaker-processingjob-experimentconfig-runname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRunName() {
            return null;
        }

        /**
         * The display name for the trial component.
         * <p>
         * If this key isn't specified, the display name is the trial component name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html#cfn-sagemaker-processingjob-experimentconfig-trialcomponentdisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html#cfn-sagemaker-processingjob-experimentconfig-trialcomponentdisplayname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrialComponentDisplayName() {
            return null;
        }

        /**
         * The name of an existing trial to associate the trial component with.
         * <p>
         * If not specified, a new trial is created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html#cfn-sagemaker-processingjob-experimentconfig-trialname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-experimentconfig.html#cfn-sagemaker-processingjob-experimentconfig-trialname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrialName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExperimentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExperimentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExperimentConfigProperty> {
            java.lang.String experimentName;
            java.lang.String runName;
            java.lang.String trialComponentDisplayName;
            java.lang.String trialName;

            /**
             * Sets the value of {@link ExperimentConfigProperty#getExperimentName}
             * @param experimentName The name of an existing experiment to associate with the trial component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder experimentName(java.lang.String experimentName) {
                this.experimentName = experimentName;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentConfigProperty#getRunName}
             * @param runName The name of the experiment run to associate with the trial component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runName(java.lang.String runName) {
                this.runName = runName;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentConfigProperty#getTrialComponentDisplayName}
             * @param trialComponentDisplayName The display name for the trial component.
             *                                  If this key isn't specified, the display name is the trial component name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trialComponentDisplayName(java.lang.String trialComponentDisplayName) {
                this.trialComponentDisplayName = trialComponentDisplayName;
                return this;
            }

            /**
             * Sets the value of {@link ExperimentConfigProperty#getTrialName}
             * @param trialName The name of an existing trial to associate the trial component with.
             *                  If not specified, a new trial is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trialName(java.lang.String trialName) {
                this.trialName = trialName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExperimentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExperimentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExperimentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExperimentConfigProperty {
            private final java.lang.String experimentName;
            private final java.lang.String runName;
            private final java.lang.String trialComponentDisplayName;
            private final java.lang.String trialName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.experimentName = software.amazon.jsii.Kernel.get(this, "experimentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runName = software.amazon.jsii.Kernel.get(this, "runName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trialComponentDisplayName = software.amazon.jsii.Kernel.get(this, "trialComponentDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trialName = software.amazon.jsii.Kernel.get(this, "trialName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.experimentName = builder.experimentName;
                this.runName = builder.runName;
                this.trialComponentDisplayName = builder.trialComponentDisplayName;
                this.trialName = builder.trialName;
            }

            @Override
            public final java.lang.String getExperimentName() {
                return this.experimentName;
            }

            @Override
            public final java.lang.String getRunName() {
                return this.runName;
            }

            @Override
            public final java.lang.String getTrialComponentDisplayName() {
                return this.trialComponentDisplayName;
            }

            @Override
            public final java.lang.String getTrialName() {
                return this.trialName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExperimentName() != null) {
                    data.set("experimentName", om.valueToTree(this.getExperimentName()));
                }
                if (this.getRunName() != null) {
                    data.set("runName", om.valueToTree(this.getRunName()));
                }
                if (this.getTrialComponentDisplayName() != null) {
                    data.set("trialComponentDisplayName", om.valueToTree(this.getTrialComponentDisplayName()));
                }
                if (this.getTrialName() != null) {
                    data.set("trialName", om.valueToTree(this.getTrialName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ExperimentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExperimentConfigProperty.Jsii$Proxy that = (ExperimentConfigProperty.Jsii$Proxy) o;

                if (this.experimentName != null ? !this.experimentName.equals(that.experimentName) : that.experimentName != null) return false;
                if (this.runName != null ? !this.runName.equals(that.runName) : that.runName != null) return false;
                if (this.trialComponentDisplayName != null ? !this.trialComponentDisplayName.equals(that.trialComponentDisplayName) : that.trialComponentDisplayName != null) return false;
                return this.trialName != null ? this.trialName.equals(that.trialName) : that.trialName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.experimentName != null ? this.experimentName.hashCode() : 0;
                result = 31 * result + (this.runName != null ? this.runName.hashCode() : 0);
                result = 31 * result + (this.trialComponentDisplayName != null ? this.trialComponentDisplayName.hashCode() : 0);
                result = 31 * result + (this.trialName != null ? this.trialName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for processing job outputs in Amazon SageMaker Feature Store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * FeatureStoreOutputProperty featureStoreOutputProperty = FeatureStoreOutputProperty.builder()
     *         .featureGroupName("featureGroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-featurestoreoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-featurestoreoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.FeatureStoreOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(FeatureStoreOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FeatureStoreOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output.
         * <p>
         * Note that your processing script is responsible for putting records into your Feature Store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-featurestoreoutput.html#cfn-sagemaker-processingjob-featurestoreoutput-featuregroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-featurestoreoutput.html#cfn-sagemaker-processingjob-featurestoreoutput-featuregroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeatureGroupName();

        /**
         * @return a {@link Builder} of {@link FeatureStoreOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FeatureStoreOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FeatureStoreOutputProperty> {
            java.lang.String featureGroupName;

            /**
             * Sets the value of {@link FeatureStoreOutputProperty#getFeatureGroupName}
             * @param featureGroupName The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output. This parameter is required.
             *                         Note that your processing script is responsible for putting records into your Feature Store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureGroupName(java.lang.String featureGroupName) {
                this.featureGroupName = featureGroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FeatureStoreOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FeatureStoreOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FeatureStoreOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FeatureStoreOutputProperty {
            private final java.lang.String featureGroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.featureGroupName = software.amazon.jsii.Kernel.get(this, "featureGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.featureGroupName = java.util.Objects.requireNonNull(builder.featureGroupName, "featureGroupName is required");
            }

            @Override
            public final java.lang.String getFeatureGroupName() {
                return this.featureGroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("featureGroupName", om.valueToTree(this.getFeatureGroupName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.FeatureStoreOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FeatureStoreOutputProperty.Jsii$Proxy that = (FeatureStoreOutputProperty.Jsii$Proxy) o;

                return this.featureGroupName.equals(that.featureGroupName);
            }

            @Override
            public final int hashCode() {
                int result = this.featureGroupName.hashCode();
                return result;
            }
        }
    }
    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * NetworkConfigProperty networkConfigProperty = NetworkConfigProperty.builder()
     *         .enableInterContainerTrafficEncryption(false)
     *         .enableNetworkIsolation(false)
     *         .vpcConfig(VpcConfigProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-networkconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-networkconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.NetworkConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to encrypt all communications between distributed processing jobs.
         * <p>
         * Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-networkconfig.html#cfn-sagemaker-processingjob-networkconfig-enableintercontainertrafficencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-networkconfig.html#cfn-sagemaker-processingjob-networkconfig-enableintercontainertrafficencryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableInterContainerTrafficEncryption() {
            return null;
        }

        /**
         * Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-networkconfig.html#cfn-sagemaker-processingjob-networkconfig-enablenetworkisolation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-networkconfig.html#cfn-sagemaker-processingjob-networkconfig-enablenetworkisolation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableNetworkIsolation() {
            return null;
        }

        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
         * <p>
         * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.VpcConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-networkconfig.html#cfn-sagemaker-processingjob-networkconfig-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-networkconfig.html#cfn-sagemaker-processingjob-networkconfig-vpcconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigProperty> {
            java.lang.Object enableInterContainerTrafficEncryption;
            java.lang.Object enableNetworkIsolation;
            java.lang.Object vpcConfig;

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption Whether to encrypt all communications between distributed processing jobs.
             *                                              Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(java.lang.Boolean enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption Whether to encrypt all communications between distributed processing jobs.
             *                                              Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(software.amazon.awscdk.IResolvable enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(java.lang.Boolean enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(software.amazon.awscdk.IResolvable enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
             *                  You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
             *                  You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.VpcConfigProperty vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigProperty {
            private final java.lang.Object enableInterContainerTrafficEncryption;
            private final java.lang.Object enableNetworkIsolation;
            private final java.lang.Object vpcConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableInterContainerTrafficEncryption = software.amazon.jsii.Kernel.get(this, "enableInterContainerTrafficEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableNetworkIsolation = software.amazon.jsii.Kernel.get(this, "enableNetworkIsolation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
                this.enableNetworkIsolation = builder.enableNetworkIsolation;
                this.vpcConfig = builder.vpcConfig;
            }

            @Override
            public final java.lang.Object getEnableInterContainerTrafficEncryption() {
                return this.enableInterContainerTrafficEncryption;
            }

            @Override
            public final java.lang.Object getEnableNetworkIsolation() {
                return this.enableNetworkIsolation;
            }

            @Override
            public final java.lang.Object getVpcConfig() {
                return this.vpcConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableInterContainerTrafficEncryption() != null) {
                    data.set("enableInterContainerTrafficEncryption", om.valueToTree(this.getEnableInterContainerTrafficEncryption()));
                }
                if (this.getEnableNetworkIsolation() != null) {
                    data.set("enableNetworkIsolation", om.valueToTree(this.getEnableNetworkIsolation()));
                }
                if (this.getVpcConfig() != null) {
                    data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.NetworkConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigProperty.Jsii$Proxy that = (NetworkConfigProperty.Jsii$Proxy) o;

                if (this.enableInterContainerTrafficEncryption != null ? !this.enableInterContainerTrafficEncryption.equals(that.enableInterContainerTrafficEncryption) : that.enableInterContainerTrafficEncryption != null) return false;
                if (this.enableNetworkIsolation != null ? !this.enableNetworkIsolation.equals(that.enableNetworkIsolation) : that.enableNetworkIsolation != null) return false;
                return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableInterContainerTrafficEncryption != null ? this.enableInterContainerTrafficEncryption.hashCode() : 0;
                result = 31 * result + (this.enableNetworkIsolation != null ? this.enableNetworkIsolation.hashCode() : 0);
                result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The inputs for a processing job.
     * <p>
     * The processing input must specify exactly one of either <code>S3Input</code> or <code>DatasetDefinition</code> types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ProcessingInputsObjectProperty processingInputsObjectProperty = ProcessingInputsObjectProperty.builder()
     *         .inputName("inputName")
     *         // the properties below are optional
     *         .appManaged(false)
     *         .datasetDefinition(DatasetDefinitionProperty.builder()
     *                 .athenaDatasetDefinition(AthenaDatasetDefinitionProperty.builder()
     *                         .catalog("catalog")
     *                         .database("database")
     *                         .outputFormat("outputFormat")
     *                         .outputS3Uri("outputS3Uri")
     *                         .queryString("queryString")
     *                         // the properties below are optional
     *                         .kmsKeyId("kmsKeyId")
     *                         .outputCompression("outputCompression")
     *                         .workGroup("workGroup")
     *                         .build())
     *                 .dataDistributionType("dataDistributionType")
     *                 .inputMode("inputMode")
     *                 .localPath("localPath")
     *                 .redshiftDatasetDefinition(RedshiftDatasetDefinitionProperty.builder()
     *                         .clusterId("clusterId")
     *                         .clusterRoleArn("clusterRoleArn")
     *                         .database("database")
     *                         .dbUser("dbUser")
     *                         .outputFormat("outputFormat")
     *                         .outputS3Uri("outputS3Uri")
     *                         .queryString("queryString")
     *                         // the properties below are optional
     *                         .kmsKeyId("kmsKeyId")
     *                         .outputCompression("outputCompression")
     *                         .build())
     *                 .build())
     *         .s3Input(S3InputProperty.builder()
     *                 .s3DataType("s3DataType")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .localPath("localPath")
     *                 .s3CompressionType("s3CompressionType")
     *                 .s3DataDistributionType("s3DataDistributionType")
     *                 .s3InputMode("s3InputMode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ProcessingInputsObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessingInputsObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessingInputsObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name for the processing job input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html#cfn-sagemaker-processingjob-processinginputsobject-inputname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html#cfn-sagemaker-processingjob-processinginputsobject-inputname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputName();

        /**
         * When <code>True</code> , input operations such as data download are managed natively by the processing job application.
         * <p>
         * When <code>False</code> (default), input operations are managed by Amazon SageMaker.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html#cfn-sagemaker-processingjob-processinginputsobject-appmanaged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html#cfn-sagemaker-processingjob-processinginputsobject-appmanaged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppManaged() {
            return null;
        }

        /**
         * Configuration for Dataset Definition inputs.
         * <p>
         * The Dataset Definition input must specify exactly one of either <code>AthenaDatasetDefinition</code> or <code>RedshiftDatasetDefinition</code> types.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.DatasetDefinitionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html#cfn-sagemaker-processingjob-processinginputsobject-datasetdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html#cfn-sagemaker-processingjob-processinginputsobject-datasetdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatasetDefinition() {
            return null;
        }

        /**
         * Configuration for downloading input data from Amazon S3 into the processing container.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.S3InputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html#cfn-sagemaker-processingjob-processinginputsobject-s3input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processinginputsobject.html#cfn-sagemaker-processingjob-processinginputsobject-s3input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Input() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessingInputsObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessingInputsObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessingInputsObjectProperty> {
            java.lang.String inputName;
            java.lang.Object appManaged;
            java.lang.Object datasetDefinition;
            java.lang.Object s3Input;

            /**
             * Sets the value of {@link ProcessingInputsObjectProperty#getInputName}
             * @param inputName The name for the processing job input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputName(java.lang.String inputName) {
                this.inputName = inputName;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingInputsObjectProperty#getAppManaged}
             * @param appManaged When <code>True</code> , input operations such as data download are managed natively by the processing job application.
             *                   When <code>False</code> (default), input operations are managed by Amazon SageMaker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appManaged(java.lang.Boolean appManaged) {
                this.appManaged = appManaged;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingInputsObjectProperty#getAppManaged}
             * @param appManaged When <code>True</code> , input operations such as data download are managed natively by the processing job application.
             *                   When <code>False</code> (default), input operations are managed by Amazon SageMaker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appManaged(software.amazon.awscdk.IResolvable appManaged) {
                this.appManaged = appManaged;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingInputsObjectProperty#getDatasetDefinition}
             * @param datasetDefinition Configuration for Dataset Definition inputs.
             *                          The Dataset Definition input must specify exactly one of either <code>AthenaDatasetDefinition</code> or <code>RedshiftDatasetDefinition</code> types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetDefinition(software.amazon.awscdk.IResolvable datasetDefinition) {
                this.datasetDefinition = datasetDefinition;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingInputsObjectProperty#getDatasetDefinition}
             * @param datasetDefinition Configuration for Dataset Definition inputs.
             *                          The Dataset Definition input must specify exactly one of either <code>AthenaDatasetDefinition</code> or <code>RedshiftDatasetDefinition</code> types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetDefinition(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.DatasetDefinitionProperty datasetDefinition) {
                this.datasetDefinition = datasetDefinition;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingInputsObjectProperty#getS3Input}
             * @param s3Input Configuration for downloading input data from Amazon S3 into the processing container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Input(software.amazon.awscdk.IResolvable s3Input) {
                this.s3Input = s3Input;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingInputsObjectProperty#getS3Input}
             * @param s3Input Configuration for downloading input data from Amazon S3 into the processing container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Input(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.S3InputProperty s3Input) {
                this.s3Input = s3Input;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessingInputsObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessingInputsObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessingInputsObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessingInputsObjectProperty {
            private final java.lang.String inputName;
            private final java.lang.Object appManaged;
            private final java.lang.Object datasetDefinition;
            private final java.lang.Object s3Input;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputName = software.amazon.jsii.Kernel.get(this, "inputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.appManaged = software.amazon.jsii.Kernel.get(this, "appManaged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datasetDefinition = software.amazon.jsii.Kernel.get(this, "datasetDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Input = software.amazon.jsii.Kernel.get(this, "s3Input", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputName = java.util.Objects.requireNonNull(builder.inputName, "inputName is required");
                this.appManaged = builder.appManaged;
                this.datasetDefinition = builder.datasetDefinition;
                this.s3Input = builder.s3Input;
            }

            @Override
            public final java.lang.String getInputName() {
                return this.inputName;
            }

            @Override
            public final java.lang.Object getAppManaged() {
                return this.appManaged;
            }

            @Override
            public final java.lang.Object getDatasetDefinition() {
                return this.datasetDefinition;
            }

            @Override
            public final java.lang.Object getS3Input() {
                return this.s3Input;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputName", om.valueToTree(this.getInputName()));
                if (this.getAppManaged() != null) {
                    data.set("appManaged", om.valueToTree(this.getAppManaged()));
                }
                if (this.getDatasetDefinition() != null) {
                    data.set("datasetDefinition", om.valueToTree(this.getDatasetDefinition()));
                }
                if (this.getS3Input() != null) {
                    data.set("s3Input", om.valueToTree(this.getS3Input()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ProcessingInputsObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessingInputsObjectProperty.Jsii$Proxy that = (ProcessingInputsObjectProperty.Jsii$Proxy) o;

                if (!inputName.equals(that.inputName)) return false;
                if (this.appManaged != null ? !this.appManaged.equals(that.appManaged) : that.appManaged != null) return false;
                if (this.datasetDefinition != null ? !this.datasetDefinition.equals(that.datasetDefinition) : that.datasetDefinition != null) return false;
                return this.s3Input != null ? this.s3Input.equals(that.s3Input) : that.s3Input == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inputName.hashCode();
                result = 31 * result + (this.appManaged != null ? this.appManaged.hashCode() : 0);
                result = 31 * result + (this.datasetDefinition != null ? this.datasetDefinition.hashCode() : 0);
                result = 31 * result + (this.s3Input != null ? this.s3Input.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for uploading output from the processing container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ProcessingOutputConfigProperty processingOutputConfigProperty = ProcessingOutputConfigProperty.builder()
     *         .outputs(List.of(ProcessingOutputsObjectProperty.builder()
     *                 .outputName("outputName")
     *                 // the properties below are optional
     *                 .appManaged(false)
     *                 .featureStoreOutput(FeatureStoreOutputProperty.builder()
     *                         .featureGroupName("featureGroupName")
     *                         .build())
     *                 .s3Output(S3OutputProperty.builder()
     *                         .s3UploadMode("s3UploadMode")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .localPath("localPath")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ProcessingOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessingOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessingOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of outputs configuring the data to upload from the processing container.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingOutputsObjectProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputconfig.html#cfn-sagemaker-processingjob-processingoutputconfig-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputconfig.html#cfn-sagemaker-processingjob-processingoutputconfig-outputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutputs();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the processing job output.
         * <p>
         * <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputconfig.html#cfn-sagemaker-processingjob-processingoutputconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputconfig.html#cfn-sagemaker-processingjob-processingoutputconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessingOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessingOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessingOutputConfigProperty> {
            java.lang.Object outputs;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link ProcessingOutputConfigProperty#getOutputs}
             * @param outputs An array of outputs configuring the data to upload from the processing container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputs(software.amazon.awscdk.IResolvable outputs) {
                this.outputs = outputs;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingOutputConfigProperty#getOutputs}
             * @param outputs An array of outputs configuring the data to upload from the processing container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputs(java.util.List<? extends java.lang.Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingOutputConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt the processing job output.
             *                 <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessingOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessingOutputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessingOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessingOutputConfigProperty {
            private final java.lang.Object outputs;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputs = java.util.Objects.requireNonNull(builder.outputs, "outputs is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getOutputs() {
                return this.outputs;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputs", om.valueToTree(this.getOutputs()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ProcessingOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessingOutputConfigProperty.Jsii$Proxy that = (ProcessingOutputConfigProperty.Jsii$Proxy) o;

                if (!outputs.equals(that.outputs)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputs.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the results of a processing job.
     * <p>
     * The processing output must specify exactly one of either <code>S3Output</code> or <code>FeatureStoreOutput</code> types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ProcessingOutputsObjectProperty processingOutputsObjectProperty = ProcessingOutputsObjectProperty.builder()
     *         .outputName("outputName")
     *         // the properties below are optional
     *         .appManaged(false)
     *         .featureStoreOutput(FeatureStoreOutputProperty.builder()
     *                 .featureGroupName("featureGroupName")
     *                 .build())
     *         .s3Output(S3OutputProperty.builder()
     *                 .s3UploadMode("s3UploadMode")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .localPath("localPath")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ProcessingOutputsObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessingOutputsObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessingOutputsObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name for the processing job output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html#cfn-sagemaker-processingjob-processingoutputsobject-outputname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html#cfn-sagemaker-processingjob-processingoutputsobject-outputname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputName();

        /**
         * When <code>True</code> , output operations such as data upload are managed natively by the processing job application.
         * <p>
         * When <code>False</code> (default), output operations are managed by Amazon SageMaker.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html#cfn-sagemaker-processingjob-processingoutputsobject-appmanaged">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html#cfn-sagemaker-processingjob-processingoutputsobject-appmanaged</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppManaged() {
            return null;
        }

        /**
         * Configuration for processing job outputs in Amazon SageMaker Feature Store.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.FeatureStoreOutputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html#cfn-sagemaker-processingjob-processingoutputsobject-featurestoreoutput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html#cfn-sagemaker-processingjob-processingoutputsobject-featurestoreoutput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFeatureStoreOutput() {
            return null;
        }

        /**
         * Configuration for uploading output data to Amazon S3 from the processing container.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.S3OutputProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html#cfn-sagemaker-processingjob-processingoutputsobject-s3output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingoutputsobject.html#cfn-sagemaker-processingjob-processingoutputsobject-s3output</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Output() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessingOutputsObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessingOutputsObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessingOutputsObjectProperty> {
            java.lang.String outputName;
            java.lang.Object appManaged;
            java.lang.Object featureStoreOutput;
            java.lang.Object s3Output;

            /**
             * Sets the value of {@link ProcessingOutputsObjectProperty#getOutputName}
             * @param outputName The name for the processing job output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputName(java.lang.String outputName) {
                this.outputName = outputName;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingOutputsObjectProperty#getAppManaged}
             * @param appManaged When <code>True</code> , output operations such as data upload are managed natively by the processing job application.
             *                   When <code>False</code> (default), output operations are managed by Amazon SageMaker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appManaged(java.lang.Boolean appManaged) {
                this.appManaged = appManaged;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingOutputsObjectProperty#getAppManaged}
             * @param appManaged When <code>True</code> , output operations such as data upload are managed natively by the processing job application.
             *                   When <code>False</code> (default), output operations are managed by Amazon SageMaker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appManaged(software.amazon.awscdk.IResolvable appManaged) {
                this.appManaged = appManaged;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingOutputsObjectProperty#getFeatureStoreOutput}
             * @param featureStoreOutput Configuration for processing job outputs in Amazon SageMaker Feature Store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureStoreOutput(software.amazon.awscdk.IResolvable featureStoreOutput) {
                this.featureStoreOutput = featureStoreOutput;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingOutputsObjectProperty#getFeatureStoreOutput}
             * @param featureStoreOutput Configuration for processing job outputs in Amazon SageMaker Feature Store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureStoreOutput(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.FeatureStoreOutputProperty featureStoreOutput) {
                this.featureStoreOutput = featureStoreOutput;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingOutputsObjectProperty#getS3Output}
             * @param s3Output Configuration for uploading output data to Amazon S3 from the processing container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.IResolvable s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingOutputsObjectProperty#getS3Output}
             * @param s3Output Configuration for uploading output data to Amazon S3 from the processing container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.S3OutputProperty s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessingOutputsObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessingOutputsObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessingOutputsObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessingOutputsObjectProperty {
            private final java.lang.String outputName;
            private final java.lang.Object appManaged;
            private final java.lang.Object featureStoreOutput;
            private final java.lang.Object s3Output;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.outputName = software.amazon.jsii.Kernel.get(this, "outputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.appManaged = software.amazon.jsii.Kernel.get(this, "appManaged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.featureStoreOutput = software.amazon.jsii.Kernel.get(this, "featureStoreOutput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Output = software.amazon.jsii.Kernel.get(this, "s3Output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.outputName = java.util.Objects.requireNonNull(builder.outputName, "outputName is required");
                this.appManaged = builder.appManaged;
                this.featureStoreOutput = builder.featureStoreOutput;
                this.s3Output = builder.s3Output;
            }

            @Override
            public final java.lang.String getOutputName() {
                return this.outputName;
            }

            @Override
            public final java.lang.Object getAppManaged() {
                return this.appManaged;
            }

            @Override
            public final java.lang.Object getFeatureStoreOutput() {
                return this.featureStoreOutput;
            }

            @Override
            public final java.lang.Object getS3Output() {
                return this.s3Output;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("outputName", om.valueToTree(this.getOutputName()));
                if (this.getAppManaged() != null) {
                    data.set("appManaged", om.valueToTree(this.getAppManaged()));
                }
                if (this.getFeatureStoreOutput() != null) {
                    data.set("featureStoreOutput", om.valueToTree(this.getFeatureStoreOutput()));
                }
                if (this.getS3Output() != null) {
                    data.set("s3Output", om.valueToTree(this.getS3Output()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ProcessingOutputsObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessingOutputsObjectProperty.Jsii$Proxy that = (ProcessingOutputsObjectProperty.Jsii$Proxy) o;

                if (!outputName.equals(that.outputName)) return false;
                if (this.appManaged != null ? !this.appManaged.equals(that.appManaged) : that.appManaged != null) return false;
                if (this.featureStoreOutput != null ? !this.featureStoreOutput.equals(that.featureStoreOutput) : that.featureStoreOutput != null) return false;
                return this.s3Output != null ? this.s3Output.equals(that.s3Output) : that.s3Output == null;
            }

            @Override
            public final int hashCode() {
                int result = this.outputName.hashCode();
                result = 31 * result + (this.appManaged != null ? this.appManaged.hashCode() : 0);
                result = 31 * result + (this.featureStoreOutput != null ? this.featureStoreOutput.hashCode() : 0);
                result = 31 * result + (this.s3Output != null ? this.s3Output.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
     * <p>
     * In distributed training, you specify more than one instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ProcessingResourcesProperty processingResourcesProperty = ProcessingResourcesProperty.builder()
     *         .clusterConfig(ClusterConfigProperty.builder()
     *                 .instanceCount(123)
     *                 .instanceType("instanceType")
     *                 .volumeSizeInGb(123)
     *                 // the properties below are optional
     *                 .volumeKmsKeyId("volumeKmsKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingresources.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingresources.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ProcessingResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessingResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessingResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for the resources in a cluster used to run the processing job.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ClusterConfigProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingresources.html#cfn-sagemaker-processingjob-processingresources-clusterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-processingresources.html#cfn-sagemaker-processingjob-processingresources-clusterconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClusterConfig();

        /**
         * @return a {@link Builder} of {@link ProcessingResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessingResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessingResourcesProperty> {
            java.lang.Object clusterConfig;

            /**
             * Sets the value of {@link ProcessingResourcesProperty#getClusterConfig}
             * @param clusterConfig The configuration for the resources in a cluster used to run the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.IResolvable clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingResourcesProperty#getClusterConfig}
             * @param clusterConfig The configuration for the resources in a cluster used to run the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ClusterConfigProperty clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessingResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessingResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessingResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessingResourcesProperty {
            private final java.lang.Object clusterConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterConfig = software.amazon.jsii.Kernel.get(this, "clusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterConfig = java.util.Objects.requireNonNull(builder.clusterConfig, "clusterConfig is required");
            }

            @Override
            public final java.lang.Object getClusterConfig() {
                return this.clusterConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterConfig", om.valueToTree(this.getClusterConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.ProcessingResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessingResourcesProperty.Jsii$Proxy that = (ProcessingResourcesProperty.Jsii$Proxy) o;

                return this.clusterConfig.equals(that.clusterConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration for Redshift Dataset Definition input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * RedshiftDatasetDefinitionProperty redshiftDatasetDefinitionProperty = RedshiftDatasetDefinitionProperty.builder()
     *         .clusterId("clusterId")
     *         .clusterRoleArn("clusterRoleArn")
     *         .database("database")
     *         .dbUser("dbUser")
     *         .outputFormat("outputFormat")
     *         .outputS3Uri("outputS3Uri")
     *         .queryString("queryString")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .outputCompression("outputCompression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.RedshiftDatasetDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftDatasetDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftDatasetDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Redshift cluster Identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-clusterid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-clusterid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterId();

        /**
         * The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-clusterrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-clusterrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterRoleArn();

        /**
         * The name of the Redshift database used in Redshift query execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * The database user name used in Redshift query execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-dbuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-dbuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDbUser();

        /**
         * The data storage format for Redshift query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-outputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-outputformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputFormat();

        /**
         * The location in Amazon S3 where the Redshift query results are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-outputs3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-outputs3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputS3Uri();

        /**
         * The SQL query statements to be executed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-querystring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQueryString();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data from a Redshift execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The compression used for Redshift query results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-outputcompression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-redshiftdatasetdefinition.html#cfn-sagemaker-processingjob-redshiftdatasetdefinition-outputcompression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputCompression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftDatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftDatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftDatasetDefinitionProperty> {
            java.lang.String clusterId;
            java.lang.String clusterRoleArn;
            java.lang.String database;
            java.lang.String dbUser;
            java.lang.String outputFormat;
            java.lang.String outputS3Uri;
            java.lang.String queryString;
            java.lang.String kmsKeyId;
            java.lang.String outputCompression;

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getClusterId}
             * @param clusterId The Redshift cluster Identifier. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterId(java.lang.String clusterId) {
                this.clusterId = clusterId;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getClusterRoleArn}
             * @param clusterRoleArn The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterRoleArn(java.lang.String clusterRoleArn) {
                this.clusterRoleArn = clusterRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getDatabase}
             * @param database The name of the Redshift database used in Redshift query execution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getDbUser}
             * @param dbUser The database user name used in Redshift query execution. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbUser(java.lang.String dbUser) {
                this.dbUser = dbUser;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getOutputFormat}
             * @param outputFormat The data storage format for Redshift query results. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormat(java.lang.String outputFormat) {
                this.outputFormat = outputFormat;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getOutputS3Uri}
             * @param outputS3Uri The location in Amazon S3 where the Redshift query results are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputS3Uri(java.lang.String outputS3Uri) {
                this.outputS3Uri = outputS3Uri;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getQueryString}
             * @param queryString The SQL query statements to be executed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.String queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data from a Redshift execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDatasetDefinitionProperty#getOutputCompression}
             * @param outputCompression The compression used for Redshift query results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputCompression(java.lang.String outputCompression) {
                this.outputCompression = outputCompression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftDatasetDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftDatasetDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftDatasetDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftDatasetDefinitionProperty {
            private final java.lang.String clusterId;
            private final java.lang.String clusterRoleArn;
            private final java.lang.String database;
            private final java.lang.String dbUser;
            private final java.lang.String outputFormat;
            private final java.lang.String outputS3Uri;
            private final java.lang.String queryString;
            private final java.lang.String kmsKeyId;
            private final java.lang.String outputCompression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterId = software.amazon.jsii.Kernel.get(this, "clusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clusterRoleArn = software.amazon.jsii.Kernel.get(this, "clusterRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbUser = software.amazon.jsii.Kernel.get(this, "dbUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputFormat = software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputS3Uri = software.amazon.jsii.Kernel.get(this, "outputS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputCompression = software.amazon.jsii.Kernel.get(this, "outputCompression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterId = java.util.Objects.requireNonNull(builder.clusterId, "clusterId is required");
                this.clusterRoleArn = java.util.Objects.requireNonNull(builder.clusterRoleArn, "clusterRoleArn is required");
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.dbUser = java.util.Objects.requireNonNull(builder.dbUser, "dbUser is required");
                this.outputFormat = java.util.Objects.requireNonNull(builder.outputFormat, "outputFormat is required");
                this.outputS3Uri = java.util.Objects.requireNonNull(builder.outputS3Uri, "outputS3Uri is required");
                this.queryString = java.util.Objects.requireNonNull(builder.queryString, "queryString is required");
                this.kmsKeyId = builder.kmsKeyId;
                this.outputCompression = builder.outputCompression;
            }

            @Override
            public final java.lang.String getClusterId() {
                return this.clusterId;
            }

            @Override
            public final java.lang.String getClusterRoleArn() {
                return this.clusterRoleArn;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getDbUser() {
                return this.dbUser;
            }

            @Override
            public final java.lang.String getOutputFormat() {
                return this.outputFormat;
            }

            @Override
            public final java.lang.String getOutputS3Uri() {
                return this.outputS3Uri;
            }

            @Override
            public final java.lang.String getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getOutputCompression() {
                return this.outputCompression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterId", om.valueToTree(this.getClusterId()));
                data.set("clusterRoleArn", om.valueToTree(this.getClusterRoleArn()));
                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("dbUser", om.valueToTree(this.getDbUser()));
                data.set("outputFormat", om.valueToTree(this.getOutputFormat()));
                data.set("outputS3Uri", om.valueToTree(this.getOutputS3Uri()));
                data.set("queryString", om.valueToTree(this.getQueryString()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getOutputCompression() != null) {
                    data.set("outputCompression", om.valueToTree(this.getOutputCompression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.RedshiftDatasetDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftDatasetDefinitionProperty.Jsii$Proxy that = (RedshiftDatasetDefinitionProperty.Jsii$Proxy) o;

                if (!clusterId.equals(that.clusterId)) return false;
                if (!clusterRoleArn.equals(that.clusterRoleArn)) return false;
                if (!database.equals(that.database)) return false;
                if (!dbUser.equals(that.dbUser)) return false;
                if (!outputFormat.equals(that.outputFormat)) return false;
                if (!outputS3Uri.equals(that.outputS3Uri)) return false;
                if (!queryString.equals(that.queryString)) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                return this.outputCompression != null ? this.outputCompression.equals(that.outputCompression) : that.outputCompression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterId.hashCode();
                result = 31 * result + (this.clusterRoleArn.hashCode());
                result = 31 * result + (this.database.hashCode());
                result = 31 * result + (this.dbUser.hashCode());
                result = 31 * result + (this.outputFormat.hashCode());
                result = 31 * result + (this.outputS3Uri.hashCode());
                result = 31 * result + (this.queryString.hashCode());
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.outputCompression != null ? this.outputCompression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for downloading input data from Amazon S3 into the processing container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * S3InputProperty s3InputProperty = S3InputProperty.builder()
     *         .s3DataType("s3DataType")
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .localPath("localPath")
     *         .s3CompressionType("s3CompressionType")
     *         .s3DataDistributionType("s3DataDistributionType")
     *         .s3InputMode("s3InputMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.S3InputProperty")
    @software.amazon.jsii.Jsii.Proxy(S3InputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3InputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type.
         * <p>
         * If you choose <code>S3Prefix</code> , <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code> , <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3datatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3DataType();

        /**
         * The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run a processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * The local path in your container where you want Amazon SageMaker to write input data to.
         * <p>
         * <code>LocalPath</code> is an absolute path to the input data and must begin with <code>/opt/ml/processing/</code> . <code>LocalPath</code> is a required parameter when <code>AppManaged</code> is <code>False</code> (default).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalPath() {
            return null;
        }

        /**
         * Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the processing container.
         * <p>
         * <code>Gzip</code> can only be used when <code>Pipe</code> mode is specified as the <code>S3InputMode</code> . In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your container without using the EBS volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3compressiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3compressiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3CompressionType() {
            return null;
        }

        /**
         * Whether to distribute the data from Amazon S3 to all processing instances with <code>FullyReplicated</code> , or whether the data from Amazon S3 is sharded by Amazon S3 key, downloading one shard of data to each processing instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3datadistributiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3datadistributiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3DataDistributionType() {
            return null;
        }

        /**
         * Whether to use <code>File</code> or <code>Pipe</code> input mode.
         * <p>
         * In File mode, Amazon SageMaker copies the data from the input source onto the local ML storage volume before starting your processing container. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your processing container into named pipes without using the ML storage volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3inputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3input.html#cfn-sagemaker-processingjob-s3input-s3inputmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3InputProperty> {
            java.lang.String s3DataType;
            java.lang.String s3Uri;
            java.lang.String localPath;
            java.lang.String s3CompressionType;
            java.lang.String s3DataDistributionType;
            java.lang.String s3InputMode;

            /**
             * Sets the value of {@link S3InputProperty#getS3DataType}
             * @param s3DataType Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. This parameter is required.
             *                   If you choose <code>S3Prefix</code> , <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code> , <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataType(java.lang.String s3DataType) {
                this.s3DataType = s3DataType;
                return this;
            }

            /**
             * Sets the value of {@link S3InputProperty#getS3Uri}
             * @param s3Uri The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run a processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link S3InputProperty#getLocalPath}
             * @param localPath The local path in your container where you want Amazon SageMaker to write input data to.
             *                  <code>LocalPath</code> is an absolute path to the input data and must begin with <code>/opt/ml/processing/</code> . <code>LocalPath</code> is a required parameter when <code>AppManaged</code> is <code>False</code> (default).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link S3InputProperty#getS3CompressionType}
             * @param s3CompressionType Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the processing container.
             *                          <code>Gzip</code> can only be used when <code>Pipe</code> mode is specified as the <code>S3InputMode</code> . In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your container without using the EBS volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3CompressionType(java.lang.String s3CompressionType) {
                this.s3CompressionType = s3CompressionType;
                return this;
            }

            /**
             * Sets the value of {@link S3InputProperty#getS3DataDistributionType}
             * @param s3DataDistributionType Whether to distribute the data from Amazon S3 to all processing instances with <code>FullyReplicated</code> , or whether the data from Amazon S3 is sharded by Amazon S3 key, downloading one shard of data to each processing instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataDistributionType(java.lang.String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            /**
             * Sets the value of {@link S3InputProperty#getS3InputMode}
             * @param s3InputMode Whether to use <code>File</code> or <code>Pipe</code> input mode.
             *                    In File mode, Amazon SageMaker copies the data from the input source onto the local ML storage volume before starting your processing container. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your processing container into named pipes without using the ML storage volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputMode(java.lang.String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3InputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3InputProperty {
            private final java.lang.String s3DataType;
            private final java.lang.String s3Uri;
            private final java.lang.String localPath;
            private final java.lang.String s3CompressionType;
            private final java.lang.String s3DataDistributionType;
            private final java.lang.String s3InputMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3DataType = software.amazon.jsii.Kernel.get(this, "s3DataType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3CompressionType = software.amazon.jsii.Kernel.get(this, "s3CompressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3DataDistributionType = software.amazon.jsii.Kernel.get(this, "s3DataDistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputMode = software.amazon.jsii.Kernel.get(this, "s3InputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3DataType = java.util.Objects.requireNonNull(builder.s3DataType, "s3DataType is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.localPath = builder.localPath;
                this.s3CompressionType = builder.s3CompressionType;
                this.s3DataDistributionType = builder.s3DataDistributionType;
                this.s3InputMode = builder.s3InputMode;
            }

            @Override
            public final java.lang.String getS3DataType() {
                return this.s3DataType;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getS3CompressionType() {
                return this.s3CompressionType;
            }

            @Override
            public final java.lang.String getS3DataDistributionType() {
                return this.s3DataDistributionType;
            }

            @Override
            public final java.lang.String getS3InputMode() {
                return this.s3InputMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3DataType", om.valueToTree(this.getS3DataType()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getLocalPath() != null) {
                    data.set("localPath", om.valueToTree(this.getLocalPath()));
                }
                if (this.getS3CompressionType() != null) {
                    data.set("s3CompressionType", om.valueToTree(this.getS3CompressionType()));
                }
                if (this.getS3DataDistributionType() != null) {
                    data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
                }
                if (this.getS3InputMode() != null) {
                    data.set("s3InputMode", om.valueToTree(this.getS3InputMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.S3InputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3InputProperty.Jsii$Proxy that = (S3InputProperty.Jsii$Proxy) o;

                if (!s3DataType.equals(that.s3DataType)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                if (this.localPath != null ? !this.localPath.equals(that.localPath) : that.localPath != null) return false;
                if (this.s3CompressionType != null ? !this.s3CompressionType.equals(that.s3CompressionType) : that.s3CompressionType != null) return false;
                if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
                return this.s3InputMode != null ? this.s3InputMode.equals(that.s3InputMode) : that.s3InputMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3DataType.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.localPath != null ? this.localPath.hashCode() : 0);
                result = 31 * result + (this.s3CompressionType != null ? this.s3CompressionType.hashCode() : 0);
                result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
                result = 31 * result + (this.s3InputMode != null ? this.s3InputMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for uploading output data to Amazon S3 from the processing container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * S3OutputProperty s3OutputProperty = S3OutputProperty.builder()
     *         .s3UploadMode("s3UploadMode")
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .localPath("localPath")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3output.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3output.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.S3OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to upload the results of the processing job continuously or after the job completes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3output.html#cfn-sagemaker-processingjob-s3output-s3uploadmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3output.html#cfn-sagemaker-processingjob-s3output-s3uploadmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3UploadMode();

        /**
         * The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run a processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3output.html#cfn-sagemaker-processingjob-s3output-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3output.html#cfn-sagemaker-processingjob-s3output-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * The local path of a directory where you want Amazon SageMaker to upload its contents to Amazon S3.
         * <p>
         * <code>LocalPath</code> is an absolute path to a directory containing output files. This directory will be created by the platform and exist when your container's entrypoint is invoked.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3output.html#cfn-sagemaker-processingjob-s3output-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-s3output.html#cfn-sagemaker-processingjob-s3output-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputProperty> {
            java.lang.String s3UploadMode;
            java.lang.String s3Uri;
            java.lang.String localPath;

            /**
             * Sets the value of {@link S3OutputProperty#getS3UploadMode}
             * @param s3UploadMode Whether to upload the results of the processing job continuously or after the job completes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3UploadMode(java.lang.String s3UploadMode) {
                this.s3UploadMode = s3UploadMode;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3Uri}
             * @param s3Uri The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run a processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getLocalPath}
             * @param localPath The local path of a directory where you want Amazon SageMaker to upload its contents to Amazon S3.
             *                  <code>LocalPath</code> is an absolute path to a directory containing output files. This directory will be created by the platform and exist when your container's entrypoint is invoked.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputProperty {
            private final java.lang.String s3UploadMode;
            private final java.lang.String s3Uri;
            private final java.lang.String localPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3UploadMode = software.amazon.jsii.Kernel.get(this, "s3UploadMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3UploadMode = java.util.Objects.requireNonNull(builder.s3UploadMode, "s3UploadMode is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.localPath = builder.localPath;
            }

            @Override
            public final java.lang.String getS3UploadMode() {
                return this.s3UploadMode;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3UploadMode", om.valueToTree(this.getS3UploadMode()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getLocalPath() != null) {
                    data.set("localPath", om.valueToTree(this.getLocalPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.S3OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputProperty.Jsii$Proxy that = (S3OutputProperty.Jsii$Proxy) o;

                if (!s3UploadMode.equals(that.s3UploadMode)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.localPath != null ? this.localPath.equals(that.localPath) : that.localPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3UploadMode.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.localPath != null ? this.localPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
     * <p>
     * After the condition is met, the processing job is stopped.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * StoppingConditionProperty stoppingConditionProperty = StoppingConditionProperty.builder()
     *         .maxRuntimeInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-stoppingcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-stoppingcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.StoppingConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(StoppingConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StoppingConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.
         * <p>
         * For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
         * <p>
         * For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
         * <p>
         * The maximum time that a <code>TrainingJob</code> can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-stoppingcondition.html#cfn-sagemaker-processingjob-stoppingcondition-maxruntimeinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-stoppingcondition.html#cfn-sagemaker-processingjob-stoppingcondition-maxruntimeinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRuntimeInSeconds();

        /**
         * @return a {@link Builder} of {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StoppingConditionProperty> {
            java.lang.Number maxRuntimeInSeconds;

            /**
             * Sets the value of {@link StoppingConditionProperty#getMaxRuntimeInSeconds}
             * @param maxRuntimeInSeconds The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. This parameter is required.
             *                            For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
             *                            <p>
             *                            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
             *                            <p>
             *                            The maximum time that a <code>TrainingJob</code> can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRuntimeInSeconds(java.lang.Number maxRuntimeInSeconds) {
                this.maxRuntimeInSeconds = maxRuntimeInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StoppingConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StoppingConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StoppingConditionProperty {
            private final java.lang.Number maxRuntimeInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRuntimeInSeconds = software.amazon.jsii.Kernel.get(this, "maxRuntimeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRuntimeInSeconds = java.util.Objects.requireNonNull(builder.maxRuntimeInSeconds, "maxRuntimeInSeconds is required");
            }

            @Override
            public final java.lang.Number getMaxRuntimeInSeconds() {
                return this.maxRuntimeInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRuntimeInSeconds", om.valueToTree(this.getMaxRuntimeInSeconds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.StoppingConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StoppingConditionProperty.Jsii$Proxy that = (StoppingConditionProperty.Jsii$Proxy) o;

                return this.maxRuntimeInSeconds.equals(that.maxRuntimeInSeconds);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRuntimeInSeconds.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     * <p>
     * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnProcessingJob.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> .
         * <p>
         * Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-vpcconfig.html#cfn-sagemaker-processingjob-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-vpcconfig.html#cfn-sagemaker-processingjob-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The ID of the subnets in the VPC to which you want to connect your training job or model.
         * <p>
         * For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-vpcconfig.html#cfn-sagemaker-processingjob-vpcconfig-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-processingjob-vpcconfig.html#cfn-sagemaker-processingjob-vpcconfig-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> . This parameter is required.
             *                         Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets The ID of the subnets in the VPC to which you want to connect your training job or model. This parameter is required.
             *                For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnProcessingJob.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnProcessingJob> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnProcessingJobProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnProcessingJobProps.Builder();
        }

        /**
         * Configuration to run a processing job in a specified container image.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-appspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-appspecification</a>
         * @param appSpecification Configuration to run a processing job in a specified container image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSpecification(final software.amazon.awscdk.IResolvable appSpecification) {
            this.props.appSpecification(appSpecification);
            return this;
        }
        /**
         * Configuration to run a processing job in a specified container image.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-appspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-appspecification</a>
         * @param appSpecification Configuration to run a processing job in a specified container image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appSpecification(final software.amazon.awscdk.services.sagemaker.CfnProcessingJob.AppSpecificationProperty appSpecification) {
            this.props.appSpecification(appSpecification);
            return this;
        }

        /**
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
         * <p>
         * In distributed training, you specify more than one instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingresources</a>
         * @param processingResources Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingResources(final software.amazon.awscdk.IResolvable processingResources) {
            this.props.processingResources(processingResources);
            return this;
        }
        /**
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
         * <p>
         * In distributed training, you specify more than one instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingresources</a>
         * @param processingResources Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingResources(final software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingResourcesProperty processingResources) {
            this.props.processingResources(processingResources);
            return this;
        }

        /**
         * The ARN of the role used to create the processing job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-rolearn</a>
         * @param roleArn The ARN of the role used to create the processing job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Sets the environment variables in the Docker container.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-environment</a>
         * @param environment Sets the environment variables in the Docker container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }
        /**
         * Sets the environment variables in the Docker container.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-environment</a>
         * @param environment Sets the environment variables in the Docker container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final software.amazon.awscdk.IResolvable environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * Associates a SageMaker job as a trial component with an experiment and trial.
         * <p>
         * Specified when you call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html">CreateProcessingJob</a> API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-experimentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-experimentconfig</a>
         * @param experimentConfig Associates a SageMaker job as a trial component with an experiment and trial. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentConfig(final software.amazon.awscdk.IResolvable experimentConfig) {
            this.props.experimentConfig(experimentConfig);
            return this;
        }
        /**
         * Associates a SageMaker job as a trial component with an experiment and trial.
         * <p>
         * Specified when you call the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html">CreateProcessingJob</a> API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-experimentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-experimentconfig</a>
         * @param experimentConfig Associates a SageMaker job as a trial component with an experiment and trial. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder experimentConfig(final software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ExperimentConfigProperty experimentConfig) {
            this.props.experimentConfig(experimentConfig);
            return this;
        }

        /**
         * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-networkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-networkconfig</a>
         * @param networkConfig Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(final software.amazon.awscdk.IResolvable networkConfig) {
            this.props.networkConfig(networkConfig);
            return this;
        }
        /**
         * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-networkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-networkconfig</a>
         * @param networkConfig Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfig(final software.amazon.awscdk.services.sagemaker.CfnProcessingJob.NetworkConfigProperty networkConfig) {
            this.props.networkConfig(networkConfig);
            return this;
        }

        /**
         * List of input configurations for the processing job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processinginputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processinginputs</a>
         * @param processingInputs List of input configurations for the processing job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingInputs(final software.amazon.awscdk.IResolvable processingInputs) {
            this.props.processingInputs(processingInputs);
            return this;
        }
        /**
         * List of input configurations for the processing job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processinginputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processinginputs</a>
         * @param processingInputs List of input configurations for the processing job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingInputs(final java.util.List<? extends java.lang.Object> processingInputs) {
            this.props.processingInputs(processingInputs);
            return this;
        }

        /**
         * The name of the processing job.
         * <p>
         * If you don't provide a job name, then a unique name is automatically created for the job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingjobname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingjobname</a>
         * @param processingJobName The name of the processing job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingJobName(final java.lang.String processingJobName) {
            this.props.processingJobName(processingJobName);
            return this;
        }

        /**
         * Contains information about the output location for the compiled model and the target device that the model runs on.
         * <p>
         * <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingoutputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingoutputconfig</a>
         * @param processingOutputConfig Contains information about the output location for the compiled model and the target device that the model runs on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingOutputConfig(final software.amazon.awscdk.IResolvable processingOutputConfig) {
            this.props.processingOutputConfig(processingOutputConfig);
            return this;
        }
        /**
         * Contains information about the output location for the compiled model and the target device that the model runs on.
         * <p>
         * <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingoutputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-processingoutputconfig</a>
         * @param processingOutputConfig Contains information about the output location for the compiled model and the target device that the model runs on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processingOutputConfig(final software.amazon.awscdk.services.sagemaker.CfnProcessingJob.ProcessingOutputConfigProperty processingOutputConfig) {
            this.props.processingOutputConfig(processingOutputConfig);
            return this;
        }

        /**
         * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
         * <p>
         * After the condition is met, the processing job is stopped.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-stoppingcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-stoppingcondition</a>
         * @param stoppingCondition Configures conditions under which the processing job should be stopped, such as how long the processing job has been running. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(final software.amazon.awscdk.IResolvable stoppingCondition) {
            this.props.stoppingCondition(stoppingCondition);
            return this;
        }
        /**
         * Configures conditions under which the processing job should be stopped, such as how long the processing job has been running.
         * <p>
         * After the condition is met, the processing job is stopped.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-stoppingcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-stoppingcondition</a>
         * @param stoppingCondition Configures conditions under which the processing job should be stopped, such as how long the processing job has been running. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stoppingCondition(final software.amazon.awscdk.services.sagemaker.CfnProcessingJob.StoppingConditionProperty stoppingCondition) {
            this.props.stoppingCondition(stoppingCondition);
            return this;
        }

        /**
         * An array of key-value pairs.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <em>AWS Billing and Cost Management User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-processingjob.html#cfn-sagemaker-processingjob-tags</a>
         * @param tags An array of key-value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnProcessingJob}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnProcessingJob build() {
            return new software.amazon.awscdk.services.sagemaker.CfnProcessingJob(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
