package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnStudioLifecycleConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnStudioLifecycleConfigProps cfnStudioLifecycleConfigProps = CfnStudioLifecycleConfigProps.builder()
 *         .studioLifecycleConfigAppType("studioLifecycleConfigAppType")
 *         .studioLifecycleConfigContent("studioLifecycleConfigContent")
 *         .studioLifecycleConfigName("studioLifecycleConfigName")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.660Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnStudioLifecycleConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnStudioLifecycleConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStudioLifecycleConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The App type to which the Lifecycle Configuration is attached.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html#cfn-sagemaker-studiolifecycleconfig-studiolifecycleconfigapptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html#cfn-sagemaker-studiolifecycleconfig-studiolifecycleconfigapptype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioLifecycleConfigAppType();

    /**
     * The content of your Amazon SageMaker Studio Lifecycle Configuration script.
     * <p>
     * This content must be base64 encoded.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html#cfn-sagemaker-studiolifecycleconfig-studiolifecycleconfigcontent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html#cfn-sagemaker-studiolifecycleconfig-studiolifecycleconfigcontent</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioLifecycleConfigContent();

    /**
     * The name of the Amazon SageMaker AI Studio Lifecycle Configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html#cfn-sagemaker-studiolifecycleconfig-studiolifecycleconfigname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html#cfn-sagemaker-studiolifecycleconfig-studiolifecycleconfigname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioLifecycleConfigName();

    /**
     * Tags to be associated with the Lifecycle Configuration.
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html#cfn-sagemaker-studiolifecycleconfig-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-studiolifecycleconfig.html#cfn-sagemaker-studiolifecycleconfig-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStudioLifecycleConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStudioLifecycleConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStudioLifecycleConfigProps> {
        java.lang.String studioLifecycleConfigAppType;
        java.lang.String studioLifecycleConfigContent;
        java.lang.String studioLifecycleConfigName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnStudioLifecycleConfigProps#getStudioLifecycleConfigAppType}
         * @param studioLifecycleConfigAppType The App type to which the Lifecycle Configuration is attached. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioLifecycleConfigAppType(java.lang.String studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType = studioLifecycleConfigAppType;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioLifecycleConfigProps#getStudioLifecycleConfigContent}
         * @param studioLifecycleConfigContent The content of your Amazon SageMaker Studio Lifecycle Configuration script. This parameter is required.
         *                                     This content must be base64 encoded.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioLifecycleConfigContent(java.lang.String studioLifecycleConfigContent) {
            this.studioLifecycleConfigContent = studioLifecycleConfigContent;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioLifecycleConfigProps#getStudioLifecycleConfigName}
         * @param studioLifecycleConfigName The name of the Amazon SageMaker AI Studio Lifecycle Configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioLifecycleConfigName(java.lang.String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioLifecycleConfigProps#getTags}
         * @param tags Tags to be associated with the Lifecycle Configuration.
         *             Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStudioLifecycleConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStudioLifecycleConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStudioLifecycleConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStudioLifecycleConfigProps {
        private final java.lang.String studioLifecycleConfigAppType;
        private final java.lang.String studioLifecycleConfigContent;
        private final java.lang.String studioLifecycleConfigName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.studioLifecycleConfigAppType = software.amazon.jsii.Kernel.get(this, "studioLifecycleConfigAppType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioLifecycleConfigContent = software.amazon.jsii.Kernel.get(this, "studioLifecycleConfigContent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioLifecycleConfigName = software.amazon.jsii.Kernel.get(this, "studioLifecycleConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.studioLifecycleConfigAppType = java.util.Objects.requireNonNull(builder.studioLifecycleConfigAppType, "studioLifecycleConfigAppType is required");
            this.studioLifecycleConfigContent = java.util.Objects.requireNonNull(builder.studioLifecycleConfigContent, "studioLifecycleConfigContent is required");
            this.studioLifecycleConfigName = java.util.Objects.requireNonNull(builder.studioLifecycleConfigName, "studioLifecycleConfigName is required");
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getStudioLifecycleConfigAppType() {
            return this.studioLifecycleConfigAppType;
        }

        @Override
        public final java.lang.String getStudioLifecycleConfigContent() {
            return this.studioLifecycleConfigContent;
        }

        @Override
        public final java.lang.String getStudioLifecycleConfigName() {
            return this.studioLifecycleConfigName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("studioLifecycleConfigAppType", om.valueToTree(this.getStudioLifecycleConfigAppType()));
            data.set("studioLifecycleConfigContent", om.valueToTree(this.getStudioLifecycleConfigContent()));
            data.set("studioLifecycleConfigName", om.valueToTree(this.getStudioLifecycleConfigName()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnStudioLifecycleConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStudioLifecycleConfigProps.Jsii$Proxy that = (CfnStudioLifecycleConfigProps.Jsii$Proxy) o;

            if (!studioLifecycleConfigAppType.equals(that.studioLifecycleConfigAppType)) return false;
            if (!studioLifecycleConfigContent.equals(that.studioLifecycleConfigContent)) return false;
            if (!studioLifecycleConfigName.equals(that.studioLifecycleConfigName)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.studioLifecycleConfigAppType.hashCode();
            result = 31 * result + (this.studioLifecycleConfigContent.hashCode());
            result = 31 * result + (this.studioLifecycleConfigName.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
