package software.amazon.awscdk.services.sagemaker;

/**
 * A reference to a DeviceFleet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * DeviceFleetReference deviceFleetReference = DeviceFleetReference.builder()
 *         .deviceFleetName("deviceFleetName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.680Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.DeviceFleetReference")
@software.amazon.jsii.Jsii.Proxy(DeviceFleetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeviceFleetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The DeviceFleetName of the DeviceFleet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeviceFleetName();

    /**
     * @return a {@link Builder} of {@link DeviceFleetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeviceFleetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeviceFleetReference> {
        java.lang.String deviceFleetName;

        /**
         * Sets the value of {@link DeviceFleetReference#getDeviceFleetName}
         * @param deviceFleetName The DeviceFleetName of the DeviceFleet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceFleetName(java.lang.String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeviceFleetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeviceFleetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeviceFleetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceFleetReference {
        private final java.lang.String deviceFleetName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deviceFleetName = software.amazon.jsii.Kernel.get(this, "deviceFleetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deviceFleetName = java.util.Objects.requireNonNull(builder.deviceFleetName, "deviceFleetName is required");
        }

        @Override
        public final java.lang.String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deviceFleetName", om.valueToTree(this.getDeviceFleetName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.DeviceFleetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeviceFleetReference.Jsii$Proxy that = (DeviceFleetReference.Jsii$Proxy) o;

            return this.deviceFleetName.equals(that.deviceFleetName);
        }

        @Override
        public final int hashCode() {
            int result = this.deviceFleetName.hashCode();
            return result;
        }
    }
}
