package software.amazon.awscdk.services.sagemaker;

/**
 * A reference to a ModelCard resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * ModelCardReference modelCardReference = ModelCardReference.builder()
 *         .modelCardArn("modelCardArn")
 *         .modelCardName("modelCardName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.708Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.ModelCardReference")
@software.amazon.jsii.Jsii.Proxy(ModelCardReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ModelCardReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the ModelCard resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelCardArn();

    /**
     * The ModelCardName of the ModelCard resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelCardName();

    /**
     * @return a {@link Builder} of {@link ModelCardReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ModelCardReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ModelCardReference> {
        java.lang.String modelCardArn;
        java.lang.String modelCardName;

        /**
         * Sets the value of {@link ModelCardReference#getModelCardArn}
         * @param modelCardArn The ARN of the ModelCard resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelCardArn(java.lang.String modelCardArn) {
            this.modelCardArn = modelCardArn;
            return this;
        }

        /**
         * Sets the value of {@link ModelCardReference#getModelCardName}
         * @param modelCardName The ModelCardName of the ModelCard resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelCardName(java.lang.String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ModelCardReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ModelCardReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ModelCardReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelCardReference {
        private final java.lang.String modelCardArn;
        private final java.lang.String modelCardName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.modelCardArn = software.amazon.jsii.Kernel.get(this, "modelCardArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelCardName = software.amazon.jsii.Kernel.get(this, "modelCardName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.modelCardArn = java.util.Objects.requireNonNull(builder.modelCardArn, "modelCardArn is required");
            this.modelCardName = java.util.Objects.requireNonNull(builder.modelCardName, "modelCardName is required");
        }

        @Override
        public final java.lang.String getModelCardArn() {
            return this.modelCardArn;
        }

        @Override
        public final java.lang.String getModelCardName() {
            return this.modelCardName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("modelCardArn", om.valueToTree(this.getModelCardArn()));
            data.set("modelCardName", om.valueToTree(this.getModelCardName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.ModelCardReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ModelCardReference.Jsii$Proxy that = (ModelCardReference.Jsii$Proxy) o;

            if (!modelCardArn.equals(that.modelCardArn)) return false;
            return this.modelCardName.equals(that.modelCardName);
        }

        @Override
        public final int hashCode() {
            int result = this.modelCardArn.hashCode();
            result = 31 * result + (this.modelCardName.hashCode());
            return result;
        }
    }
}
