package software.amazon.awscdk.services.sagemaker;

/**
 * A reference to a StudioLifecycleConfig resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * StudioLifecycleConfigReference studioLifecycleConfigReference = StudioLifecycleConfigReference.builder()
 *         .studioLifecycleConfigArn("studioLifecycleConfigArn")
 *         .studioLifecycleConfigName("studioLifecycleConfigName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:14.712Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.StudioLifecycleConfigReference")
@software.amazon.jsii.Jsii.Proxy(StudioLifecycleConfigReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StudioLifecycleConfigReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the StudioLifecycleConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioLifecycleConfigArn();

    /**
     * The StudioLifecycleConfigName of the StudioLifecycleConfig resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioLifecycleConfigName();

    /**
     * @return a {@link Builder} of {@link StudioLifecycleConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StudioLifecycleConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StudioLifecycleConfigReference> {
        java.lang.String studioLifecycleConfigArn;
        java.lang.String studioLifecycleConfigName;

        /**
         * Sets the value of {@link StudioLifecycleConfigReference#getStudioLifecycleConfigArn}
         * @param studioLifecycleConfigArn The ARN of the StudioLifecycleConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioLifecycleConfigArn(java.lang.String studioLifecycleConfigArn) {
            this.studioLifecycleConfigArn = studioLifecycleConfigArn;
            return this;
        }

        /**
         * Sets the value of {@link StudioLifecycleConfigReference#getStudioLifecycleConfigName}
         * @param studioLifecycleConfigName The StudioLifecycleConfigName of the StudioLifecycleConfig resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioLifecycleConfigName(java.lang.String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StudioLifecycleConfigReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StudioLifecycleConfigReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StudioLifecycleConfigReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StudioLifecycleConfigReference {
        private final java.lang.String studioLifecycleConfigArn;
        private final java.lang.String studioLifecycleConfigName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.studioLifecycleConfigArn = software.amazon.jsii.Kernel.get(this, "studioLifecycleConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioLifecycleConfigName = software.amazon.jsii.Kernel.get(this, "studioLifecycleConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.studioLifecycleConfigArn = java.util.Objects.requireNonNull(builder.studioLifecycleConfigArn, "studioLifecycleConfigArn is required");
            this.studioLifecycleConfigName = java.util.Objects.requireNonNull(builder.studioLifecycleConfigName, "studioLifecycleConfigName is required");
        }

        @Override
        public final java.lang.String getStudioLifecycleConfigArn() {
            return this.studioLifecycleConfigArn;
        }

        @Override
        public final java.lang.String getStudioLifecycleConfigName() {
            return this.studioLifecycleConfigName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("studioLifecycleConfigArn", om.valueToTree(this.getStudioLifecycleConfigArn()));
            data.set("studioLifecycleConfigName", om.valueToTree(this.getStudioLifecycleConfigName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.StudioLifecycleConfigReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StudioLifecycleConfigReference.Jsii$Proxy that = (StudioLifecycleConfigReference.Jsii$Proxy) o;

            if (!studioLifecycleConfigArn.equals(that.studioLifecycleConfigArn)) return false;
            return this.studioLifecycleConfigName.equals(that.studioLifecycleConfigName);
        }

        @Override
        public final int hashCode() {
            int result = this.studioLifecycleConfigArn.hashCode();
            result = 31 * result + (this.studioLifecycleConfigName.hashCode());
            return result;
        }
    }
}
