package software.amazon.awscdk.services.securitylake;

/**
 * A reference to a AwsLogSource resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securitylake.*;
 * AwsLogSourceReference awsLogSourceReference = AwsLogSourceReference.builder()
 *         .sourceName("sourceName")
 *         .sourceVersion("sourceVersion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.058Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securitylake.AwsLogSourceReference")
@software.amazon.jsii.Jsii.Proxy(AwsLogSourceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsLogSourceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The SourceName of the AwsLogSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceName();

    /**
     * The SourceVersion of the AwsLogSource resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceVersion();

    /**
     * @return a {@link Builder} of {@link AwsLogSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsLogSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsLogSourceReference> {
        java.lang.String sourceName;
        java.lang.String sourceVersion;

        /**
         * Sets the value of {@link AwsLogSourceReference#getSourceName}
         * @param sourceName The SourceName of the AwsLogSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceName(java.lang.String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        /**
         * Sets the value of {@link AwsLogSourceReference#getSourceVersion}
         * @param sourceVersion The SourceVersion of the AwsLogSource resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceVersion(java.lang.String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsLogSourceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsLogSourceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsLogSourceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsLogSourceReference {
        private final java.lang.String sourceName;
        private final java.lang.String sourceVersion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceName = software.amazon.jsii.Kernel.get(this, "sourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceVersion = software.amazon.jsii.Kernel.get(this, "sourceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceName = java.util.Objects.requireNonNull(builder.sourceName, "sourceName is required");
            this.sourceVersion = java.util.Objects.requireNonNull(builder.sourceVersion, "sourceVersion is required");
        }

        @Override
        public final java.lang.String getSourceName() {
            return this.sourceName;
        }

        @Override
        public final java.lang.String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceName", om.valueToTree(this.getSourceName()));
            data.set("sourceVersion", om.valueToTree(this.getSourceVersion()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securitylake.AwsLogSourceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsLogSourceReference.Jsii$Proxy that = (AwsLogSourceReference.Jsii$Proxy) o;

            if (!sourceName.equals(that.sourceName)) return false;
            return this.sourceVersion.equals(that.sourceVersion);
        }

        @Override
        public final int hashCode() {
            int result = this.sourceName.hashCode();
            result = 31 * result + (this.sourceVersion.hashCode());
            return result;
        }
    }
}
