package software.amazon.awscdk.services.servicecatalog;

/**
 * A reference to a ServiceAction resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicecatalog.*;
 * ServiceActionReference serviceActionReference = ServiceActionReference.builder()
 *         .serviceActionId("serviceActionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.165Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.ServiceActionReference")
@software.amazon.jsii.Jsii.Proxy(ServiceActionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ServiceActionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the ServiceAction resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceActionId();

    /**
     * @return a {@link Builder} of {@link ServiceActionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ServiceActionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ServiceActionReference> {
        java.lang.String serviceActionId;

        /**
         * Sets the value of {@link ServiceActionReference#getServiceActionId}
         * @param serviceActionId The Id of the ServiceAction resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceActionId(java.lang.String serviceActionId) {
            this.serviceActionId = serviceActionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ServiceActionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ServiceActionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ServiceActionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceActionReference {
        private final java.lang.String serviceActionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.serviceActionId = software.amazon.jsii.Kernel.get(this, "serviceActionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.serviceActionId = java.util.Objects.requireNonNull(builder.serviceActionId, "serviceActionId is required");
        }

        @Override
        public final java.lang.String getServiceActionId() {
            return this.serviceActionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("serviceActionId", om.valueToTree(this.getServiceActionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.ServiceActionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ServiceActionReference.Jsii$Proxy that = (ServiceActionReference.Jsii$Proxy) o;

            return this.serviceActionId.equals(that.serviceActionId);
        }

        @Override
        public final int hashCode() {
            int result = this.serviceActionId.hashCode();
            return result;
        }
    }
}
