package software.amazon.awscdk.services.servicecatalog;

/**
 * An assertion within a template rule, defined by intrinsic functions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.servicecatalog.*;
 * ICfnRuleConditionExpression cfnRuleConditionExpression;
 * TemplateRuleAssertion templateRuleAssertion = TemplateRuleAssertion.builder()
 *         .assert(cfnRuleConditionExpression)
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.168Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.TemplateRuleAssertion")
@software.amazon.jsii.Jsii.Proxy(TemplateRuleAssertion.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TemplateRuleAssertion extends software.amazon.jsii.JsiiSerializable {

    /**
     * The assertion condition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.ICfnRuleConditionExpression getAssertValue();

    /**
     * The description for the asssertion.
     * <p>
     * Default: - no description provided for the assertion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TemplateRuleAssertion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TemplateRuleAssertion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TemplateRuleAssertion> {
        software.amazon.awscdk.ICfnRuleConditionExpression assertValue;
        java.lang.String description;

        /**
         * Sets the value of {@link TemplateRuleAssertion#getAssertValue}
         * @param assertValue The assertion condition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertValue(software.amazon.awscdk.ICfnRuleConditionExpression assertValue) {
            this.assertValue = assertValue;
            return this;
        }

        /**
         * Sets the value of {@link TemplateRuleAssertion#getDescription}
         * @param description The description for the asssertion.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TemplateRuleAssertion}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TemplateRuleAssertion build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TemplateRuleAssertion}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateRuleAssertion {
        private final software.amazon.awscdk.ICfnRuleConditionExpression assertValue;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assertValue = software.amazon.jsii.Kernel.get(this, "assert", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ICfnRuleConditionExpression.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assertValue = java.util.Objects.requireNonNull(builder.assertValue, "assertValue is required");
            this.description = builder.description;
        }

        @Override
        public final software.amazon.awscdk.ICfnRuleConditionExpression getAssertValue() {
            return this.assertValue;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assert", om.valueToTree(this.getAssertValue()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicecatalog.TemplateRuleAssertion"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TemplateRuleAssertion.Jsii$Proxy that = (TemplateRuleAssertion.Jsii$Proxy) o;

            if (!assertValue.equals(that.assertValue)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assertValue.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
