package software.amazon.awscdk.services.servicediscovery;

/**
 * A reference to a HttpNamespace resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * HttpNamespaceReference httpNamespaceReference = HttpNamespaceReference.builder()
 *         .httpNamespaceArn("httpNamespaceArn")
 *         .httpNamespaceId("httpNamespaceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.216Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.HttpNamespaceReference")
@software.amazon.jsii.Jsii.Proxy(HttpNamespaceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpNamespaceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the HttpNamespace resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpNamespaceArn();

    /**
     * The Id of the HttpNamespace resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpNamespaceId();

    /**
     * @return a {@link Builder} of {@link HttpNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpNamespaceReference> {
        java.lang.String httpNamespaceArn;
        java.lang.String httpNamespaceId;

        /**
         * Sets the value of {@link HttpNamespaceReference#getHttpNamespaceArn}
         * @param httpNamespaceArn The ARN of the HttpNamespace resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpNamespaceArn(java.lang.String httpNamespaceArn) {
            this.httpNamespaceArn = httpNamespaceArn;
            return this;
        }

        /**
         * Sets the value of {@link HttpNamespaceReference#getHttpNamespaceId}
         * @param httpNamespaceId The Id of the HttpNamespace resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpNamespaceId(java.lang.String httpNamespaceId) {
            this.httpNamespaceId = httpNamespaceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpNamespaceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpNamespaceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpNamespaceReference {
        private final java.lang.String httpNamespaceArn;
        private final java.lang.String httpNamespaceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpNamespaceArn = software.amazon.jsii.Kernel.get(this, "httpNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpNamespaceId = software.amazon.jsii.Kernel.get(this, "httpNamespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpNamespaceArn = java.util.Objects.requireNonNull(builder.httpNamespaceArn, "httpNamespaceArn is required");
            this.httpNamespaceId = java.util.Objects.requireNonNull(builder.httpNamespaceId, "httpNamespaceId is required");
        }

        @Override
        public final java.lang.String getHttpNamespaceArn() {
            return this.httpNamespaceArn;
        }

        @Override
        public final java.lang.String getHttpNamespaceId() {
            return this.httpNamespaceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpNamespaceArn", om.valueToTree(this.getHttpNamespaceArn()));
            data.set("httpNamespaceId", om.valueToTree(this.getHttpNamespaceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.HttpNamespaceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpNamespaceReference.Jsii$Proxy that = (HttpNamespaceReference.Jsii$Proxy) o;

            if (!httpNamespaceArn.equals(that.httpNamespaceArn)) return false;
            return this.httpNamespaceId.equals(that.httpNamespaceId);
        }

        @Override
        public final int hashCode() {
            int result = this.httpNamespaceArn.hashCode();
            result = 31 * result + (this.httpNamespaceId.hashCode());
            return result;
        }
    }
}
