package software.amazon.awscdk.services.servicediscovery;

/**
 * A reference to a PublicDnsNamespace resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.servicediscovery.*;
 * PublicDnsNamespaceReference publicDnsNamespaceReference = PublicDnsNamespaceReference.builder()
 *         .publicDnsNamespaceArn("publicDnsNamespaceArn")
 *         .publicDnsNamespaceId("publicDnsNamespaceId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.228Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.PublicDnsNamespaceReference")
@software.amazon.jsii.Jsii.Proxy(PublicDnsNamespaceReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PublicDnsNamespaceReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the PublicDnsNamespace resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPublicDnsNamespaceArn();

    /**
     * The Id of the PublicDnsNamespace resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPublicDnsNamespaceId();

    /**
     * @return a {@link Builder} of {@link PublicDnsNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PublicDnsNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PublicDnsNamespaceReference> {
        java.lang.String publicDnsNamespaceArn;
        java.lang.String publicDnsNamespaceId;

        /**
         * Sets the value of {@link PublicDnsNamespaceReference#getPublicDnsNamespaceArn}
         * @param publicDnsNamespaceArn The ARN of the PublicDnsNamespace resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicDnsNamespaceArn(java.lang.String publicDnsNamespaceArn) {
            this.publicDnsNamespaceArn = publicDnsNamespaceArn;
            return this;
        }

        /**
         * Sets the value of {@link PublicDnsNamespaceReference#getPublicDnsNamespaceId}
         * @param publicDnsNamespaceId The Id of the PublicDnsNamespace resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicDnsNamespaceId(java.lang.String publicDnsNamespaceId) {
            this.publicDnsNamespaceId = publicDnsNamespaceId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PublicDnsNamespaceReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PublicDnsNamespaceReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PublicDnsNamespaceReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicDnsNamespaceReference {
        private final java.lang.String publicDnsNamespaceArn;
        private final java.lang.String publicDnsNamespaceId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.publicDnsNamespaceArn = software.amazon.jsii.Kernel.get(this, "publicDnsNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicDnsNamespaceId = software.amazon.jsii.Kernel.get(this, "publicDnsNamespaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.publicDnsNamespaceArn = java.util.Objects.requireNonNull(builder.publicDnsNamespaceArn, "publicDnsNamespaceArn is required");
            this.publicDnsNamespaceId = java.util.Objects.requireNonNull(builder.publicDnsNamespaceId, "publicDnsNamespaceId is required");
        }

        @Override
        public final java.lang.String getPublicDnsNamespaceArn() {
            return this.publicDnsNamespaceArn;
        }

        @Override
        public final java.lang.String getPublicDnsNamespaceId() {
            return this.publicDnsNamespaceId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("publicDnsNamespaceArn", om.valueToTree(this.getPublicDnsNamespaceArn()));
            data.set("publicDnsNamespaceId", om.valueToTree(this.getPublicDnsNamespaceId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_servicediscovery.PublicDnsNamespaceReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PublicDnsNamespaceReference.Jsii$Proxy that = (PublicDnsNamespaceReference.Jsii$Proxy) o;

            if (!publicDnsNamespaceArn.equals(that.publicDnsNamespaceArn)) return false;
            return this.publicDnsNamespaceId.equals(that.publicDnsNamespaceId);
        }

        @Override
        public final int hashCode() {
            int result = this.publicDnsNamespaceArn.hashCode();
            result = 31 * result + (this.publicDnsNamespaceId.hashCode());
            return result;
        }
    }
}
