package software.amazon.awscdk.services.ses;

/**
 * A reference to a MailManagerAddressList resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * MailManagerAddressListReference mailManagerAddressListReference = MailManagerAddressListReference.builder()
 *         .addressListId("addressListId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.383Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.MailManagerAddressListReference")
@software.amazon.jsii.Jsii.Proxy(MailManagerAddressListReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MailManagerAddressListReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AddressListId of the MailManagerAddressList resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddressListId();

    /**
     * @return a {@link Builder} of {@link MailManagerAddressListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MailManagerAddressListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MailManagerAddressListReference> {
        java.lang.String addressListId;

        /**
         * Sets the value of {@link MailManagerAddressListReference#getAddressListId}
         * @param addressListId The AddressListId of the MailManagerAddressList resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addressListId(java.lang.String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MailManagerAddressListReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MailManagerAddressListReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MailManagerAddressListReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MailManagerAddressListReference {
        private final java.lang.String addressListId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addressListId = software.amazon.jsii.Kernel.get(this, "addressListId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addressListId = java.util.Objects.requireNonNull(builder.addressListId, "addressListId is required");
        }

        @Override
        public final java.lang.String getAddressListId() {
            return this.addressListId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addressListId", om.valueToTree(this.getAddressListId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.MailManagerAddressListReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MailManagerAddressListReference.Jsii$Proxy that = (MailManagerAddressListReference.Jsii$Proxy) o;

            return this.addressListId.equals(that.addressListId);
        }

        @Override
        public final int hashCode() {
            int result = this.addressListId.hashCode();
            return result;
        }
    }
}
