package software.amazon.awscdk.services.ses;

/**
 * A reference to a MailManagerRuleSet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * MailManagerRuleSetReference mailManagerRuleSetReference = MailManagerRuleSetReference.builder()
 *         .ruleSetId("ruleSetId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.384Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.MailManagerRuleSetReference")
@software.amazon.jsii.Jsii.Proxy(MailManagerRuleSetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MailManagerRuleSetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The RuleSetId of the MailManagerRuleSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleSetId();

    /**
     * @return a {@link Builder} of {@link MailManagerRuleSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MailManagerRuleSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MailManagerRuleSetReference> {
        java.lang.String ruleSetId;

        /**
         * Sets the value of {@link MailManagerRuleSetReference#getRuleSetId}
         * @param ruleSetId The RuleSetId of the MailManagerRuleSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetId(java.lang.String ruleSetId) {
            this.ruleSetId = ruleSetId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MailManagerRuleSetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MailManagerRuleSetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MailManagerRuleSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MailManagerRuleSetReference {
        private final java.lang.String ruleSetId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ruleSetId = software.amazon.jsii.Kernel.get(this, "ruleSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ruleSetId = java.util.Objects.requireNonNull(builder.ruleSetId, "ruleSetId is required");
        }

        @Override
        public final java.lang.String getRuleSetId() {
            return this.ruleSetId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ruleSetId", om.valueToTree(this.getRuleSetId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.MailManagerRuleSetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MailManagerRuleSetReference.Jsii$Proxy that = (MailManagerRuleSetReference.Jsii$Proxy) o;

            return this.ruleSetId.equals(that.ruleSetId);
        }

        @Override
        public final int hashCode() {
            int result = this.ruleSetId.hashCode();
            return result;
        }
    }
}
