package software.amazon.awscdk.services.smsvoice;

/**
 * Creates a new configuration set.
 * <p>
 * After you create the configuration set, you can add one or more event destinations to it.
 * <p>
 * A configuration set is a set of rules that you apply to the SMS and voice messages that you send.
 * <p>
 * When you send a message, you can optionally specify a single configuration set.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.smsvoice.*;
 * CfnConfigurationSet cfnConfigurationSet = CfnConfigurationSet.Builder.create(this, "MyCfnConfigurationSet")
 *         .configurationSetName("configurationSetName")
 *         .defaultSenderId("defaultSenderId")
 *         .eventDestinations(List.of(EventDestinationProperty.builder()
 *                 .enabled(false)
 *                 .eventDestinationName("eventDestinationName")
 *                 .matchingEventTypes(List.of("matchingEventTypes"))
 *                 // the properties below are optional
 *                 .cloudWatchLogsDestination(CloudWatchLogsDestinationProperty.builder()
 *                         .iamRoleArn("iamRoleArn")
 *                         .logGroupArn("logGroupArn")
 *                         .build())
 *                 .kinesisFirehoseDestination(KinesisFirehoseDestinationProperty.builder()
 *                         .deliveryStreamArn("deliveryStreamArn")
 *                         .iamRoleArn("iamRoleArn")
 *                         .build())
 *                 .snsDestination(SnsDestinationProperty.builder()
 *                         .topicArn("topicArn")
 *                         .build())
 *                 .build()))
 *         .messageFeedbackEnabled(false)
 *         .protectConfigurationId("protectConfigurationId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.437Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnConfigurationSet")
public class CfnConfigurationSet extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.smsvoice.IConfigurationSetRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnConfigurationSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.smsvoice.CfnConfigurationSetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationSet(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Creates a new IConfigurationSetRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.IConfigurationSetRef fromConfigurationSetArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.class, "fromConfigurationSetArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.IConfigurationSetRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Creates a new IConfigurationSetRef from a configurationSetName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param configurationSetName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.IConfigurationSetRef fromConfigurationSetName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String configurationSetName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.class, "fromConfigurationSetName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.IConfigurationSetRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(configurationSetName, "configurationSetName is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the ConfigurationSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ConfigurationSet resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.ConfigurationSetReference getConfigurationSetRef() {
        return software.amazon.jsii.Kernel.get(this, "configurationSetRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.ConfigurationSetReference.class));
    }

    /**
     * The name of the ConfigurationSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSetName() {
        return software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ConfigurationSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationSetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configurationSetName", value);
    }

    /**
     * The default sender ID used by the ConfigurationSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultSenderId() {
        return software.amazon.jsii.Kernel.get(this, "defaultSenderId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default sender ID used by the ConfigurationSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultSenderId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultSenderId", value);
    }

    /**
     * An array of EventDestination objects that describe any events to log and where to log them.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.EventDestinationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventDestinations() {
        return software.amazon.jsii.Kernel.get(this, "eventDestinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of EventDestination objects that describe any events to log and where to log them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventDestinations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventDestinations", value);
    }

    /**
     * An array of EventDestination objects that describe any events to log and where to log them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventDestinations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.EventDestinationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.EventDestinationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "eventDestinations", value);
    }

    /**
     * Set to true to enable feedback for the message.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMessageFeedbackEnabled() {
        return software.amazon.jsii.Kernel.get(this, "messageFeedbackEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Set to true to enable feedback for the message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMessageFeedbackEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "messageFeedbackEnabled", value);
    }

    /**
     * Set to true to enable feedback for the message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMessageFeedbackEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "messageFeedbackEnabled", value);
    }

    /**
     * The unique identifier for the protect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProtectConfigurationId() {
        return software.amazon.jsii.Kernel.get(this, "protectConfigurationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the protect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtectConfigurationId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protectConfigurationId", value);
    }

    /**
     * An array of key and value pair tags that's associated with the new configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key and value pair tags that's associated with the new configuration set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains the destination configuration to use when publishing message sending events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * CloudWatchLogsDestinationProperty cloudWatchLogsDestinationProperty = CloudWatchLogsDestinationProperty.builder()
     *         .iamRoleArn("iamRoleArn")
     *         .logGroupArn("logGroupArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-cloudwatchlogsdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-cloudwatchlogsdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnConfigurationSet.CloudWatchLogsDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an AWS Identity and Access Management role that is able to write event data to an Amazon CloudWatch destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-cloudwatchlogsdestination.html#cfn-smsvoice-configurationset-cloudwatchlogsdestination-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-cloudwatchlogsdestination.html#cfn-smsvoice-configurationset-cloudwatchlogsdestination-iamrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn();

        /**
         * The name of the Amazon CloudWatch log group that you want to record events in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-cloudwatchlogsdestination.html#cfn-smsvoice-configurationset-cloudwatchlogsdestination-loggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-cloudwatchlogsdestination.html#cfn-smsvoice-configurationset-cloudwatchlogsdestination-loggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroupArn();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsDestinationProperty> {
            java.lang.String iamRoleArn;
            java.lang.String logGroupArn;

            /**
             * Sets the value of {@link CloudWatchLogsDestinationProperty#getIamRoleArn}
             * @param iamRoleArn The Amazon Resource Name (ARN) of an AWS Identity and Access Management role that is able to write event data to an Amazon CloudWatch destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamRoleArn(java.lang.String iamRoleArn) {
                this.iamRoleArn = iamRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsDestinationProperty#getLogGroupArn}
             * @param logGroupArn The name of the Amazon CloudWatch log group that you want to record events in. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupArn(java.lang.String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsDestinationProperty {
            private final java.lang.String iamRoleArn;
            private final java.lang.String logGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logGroupArn = software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iamRoleArn = java.util.Objects.requireNonNull(builder.iamRoleArn, "iamRoleArn is required");
                this.logGroupArn = java.util.Objects.requireNonNull(builder.logGroupArn, "logGroupArn is required");
            }

            @Override
            public final java.lang.String getIamRoleArn() {
                return this.iamRoleArn;
            }

            @Override
            public final java.lang.String getLogGroupArn() {
                return this.logGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));
                data.set("logGroupArn", om.valueToTree(this.getLogGroupArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnConfigurationSet.CloudWatchLogsDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsDestinationProperty.Jsii$Proxy that = (CloudWatchLogsDestinationProperty.Jsii$Proxy) o;

                if (!iamRoleArn.equals(that.iamRoleArn)) return false;
                return this.logGroupArn.equals(that.logGroupArn);
            }

            @Override
            public final int hashCode() {
                int result = this.iamRoleArn.hashCode();
                result = 31 * result + (this.logGroupArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about an event destination.
     * <p>
     * Event destinations are associated with configuration sets, which enable you to publish message sending events to CloudWatch, Firehose, or Amazon SNS.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * EventDestinationProperty eventDestinationProperty = EventDestinationProperty.builder()
     *         .enabled(false)
     *         .eventDestinationName("eventDestinationName")
     *         .matchingEventTypes(List.of("matchingEventTypes"))
     *         // the properties below are optional
     *         .cloudWatchLogsDestination(CloudWatchLogsDestinationProperty.builder()
     *                 .iamRoleArn("iamRoleArn")
     *                 .logGroupArn("logGroupArn")
     *                 .build())
     *         .kinesisFirehoseDestination(KinesisFirehoseDestinationProperty.builder()
     *                 .deliveryStreamArn("deliveryStreamArn")
     *                 .iamRoleArn("iamRoleArn")
     *                 .build())
     *         .snsDestination(SnsDestinationProperty.builder()
     *                 .topicArn("topicArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnConfigurationSet.EventDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(EventDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When set to true events will be logged.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The name of the EventDestination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-eventdestinationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-eventdestinationname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventDestinationName();

        /**
         * An array of event types that determine which events to log.
         * <p>
         * <blockquote>
         * <p>
         * The <code>TEXT_SENT</code> event type is not supported.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-matchingeventtypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-matchingeventtypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMatchingEventTypes();

        /**
         * An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.CloudWatchLogsDestinationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-cloudwatchlogsdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-cloudwatchlogsdestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogsDestination() {
            return null;
        }

        /**
         * An object that contains information about an event destination for logging to Amazon Data Firehose.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.KinesisFirehoseDestinationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-kinesisfirehosedestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-kinesisfirehosedestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseDestination() {
            return null;
        }

        /**
         * An object that contains information about an event destination that sends logging events to Amazon SNS.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.SnsDestinationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-snsdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-eventdestination.html#cfn-smsvoice-configurationset-eventdestination-snsdestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnsDestination() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventDestinationProperty> {
            java.lang.Object enabled;
            java.lang.String eventDestinationName;
            java.util.List<java.lang.String> matchingEventTypes;
            java.lang.Object cloudWatchLogsDestination;
            java.lang.Object kinesisFirehoseDestination;
            java.lang.Object snsDestination;

            /**
             * Sets the value of {@link EventDestinationProperty#getEnabled}
             * @param enabled When set to true events will be logged. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getEnabled}
             * @param enabled When set to true events will be logged. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getEventDestinationName}
             * @param eventDestinationName The name of the EventDestination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventDestinationName(java.lang.String eventDestinationName) {
                this.eventDestinationName = eventDestinationName;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getMatchingEventTypes}
             * @param matchingEventTypes An array of event types that determine which events to log. This parameter is required.
             *                           <blockquote>
             *                           <p>
             *                           The <code>TEXT_SENT</code> event type is not supported.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchingEventTypes(java.util.List<java.lang.String> matchingEventTypes) {
                this.matchingEventTypes = matchingEventTypes;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getCloudWatchLogsDestination}
             * @param cloudWatchLogsDestination An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsDestination(software.amazon.awscdk.IResolvable cloudWatchLogsDestination) {
                this.cloudWatchLogsDestination = cloudWatchLogsDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getCloudWatchLogsDestination}
             * @param cloudWatchLogsDestination An object that contains information about an event destination that sends logging events to Amazon CloudWatch logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsDestination(software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.CloudWatchLogsDestinationProperty cloudWatchLogsDestination) {
                this.cloudWatchLogsDestination = cloudWatchLogsDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getKinesisFirehoseDestination}
             * @param kinesisFirehoseDestination An object that contains information about an event destination for logging to Amazon Data Firehose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDestination(software.amazon.awscdk.IResolvable kinesisFirehoseDestination) {
                this.kinesisFirehoseDestination = kinesisFirehoseDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getKinesisFirehoseDestination}
             * @param kinesisFirehoseDestination An object that contains information about an event destination for logging to Amazon Data Firehose.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDestination(software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.KinesisFirehoseDestinationProperty kinesisFirehoseDestination) {
                this.kinesisFirehoseDestination = kinesisFirehoseDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getSnsDestination}
             * @param snsDestination An object that contains information about an event destination that sends logging events to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsDestination(software.amazon.awscdk.IResolvable snsDestination) {
                this.snsDestination = snsDestination;
                return this;
            }

            /**
             * Sets the value of {@link EventDestinationProperty#getSnsDestination}
             * @param snsDestination An object that contains information about an event destination that sends logging events to Amazon SNS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsDestination(software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.SnsDestinationProperty snsDestination) {
                this.snsDestination = snsDestination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventDestinationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String eventDestinationName;
            private final java.util.List<java.lang.String> matchingEventTypes;
            private final java.lang.Object cloudWatchLogsDestination;
            private final java.lang.Object kinesisFirehoseDestination;
            private final java.lang.Object snsDestination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventDestinationName = software.amazon.jsii.Kernel.get(this, "eventDestinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchingEventTypes = software.amazon.jsii.Kernel.get(this, "matchingEventTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cloudWatchLogsDestination = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisFirehoseDestination = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snsDestination = software.amazon.jsii.Kernel.get(this, "snsDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.eventDestinationName = java.util.Objects.requireNonNull(builder.eventDestinationName, "eventDestinationName is required");
                this.matchingEventTypes = java.util.Objects.requireNonNull(builder.matchingEventTypes, "matchingEventTypes is required");
                this.cloudWatchLogsDestination = builder.cloudWatchLogsDestination;
                this.kinesisFirehoseDestination = builder.kinesisFirehoseDestination;
                this.snsDestination = builder.snsDestination;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getEventDestinationName() {
                return this.eventDestinationName;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchingEventTypes() {
                return this.matchingEventTypes;
            }

            @Override
            public final java.lang.Object getCloudWatchLogsDestination() {
                return this.cloudWatchLogsDestination;
            }

            @Override
            public final java.lang.Object getKinesisFirehoseDestination() {
                return this.kinesisFirehoseDestination;
            }

            @Override
            public final java.lang.Object getSnsDestination() {
                return this.snsDestination;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                data.set("eventDestinationName", om.valueToTree(this.getEventDestinationName()));
                data.set("matchingEventTypes", om.valueToTree(this.getMatchingEventTypes()));
                if (this.getCloudWatchLogsDestination() != null) {
                    data.set("cloudWatchLogsDestination", om.valueToTree(this.getCloudWatchLogsDestination()));
                }
                if (this.getKinesisFirehoseDestination() != null) {
                    data.set("kinesisFirehoseDestination", om.valueToTree(this.getKinesisFirehoseDestination()));
                }
                if (this.getSnsDestination() != null) {
                    data.set("snsDestination", om.valueToTree(this.getSnsDestination()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnConfigurationSet.EventDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventDestinationProperty.Jsii$Proxy that = (EventDestinationProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (!eventDestinationName.equals(that.eventDestinationName)) return false;
                if (!matchingEventTypes.equals(that.matchingEventTypes)) return false;
                if (this.cloudWatchLogsDestination != null ? !this.cloudWatchLogsDestination.equals(that.cloudWatchLogsDestination) : that.cloudWatchLogsDestination != null) return false;
                if (this.kinesisFirehoseDestination != null ? !this.kinesisFirehoseDestination.equals(that.kinesisFirehoseDestination) : that.kinesisFirehoseDestination != null) return false;
                return this.snsDestination != null ? this.snsDestination.equals(that.snsDestination) : that.snsDestination == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.eventDestinationName.hashCode());
                result = 31 * result + (this.matchingEventTypes.hashCode());
                result = 31 * result + (this.cloudWatchLogsDestination != null ? this.cloudWatchLogsDestination.hashCode() : 0);
                result = 31 * result + (this.kinesisFirehoseDestination != null ? this.kinesisFirehoseDestination.hashCode() : 0);
                result = 31 * result + (this.snsDestination != null ? this.snsDestination.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the delivery stream Amazon Resource Name (ARN), and the ARN of the AWS Identity and Access Management (IAM) role associated with a Firehose event destination.
     * <p>
     * Event destinations, such as Firehose, are associated with configuration sets, which enable you to publish message sending events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * KinesisFirehoseDestinationProperty kinesisFirehoseDestinationProperty = KinesisFirehoseDestinationProperty.builder()
     *         .deliveryStreamArn("deliveryStreamArn")
     *         .iamRoleArn("iamRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-kinesisfirehosedestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-kinesisfirehosedestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnConfigurationSet.KinesisFirehoseDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-kinesisfirehosedestination.html#cfn-smsvoice-configurationset-kinesisfirehosedestination-deliverystreamarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-kinesisfirehosedestination.html#cfn-smsvoice-configurationset-kinesisfirehosedestination-deliverystreamarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStreamArn();

        /**
         * The ARN of an AWS Identity and Access Management role that is able to write event data to an Amazon Data Firehose destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-kinesisfirehosedestination.html#cfn-smsvoice-configurationset-kinesisfirehosedestination-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-kinesisfirehosedestination.html#cfn-smsvoice-configurationset-kinesisfirehosedestination-iamrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseDestinationProperty> {
            java.lang.String deliveryStreamArn;
            java.lang.String iamRoleArn;

            /**
             * Sets the value of {@link KinesisFirehoseDestinationProperty#getDeliveryStreamArn}
             * @param deliveryStreamArn The Amazon Resource Name (ARN) of the delivery stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStreamArn(java.lang.String deliveryStreamArn) {
                this.deliveryStreamArn = deliveryStreamArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisFirehoseDestinationProperty#getIamRoleArn}
             * @param iamRoleArn The ARN of an AWS Identity and Access Management role that is able to write event data to an Amazon Data Firehose destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamRoleArn(java.lang.String iamRoleArn) {
                this.iamRoleArn = iamRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseDestinationProperty {
            private final java.lang.String deliveryStreamArn;
            private final java.lang.String iamRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryStreamArn = software.amazon.jsii.Kernel.get(this, "deliveryStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryStreamArn = java.util.Objects.requireNonNull(builder.deliveryStreamArn, "deliveryStreamArn is required");
                this.iamRoleArn = java.util.Objects.requireNonNull(builder.iamRoleArn, "iamRoleArn is required");
            }

            @Override
            public final java.lang.String getDeliveryStreamArn() {
                return this.deliveryStreamArn;
            }

            @Override
            public final java.lang.String getIamRoleArn() {
                return this.iamRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deliveryStreamArn", om.valueToTree(this.getDeliveryStreamArn()));
                data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnConfigurationSet.KinesisFirehoseDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseDestinationProperty.Jsii$Proxy that = (KinesisFirehoseDestinationProperty.Jsii$Proxy) o;

                if (!deliveryStreamArn.equals(that.deliveryStreamArn)) return false;
                return this.iamRoleArn.equals(that.iamRoleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryStreamArn.hashCode();
                result = 31 * result + (this.iamRoleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that defines an Amazon SNS destination for events.
     * <p>
     * You can use Amazon SNS to send notification when certain events occur.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * SnsDestinationProperty snsDestinationProperty = SnsDestinationProperty.builder()
     *         .topicArn("topicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-snsdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-snsdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnConfigurationSet.SnsDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnsDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnsDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-snsdestination.html#cfn-smsvoice-configurationset-snsdestination-topicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-configurationset-snsdestination.html#cfn-smsvoice-configurationset-snsdestination-topicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicArn();

        /**
         * @return a {@link Builder} of {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnsDestinationProperty> {
            java.lang.String topicArn;

            /**
             * Sets the value of {@link SnsDestinationProperty#getTopicArn}
             * @param topicArn The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish events to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicArn(java.lang.String topicArn) {
                this.topicArn = topicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnsDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnsDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnsDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnsDestinationProperty {
            private final java.lang.String topicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicArn = software.amazon.jsii.Kernel.get(this, "topicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicArn = java.util.Objects.requireNonNull(builder.topicArn, "topicArn is required");
            }

            @Override
            public final java.lang.String getTopicArn() {
                return this.topicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicArn", om.valueToTree(this.getTopicArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnConfigurationSet.SnsDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnsDestinationProperty.Jsii$Proxy that = (SnsDestinationProperty.Jsii$Proxy) o;

                return this.topicArn.equals(that.topicArn);
            }

            @Override
            public final int hashCode() {
                int result = this.topicArn.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.smsvoice.CfnConfigurationSet}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.smsvoice.CfnConfigurationSet> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.smsvoice.CfnConfigurationSetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the ConfigurationSet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-configurationsetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-configurationsetname</a>
         * @param configurationSetName The name of the ConfigurationSet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetName(final java.lang.String configurationSetName) {
            this.props().configurationSetName(configurationSetName);
            return this;
        }

        /**
         * The default sender ID used by the ConfigurationSet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-defaultsenderid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-defaultsenderid</a>
         * @param defaultSenderId The default sender ID used by the ConfigurationSet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSenderId(final java.lang.String defaultSenderId) {
            this.props().defaultSenderId(defaultSenderId);
            return this;
        }

        /**
         * An array of EventDestination objects that describe any events to log and where to log them.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-eventdestinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-eventdestinations</a>
         * @param eventDestinations An array of EventDestination objects that describe any events to log and where to log them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestinations(final software.amazon.awscdk.IResolvable eventDestinations) {
            this.props().eventDestinations(eventDestinations);
            return this;
        }
        /**
         * An array of EventDestination objects that describe any events to log and where to log them.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-eventdestinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-eventdestinations</a>
         * @param eventDestinations An array of EventDestination objects that describe any events to log and where to log them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestinations(final java.util.List<? extends java.lang.Object> eventDestinations) {
            this.props().eventDestinations(eventDestinations);
            return this;
        }

        /**
         * Set to true to enable feedback for the message.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-messagefeedbackenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-messagefeedbackenabled</a>
         * @param messageFeedbackEnabled Set to true to enable feedback for the message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageFeedbackEnabled(final java.lang.Boolean messageFeedbackEnabled) {
            this.props().messageFeedbackEnabled(messageFeedbackEnabled);
            return this;
        }
        /**
         * Set to true to enable feedback for the message.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-messagefeedbackenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-messagefeedbackenabled</a>
         * @param messageFeedbackEnabled Set to true to enable feedback for the message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageFeedbackEnabled(final software.amazon.awscdk.IResolvable messageFeedbackEnabled) {
            this.props().messageFeedbackEnabled(messageFeedbackEnabled);
            return this;
        }

        /**
         * The unique identifier for the protect configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-protectconfigurationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-protectconfigurationid</a>
         * @param protectConfigurationId The unique identifier for the protect configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectConfigurationId(final java.lang.String protectConfigurationId) {
            this.props().protectConfigurationId(protectConfigurationId);
            return this;
        }

        /**
         * An array of key and value pair tags that's associated with the new configuration set.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-tags</a>
         * @param tags An array of key and value pair tags that's associated with the new configuration set. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.smsvoice.CfnConfigurationSet}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.smsvoice.CfnConfigurationSet build() {
            return new software.amazon.awscdk.services.smsvoice.CfnConfigurationSet(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.smsvoice.CfnConfigurationSetProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.smsvoice.CfnConfigurationSetProps.Builder();
            }
            return this.props;
        }
    }
}
