package software.amazon.awscdk.services.smsvoice;

/**
 * Properties for defining a <code>CfnConfigurationSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.smsvoice.*;
 * CfnConfigurationSetProps cfnConfigurationSetProps = CfnConfigurationSetProps.builder()
 *         .configurationSetName("configurationSetName")
 *         .defaultSenderId("defaultSenderId")
 *         .eventDestinations(List.of(EventDestinationProperty.builder()
 *                 .enabled(false)
 *                 .eventDestinationName("eventDestinationName")
 *                 .matchingEventTypes(List.of("matchingEventTypes"))
 *                 // the properties below are optional
 *                 .cloudWatchLogsDestination(CloudWatchLogsDestinationProperty.builder()
 *                         .iamRoleArn("iamRoleArn")
 *                         .logGroupArn("logGroupArn")
 *                         .build())
 *                 .kinesisFirehoseDestination(KinesisFirehoseDestinationProperty.builder()
 *                         .deliveryStreamArn("deliveryStreamArn")
 *                         .iamRoleArn("iamRoleArn")
 *                         .build())
 *                 .snsDestination(SnsDestinationProperty.builder()
 *                         .topicArn("topicArn")
 *                         .build())
 *                 .build()))
 *         .messageFeedbackEnabled(false)
 *         .protectConfigurationId("protectConfigurationId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.453Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnConfigurationSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnConfigurationSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConfigurationSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the ConfigurationSet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-configurationsetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-configurationsetname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSetName() {
        return null;
    }

    /**
     * The default sender ID used by the ConfigurationSet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-defaultsenderid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-defaultsenderid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultSenderId() {
        return null;
    }

    /**
     * An array of EventDestination objects that describe any events to log and where to log them.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnConfigurationSet.EventDestinationProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-eventdestinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-eventdestinations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventDestinations() {
        return null;
    }

    /**
     * Set to true to enable feedback for the message.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-messagefeedbackenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-messagefeedbackenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMessageFeedbackEnabled() {
        return null;
    }

    /**
     * The unique identifier for the protect configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-protectconfigurationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-protectconfigurationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtectConfigurationId() {
        return null;
    }

    /**
     * An array of key and value pair tags that's associated with the new configuration set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-configurationset.html#cfn-smsvoice-configurationset-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConfigurationSetProps> {
        java.lang.String configurationSetName;
        java.lang.String defaultSenderId;
        java.lang.Object eventDestinations;
        java.lang.Object messageFeedbackEnabled;
        java.lang.String protectConfigurationId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getConfigurationSetName}
         * @param configurationSetName The name of the ConfigurationSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetName(java.lang.String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getDefaultSenderId}
         * @param defaultSenderId The default sender ID used by the ConfigurationSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSenderId(java.lang.String defaultSenderId) {
            this.defaultSenderId = defaultSenderId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getEventDestinations}
         * @param eventDestinations An array of EventDestination objects that describe any events to log and where to log them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestinations(software.amazon.awscdk.IResolvable eventDestinations) {
            this.eventDestinations = eventDestinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getEventDestinations}
         * @param eventDestinations An array of EventDestination objects that describe any events to log and where to log them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventDestinations(java.util.List<? extends java.lang.Object> eventDestinations) {
            this.eventDestinations = eventDestinations;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getMessageFeedbackEnabled}
         * @param messageFeedbackEnabled Set to true to enable feedback for the message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageFeedbackEnabled(java.lang.Boolean messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getMessageFeedbackEnabled}
         * @param messageFeedbackEnabled Set to true to enable feedback for the message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageFeedbackEnabled(software.amazon.awscdk.IResolvable messageFeedbackEnabled) {
            this.messageFeedbackEnabled = messageFeedbackEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getProtectConfigurationId}
         * @param protectConfigurationId The unique identifier for the protect configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectConfigurationId(java.lang.String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConfigurationSetProps#getTags}
         * @param tags An array of key and value pair tags that's associated with the new configuration set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConfigurationSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConfigurationSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConfigurationSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConfigurationSetProps {
        private final java.lang.String configurationSetName;
        private final java.lang.String defaultSenderId;
        private final java.lang.Object eventDestinations;
        private final java.lang.Object messageFeedbackEnabled;
        private final java.lang.String protectConfigurationId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.configurationSetName = software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultSenderId = software.amazon.jsii.Kernel.get(this, "defaultSenderId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventDestinations = software.amazon.jsii.Kernel.get(this, "eventDestinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.messageFeedbackEnabled = software.amazon.jsii.Kernel.get(this, "messageFeedbackEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.protectConfigurationId = software.amazon.jsii.Kernel.get(this, "protectConfigurationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.configurationSetName = builder.configurationSetName;
            this.defaultSenderId = builder.defaultSenderId;
            this.eventDestinations = builder.eventDestinations;
            this.messageFeedbackEnabled = builder.messageFeedbackEnabled;
            this.protectConfigurationId = builder.protectConfigurationId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final java.lang.String getDefaultSenderId() {
            return this.defaultSenderId;
        }

        @Override
        public final java.lang.Object getEventDestinations() {
            return this.eventDestinations;
        }

        @Override
        public final java.lang.Object getMessageFeedbackEnabled() {
            return this.messageFeedbackEnabled;
        }

        @Override
        public final java.lang.String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getConfigurationSetName() != null) {
                data.set("configurationSetName", om.valueToTree(this.getConfigurationSetName()));
            }
            if (this.getDefaultSenderId() != null) {
                data.set("defaultSenderId", om.valueToTree(this.getDefaultSenderId()));
            }
            if (this.getEventDestinations() != null) {
                data.set("eventDestinations", om.valueToTree(this.getEventDestinations()));
            }
            if (this.getMessageFeedbackEnabled() != null) {
                data.set("messageFeedbackEnabled", om.valueToTree(this.getMessageFeedbackEnabled()));
            }
            if (this.getProtectConfigurationId() != null) {
                data.set("protectConfigurationId", om.valueToTree(this.getProtectConfigurationId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnConfigurationSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConfigurationSetProps.Jsii$Proxy that = (CfnConfigurationSetProps.Jsii$Proxy) o;

            if (this.configurationSetName != null ? !this.configurationSetName.equals(that.configurationSetName) : that.configurationSetName != null) return false;
            if (this.defaultSenderId != null ? !this.defaultSenderId.equals(that.defaultSenderId) : that.defaultSenderId != null) return false;
            if (this.eventDestinations != null ? !this.eventDestinations.equals(that.eventDestinations) : that.eventDestinations != null) return false;
            if (this.messageFeedbackEnabled != null ? !this.messageFeedbackEnabled.equals(that.messageFeedbackEnabled) : that.messageFeedbackEnabled != null) return false;
            if (this.protectConfigurationId != null ? !this.protectConfigurationId.equals(that.protectConfigurationId) : that.protectConfigurationId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.configurationSetName != null ? this.configurationSetName.hashCode() : 0;
            result = 31 * result + (this.defaultSenderId != null ? this.defaultSenderId.hashCode() : 0);
            result = 31 * result + (this.eventDestinations != null ? this.eventDestinations.hashCode() : 0);
            result = 31 * result + (this.messageFeedbackEnabled != null ? this.messageFeedbackEnabled.hashCode() : 0);
            result = 31 * result + (this.protectConfigurationId != null ? this.protectConfigurationId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
