package software.amazon.awscdk.services.smsvoice;

/**
 * Properties for defining a <code>CfnPhoneNumber</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.smsvoice.*;
 * CfnPhoneNumberProps cfnPhoneNumberProps = CfnPhoneNumberProps.builder()
 *         .isoCountryCode("isoCountryCode")
 *         .mandatoryKeywords(MandatoryKeywordsProperty.builder()
 *                 .help(MandatoryKeywordProperty.builder()
 *                         .message("message")
 *                         .build())
 *                 .stop(MandatoryKeywordProperty.builder()
 *                         .message("message")
 *                         .build())
 *                 .build())
 *         .numberCapabilities(List.of("numberCapabilities"))
 *         .numberType("numberType")
 *         // the properties below are optional
 *         .deletionProtectionEnabled(false)
 *         .optionalKeywords(List.of(OptionalKeywordProperty.builder()
 *                 .action("action")
 *                 .keyword("keyword")
 *                 .message("message")
 *                 .build()))
 *         .optOutListName("optOutListName")
 *         .selfManagedOptOutsEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .twoWay(TwoWayProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .channelArn("channelArn")
 *                 .channelRole("channelRole")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.459Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnPhoneNumberProps")
@software.amazon.jsii.Jsii.Proxy(CfnPhoneNumberProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPhoneNumberProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-isocountrycode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-isocountrycode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIsoCountryCode();

    /**
     * Creates or updates a <code>MandatoryKeyword</code> configuration on an origination phone number For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPhoneNumber.MandatoryKeywordsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-mandatorykeywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-mandatorykeywords</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMandatoryKeywords();

    /**
     * Indicates if the phone number will be used for text messages, voice messages, or both.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-numbercapabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-numbercapabilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getNumberCapabilities();

    /**
     * The type of phone number to request.
     * <p>
     * <blockquote>
     * <p>
     * The <code>ShortCode</code> number type is not supported in AWS CloudFormation .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-numbertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-numbertype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNumberType();

    /**
     * By default this is set to false.
     * <p>
     * When set to true the phone number can't be deleted.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-deletionprotectionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtectionEnabled() {
        return null;
    }

    /**
     * A keyword is a word that you can search for on a particular phone number or pool.
     * <p>
     * It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, End User Messaging  responds with a customizable message. Optional keywords are differentiated from mandatory keywords. For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPhoneNumber.OptionalKeywordProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-optionalkeywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-optionalkeywords</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptionalKeywords() {
        return null;
    }

    /**
     * The name of the OptOutList associated with the phone number.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-optoutlistname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-optoutlistname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOptOutListName() {
        return null;
    }

    /**
     * When set to false and an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
     * <p>
     * When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/opt-out-list-self-managed.html">Self-managed opt-outs</a>
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-selfmanagedoptoutsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-selfmanagedoptoutsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedOptOutsEnabled() {
        return null;
    }

    /**
     * An array of tags (key and value pairs) to associate with the requested phone number.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Describes the two-way SMS configuration for a phone number.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/two-way-sms.html">Two-way SMS messaging</a> in the End User Messaging  User Guide.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPhoneNumber.TwoWayProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-twoway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-phonenumber.html#cfn-smsvoice-phonenumber-twoway</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTwoWay() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPhoneNumberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPhoneNumberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPhoneNumberProps> {
        java.lang.String isoCountryCode;
        java.lang.Object mandatoryKeywords;
        java.util.List<java.lang.String> numberCapabilities;
        java.lang.String numberType;
        java.lang.Object deletionProtectionEnabled;
        java.lang.Object optionalKeywords;
        java.lang.String optOutListName;
        java.lang.Object selfManagedOptOutsEnabled;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object twoWay;

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getIsoCountryCode}
         * @param isoCountryCode The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isoCountryCode(java.lang.String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getMandatoryKeywords}
         * @param mandatoryKeywords Creates or updates a <code>MandatoryKeyword</code> configuration on an origination phone number For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatoryKeywords(software.amazon.awscdk.IResolvable mandatoryKeywords) {
            this.mandatoryKeywords = mandatoryKeywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getMandatoryKeywords}
         * @param mandatoryKeywords Creates or updates a <code>MandatoryKeyword</code> configuration on an origination phone number For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatoryKeywords(software.amazon.awscdk.services.smsvoice.CfnPhoneNumber.MandatoryKeywordsProperty mandatoryKeywords) {
            this.mandatoryKeywords = mandatoryKeywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getNumberCapabilities}
         * @param numberCapabilities Indicates if the phone number will be used for text messages, voice messages, or both. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberCapabilities(java.util.List<java.lang.String> numberCapabilities) {
            this.numberCapabilities = numberCapabilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getNumberType}
         * @param numberType The type of phone number to request. This parameter is required.
         *                   <blockquote>
         *                   <p>
         *                   The <code>ShortCode</code> number type is not supported in AWS CloudFormation .
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberType(java.lang.String numberType) {
            this.numberType = numberType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getDeletionProtectionEnabled}
         * @param deletionProtectionEnabled By default this is set to false.
         *                                  When set to true the phone number can't be deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(java.lang.Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getDeletionProtectionEnabled}
         * @param deletionProtectionEnabled By default this is set to false.
         *                                  When set to true the phone number can't be deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(software.amazon.awscdk.IResolvable deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getOptionalKeywords}
         * @param optionalKeywords A keyword is a word that you can search for on a particular phone number or pool.
         *                         It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, End User Messaging  responds with a customizable message. Optional keywords are differentiated from mandatory keywords. For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionalKeywords(software.amazon.awscdk.IResolvable optionalKeywords) {
            this.optionalKeywords = optionalKeywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getOptionalKeywords}
         * @param optionalKeywords A keyword is a word that you can search for on a particular phone number or pool.
         *                         It is also a specific word or phrase that an end user can send to your number to elicit a response, such as an informational message or a special offer. When your number receives a message that begins with a keyword, End User Messaging  responds with a customizable message. Optional keywords are differentiated from mandatory keywords. For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionalKeywords(java.util.List<? extends java.lang.Object> optionalKeywords) {
            this.optionalKeywords = optionalKeywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getOptOutListName}
         * @param optOutListName The name of the OptOutList associated with the phone number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optOutListName(java.lang.String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getSelfManagedOptOutsEnabled}
         * @param selfManagedOptOutsEnabled When set to false and an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
         *                                  When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/opt-out-list-self-managed.html">Self-managed opt-outs</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedOptOutsEnabled(java.lang.Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getSelfManagedOptOutsEnabled}
         * @param selfManagedOptOutsEnabled When set to false and an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
         *                                  When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out request. For more information see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/opt-out-list-self-managed.html">Self-managed opt-outs</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedOptOutsEnabled(software.amazon.awscdk.IResolvable selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getTags}
         * @param tags An array of tags (key and value pairs) to associate with the requested phone number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getTwoWay}
         * @param twoWay Describes the two-way SMS configuration for a phone number.
         *               For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/two-way-sms.html">Two-way SMS messaging</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder twoWay(software.amazon.awscdk.IResolvable twoWay) {
            this.twoWay = twoWay;
            return this;
        }

        /**
         * Sets the value of {@link CfnPhoneNumberProps#getTwoWay}
         * @param twoWay Describes the two-way SMS configuration for a phone number.
         *               For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/two-way-sms.html">Two-way SMS messaging</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder twoWay(software.amazon.awscdk.services.smsvoice.CfnPhoneNumber.TwoWayProperty twoWay) {
            this.twoWay = twoWay;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPhoneNumberProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPhoneNumberProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPhoneNumberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPhoneNumberProps {
        private final java.lang.String isoCountryCode;
        private final java.lang.Object mandatoryKeywords;
        private final java.util.List<java.lang.String> numberCapabilities;
        private final java.lang.String numberType;
        private final java.lang.Object deletionProtectionEnabled;
        private final java.lang.Object optionalKeywords;
        private final java.lang.String optOutListName;
        private final java.lang.Object selfManagedOptOutsEnabled;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object twoWay;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.isoCountryCode = software.amazon.jsii.Kernel.get(this, "isoCountryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mandatoryKeywords = software.amazon.jsii.Kernel.get(this, "mandatoryKeywords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.numberCapabilities = software.amazon.jsii.Kernel.get(this, "numberCapabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.numberType = software.amazon.jsii.Kernel.get(this, "numberType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletionProtectionEnabled = software.amazon.jsii.Kernel.get(this, "deletionProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.optionalKeywords = software.amazon.jsii.Kernel.get(this, "optionalKeywords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.optOutListName = software.amazon.jsii.Kernel.get(this, "optOutListName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.selfManagedOptOutsEnabled = software.amazon.jsii.Kernel.get(this, "selfManagedOptOutsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.twoWay = software.amazon.jsii.Kernel.get(this, "twoWay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.isoCountryCode = java.util.Objects.requireNonNull(builder.isoCountryCode, "isoCountryCode is required");
            this.mandatoryKeywords = java.util.Objects.requireNonNull(builder.mandatoryKeywords, "mandatoryKeywords is required");
            this.numberCapabilities = java.util.Objects.requireNonNull(builder.numberCapabilities, "numberCapabilities is required");
            this.numberType = java.util.Objects.requireNonNull(builder.numberType, "numberType is required");
            this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
            this.optionalKeywords = builder.optionalKeywords;
            this.optOutListName = builder.optOutListName;
            this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.twoWay = builder.twoWay;
        }

        @Override
        public final java.lang.String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        @Override
        public final java.lang.Object getMandatoryKeywords() {
            return this.mandatoryKeywords;
        }

        @Override
        public final java.util.List<java.lang.String> getNumberCapabilities() {
            return this.numberCapabilities;
        }

        @Override
        public final java.lang.String getNumberType() {
            return this.numberType;
        }

        @Override
        public final java.lang.Object getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        @Override
        public final java.lang.Object getOptionalKeywords() {
            return this.optionalKeywords;
        }

        @Override
        public final java.lang.String getOptOutListName() {
            return this.optOutListName;
        }

        @Override
        public final java.lang.Object getSelfManagedOptOutsEnabled() {
            return this.selfManagedOptOutsEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTwoWay() {
            return this.twoWay;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("isoCountryCode", om.valueToTree(this.getIsoCountryCode()));
            data.set("mandatoryKeywords", om.valueToTree(this.getMandatoryKeywords()));
            data.set("numberCapabilities", om.valueToTree(this.getNumberCapabilities()));
            data.set("numberType", om.valueToTree(this.getNumberType()));
            if (this.getDeletionProtectionEnabled() != null) {
                data.set("deletionProtectionEnabled", om.valueToTree(this.getDeletionProtectionEnabled()));
            }
            if (this.getOptionalKeywords() != null) {
                data.set("optionalKeywords", om.valueToTree(this.getOptionalKeywords()));
            }
            if (this.getOptOutListName() != null) {
                data.set("optOutListName", om.valueToTree(this.getOptOutListName()));
            }
            if (this.getSelfManagedOptOutsEnabled() != null) {
                data.set("selfManagedOptOutsEnabled", om.valueToTree(this.getSelfManagedOptOutsEnabled()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTwoWay() != null) {
                data.set("twoWay", om.valueToTree(this.getTwoWay()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnPhoneNumberProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPhoneNumberProps.Jsii$Proxy that = (CfnPhoneNumberProps.Jsii$Proxy) o;

            if (!isoCountryCode.equals(that.isoCountryCode)) return false;
            if (!mandatoryKeywords.equals(that.mandatoryKeywords)) return false;
            if (!numberCapabilities.equals(that.numberCapabilities)) return false;
            if (!numberType.equals(that.numberType)) return false;
            if (this.deletionProtectionEnabled != null ? !this.deletionProtectionEnabled.equals(that.deletionProtectionEnabled) : that.deletionProtectionEnabled != null) return false;
            if (this.optionalKeywords != null ? !this.optionalKeywords.equals(that.optionalKeywords) : that.optionalKeywords != null) return false;
            if (this.optOutListName != null ? !this.optOutListName.equals(that.optOutListName) : that.optOutListName != null) return false;
            if (this.selfManagedOptOutsEnabled != null ? !this.selfManagedOptOutsEnabled.equals(that.selfManagedOptOutsEnabled) : that.selfManagedOptOutsEnabled != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.twoWay != null ? this.twoWay.equals(that.twoWay) : that.twoWay == null;
        }

        @Override
        public final int hashCode() {
            int result = this.isoCountryCode.hashCode();
            result = 31 * result + (this.mandatoryKeywords.hashCode());
            result = 31 * result + (this.numberCapabilities.hashCode());
            result = 31 * result + (this.numberType.hashCode());
            result = 31 * result + (this.deletionProtectionEnabled != null ? this.deletionProtectionEnabled.hashCode() : 0);
            result = 31 * result + (this.optionalKeywords != null ? this.optionalKeywords.hashCode() : 0);
            result = 31 * result + (this.optOutListName != null ? this.optOutListName.hashCode() : 0);
            result = 31 * result + (this.selfManagedOptOutsEnabled != null ? this.selfManagedOptOutsEnabled.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.twoWay != null ? this.twoWay.hashCode() : 0);
            return result;
        }
    }
}
