package software.amazon.awscdk.services.smsvoice;

/**
 * Creates a new pool and associates the specified origination identity to the pool.
 * <p>
 * A pool can include one or more phone numbers and SenderIds that are associated with your AWS account.
 * <p>
 * The new pool inherits its configuration from the specified origination identity. This includes keywords, message type, opt-out list, two-way configuration, and self-managed opt-out configuration. Deletion protection isn't inherited from the origination identity and defaults to false.
 * <p>
 * If the origination identity is a phone number and is already associated with another pool, an error is returned. A sender ID can be associated with multiple pools.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.smsvoice.*;
 * CfnPool cfnPool = CfnPool.Builder.create(this, "MyCfnPool")
 *         .mandatoryKeywords(MandatoryKeywordsProperty.builder()
 *                 .help(MandatoryKeywordProperty.builder()
 *                         .message("message")
 *                         .build())
 *                 .stop(MandatoryKeywordProperty.builder()
 *                         .message("message")
 *                         .build())
 *                 .build())
 *         .originationIdentities(List.of("originationIdentities"))
 *         // the properties below are optional
 *         .deletionProtectionEnabled(false)
 *         .optionalKeywords(List.of(OptionalKeywordProperty.builder()
 *                 .action("action")
 *                 .keyword("keyword")
 *                 .message("message")
 *                 .build()))
 *         .optOutListName("optOutListName")
 *         .selfManagedOptOutsEnabled(false)
 *         .sharedRoutesEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .twoWay(TwoWayProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .channelArn("channelArn")
 *                 .channelRole("channelRole")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.460Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnPool")
public class CfnPool extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.smsvoice.IPoolRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnPool(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPool(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.smsvoice.CfnPool.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPool(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.CfnPoolProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new IPoolRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.IPoolRef fromPoolArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.smsvoice.CfnPool.class, "fromPoolArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.IPoolRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Creates a new IPoolRef from a poolId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param poolId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.IPoolRef fromPoolId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String poolId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.smsvoice.CfnPool.class, "fromPoolId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.IPoolRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(poolId, "poolId is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name of the <code>Pool</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPoolId() {
        return software.amazon.jsii.Kernel.get(this, "attrPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a Pool resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.PoolReference getPoolRef() {
        return software.amazon.jsii.Kernel.get(this, "poolRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.PoolReference.class));
    }

    /**
     * Creates or updates the pool's <code>MandatoryKeyword</code> configuration.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordsProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMandatoryKeywords() {
        return software.amazon.jsii.Kernel.get(this, "mandatoryKeywords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Creates or updates the pool's <code>MandatoryKeyword</code> configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMandatoryKeywords(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mandatoryKeywords", java.util.Objects.requireNonNull(value, "mandatoryKeywords is required"));
    }

    /**
     * Creates or updates the pool's <code>MandatoryKeyword</code> configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMandatoryKeywords(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordsProperty value) {
        software.amazon.jsii.Kernel.set(this, "mandatoryKeywords", java.util.Objects.requireNonNull(value, "mandatoryKeywords is required"));
    }

    /**
     * The list of origination identities to apply to the pool, either <code>PhoneNumberArn</code> or <code>SenderIdArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOriginationIdentities() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "originationIdentities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The list of origination identities to apply to the pool, either <code>PhoneNumberArn</code> or <code>SenderIdArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOriginationIdentities(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "originationIdentities", java.util.Objects.requireNonNull(value, "originationIdentities is required"));
    }

    /**
     * When set to true the pool can't be deleted.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtectionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When set to true the pool can't be deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtectionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtectionEnabled", value);
    }

    /**
     * When set to true the pool can't be deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtectionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtectionEnabled", value);
    }

    /**
     * Specifies any optional keywords to associate with the pool.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPool.OptionalKeywordProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOptionalKeywords() {
        return software.amazon.jsii.Kernel.get(this, "optionalKeywords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies any optional keywords to associate with the pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionalKeywords(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "optionalKeywords", value);
    }

    /**
     * Specifies any optional keywords to associate with the pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptionalKeywords(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.smsvoice.CfnPool.OptionalKeywordProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.smsvoice.CfnPool.OptionalKeywordProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "optionalKeywords", value);
    }

    /**
     * The name of the OptOutList associated with the pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOptOutListName() {
        return software.amazon.jsii.Kernel.get(this, "optOutListName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the OptOutList associated with the pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptOutListName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "optOutListName", value);
    }

    /**
     * When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedOptOutsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "selfManagedOptOutsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSelfManagedOptOutsEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "selfManagedOptOutsEnabled", value);
    }

    /**
     * When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSelfManagedOptOutsEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "selfManagedOptOutsEnabled", value);
    }

    /**
     * Allows you to enable shared routes on your pool.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSharedRoutesEnabled() {
        return software.amazon.jsii.Kernel.get(this, "sharedRoutesEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Allows you to enable shared routes on your pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSharedRoutesEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "sharedRoutesEnabled", value);
    }

    /**
     * Allows you to enable shared routes on your pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSharedRoutesEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sharedRoutesEnabled", value);
    }

    /**
     * An array of tags (key and value pairs) associated with the pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of tags (key and value pairs) associated with the pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Describes the two-way SMS configuration for a phone number.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPool.TwoWayProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTwoWay() {
        return software.amazon.jsii.Kernel.get(this, "twoWay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the two-way SMS configuration for a phone number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTwoWay(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "twoWay", value);
    }

    /**
     * Describes the two-way SMS configuration for a phone number.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTwoWay(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.smsvoice.CfnPool.TwoWayProperty value) {
        software.amazon.jsii.Kernel.set(this, "twoWay", value);
    }
    /**
     * The keywords <code>HELP</code> and <code>STOP</code> are mandatory keywords that each phone number must have.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * MandatoryKeywordProperty mandatoryKeywordProperty = MandatoryKeywordProperty.builder()
     *         .message("message")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeyword.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeyword.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnPool.MandatoryKeywordProperty")
    @software.amazon.jsii.Jsii.Proxy(MandatoryKeywordProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MandatoryKeywordProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message associated with the keyword.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeyword.html#cfn-smsvoice-pool-mandatorykeyword-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeyword.html#cfn-smsvoice-pool-mandatorykeyword-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessage();

        /**
         * @return a {@link Builder} of {@link MandatoryKeywordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MandatoryKeywordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MandatoryKeywordProperty> {
            java.lang.String message;

            /**
             * Sets the value of {@link MandatoryKeywordProperty#getMessage}
             * @param message The message associated with the keyword. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MandatoryKeywordProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MandatoryKeywordProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MandatoryKeywordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MandatoryKeywordProperty {
            private final java.lang.String message;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("message", om.valueToTree(this.getMessage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnPool.MandatoryKeywordProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MandatoryKeywordProperty.Jsii$Proxy that = (MandatoryKeywordProperty.Jsii$Proxy) o;

                return this.message.equals(that.message);
            }

            @Override
            public final int hashCode() {
                int result = this.message.hashCode();
                return result;
            }
        }
    }
    /**
     * The manadatory keywords, <code>HELP</code> and <code>STOP</code> to add to the pool.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * MandatoryKeywordsProperty mandatoryKeywordsProperty = MandatoryKeywordsProperty.builder()
     *         .help(MandatoryKeywordProperty.builder()
     *                 .message("message")
     *                 .build())
     *         .stop(MandatoryKeywordProperty.builder()
     *                 .message("message")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeywords.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeywords.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnPool.MandatoryKeywordsProperty")
    @software.amazon.jsii.Jsii.Proxy(MandatoryKeywordsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MandatoryKeywordsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the pool's <code>HELP</code> keyword.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/opt-out-list-keywords.html">Opt out list required keywords</a> in the End User Messaging  User Guide.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeywords.html#cfn-smsvoice-pool-mandatorykeywords-help">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeywords.html#cfn-smsvoice-pool-mandatorykeywords-help</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHelp();

        /**
         * Specifies the pool's opt-out keyword.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords-required.html">Required opt-out keywords</a> in the End User Messaging  User Guide.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeywords.html#cfn-smsvoice-pool-mandatorykeywords-stop">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-mandatorykeywords.html#cfn-smsvoice-pool-mandatorykeywords-stop</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStop();

        /**
         * @return a {@link Builder} of {@link MandatoryKeywordsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MandatoryKeywordsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MandatoryKeywordsProperty> {
            java.lang.Object help;
            java.lang.Object stop;

            /**
             * Sets the value of {@link MandatoryKeywordsProperty#getHelp}
             * @param help Specifies the pool's <code>HELP</code> keyword. This parameter is required.
             *             For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/opt-out-list-keywords.html">Opt out list required keywords</a> in the End User Messaging  User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder help(software.amazon.awscdk.IResolvable help) {
                this.help = help;
                return this;
            }

            /**
             * Sets the value of {@link MandatoryKeywordsProperty#getHelp}
             * @param help Specifies the pool's <code>HELP</code> keyword. This parameter is required.
             *             For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/opt-out-list-keywords.html">Opt out list required keywords</a> in the End User Messaging  User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder help(software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordProperty help) {
                this.help = help;
                return this;
            }

            /**
             * Sets the value of {@link MandatoryKeywordsProperty#getStop}
             * @param stop Specifies the pool's opt-out keyword. This parameter is required.
             *             For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords-required.html">Required opt-out keywords</a> in the End User Messaging  User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stop(software.amazon.awscdk.IResolvable stop) {
                this.stop = stop;
                return this;
            }

            /**
             * Sets the value of {@link MandatoryKeywordsProperty#getStop}
             * @param stop Specifies the pool's opt-out keyword. This parameter is required.
             *             For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords-required.html">Required opt-out keywords</a> in the End User Messaging  User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stop(software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordProperty stop) {
                this.stop = stop;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MandatoryKeywordsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MandatoryKeywordsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MandatoryKeywordsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MandatoryKeywordsProperty {
            private final java.lang.Object help;
            private final java.lang.Object stop;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.help = software.amazon.jsii.Kernel.get(this, "help", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stop = software.amazon.jsii.Kernel.get(this, "stop", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.help = java.util.Objects.requireNonNull(builder.help, "help is required");
                this.stop = java.util.Objects.requireNonNull(builder.stop, "stop is required");
            }

            @Override
            public final java.lang.Object getHelp() {
                return this.help;
            }

            @Override
            public final java.lang.Object getStop() {
                return this.stop;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("help", om.valueToTree(this.getHelp()));
                data.set("stop", om.valueToTree(this.getStop()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnPool.MandatoryKeywordsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MandatoryKeywordsProperty.Jsii$Proxy that = (MandatoryKeywordsProperty.Jsii$Proxy) o;

                if (!help.equals(that.help)) return false;
                return this.stop.equals(that.stop);
            }

            @Override
            public final int hashCode() {
                int result = this.help.hashCode();
                result = 31 * result + (this.stop.hashCode());
                return result;
            }
        }
    }
    /**
     * The pool's <code>OptionalKeyword</code> configuration.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * OptionalKeywordProperty optionalKeywordProperty = OptionalKeywordProperty.builder()
     *         .action("action")
     *         .keyword("keyword")
     *         .message("message")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-optionalkeyword.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-optionalkeyword.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnPool.OptionalKeywordProperty")
    @software.amazon.jsii.Jsii.Proxy(OptionalKeywordProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OptionalKeywordProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to perform when the keyword is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-optionalkeyword.html#cfn-smsvoice-pool-optionalkeyword-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-optionalkeyword.html#cfn-smsvoice-pool-optionalkeyword-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The new keyword to add.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-optionalkeyword.html#cfn-smsvoice-pool-optionalkeyword-keyword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-optionalkeyword.html#cfn-smsvoice-pool-optionalkeyword-keyword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyword();

        /**
         * The message associated with the keyword.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-optionalkeyword.html#cfn-smsvoice-pool-optionalkeyword-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-optionalkeyword.html#cfn-smsvoice-pool-optionalkeyword-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessage();

        /**
         * @return a {@link Builder} of {@link OptionalKeywordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OptionalKeywordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OptionalKeywordProperty> {
            java.lang.String action;
            java.lang.String keyword;
            java.lang.String message;

            /**
             * Sets the value of {@link OptionalKeywordProperty#getAction}
             * @param action The action to perform when the keyword is used. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link OptionalKeywordProperty#getKeyword}
             * @param keyword The new keyword to add. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyword(java.lang.String keyword) {
                this.keyword = keyword;
                return this;
            }

            /**
             * Sets the value of {@link OptionalKeywordProperty#getMessage}
             * @param message The message associated with the keyword. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OptionalKeywordProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OptionalKeywordProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OptionalKeywordProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OptionalKeywordProperty {
            private final java.lang.String action;
            private final java.lang.String keyword;
            private final java.lang.String message;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyword = software.amazon.jsii.Kernel.get(this, "keyword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.keyword = java.util.Objects.requireNonNull(builder.keyword, "keyword is required");
                this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getKeyword() {
                return this.keyword;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("keyword", om.valueToTree(this.getKeyword()));
                data.set("message", om.valueToTree(this.getMessage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnPool.OptionalKeywordProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OptionalKeywordProperty.Jsii$Proxy that = (OptionalKeywordProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!keyword.equals(that.keyword)) return false;
                return this.message.equals(that.message);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.keyword.hashCode());
                result = 31 * result + (this.message.hashCode());
                return result;
            }
        }
    }
    /**
     * The pool's two-way SMS configuration object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * TwoWayProperty twoWayProperty = TwoWayProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .channelArn("channelArn")
     *         .channelRole("channelRole")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-twoway.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-twoway.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnPool.TwoWayProperty")
    @software.amazon.jsii.Jsii.Proxy(TwoWayProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TwoWayProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * By default this is set to false.
         * <p>
         * When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-twoway.html#cfn-smsvoice-pool-twoway-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-twoway.html#cfn-smsvoice-pool-twoway-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The Amazon Resource Name (ARN) of the two way channel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-twoway.html#cfn-smsvoice-pool-twoway-channelarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-twoway.html#cfn-smsvoice-pool-twoway-channelarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getChannelArn() {
            return null;
        }

        /**
         * An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-twoway.html#cfn-smsvoice-pool-twoway-channelrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-pool-twoway.html#cfn-smsvoice-pool-twoway-channelrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getChannelRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TwoWayProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TwoWayProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TwoWayProperty> {
            java.lang.Object enabled;
            java.lang.String channelArn;
            java.lang.String channelRole;

            /**
             * Sets the value of {@link TwoWayProperty#getEnabled}
             * @param enabled By default this is set to false. This parameter is required.
             *                When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TwoWayProperty#getEnabled}
             * @param enabled By default this is set to false. This parameter is required.
             *                When set to true you can receive incoming text messages from your end recipients using the TwoWayChannelArn.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TwoWayProperty#getChannelArn}
             * @param channelArn The Amazon Resource Name (ARN) of the two way channel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelArn(java.lang.String channelArn) {
                this.channelArn = channelArn;
                return this;
            }

            /**
             * Sets the value of {@link TwoWayProperty#getChannelRole}
             * @param channelRole An optional IAM Role Arn for a service to assume, to be able to post inbound SMS messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelRole(java.lang.String channelRole) {
                this.channelRole = channelRole;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TwoWayProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TwoWayProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TwoWayProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TwoWayProperty {
            private final java.lang.Object enabled;
            private final java.lang.String channelArn;
            private final java.lang.String channelRole;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.channelArn = software.amazon.jsii.Kernel.get(this, "channelArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.channelRole = software.amazon.jsii.Kernel.get(this, "channelRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.channelArn = builder.channelArn;
                this.channelRole = builder.channelRole;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getChannelArn() {
                return this.channelArn;
            }

            @Override
            public final java.lang.String getChannelRole() {
                return this.channelRole;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getChannelArn() != null) {
                    data.set("channelArn", om.valueToTree(this.getChannelArn()));
                }
                if (this.getChannelRole() != null) {
                    data.set("channelRole", om.valueToTree(this.getChannelRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnPool.TwoWayProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TwoWayProperty.Jsii$Proxy that = (TwoWayProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.channelArn != null ? !this.channelArn.equals(that.channelArn) : that.channelArn != null) return false;
                return this.channelRole != null ? this.channelRole.equals(that.channelRole) : that.channelRole == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.channelArn != null ? this.channelArn.hashCode() : 0);
                result = 31 * result + (this.channelRole != null ? this.channelRole.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.smsvoice.CfnPool}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.smsvoice.CfnPool> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.smsvoice.CfnPoolProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.smsvoice.CfnPoolProps.Builder();
        }

        /**
         * Creates or updates the pool's <code>MandatoryKeyword</code> configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-mandatorykeywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-mandatorykeywords</a>
         * @param mandatoryKeywords Creates or updates the pool's <code>MandatoryKeyword</code> configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatoryKeywords(final software.amazon.awscdk.IResolvable mandatoryKeywords) {
            this.props.mandatoryKeywords(mandatoryKeywords);
            return this;
        }
        /**
         * Creates or updates the pool's <code>MandatoryKeyword</code> configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-mandatorykeywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-mandatorykeywords</a>
         * @param mandatoryKeywords Creates or updates the pool's <code>MandatoryKeyword</code> configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatoryKeywords(final software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordsProperty mandatoryKeywords) {
            this.props.mandatoryKeywords(mandatoryKeywords);
            return this;
        }

        /**
         * The list of origination identities to apply to the pool, either <code>PhoneNumberArn</code> or <code>SenderIdArn</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/registrations.html">Registrations</a> in the End User Messaging  User Guide.
         * <p>
         * <blockquote>
         * <p>
         * If you are using a shared End User Messaging  resource then you must use the full Amazon Resource Name (ARN).
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-originationidentities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-originationidentities</a>
         * @param originationIdentities The list of origination identities to apply to the pool, either <code>PhoneNumberArn</code> or <code>SenderIdArn</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originationIdentities(final java.util.List<java.lang.String> originationIdentities) {
            this.props.originationIdentities(originationIdentities);
            return this;
        }

        /**
         * When set to true the pool can't be deleted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-deletionprotectionenabled</a>
         * @param deletionProtectionEnabled When set to true the pool can't be deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(final java.lang.Boolean deletionProtectionEnabled) {
            this.props.deletionProtectionEnabled(deletionProtectionEnabled);
            return this;
        }
        /**
         * When set to true the pool can't be deleted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-deletionprotectionenabled</a>
         * @param deletionProtectionEnabled When set to true the pool can't be deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(final software.amazon.awscdk.IResolvable deletionProtectionEnabled) {
            this.props.deletionProtectionEnabled(deletionProtectionEnabled);
            return this;
        }

        /**
         * Specifies any optional keywords to associate with the pool.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optionalkeywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optionalkeywords</a>
         * @param optionalKeywords Specifies any optional keywords to associate with the pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionalKeywords(final software.amazon.awscdk.IResolvable optionalKeywords) {
            this.props.optionalKeywords(optionalKeywords);
            return this;
        }
        /**
         * Specifies any optional keywords to associate with the pool.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optionalkeywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optionalkeywords</a>
         * @param optionalKeywords Specifies any optional keywords to associate with the pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionalKeywords(final java.util.List<? extends java.lang.Object> optionalKeywords) {
            this.props.optionalKeywords(optionalKeywords);
            return this;
        }

        /**
         * The name of the OptOutList associated with the pool.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optoutlistname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optoutlistname</a>
         * @param optOutListName The name of the OptOutList associated with the pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optOutListName(final java.lang.String optOutListName) {
            this.props.optOutListName(optOutListName);
            return this;
        }

        /**
         * When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
         * <p>
         * When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com//pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-selfmanagedoptoutsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-selfmanagedoptoutsenabled</a>
         * @param selfManagedOptOutsEnabled When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedOptOutsEnabled(final java.lang.Boolean selfManagedOptOutsEnabled) {
            this.props.selfManagedOptOutsEnabled(selfManagedOptOutsEnabled);
            return this;
        }
        /**
         * When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
         * <p>
         * When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com//pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-selfmanagedoptoutsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-selfmanagedoptoutsenabled</a>
         * @param selfManagedOptOutsEnabled When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedOptOutsEnabled(final software.amazon.awscdk.IResolvable selfManagedOptOutsEnabled) {
            this.props.selfManagedOptOutsEnabled(selfManagedOptOutsEnabled);
            return this;
        }

        /**
         * Allows you to enable shared routes on your pool.
         * <p>
         * By default, this is set to <code>False</code> . If you set this value to <code>True</code> , your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-sharedroutesenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-sharedroutesenabled</a>
         * @param sharedRoutesEnabled Allows you to enable shared routes on your pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sharedRoutesEnabled(final java.lang.Boolean sharedRoutesEnabled) {
            this.props.sharedRoutesEnabled(sharedRoutesEnabled);
            return this;
        }
        /**
         * Allows you to enable shared routes on your pool.
         * <p>
         * By default, this is set to <code>False</code> . If you set this value to <code>True</code> , your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-sharedroutesenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-sharedroutesenabled</a>
         * @param sharedRoutesEnabled Allows you to enable shared routes on your pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sharedRoutesEnabled(final software.amazon.awscdk.IResolvable sharedRoutesEnabled) {
            this.props.sharedRoutesEnabled(sharedRoutesEnabled);
            return this;
        }

        /**
         * An array of tags (key and value pairs) associated with the pool.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-tags</a>
         * @param tags An array of tags (key and value pairs) associated with the pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Describes the two-way SMS configuration for a phone number.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/two-way-sms.html">Two-way SMS messaging</a> in the End User Messaging  User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-twoway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-twoway</a>
         * @param twoWay Describes the two-way SMS configuration for a phone number. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder twoWay(final software.amazon.awscdk.IResolvable twoWay) {
            this.props.twoWay(twoWay);
            return this;
        }
        /**
         * Describes the two-way SMS configuration for a phone number.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/two-way-sms.html">Two-way SMS messaging</a> in the End User Messaging  User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-twoway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-twoway</a>
         * @param twoWay Describes the two-way SMS configuration for a phone number. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder twoWay(final software.amazon.awscdk.services.smsvoice.CfnPool.TwoWayProperty twoWay) {
            this.props.twoWay(twoWay);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.smsvoice.CfnPool}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.smsvoice.CfnPool build() {
            return new software.amazon.awscdk.services.smsvoice.CfnPool(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
