package software.amazon.awscdk.services.smsvoice;

/**
 * Properties for defining a <code>CfnPool</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.smsvoice.*;
 * CfnPoolProps cfnPoolProps = CfnPoolProps.builder()
 *         .mandatoryKeywords(MandatoryKeywordsProperty.builder()
 *                 .help(MandatoryKeywordProperty.builder()
 *                         .message("message")
 *                         .build())
 *                 .stop(MandatoryKeywordProperty.builder()
 *                         .message("message")
 *                         .build())
 *                 .build())
 *         .originationIdentities(List.of("originationIdentities"))
 *         // the properties below are optional
 *         .deletionProtectionEnabled(false)
 *         .optionalKeywords(List.of(OptionalKeywordProperty.builder()
 *                 .action("action")
 *                 .keyword("keyword")
 *                 .message("message")
 *                 .build()))
 *         .optOutListName("optOutListName")
 *         .selfManagedOptOutsEnabled(false)
 *         .sharedRoutesEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .twoWay(TwoWayProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .channelArn("channelArn")
 *                 .channelRole("channelRole")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.464Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Creates or updates the pool's <code>MandatoryKeyword</code> configuration.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-mandatorykeywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-mandatorykeywords</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getMandatoryKeywords();

    /**
     * The list of origination identities to apply to the pool, either <code>PhoneNumberArn</code> or <code>SenderIdArn</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/registrations.html">Registrations</a> in the End User Messaging  User Guide.
     * <p>
     * <blockquote>
     * <p>
     * If you are using a shared End User Messaging  resource then you must use the full Amazon Resource Name (ARN).
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-originationidentities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-originationidentities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOriginationIdentities();

    /**
     * When set to true the pool can't be deleted.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-deletionprotectionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtectionEnabled() {
        return null;
    }

    /**
     * Specifies any optional keywords to associate with the pool.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPool.OptionalKeywordProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optionalkeywords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optionalkeywords</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptionalKeywords() {
        return null;
    }

    /**
     * The name of the OptOutList associated with the pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optoutlistname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-optoutlistname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOptOutListName() {
        return null;
    }

    /**
     * When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
     * <p>
     * When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com//pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a>
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-selfmanagedoptoutsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-selfmanagedoptoutsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedOptOutsEnabled() {
        return null;
    }

    /**
     * Allows you to enable shared routes on your pool.
     * <p>
     * By default, this is set to <code>False</code> . If you set this value to <code>True</code> , your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-sharedroutesenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-sharedroutesenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSharedRoutesEnabled() {
        return null;
    }

    /**
     * An array of tags (key and value pairs) associated with the pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Describes the two-way SMS configuration for a phone number.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/two-way-sms.html">Two-way SMS messaging</a> in the End User Messaging  User Guide.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnPool.TwoWayProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-twoway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-pool.html#cfn-smsvoice-pool-twoway</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTwoWay() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPoolProps> {
        java.lang.Object mandatoryKeywords;
        java.util.List<java.lang.String> originationIdentities;
        java.lang.Object deletionProtectionEnabled;
        java.lang.Object optionalKeywords;
        java.lang.String optOutListName;
        java.lang.Object selfManagedOptOutsEnabled;
        java.lang.Object sharedRoutesEnabled;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object twoWay;

        /**
         * Sets the value of {@link CfnPoolProps#getMandatoryKeywords}
         * @param mandatoryKeywords Creates or updates the pool's <code>MandatoryKeyword</code> configuration. This parameter is required.
         *                          For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatoryKeywords(software.amazon.awscdk.IResolvable mandatoryKeywords) {
            this.mandatoryKeywords = mandatoryKeywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getMandatoryKeywords}
         * @param mandatoryKeywords Creates or updates the pool's <code>MandatoryKeyword</code> configuration. This parameter is required.
         *                          For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mandatoryKeywords(software.amazon.awscdk.services.smsvoice.CfnPool.MandatoryKeywordsProperty mandatoryKeywords) {
            this.mandatoryKeywords = mandatoryKeywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getOriginationIdentities}
         * @param originationIdentities The list of origination identities to apply to the pool, either <code>PhoneNumberArn</code> or <code>SenderIdArn</code> . This parameter is required.
         *                              For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/registrations.html">Registrations</a> in the End User Messaging  User Guide.
         *                              <p>
         *                              <blockquote>
         *                              <p>
         *                              If you are using a shared End User Messaging  resource then you must use the full Amazon Resource Name (ARN).
         *                              <p>
         *                              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originationIdentities(java.util.List<java.lang.String> originationIdentities) {
            this.originationIdentities = originationIdentities;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getDeletionProtectionEnabled}
         * @param deletionProtectionEnabled When set to true the pool can't be deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(java.lang.Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getDeletionProtectionEnabled}
         * @param deletionProtectionEnabled When set to true the pool can't be deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(software.amazon.awscdk.IResolvable deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getOptionalKeywords}
         * @param optionalKeywords Specifies any optional keywords to associate with the pool.
         *                         For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionalKeywords(software.amazon.awscdk.IResolvable optionalKeywords) {
            this.optionalKeywords = optionalKeywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getOptionalKeywords}
         * @param optionalKeywords Specifies any optional keywords to associate with the pool.
         *                         For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/keywords.html">Keywords</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optionalKeywords(java.util.List<? extends java.lang.Object> optionalKeywords) {
            this.optionalKeywords = optionalKeywords;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getOptOutListName}
         * @param optOutListName The name of the OptOutList associated with the pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optOutListName(java.lang.String optOutListName) {
            this.optOutListName = optOutListName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getSelfManagedOptOutsEnabled}
         * @param selfManagedOptOutsEnabled When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
         *                                  When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com//pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedOptOutsEnabled(java.lang.Boolean selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getSelfManagedOptOutsEnabled}
         * @param selfManagedOptOutsEnabled When set to false, an end recipient sends a message that begins with HELP or STOP to one of your dedicated numbers, End User Messaging  automatically replies with a customizable message and adds the end recipient to the OptOutList.
         *                                  When set to true you're responsible for responding to HELP and STOP requests. You're also responsible for tracking and honoring opt-out requests. For more information see <a href="https://docs.aws.amazon.com//pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out">Self-managed opt-outs</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedOptOutsEnabled(software.amazon.awscdk.IResolvable selfManagedOptOutsEnabled) {
            this.selfManagedOptOutsEnabled = selfManagedOptOutsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getSharedRoutesEnabled}
         * @param sharedRoutesEnabled Allows you to enable shared routes on your pool.
         *                            By default, this is set to <code>False</code> . If you set this value to <code>True</code> , your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sharedRoutesEnabled(java.lang.Boolean sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getSharedRoutesEnabled}
         * @param sharedRoutesEnabled Allows you to enable shared routes on your pool.
         *                            By default, this is set to <code>False</code> . If you set this value to <code>True</code> , your messages are sent using phone numbers or sender IDs (depending on the country) that are shared with other users. In some countries, such as the United States, senders aren't allowed to use shared routes and must use a dedicated phone number or short code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sharedRoutesEnabled(software.amazon.awscdk.IResolvable sharedRoutesEnabled) {
            this.sharedRoutesEnabled = sharedRoutesEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getTags}
         * @param tags An array of tags (key and value pairs) associated with the pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getTwoWay}
         * @param twoWay Describes the two-way SMS configuration for a phone number.
         *               For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/two-way-sms.html">Two-way SMS messaging</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder twoWay(software.amazon.awscdk.IResolvable twoWay) {
            this.twoWay = twoWay;
            return this;
        }

        /**
         * Sets the value of {@link CfnPoolProps#getTwoWay}
         * @param twoWay Describes the two-way SMS configuration for a phone number.
         *               For more information, see <a href="https://docs.aws.amazon.com/sms-voice/latest/userguide/two-way-sms.html">Two-way SMS messaging</a> in the End User Messaging  User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder twoWay(software.amazon.awscdk.services.smsvoice.CfnPool.TwoWayProperty twoWay) {
            this.twoWay = twoWay;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPoolProps {
        private final java.lang.Object mandatoryKeywords;
        private final java.util.List<java.lang.String> originationIdentities;
        private final java.lang.Object deletionProtectionEnabled;
        private final java.lang.Object optionalKeywords;
        private final java.lang.String optOutListName;
        private final java.lang.Object selfManagedOptOutsEnabled;
        private final java.lang.Object sharedRoutesEnabled;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object twoWay;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mandatoryKeywords = software.amazon.jsii.Kernel.get(this, "mandatoryKeywords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.originationIdentities = software.amazon.jsii.Kernel.get(this, "originationIdentities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.deletionProtectionEnabled = software.amazon.jsii.Kernel.get(this, "deletionProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.optionalKeywords = software.amazon.jsii.Kernel.get(this, "optionalKeywords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.optOutListName = software.amazon.jsii.Kernel.get(this, "optOutListName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.selfManagedOptOutsEnabled = software.amazon.jsii.Kernel.get(this, "selfManagedOptOutsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sharedRoutesEnabled = software.amazon.jsii.Kernel.get(this, "sharedRoutesEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.twoWay = software.amazon.jsii.Kernel.get(this, "twoWay", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mandatoryKeywords = java.util.Objects.requireNonNull(builder.mandatoryKeywords, "mandatoryKeywords is required");
            this.originationIdentities = java.util.Objects.requireNonNull(builder.originationIdentities, "originationIdentities is required");
            this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
            this.optionalKeywords = builder.optionalKeywords;
            this.optOutListName = builder.optOutListName;
            this.selfManagedOptOutsEnabled = builder.selfManagedOptOutsEnabled;
            this.sharedRoutesEnabled = builder.sharedRoutesEnabled;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.twoWay = builder.twoWay;
        }

        @Override
        public final java.lang.Object getMandatoryKeywords() {
            return this.mandatoryKeywords;
        }

        @Override
        public final java.util.List<java.lang.String> getOriginationIdentities() {
            return this.originationIdentities;
        }

        @Override
        public final java.lang.Object getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        @Override
        public final java.lang.Object getOptionalKeywords() {
            return this.optionalKeywords;
        }

        @Override
        public final java.lang.String getOptOutListName() {
            return this.optOutListName;
        }

        @Override
        public final java.lang.Object getSelfManagedOptOutsEnabled() {
            return this.selfManagedOptOutsEnabled;
        }

        @Override
        public final java.lang.Object getSharedRoutesEnabled() {
            return this.sharedRoutesEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTwoWay() {
            return this.twoWay;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mandatoryKeywords", om.valueToTree(this.getMandatoryKeywords()));
            data.set("originationIdentities", om.valueToTree(this.getOriginationIdentities()));
            if (this.getDeletionProtectionEnabled() != null) {
                data.set("deletionProtectionEnabled", om.valueToTree(this.getDeletionProtectionEnabled()));
            }
            if (this.getOptionalKeywords() != null) {
                data.set("optionalKeywords", om.valueToTree(this.getOptionalKeywords()));
            }
            if (this.getOptOutListName() != null) {
                data.set("optOutListName", om.valueToTree(this.getOptOutListName()));
            }
            if (this.getSelfManagedOptOutsEnabled() != null) {
                data.set("selfManagedOptOutsEnabled", om.valueToTree(this.getSelfManagedOptOutsEnabled()));
            }
            if (this.getSharedRoutesEnabled() != null) {
                data.set("sharedRoutesEnabled", om.valueToTree(this.getSharedRoutesEnabled()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTwoWay() != null) {
                data.set("twoWay", om.valueToTree(this.getTwoWay()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPoolProps.Jsii$Proxy that = (CfnPoolProps.Jsii$Proxy) o;

            if (!mandatoryKeywords.equals(that.mandatoryKeywords)) return false;
            if (!originationIdentities.equals(that.originationIdentities)) return false;
            if (this.deletionProtectionEnabled != null ? !this.deletionProtectionEnabled.equals(that.deletionProtectionEnabled) : that.deletionProtectionEnabled != null) return false;
            if (this.optionalKeywords != null ? !this.optionalKeywords.equals(that.optionalKeywords) : that.optionalKeywords != null) return false;
            if (this.optOutListName != null ? !this.optOutListName.equals(that.optOutListName) : that.optOutListName != null) return false;
            if (this.selfManagedOptOutsEnabled != null ? !this.selfManagedOptOutsEnabled.equals(that.selfManagedOptOutsEnabled) : that.selfManagedOptOutsEnabled != null) return false;
            if (this.sharedRoutesEnabled != null ? !this.sharedRoutesEnabled.equals(that.sharedRoutesEnabled) : that.sharedRoutesEnabled != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.twoWay != null ? this.twoWay.equals(that.twoWay) : that.twoWay == null;
        }

        @Override
        public final int hashCode() {
            int result = this.mandatoryKeywords.hashCode();
            result = 31 * result + (this.originationIdentities.hashCode());
            result = 31 * result + (this.deletionProtectionEnabled != null ? this.deletionProtectionEnabled.hashCode() : 0);
            result = 31 * result + (this.optionalKeywords != null ? this.optionalKeywords.hashCode() : 0);
            result = 31 * result + (this.optOutListName != null ? this.optOutListName.hashCode() : 0);
            result = 31 * result + (this.selfManagedOptOutsEnabled != null ? this.selfManagedOptOutsEnabled.hashCode() : 0);
            result = 31 * result + (this.sharedRoutesEnabled != null ? this.sharedRoutesEnabled.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.twoWay != null ? this.twoWay.hashCode() : 0);
            return result;
        }
    }
}
