package software.amazon.awscdk.services.smsvoice;

/**
 * Create a new protect configuration.
 * <p>
 * By default all country rule sets for each capability are set to <code>ALLOW</code> . A protect configurations name is stored as a Tag with the key set to <code>Name</code> and value as the name of the protect configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.smsvoice.*;
 * CfnProtectConfiguration cfnProtectConfiguration = CfnProtectConfiguration.Builder.create(this, "MyCfnProtectConfiguration")
 *         .countryRuleSet(CountryRuleSetProperty.builder()
 *                 .mms(List.of(CountryRuleProperty.builder()
 *                         .countryCode("countryCode")
 *                         .protectStatus("protectStatus")
 *                         .build()))
 *                 .sms(List.of(CountryRuleProperty.builder()
 *                         .countryCode("countryCode")
 *                         .protectStatus("protectStatus")
 *                         .build()))
 *                 .voice(List.of(CountryRuleProperty.builder()
 *                         .countryCode("countryCode")
 *                         .protectStatus("protectStatus")
 *                         .build()))
 *                 .build())
 *         .deletionProtectionEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.465Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnProtectConfiguration")
public class CfnProtectConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.smsvoice.IProtectConfigurationRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnProtectConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProtectConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnProtectConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.smsvoice.CfnProtectConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnProtectConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Creates a new IProtectConfigurationRef from an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param arn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.IProtectConfigurationRef fromProtectConfigurationArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.class, "fromProtectConfigurationArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.IProtectConfigurationRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Creates a new IProtectConfigurationRef from a protectConfigurationId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param protectConfigurationId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.IProtectConfigurationRef fromProtectConfigurationId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String protectConfigurationId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.class, "fromProtectConfigurationId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.IProtectConfigurationRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(protectConfigurationId, "protectConfigurationId is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the protect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the protect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrProtectConfigurationId() {
        return software.amazon.jsii.Kernel.get(this, "attrProtectConfigurationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ProtectConfiguration resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.smsvoice.ProtectConfigurationReference getProtectConfigurationRef() {
        return software.amazon.jsii.Kernel.get(this, "protectConfigurationRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.smsvoice.ProtectConfigurationReference.class));
    }

    /**
     * The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.CountryRuleSetProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCountryRuleSet() {
        return software.amazon.jsii.Kernel.get(this, "countryRuleSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCountryRuleSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "countryRuleSet", value);
    }

    /**
     * The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCountryRuleSet(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.CountryRuleSetProperty value) {
        software.amazon.jsii.Kernel.set(this, "countryRuleSet", value);
    }

    /**
     * The status of deletion protection for the protect configuration.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtectionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "deletionProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The status of deletion protection for the protect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtectionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtectionEnabled", value);
    }

    /**
     * The status of deletion protection for the protect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletionProtectionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deletionProtectionEnabled", value);
    }

    /**
     * An array of key and value pair tags that are associated with the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key and value pair tags that are associated with the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Specifies the type of protection to use for a country.
     * <p>
     * For example, to set Canada as allowed, the <code>CountryRule</code> would be formatted as follows:
     * <p>
     * <code>{ "CountryCode": "CA", "ProtectStatus": "ALLOW" }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * CountryRuleProperty countryRuleProperty = CountryRuleProperty.builder()
     *         .countryCode("countryCode")
     *         .protectStatus("protectStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnProtectConfiguration.CountryRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(CountryRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CountryRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryrule.html#cfn-smsvoice-protectconfiguration-countryrule-countrycode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryrule.html#cfn-smsvoice-protectconfiguration-countryrule-countrycode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCountryCode();

        /**
         * The types of protection that can be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryrule.html#cfn-smsvoice-protectconfiguration-countryrule-protectstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryrule.html#cfn-smsvoice-protectconfiguration-countryrule-protectstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProtectStatus();

        /**
         * @return a {@link Builder} of {@link CountryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CountryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CountryRuleProperty> {
            java.lang.String countryCode;
            java.lang.String protectStatus;

            /**
             * Sets the value of {@link CountryRuleProperty#getCountryCode}
             * @param countryCode The two-character code, in ISO 3166-1 alpha-2 format, for the country or region. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCode(java.lang.String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            /**
             * Sets the value of {@link CountryRuleProperty#getProtectStatus}
             * @param protectStatus The types of protection that can be used. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protectStatus(java.lang.String protectStatus) {
                this.protectStatus = protectStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CountryRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CountryRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CountryRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CountryRuleProperty {
            private final java.lang.String countryCode;
            private final java.lang.String protectStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.countryCode = software.amazon.jsii.Kernel.get(this, "countryCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protectStatus = software.amazon.jsii.Kernel.get(this, "protectStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.countryCode = java.util.Objects.requireNonNull(builder.countryCode, "countryCode is required");
                this.protectStatus = java.util.Objects.requireNonNull(builder.protectStatus, "protectStatus is required");
            }

            @Override
            public final java.lang.String getCountryCode() {
                return this.countryCode;
            }

            @Override
            public final java.lang.String getProtectStatus() {
                return this.protectStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("countryCode", om.valueToTree(this.getCountryCode()));
                data.set("protectStatus", om.valueToTree(this.getProtectStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnProtectConfiguration.CountryRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CountryRuleProperty.Jsii$Proxy that = (CountryRuleProperty.Jsii$Proxy) o;

                if (!countryCode.equals(that.countryCode)) return false;
                return this.protectStatus.equals(that.protectStatus);
            }

            @Override
            public final int hashCode() {
                int result = this.countryCode.hashCode();
                result = 31 * result + (this.protectStatus.hashCode());
                return result;
            }
        }
    }
    /**
     * The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
     * <p>
     * <blockquote>
     * <p>
     * If you don't specify all available ISO country codes in the <code>CountryRuleSet</code> for each number capability, the AWS CloudFormation drift detection feature will detect drift. This is because End User Messaging  always returns all country codes.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.smsvoice.*;
     * CountryRuleSetProperty countryRuleSetProperty = CountryRuleSetProperty.builder()
     *         .mms(List.of(CountryRuleProperty.builder()
     *                 .countryCode("countryCode")
     *                 .protectStatus("protectStatus")
     *                 .build()))
     *         .sms(List.of(CountryRuleProperty.builder()
     *                 .countryCode("countryCode")
     *                 .protectStatus("protectStatus")
     *                 .build()))
     *         .voice(List.of(CountryRuleProperty.builder()
     *                 .countryCode("countryCode")
     *                 .protectStatus("protectStatus")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryruleset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryruleset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnProtectConfiguration.CountryRuleSetProperty")
    @software.amazon.jsii.Jsii.Proxy(CountryRuleSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CountryRuleSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your MMS messages to.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.CountryRuleProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryruleset.html#cfn-smsvoice-protectconfiguration-countryruleset-mms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryruleset.html#cfn-smsvoice-protectconfiguration-countryruleset-mms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMms() {
            return null;
        }

        /**
         * The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your SMS messages to.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.CountryRuleProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryruleset.html#cfn-smsvoice-protectconfiguration-countryruleset-sms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryruleset.html#cfn-smsvoice-protectconfiguration-countryruleset-sms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSms() {
            return null;
        }

        /**
         * The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your VOICE messages to.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.CountryRuleProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryruleset.html#cfn-smsvoice-protectconfiguration-countryruleset-voice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-smsvoice-protectconfiguration-countryruleset.html#cfn-smsvoice-protectconfiguration-countryruleset-voice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVoice() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CountryRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CountryRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CountryRuleSetProperty> {
            java.lang.Object mms;
            java.lang.Object sms;
            java.lang.Object voice;

            /**
             * Sets the value of {@link CountryRuleSetProperty#getMms}
             * @param mms The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your MMS messages to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mms(software.amazon.awscdk.IResolvable mms) {
                this.mms = mms;
                return this;
            }

            /**
             * Sets the value of {@link CountryRuleSetProperty#getMms}
             * @param mms The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your MMS messages to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mms(java.util.List<? extends java.lang.Object> mms) {
                this.mms = mms;
                return this;
            }

            /**
             * Sets the value of {@link CountryRuleSetProperty#getSms}
             * @param sms The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your SMS messages to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(software.amazon.awscdk.IResolvable sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link CountryRuleSetProperty#getSms}
             * @param sms The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your SMS messages to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sms(java.util.List<? extends java.lang.Object> sms) {
                this.sms = sms;
                return this;
            }

            /**
             * Sets the value of {@link CountryRuleSetProperty#getVoice}
             * @param voice The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your VOICE messages to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voice(software.amazon.awscdk.IResolvable voice) {
                this.voice = voice;
                return this;
            }

            /**
             * Sets the value of {@link CountryRuleSetProperty#getVoice}
             * @param voice The set of <code>CountryRule</code> s to control which destination countries End User Messaging  can send your VOICE messages to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder voice(java.util.List<? extends java.lang.Object> voice) {
                this.voice = voice;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CountryRuleSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CountryRuleSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CountryRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CountryRuleSetProperty {
            private final java.lang.Object mms;
            private final java.lang.Object sms;
            private final java.lang.Object voice;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mms = software.amazon.jsii.Kernel.get(this, "mms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sms = software.amazon.jsii.Kernel.get(this, "sms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.voice = software.amazon.jsii.Kernel.get(this, "voice", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mms = builder.mms;
                this.sms = builder.sms;
                this.voice = builder.voice;
            }

            @Override
            public final java.lang.Object getMms() {
                return this.mms;
            }

            @Override
            public final java.lang.Object getSms() {
                return this.sms;
            }

            @Override
            public final java.lang.Object getVoice() {
                return this.voice;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMms() != null) {
                    data.set("mms", om.valueToTree(this.getMms()));
                }
                if (this.getSms() != null) {
                    data.set("sms", om.valueToTree(this.getSms()));
                }
                if (this.getVoice() != null) {
                    data.set("voice", om.valueToTree(this.getVoice()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnProtectConfiguration.CountryRuleSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CountryRuleSetProperty.Jsii$Proxy that = (CountryRuleSetProperty.Jsii$Proxy) o;

                if (this.mms != null ? !this.mms.equals(that.mms) : that.mms != null) return false;
                if (this.sms != null ? !this.sms.equals(that.sms) : that.sms != null) return false;
                return this.voice != null ? this.voice.equals(that.voice) : that.voice == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mms != null ? this.mms.hashCode() : 0;
                result = 31 * result + (this.sms != null ? this.sms.hashCode() : 0);
                result = 31 * result + (this.voice != null ? this.voice.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.smsvoice.CfnProtectConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-countryruleset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-countryruleset</a>
         * @param countryRuleSet The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder countryRuleSet(final software.amazon.awscdk.IResolvable countryRuleSet) {
            this.props().countryRuleSet(countryRuleSet);
            return this;
        }
        /**
         * The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-countryruleset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-countryruleset</a>
         * @param countryRuleSet The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder countryRuleSet(final software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.CountryRuleSetProperty countryRuleSet) {
            this.props().countryRuleSet(countryRuleSet);
            return this;
        }

        /**
         * The status of deletion protection for the protect configuration.
         * <p>
         * When set to true deletion protection is enabled. By default this is set to false.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-deletionprotectionenabled</a>
         * @param deletionProtectionEnabled The status of deletion protection for the protect configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(final java.lang.Boolean deletionProtectionEnabled) {
            this.props().deletionProtectionEnabled(deletionProtectionEnabled);
            return this;
        }
        /**
         * The status of deletion protection for the protect configuration.
         * <p>
         * When set to true deletion protection is enabled. By default this is set to false.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-deletionprotectionenabled</a>
         * @param deletionProtectionEnabled The status of deletion protection for the protect configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(final software.amazon.awscdk.IResolvable deletionProtectionEnabled) {
            this.props().deletionProtectionEnabled(deletionProtectionEnabled);
            return this;
        }

        /**
         * An array of key and value pair tags that are associated with the resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-tags</a>
         * @param tags An array of key and value pair tags that are associated with the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration build() {
            return new software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.smsvoice.CfnProtectConfigurationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.smsvoice.CfnProtectConfigurationProps.Builder();
            }
            return this.props;
        }
    }
}
