package software.amazon.awscdk.services.smsvoice;

/**
 * Properties for defining a <code>CfnProtectConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.smsvoice.*;
 * CfnProtectConfigurationProps cfnProtectConfigurationProps = CfnProtectConfigurationProps.builder()
 *         .countryRuleSet(CountryRuleSetProperty.builder()
 *                 .mms(List.of(CountryRuleProperty.builder()
 *                         .countryCode("countryCode")
 *                         .protectStatus("protectStatus")
 *                         .build()))
 *                 .sms(List.of(CountryRuleProperty.builder()
 *                         .countryCode("countryCode")
 *                         .protectStatus("protectStatus")
 *                         .build()))
 *                 .voice(List.of(CountryRuleProperty.builder()
 *                         .countryCode("countryCode")
 *                         .protectStatus("protectStatus")
 *                         .build()))
 *                 .build())
 *         .deletionProtectionEnabled(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.467Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.CfnProtectConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnProtectConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProtectConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.CountryRuleSetProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-countryruleset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-countryruleset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCountryRuleSet() {
        return null;
    }

    /**
     * The status of deletion protection for the protect configuration.
     * <p>
     * When set to true deletion protection is enabled. By default this is set to false.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-deletionprotectionenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-deletionprotectionenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtectionEnabled() {
        return null;
    }

    /**
     * An array of key and value pair tags that are associated with the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-smsvoice-protectconfiguration.html#cfn-smsvoice-protectconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProtectConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProtectConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProtectConfigurationProps> {
        java.lang.Object countryRuleSet;
        java.lang.Object deletionProtectionEnabled;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnProtectConfigurationProps#getCountryRuleSet}
         * @param countryRuleSet The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder countryRuleSet(software.amazon.awscdk.IResolvable countryRuleSet) {
            this.countryRuleSet = countryRuleSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectConfigurationProps#getCountryRuleSet}
         * @param countryRuleSet The set of <code>CountryRules</code> you specify to control which countries End User Messaging  can send your messages to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder countryRuleSet(software.amazon.awscdk.services.smsvoice.CfnProtectConfiguration.CountryRuleSetProperty countryRuleSet) {
            this.countryRuleSet = countryRuleSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectConfigurationProps#getDeletionProtectionEnabled}
         * @param deletionProtectionEnabled The status of deletion protection for the protect configuration.
         *                                  When set to true deletion protection is enabled. By default this is set to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(java.lang.Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectConfigurationProps#getDeletionProtectionEnabled}
         * @param deletionProtectionEnabled The status of deletion protection for the protect configuration.
         *                                  When set to true deletion protection is enabled. By default this is set to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionEnabled(software.amazon.awscdk.IResolvable deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnProtectConfigurationProps#getTags}
         * @param tags An array of key and value pair tags that are associated with the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProtectConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProtectConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProtectConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProtectConfigurationProps {
        private final java.lang.Object countryRuleSet;
        private final java.lang.Object deletionProtectionEnabled;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.countryRuleSet = software.amazon.jsii.Kernel.get(this, "countryRuleSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deletionProtectionEnabled = software.amazon.jsii.Kernel.get(this, "deletionProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.countryRuleSet = builder.countryRuleSet;
            this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getCountryRuleSet() {
            return this.countryRuleSet;
        }

        @Override
        public final java.lang.Object getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCountryRuleSet() != null) {
                data.set("countryRuleSet", om.valueToTree(this.getCountryRuleSet()));
            }
            if (this.getDeletionProtectionEnabled() != null) {
                data.set("deletionProtectionEnabled", om.valueToTree(this.getDeletionProtectionEnabled()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.CfnProtectConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProtectConfigurationProps.Jsii$Proxy that = (CfnProtectConfigurationProps.Jsii$Proxy) o;

            if (this.countryRuleSet != null ? !this.countryRuleSet.equals(that.countryRuleSet) : that.countryRuleSet != null) return false;
            if (this.deletionProtectionEnabled != null ? !this.deletionProtectionEnabled.equals(that.deletionProtectionEnabled) : that.deletionProtectionEnabled != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.countryRuleSet != null ? this.countryRuleSet.hashCode() : 0;
            result = 31 * result + (this.deletionProtectionEnabled != null ? this.deletionProtectionEnabled.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
