package software.amazon.awscdk.services.smsvoice;

/**
 * A reference to a Pool resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.smsvoice.*;
 * PoolReference poolReference = PoolReference.builder()
 *         .poolArn("poolArn")
 *         .poolId("poolId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.473Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_smsvoice.PoolReference")
@software.amazon.jsii.Jsii.Proxy(PoolReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PoolReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Pool resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPoolArn();

    /**
     * The PoolId of the Pool resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPoolId();

    /**
     * @return a {@link Builder} of {@link PoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PoolReference> {
        java.lang.String poolArn;
        java.lang.String poolId;

        /**
         * Sets the value of {@link PoolReference#getPoolArn}
         * @param poolArn The ARN of the Pool resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolArn(java.lang.String poolArn) {
            this.poolArn = poolArn;
            return this;
        }

        /**
         * Sets the value of {@link PoolReference#getPoolId}
         * @param poolId The PoolId of the Pool resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolId(java.lang.String poolId) {
            this.poolId = poolId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PoolReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PoolReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PoolReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PoolReference {
        private final java.lang.String poolArn;
        private final java.lang.String poolId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.poolArn = software.amazon.jsii.Kernel.get(this, "poolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.poolId = software.amazon.jsii.Kernel.get(this, "poolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.poolArn = java.util.Objects.requireNonNull(builder.poolArn, "poolArn is required");
            this.poolId = java.util.Objects.requireNonNull(builder.poolId, "poolId is required");
        }

        @Override
        public final java.lang.String getPoolArn() {
            return this.poolArn;
        }

        @Override
        public final java.lang.String getPoolId() {
            return this.poolId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("poolArn", om.valueToTree(this.getPoolArn()));
            data.set("poolId", om.valueToTree(this.getPoolId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_smsvoice.PoolReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PoolReference.Jsii$Proxy that = (PoolReference.Jsii$Proxy) o;

            if (!poolArn.equals(that.poolArn)) return false;
            return this.poolId.equals(that.poolId);
        }

        @Override
        public final int hashCode() {
            int result = this.poolArn.hashCode();
            result = 31 * result + (this.poolId.hashCode());
            return result;
        }
    }
}
