package software.amazon.awscdk.services.sns;

/**
 * Options for customising aspects of the content sent in AWS SNS HTTP/S requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "MyTopic");
 * myTopic.addSubscription(
 * UrlSubscription.Builder.create("https://foobar.com/")
 *         .deliveryPolicy(DeliveryPolicy.builder()
 *                 .healthyRetryPolicy(HealthyRetryPolicy.builder()
 *                         .minDelayTarget(Duration.seconds(5))
 *                         .maxDelayTarget(Duration.seconds(10))
 *                         .numRetries(6)
 *                         .backoffFunction(BackoffFunction.EXPONENTIAL)
 *                         .build())
 *                 .throttlePolicy(ThrottlePolicy.builder()
 *                         .maxReceivesPerSecond(10)
 *                         .build())
 *                 .requestPolicy(RequestPolicy.builder()
 *                         .headerContentType("application/json")
 *                         .build())
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.509Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.RequestPolicy")
@software.amazon.jsii.Jsii.Proxy(RequestPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RequestPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * The content type of the notification being sent to HTTP/S endpoints.
     * <p>
     * Default: - text/plain; charset=UTF-8
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHeaderContentType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RequestPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RequestPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RequestPolicy> {
        java.lang.String headerContentType;

        /**
         * Sets the value of {@link RequestPolicy#getHeaderContentType}
         * @param headerContentType The content type of the notification being sent to HTTP/S endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerContentType(java.lang.String headerContentType) {
            this.headerContentType = headerContentType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RequestPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RequestPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RequestPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestPolicy {
        private final java.lang.String headerContentType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.headerContentType = software.amazon.jsii.Kernel.get(this, "headerContentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.headerContentType = builder.headerContentType;
        }

        @Override
        public final java.lang.String getHeaderContentType() {
            return this.headerContentType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHeaderContentType() != null) {
                data.set("headerContentType", om.valueToTree(this.getHeaderContentType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.RequestPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RequestPolicy.Jsii$Proxy that = (RequestPolicy.Jsii$Proxy) o;

            return this.headerContentType != null ? this.headerContentType.equals(that.headerContentType) : that.headerContentType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.headerContentType != null ? this.headerContentType.hashCode() : 0;
            return result;
        }
    }
}
