package software.amazon.awscdk.services.ssmquicksetup;

/**
 * A reference to a ConfigurationManager resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmquicksetup.*;
 * ConfigurationManagerReference configurationManagerReference = ConfigurationManagerReference.builder()
 *         .managerArn("managerArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.729Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmquicksetup.ConfigurationManagerReference")
@software.amazon.jsii.Jsii.Proxy(ConfigurationManagerReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConfigurationManagerReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ManagerArn of the ConfigurationManager resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getManagerArn();

    /**
     * @return a {@link Builder} of {@link ConfigurationManagerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConfigurationManagerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConfigurationManagerReference> {
        java.lang.String managerArn;

        /**
         * Sets the value of {@link ConfigurationManagerReference#getManagerArn}
         * @param managerArn The ManagerArn of the ConfigurationManager resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managerArn(java.lang.String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConfigurationManagerReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConfigurationManagerReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConfigurationManagerReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationManagerReference {
        private final java.lang.String managerArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.managerArn = software.amazon.jsii.Kernel.get(this, "managerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.managerArn = java.util.Objects.requireNonNull(builder.managerArn, "managerArn is required");
        }

        @Override
        public final java.lang.String getManagerArn() {
            return this.managerArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("managerArn", om.valueToTree(this.getManagerArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmquicksetup.ConfigurationManagerReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConfigurationManagerReference.Jsii$Proxy that = (ConfigurationManagerReference.Jsii$Proxy) o;

            return this.managerArn.equals(that.managerArn);
        }

        @Override
        public final int hashCode() {
            int result = this.managerArn.hashCode();
            return result;
        }
    }
}
