package software.amazon.awscdk.services.stepfunctions;

/**
 * Base class for creating an EncryptionConfiguration for either state machines or activities.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.*;
 * Key kmsKey = new Key(this, "Key");
 * StateMachine stateMachine = StateMachine.Builder.create(this, "StateMachineWithCMKEncryptionConfiguration")
 *         .stateMachineName("StateMachineWithCMKEncryptionConfiguration")
 *         .definitionBody(DefinitionBody.fromChainable(Chain.start(new Pass(this, "Pass"))))
 *         .stateMachineType(StateMachineType.STANDARD)
 *         .encryptionConfiguration(new CustomerManagedEncryptionConfiguration(kmsKey, Duration.seconds(60)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.839Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.EncryptionConfiguration")
public abstract class EncryptionConfiguration extends software.amazon.jsii.JsiiObject {

    protected EncryptionConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EncryptionConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected EncryptionConfiguration(final @org.jetbrains.annotations.NotNull java.lang.String type) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * Encryption option for the state machine or activity.
     * <p>
     * Can be either CUSTOMER_MANAGED_KMS_KEY or AWS_OWNED_KEY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Encryption option for the state machine or activity.
     * <p>
     * Can be either CUSTOMER_MANAGED_KMS_KEY or AWS_OWNED_KEY.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.EncryptionConfiguration {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
