package software.amazon.awscdk.services.stepfunctions;

/**
 * AWS Step Functions integrates with services directly in the Amazon States Language.
 * <p>
 * You can control these AWS services using service integration patterns:
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codebuild.*;
 * Project codebuildProject = Project.Builder.create(this, "Project")
 *         .projectName("MyTestProject")
 *         .buildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", List.of("echo \"Hello, CodeBuild!\""))))))
 *         .build();
 * CodeBuildStartBuild task = CodeBuildStartBuild.Builder.create(this, "Task")
 *         .project(codebuildProject)
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .environmentVariablesOverride(Map.of(
 *                 "ZONE", BuildEnvironmentVariable.builder()
 *                         .type(BuildEnvironmentVariableType.PLAINTEXT)
 *                         .value(JsonPath.stringAt("$.envVariables.zone"))
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.849Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.IntegrationPattern")
public enum IntegrationPattern {
    /**
     * Step Functions will wait for an HTTP response and then progress to the next state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-default">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-default</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUEST_RESPONSE,
    /**
     * Step Functions can wait for a request to complete before progressing to the next state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RUN_JOB,
    /**
     * Callback tasks provide a way to pause a workflow until a task token is returned.
     * <p>
     * You must set a task token when using the callback pattern
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token">https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WAIT_FOR_TASK_TOKEN,
}
