package software.amazon.awscdk.services.stepfunctions;

/**
 * Interface for ItemBatcher configuration properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object batchInput;
 * ItemBatcherProps itemBatcherProps = ItemBatcherProps.builder()
 *         .batchInput(batchInput)
 *         .maxInputBytesPerBatch(123)
 *         .maxInputBytesPerBatchPath("maxInputBytesPerBatchPath")
 *         .maxItemsPerBatch(123)
 *         .maxItemsPerBatchPath("maxItemsPerBatchPath")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.850Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ItemBatcherProps")
@software.amazon.jsii.Jsii.Proxy(ItemBatcherProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ItemBatcherProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * BatchInput.
     * <p>
     * Fixed JSON input to include in each batch passed to each child workflow execution
     * <p>
     * Default: - No batchInput
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.fasterxml.jackson.databind.node.ObjectNode getBatchInput() {
        return null;
    }

    /**
     * MaxInputBytesPerBatch.
     * <p>
     * Specifies the maximum number of bytes that each child workflow execution processes, as static number
     * <p>
     * Default: - uses value of `maxInputBytesPerBatchPath` as the max size per batch,
     * no limits on the batch size under the 256KB limit if that property was also not provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxInputBytesPerBatch() {
        return null;
    }

    /**
     * MaxInputBytesPerBatchPath.
     * <p>
     * Specifies the maximum number of bytes that each child workflow execution processes, as JsonPath
     * <p>
     * Default: - uses value of `maxInputBytesPerBatch` as the max size per batch,
     * no limits on the batch size under the 256KB limit if that property was also not provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxInputBytesPerBatchPath() {
        return null;
    }

    /**
     * MaxItemsPerBatch.
     * <p>
     * Specifies the maximum number of items that each child workflow execution processes, as static number
     * <p>
     * Default: - uses value of `maxItemsPerBatchPath` as the max items per batch,
     * no limits on the number of items in a batch under the 256KB limit if that property was also not provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxItemsPerBatch() {
        return null;
    }

    /**
     * MaxItemsPerBatchPath.
     * <p>
     * Specifies the maximum number of items that each child workflow execution processes, as JsonPath
     * <p>
     * Default: - uses value of `maxItemsPerBatch` as the max items per batch,
     * no limits on the number of items in a batch under the 256KB limit if that property was also not provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMaxItemsPerBatchPath() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ItemBatcherProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ItemBatcherProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ItemBatcherProps> {
        com.fasterxml.jackson.databind.node.ObjectNode batchInput;
        java.lang.Number maxInputBytesPerBatch;
        java.lang.String maxInputBytesPerBatchPath;
        java.lang.Number maxItemsPerBatch;
        java.lang.String maxItemsPerBatchPath;

        /**
         * Sets the value of {@link ItemBatcherProps#getBatchInput}
         * @param batchInput BatchInput.
         *                   Fixed JSON input to include in each batch passed to each child workflow execution
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchInput(com.fasterxml.jackson.databind.node.ObjectNode batchInput) {
            this.batchInput = batchInput;
            return this;
        }

        /**
         * Sets the value of {@link ItemBatcherProps#getMaxInputBytesPerBatch}
         * @param maxInputBytesPerBatch MaxInputBytesPerBatch.
         *                              Specifies the maximum number of bytes that each child workflow execution processes, as static number
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInputBytesPerBatch(java.lang.Number maxInputBytesPerBatch) {
            this.maxInputBytesPerBatch = maxInputBytesPerBatch;
            return this;
        }

        /**
         * Sets the value of {@link ItemBatcherProps#getMaxInputBytesPerBatchPath}
         * @param maxInputBytesPerBatchPath MaxInputBytesPerBatchPath.
         *                                  Specifies the maximum number of bytes that each child workflow execution processes, as JsonPath
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInputBytesPerBatchPath(java.lang.String maxInputBytesPerBatchPath) {
            this.maxInputBytesPerBatchPath = maxInputBytesPerBatchPath;
            return this;
        }

        /**
         * Sets the value of {@link ItemBatcherProps#getMaxItemsPerBatch}
         * @param maxItemsPerBatch MaxItemsPerBatch.
         *                         Specifies the maximum number of items that each child workflow execution processes, as static number
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItemsPerBatch(java.lang.Number maxItemsPerBatch) {
            this.maxItemsPerBatch = maxItemsPerBatch;
            return this;
        }

        /**
         * Sets the value of {@link ItemBatcherProps#getMaxItemsPerBatchPath}
         * @param maxItemsPerBatchPath MaxItemsPerBatchPath.
         *                             Specifies the maximum number of items that each child workflow execution processes, as JsonPath
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItemsPerBatchPath(java.lang.String maxItemsPerBatchPath) {
            this.maxItemsPerBatchPath = maxItemsPerBatchPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ItemBatcherProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ItemBatcherProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ItemBatcherProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ItemBatcherProps {
        private final com.fasterxml.jackson.databind.node.ObjectNode batchInput;
        private final java.lang.Number maxInputBytesPerBatch;
        private final java.lang.String maxInputBytesPerBatchPath;
        private final java.lang.Number maxItemsPerBatch;
        private final java.lang.String maxItemsPerBatchPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.batchInput = software.amazon.jsii.Kernel.get(this, "batchInput", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
            this.maxInputBytesPerBatch = software.amazon.jsii.Kernel.get(this, "maxInputBytesPerBatch", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxInputBytesPerBatchPath = software.amazon.jsii.Kernel.get(this, "maxInputBytesPerBatchPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxItemsPerBatch = software.amazon.jsii.Kernel.get(this, "maxItemsPerBatch", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxItemsPerBatchPath = software.amazon.jsii.Kernel.get(this, "maxItemsPerBatchPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.batchInput = builder.batchInput;
            this.maxInputBytesPerBatch = builder.maxInputBytesPerBatch;
            this.maxInputBytesPerBatchPath = builder.maxInputBytesPerBatchPath;
            this.maxItemsPerBatch = builder.maxItemsPerBatch;
            this.maxItemsPerBatchPath = builder.maxItemsPerBatchPath;
        }

        @Override
        public final com.fasterxml.jackson.databind.node.ObjectNode getBatchInput() {
            return this.batchInput;
        }

        @Override
        public final java.lang.Number getMaxInputBytesPerBatch() {
            return this.maxInputBytesPerBatch;
        }

        @Override
        public final java.lang.String getMaxInputBytesPerBatchPath() {
            return this.maxInputBytesPerBatchPath;
        }

        @Override
        public final java.lang.Number getMaxItemsPerBatch() {
            return this.maxItemsPerBatch;
        }

        @Override
        public final java.lang.String getMaxItemsPerBatchPath() {
            return this.maxItemsPerBatchPath;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBatchInput() != null) {
                data.set("batchInput", om.valueToTree(this.getBatchInput()));
            }
            if (this.getMaxInputBytesPerBatch() != null) {
                data.set("maxInputBytesPerBatch", om.valueToTree(this.getMaxInputBytesPerBatch()));
            }
            if (this.getMaxInputBytesPerBatchPath() != null) {
                data.set("maxInputBytesPerBatchPath", om.valueToTree(this.getMaxInputBytesPerBatchPath()));
            }
            if (this.getMaxItemsPerBatch() != null) {
                data.set("maxItemsPerBatch", om.valueToTree(this.getMaxItemsPerBatch()));
            }
            if (this.getMaxItemsPerBatchPath() != null) {
                data.set("maxItemsPerBatchPath", om.valueToTree(this.getMaxItemsPerBatchPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.ItemBatcherProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ItemBatcherProps.Jsii$Proxy that = (ItemBatcherProps.Jsii$Proxy) o;

            if (this.batchInput != null ? !this.batchInput.equals(that.batchInput) : that.batchInput != null) return false;
            if (this.maxInputBytesPerBatch != null ? !this.maxInputBytesPerBatch.equals(that.maxInputBytesPerBatch) : that.maxInputBytesPerBatch != null) return false;
            if (this.maxInputBytesPerBatchPath != null ? !this.maxInputBytesPerBatchPath.equals(that.maxInputBytesPerBatchPath) : that.maxInputBytesPerBatchPath != null) return false;
            if (this.maxItemsPerBatch != null ? !this.maxItemsPerBatch.equals(that.maxItemsPerBatch) : that.maxItemsPerBatch != null) return false;
            return this.maxItemsPerBatchPath != null ? this.maxItemsPerBatchPath.equals(that.maxItemsPerBatchPath) : that.maxItemsPerBatchPath == null;
        }

        @Override
        public final int hashCode() {
            int result = this.batchInput != null ? this.batchInput.hashCode() : 0;
            result = 31 * result + (this.maxInputBytesPerBatch != null ? this.maxInputBytesPerBatch.hashCode() : 0);
            result = 31 * result + (this.maxInputBytesPerBatchPath != null ? this.maxInputBytesPerBatchPath.hashCode() : 0);
            result = 31 * result + (this.maxItemsPerBatch != null ? this.maxItemsPerBatch.hashCode() : 0);
            result = 31 * result + (this.maxItemsPerBatchPath != null ? this.maxItemsPerBatchPath.hashCode() : 0);
            return result;
        }
    }
}
