package software.amazon.awscdk.services.stepfunctions;

/**
 * The name of the query language used by the state machine or state.
 * <p>
 * Default: JSON_PATH
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pass jsonata = Pass.jsonata(this, "JSONata");
 * Pass jsonPath = Pass.jsonPath(this, "JSONPath");
 * Chain definition = jsonata.next(jsonPath);
 * StateMachine.Builder.create(this, "MixedStateMachine")
 *         // queryLanguage: sfn.QueryLanguage.JSON_PATH, // default
 *         .definitionBody(DefinitionBody.fromChainable(definition))
 *         .build();
 * // This throws an error. If JSONata is specified at the top level, JSONPath cannot be used in the state machine definition.
 * // This throws an error. If JSONata is specified at the top level, JSONPath cannot be used in the state machine definition.
 * StateMachine.Builder.create(this, "JSONataOnlyStateMachine")
 *         .queryLanguage(QueryLanguage.JSONATA)
 *         .definitionBody(DefinitionBody.fromChainable(definition))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/transforming-data.html">https://docs.aws.amazon.com/step-functions/latest/dg/transforming-data.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.884Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.QueryLanguage")
public enum QueryLanguage {
    /**
     * Use JSONPath.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    JSON_PATH,
    /**
     * Use JSONata.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    JSONATA,
}
