package software.amazon.awscdk.services.stepfunctions;

/**
 * Configuration for writing Distributed Map state results to S3 The ResultWriter field cannot be empty.
 * <p>
 * You must specify one of these sets of sub-fields.
 * writerConfig - to preview the formatted output, without saving the results to Amazon S3.
 * bucket and prefix - to save the results to Amazon S3 without additional formatting.
 * All three fields: writerConfig, bucket and prefix - to format the output and save it to Amazon S3.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * // create a bucket
 * Bucket bucket = new Bucket(this, "Bucket");
 * // create a WriterConfig
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "Distributed Map State")
 *         .resultWriterV2(ResultWriterV2.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("my-prefix")
 *                 .writerConfig(Map.of(
 *                         "outputType", OutputType.JSONL,
 *                         "transformation", Transformation.NONE))
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass State"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:15.885Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ResultWriterV2")
public class ResultWriterV2 extends software.amazon.jsii.JsiiObject {

    protected ResultWriterV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResultWriterV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ResultWriterV2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.ResultWriterV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Compile policy statements to provide relevent permissions to the state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> providePolicyStatements() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "providePolicyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))));
    }

    /**
     * Render ResultWriter in ASL JSON format.
     * <p>
     * @param queryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object render(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class), new Object[] { queryLanguage });
    }

    /**
     * Render ResultWriter in ASL JSON format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object render() {
        return software.amazon.jsii.Kernel.call(this, "render", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Validate that ResultWriter contains exactly either.
     * <p>
     * @see <a href="bucketNamePath">bucketNamePath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateResultWriter() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateResultWriter", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * S3 Bucket in which to save Map Run results.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getBucket() {
        return software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * S3 bucket name in which to save Map Run results, as JsonPath.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketNamePath() {
        return software.amazon.jsii.Kernel.get(this, "bucketNamePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * S3 prefix in which to save Map Run results.
     * <p>
     * Default: - No prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Configuration to format the output of the Child Workflow executions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.WriterConfig getWriterConfig() {
        return software.amazon.jsii.Kernel.get(this, "writerConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WriterConfig.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.ResultWriterV2}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.ResultWriterV2> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.ResultWriterV2Props.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.ResultWriterV2Props.Builder();
        }

        /**
         * S3 Bucket in which to save Map Run results.
         * <p>
         * Default: - specify a bucket
         * <p>
         * @return {@code this}
         * @param bucket S3 Bucket in which to save Map Run results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * S3 bucket name in which to save Map Run results, as JsonPath.
         * <p>
         * Default: - no bucket path
         * <p>
         * @return {@code this}
         * @param bucketNamePath S3 bucket name in which to save Map Run results, as JsonPath. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNamePath(final java.lang.String bucketNamePath) {
            this.props.bucketNamePath(bucketNamePath);
            return this;
        }

        /**
         * S3 prefix in which to save Map Run results.
         * <p>
         * Default: - No prefix
         * <p>
         * @return {@code this}
         * @param prefix S3 prefix in which to save Map Run results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(final java.lang.String prefix) {
            this.props.prefix(prefix);
            return this;
        }

        /**
         * Configuration to format the output of the Child Workflow executions.
         * <p>
         * Default: - Specify both Transformation and OutputType
         * <p>
         * @return {@code this}
         * @param writerConfig Configuration to format the output of the Child Workflow executions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writerConfig(final software.amazon.awscdk.services.stepfunctions.WriterConfig writerConfig) {
            this.props.writerConfig(writerConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.ResultWriterV2}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.ResultWriterV2 build() {
            return new software.amazon.awscdk.services.stepfunctions.ResultWriterV2(
                this.props.build()
            );
        }
    }
}
