package software.amazon.awscdk.services.vpclattice;

/**
 * Creates a resource configuration.
 * <p>
 * A resource configuration defines a specific resource. You can associate a resource configuration with a service network or a VPC endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.vpclattice.*;
 * CfnResourceConfiguration cfnResourceConfiguration = CfnResourceConfiguration.Builder.create(this, "MyCfnResourceConfiguration")
 *         .name("name")
 *         .resourceConfigurationType("resourceConfigurationType")
 *         // the properties below are optional
 *         .allowAssociationToSharableServiceNetwork(false)
 *         .portRanges(List.of("portRanges"))
 *         .protocolType("protocolType")
 *         .resourceConfigurationAuthType("resourceConfigurationAuthType")
 *         .resourceConfigurationDefinition(ResourceConfigurationDefinitionProperty.builder()
 *                 .arnResource("arnResource")
 *                 .dnsResource(DnsResourceProperty.builder()
 *                         .domainName("domainName")
 *                         .ipAddressType("ipAddressType")
 *                         .build())
 *                 .ipResource("ipResource")
 *                 .build())
 *         .resourceConfigurationGroupId("resourceConfigurationGroupId")
 *         .resourceGatewayId("resourceGatewayId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:16.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_vpclattice.CfnResourceConfiguration")
public class CfnResourceConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.services.vpclattice.IResourceConfigurationRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnResourceConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnResourceConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.vpclattice.CfnResourceConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ResourceConfiguration resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.vpclattice.ResourceConfigurationReference getResourceConfigurationRef() {
        return software.amazon.jsii.Kernel.get(this, "resourceConfigurationRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.vpclattice.ResourceConfigurationReference.class));
    }

    /**
     * The name of the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The type of resource configuration.
     * <p>
     * A resource configuration can be one of the following types:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceConfigurationType() {
        return software.amazon.jsii.Kernel.get(this, "resourceConfigurationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of resource configuration.
     * <p>
     * A resource configuration can be one of the following types:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceConfigurationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceConfigurationType", java.util.Objects.requireNonNull(value, "resourceConfigurationType is required"));
    }

    /**
     * Specifies whether the resource configuration can be associated with a sharable service network.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowAssociationToSharableServiceNetwork() {
        return software.amazon.jsii.Kernel.get(this, "allowAssociationToSharableServiceNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the resource configuration can be associated with a sharable service network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowAssociationToSharableServiceNetwork(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "allowAssociationToSharableServiceNetwork", value);
    }

    /**
     * Specifies whether the resource configuration can be associated with a sharable service network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowAssociationToSharableServiceNetwork(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowAssociationToSharableServiceNetwork", value);
    }

    /**
     * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPortRanges() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "portRanges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPortRanges(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "portRanges", value);
    }

    /**
     * (SINGLE, GROUP) The protocol accepted by the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProtocolType() {
        return software.amazon.jsii.Kernel.get(this, "protocolType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (SINGLE, GROUP) The protocol accepted by the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProtocolType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "protocolType", value);
    }

    /**
     * The auth type for the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceConfigurationAuthType() {
        return software.amazon.jsii.Kernel.get(this, "resourceConfigurationAuthType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The auth type for the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceConfigurationAuthType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceConfigurationAuthType", value);
    }

    /**
     * Identifies the resource configuration in one of the following ways:.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration.ResourceConfigurationDefinitionProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourceConfigurationDefinition() {
        return software.amazon.jsii.Kernel.get(this, "resourceConfigurationDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Identifies the resource configuration in one of the following ways:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceConfigurationDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceConfigurationDefinition", value);
    }

    /**
     * Identifies the resource configuration in one of the following ways:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceConfigurationDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration.ResourceConfigurationDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourceConfigurationDefinition", value);
    }

    /**
     * The ID of the group resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceConfigurationGroupId() {
        return software.amazon.jsii.Kernel.get(this, "resourceConfigurationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the group resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceConfigurationGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceConfigurationGroupId", value);
    }

    /**
     * The ID of the resource gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResourceGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "resourceGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the resource gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceGatewayId", value);
    }

    /**
     * The tags for the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags for the resource configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The domain name of the resource configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.vpclattice.*;
     * DnsResourceProperty dnsResourceProperty = DnsResourceProperty.builder()
     *         .domainName("domainName")
     *         .ipAddressType("ipAddressType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-dnsresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-dnsresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_vpclattice.CfnResourceConfiguration.DnsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DnsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DnsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The domain name of the resource configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-dnsresource.html#cfn-vpclattice-resourceconfiguration-dnsresource-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-dnsresource.html#cfn-vpclattice-resourceconfiguration-dnsresource-domainname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * The IP address type for the resource configuration.
         * <p>
         * Dualstack is not currently supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-dnsresource.html#cfn-vpclattice-resourceconfiguration-dnsresource-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-dnsresource.html#cfn-vpclattice-resourceconfiguration-dnsresource-ipaddresstype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIpAddressType();

        /**
         * @return a {@link Builder} of {@link DnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DnsResourceProperty> {
            java.lang.String domainName;
            java.lang.String ipAddressType;

            /**
             * Sets the value of {@link DnsResourceProperty#getDomainName}
             * @param domainName The domain name of the resource configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link DnsResourceProperty#getIpAddressType}
             * @param ipAddressType The IP address type for the resource configuration. This parameter is required.
             *                      Dualstack is not currently supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipAddressType(java.lang.String ipAddressType) {
                this.ipAddressType = ipAddressType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DnsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DnsResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsResourceProperty {
            private final java.lang.String domainName;
            private final java.lang.String ipAddressType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
                this.ipAddressType = java.util.Objects.requireNonNull(builder.ipAddressType, "ipAddressType is required");
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getIpAddressType() {
                return this.ipAddressType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_vpclattice.CfnResourceConfiguration.DnsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DnsResourceProperty.Jsii$Proxy that = (DnsResourceProperty.Jsii$Proxy) o;

                if (!domainName.equals(that.domainName)) return false;
                return this.ipAddressType.equals(that.ipAddressType);
            }

            @Override
            public final int hashCode() {
                int result = this.domainName.hashCode();
                result = 31 * result + (this.ipAddressType.hashCode());
                return result;
            }
        }
    }
    /**
     * Identifies the resource configuration in one of the following ways:.
     * <p>
     * <ul>
     * <li><em>Amazon Resource Name (ARN)</em> - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.</li>
     * <li><em>Domain name</em> - Any domain name that is publicly resolvable.</li>
     * <li><em>IP address</em> - For IPv4 and IPv6, only IP addresses in the VPC are supported.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.vpclattice.*;
     * ResourceConfigurationDefinitionProperty resourceConfigurationDefinitionProperty = ResourceConfigurationDefinitionProperty.builder()
     *         .arnResource("arnResource")
     *         .dnsResource(DnsResourceProperty.builder()
     *                 .domainName("domainName")
     *                 .ipAddressType("ipAddressType")
     *                 .build())
     *         .ipResource("ipResource")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-resourceconfigurationdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-resourceconfigurationdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_vpclattice.CfnResourceConfiguration.ResourceConfigurationDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceConfigurationDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceConfigurationDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the resource configuration.
         * <p>
         * For the ARN syntax and format, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arns-syntax">ARN format</a> in the <em>AWS Identity and Access Management user guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-resourceconfigurationdefinition.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition-arnresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-resourceconfigurationdefinition.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition-arnresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArnResource() {
            return null;
        }

        /**
         * The DNS name of the resource configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration.DnsResourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-resourceconfigurationdefinition.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition-dnsresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-resourceconfigurationdefinition.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition-dnsresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDnsResource() {
            return null;
        }

        /**
         * The IP address of the resource configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-resourceconfigurationdefinition.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition-ipresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-vpclattice-resourceconfiguration-resourceconfigurationdefinition.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition-ipresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIpResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceConfigurationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceConfigurationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceConfigurationDefinitionProperty> {
            java.lang.String arnResource;
            java.lang.Object dnsResource;
            java.lang.String ipResource;

            /**
             * Sets the value of {@link ResourceConfigurationDefinitionProperty#getArnResource}
             * @param arnResource The Amazon Resource Name (ARN) of the resource configuration.
             *                    For the ARN syntax and format, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arns-syntax">ARN format</a> in the <em>AWS Identity and Access Management user guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arnResource(java.lang.String arnResource) {
                this.arnResource = arnResource;
                return this;
            }

            /**
             * Sets the value of {@link ResourceConfigurationDefinitionProperty#getDnsResource}
             * @param dnsResource The DNS name of the resource configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsResource(software.amazon.awscdk.IResolvable dnsResource) {
                this.dnsResource = dnsResource;
                return this;
            }

            /**
             * Sets the value of {@link ResourceConfigurationDefinitionProperty#getDnsResource}
             * @param dnsResource The DNS name of the resource configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsResource(software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration.DnsResourceProperty dnsResource) {
                this.dnsResource = dnsResource;
                return this;
            }

            /**
             * Sets the value of {@link ResourceConfigurationDefinitionProperty#getIpResource}
             * @param ipResource The IP address of the resource configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipResource(java.lang.String ipResource) {
                this.ipResource = ipResource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceConfigurationDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceConfigurationDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceConfigurationDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceConfigurationDefinitionProperty {
            private final java.lang.String arnResource;
            private final java.lang.Object dnsResource;
            private final java.lang.String ipResource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arnResource = software.amazon.jsii.Kernel.get(this, "arnResource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dnsResource = software.amazon.jsii.Kernel.get(this, "dnsResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ipResource = software.amazon.jsii.Kernel.get(this, "ipResource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arnResource = builder.arnResource;
                this.dnsResource = builder.dnsResource;
                this.ipResource = builder.ipResource;
            }

            @Override
            public final java.lang.String getArnResource() {
                return this.arnResource;
            }

            @Override
            public final java.lang.Object getDnsResource() {
                return this.dnsResource;
            }

            @Override
            public final java.lang.String getIpResource() {
                return this.ipResource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArnResource() != null) {
                    data.set("arnResource", om.valueToTree(this.getArnResource()));
                }
                if (this.getDnsResource() != null) {
                    data.set("dnsResource", om.valueToTree(this.getDnsResource()));
                }
                if (this.getIpResource() != null) {
                    data.set("ipResource", om.valueToTree(this.getIpResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_vpclattice.CfnResourceConfiguration.ResourceConfigurationDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceConfigurationDefinitionProperty.Jsii$Proxy that = (ResourceConfigurationDefinitionProperty.Jsii$Proxy) o;

                if (this.arnResource != null ? !this.arnResource.equals(that.arnResource) : that.arnResource != null) return false;
                if (this.dnsResource != null ? !this.dnsResource.equals(that.dnsResource) : that.dnsResource != null) return false;
                return this.ipResource != null ? this.ipResource.equals(that.ipResource) : that.ipResource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arnResource != null ? this.arnResource.hashCode() : 0;
                result = 31 * result + (this.dnsResource != null ? this.dnsResource.hashCode() : 0);
                result = 31 * result + (this.ipResource != null ? this.ipResource.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.vpclattice.CfnResourceConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.vpclattice.CfnResourceConfigurationProps.Builder();
        }

        /**
         * The name of the resource configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-name</a>
         * @param name The name of the resource configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The type of resource configuration. A resource configuration can be one of the following types:.
         * <p>
         * <ul>
         * <li><em>SINGLE</em> - A single resource.</li>
         * <li><em>GROUP</em> - A group of resources. You must create a group resource configuration before you create a child resource configuration.</li>
         * <li><em>CHILD</em> - A single resource that is part of a group resource configuration.</li>
         * <li><em>ARN</em> - An AWS resource.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationtype</a>
         * @param resourceConfigurationType The type of resource configuration. A resource configuration can be one of the following types:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationType(final java.lang.String resourceConfigurationType) {
            this.props.resourceConfigurationType(resourceConfigurationType);
            return this;
        }

        /**
         * Specifies whether the resource configuration can be associated with a sharable service network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-allowassociationtosharableservicenetwork">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-allowassociationtosharableservicenetwork</a>
         * @param allowAssociationToSharableServiceNetwork Specifies whether the resource configuration can be associated with a sharable service network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAssociationToSharableServiceNetwork(final java.lang.Boolean allowAssociationToSharableServiceNetwork) {
            this.props.allowAssociationToSharableServiceNetwork(allowAssociationToSharableServiceNetwork);
            return this;
        }
        /**
         * Specifies whether the resource configuration can be associated with a sharable service network.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-allowassociationtosharableservicenetwork">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-allowassociationtosharableservicenetwork</a>
         * @param allowAssociationToSharableServiceNetwork Specifies whether the resource configuration can be associated with a sharable service network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAssociationToSharableServiceNetwork(final software.amazon.awscdk.IResolvable allowAssociationToSharableServiceNetwork) {
            this.props.allowAssociationToSharableServiceNetwork(allowAssociationToSharableServiceNetwork);
            return this;
        }

        /**
         * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535).
         * <p>
         * You can separate port ranges using commas (for example: 1,2,22-30).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-portranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-portranges</a>
         * @param portRanges (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portRanges(final java.util.List<java.lang.String> portRanges) {
            this.props.portRanges(portRanges);
            return this;
        }

        /**
         * (SINGLE, GROUP) The protocol accepted by the resource configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-protocoltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-protocoltype</a>
         * @param protocolType (SINGLE, GROUP) The protocol accepted by the resource configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolType(final java.lang.String protocolType) {
            this.props.protocolType(protocolType);
            return this;
        }

        /**
         * The auth type for the resource configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationauthtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationauthtype</a>
         * @param resourceConfigurationAuthType The auth type for the resource configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationAuthType(final java.lang.String resourceConfigurationAuthType) {
            this.props.resourceConfigurationAuthType(resourceConfigurationAuthType);
            return this;
        }

        /**
         * Identifies the resource configuration in one of the following ways:.
         * <p>
         * <ul>
         * <li><em>Amazon Resource Name (ARN)</em> - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.</li>
         * <li><em>Domain name</em> - Any domain name that is publicly resolvable.</li>
         * <li><em>IP address</em> - For IPv4 and IPv6, only IP addresses in the VPC are supported.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition</a>
         * @param resourceConfigurationDefinition Identifies the resource configuration in one of the following ways:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationDefinition(final software.amazon.awscdk.IResolvable resourceConfigurationDefinition) {
            this.props.resourceConfigurationDefinition(resourceConfigurationDefinition);
            return this;
        }
        /**
         * Identifies the resource configuration in one of the following ways:.
         * <p>
         * <ul>
         * <li><em>Amazon Resource Name (ARN)</em> - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.</li>
         * <li><em>Domain name</em> - Any domain name that is publicly resolvable.</li>
         * <li><em>IP address</em> - For IPv4 and IPv6, only IP addresses in the VPC are supported.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition</a>
         * @param resourceConfigurationDefinition Identifies the resource configuration in one of the following ways:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationDefinition(final software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration.ResourceConfigurationDefinitionProperty resourceConfigurationDefinition) {
            this.props.resourceConfigurationDefinition(resourceConfigurationDefinition);
            return this;
        }

        /**
         * The ID of the group resource configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationgroupid</a>
         * @param resourceConfigurationGroupId The ID of the group resource configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationGroupId(final java.lang.String resourceConfigurationGroupId) {
            this.props.resourceConfigurationGroupId(resourceConfigurationGroupId);
            return this;
        }

        /**
         * The ID of the resource gateway.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourcegatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourcegatewayid</a>
         * @param resourceGatewayId The ID of the resource gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceGatewayId(final java.lang.String resourceGatewayId) {
            this.props.resourceGatewayId(resourceGatewayId);
            return this;
        }

        /**
         * The tags for the resource configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-tags</a>
         * @param tags The tags for the resource configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration build() {
            return new software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
