package software.amazon.awscdk.services.wafv2;

/**
 * Properties for defining a <code>CfnWebACL</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.004Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACLProps")
@software.amazon.jsii.Jsii.Proxy(CfnWebACLProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnWebACLProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.DefaultActionProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-defaultaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-defaultaction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDefaultAction();

    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application.
     * <p>
     * For an AWS Amplify application, use <code>CLOUDFRONT</code> . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
     * <p>
     * <blockquote>
     * <p>
     * For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
     * <p>
     * </blockquote>
     * <p>
     * For information about how to define the association of the web ACL with your resource, see <code>WebACLAssociation</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-scope</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScope();

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.VisibilityConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-visibilityconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-visibilityconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVisibilityConfig();

    /**
     * Specifies custom configurations for the associations between the web ACL and protected resources.
     * <p>
     * Use this to customize the maximum size of the request body that your protected resources forward to AWS WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes).
     * <p>
     * <blockquote>
     * <p>
     * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
     * <p>
     * </blockquote>
     * <p>
     * For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.AssociationConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-associationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-associationconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociationConfig() {
        return null;
    }

    /**
     * Specifies how AWS WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings.
     * <p>
     * If you don't specify this, AWS WAF uses its default settings for <code>CaptchaConfig</code> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.CaptchaConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-captchaconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-captchaconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCaptchaConfig() {
        return null;
    }

    /**
     * Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own <code>ChallengeConfig</code> settings.
     * <p>
     * If you don't specify this, AWS WAF uses its default settings for <code>ChallengeConfig</code> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.ChallengeConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-challengeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-challengeconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getChallengeConfig() {
        return null;
    }

    /**
     * A map of custom response keys and content bodies.
     * <p>
     * When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
     * <p>
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or Map<String, either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.CustomResponseBodyProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-customresponsebodies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-customresponsebodies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomResponseBodies() {
        return null;
    }

    /**
     * Specifies data protection to apply to the web request data for the web ACL.
     * <p>
     * This is a web ACL level data protection option.
     * <p>
     * The data protection that you configure for the web ACL alters the data that's available for any other data collection activity, including your AWS WAF logging destinations, web ACL request sampling, and Amazon Security Lake data collection and management. Your other option for data protection is in the logging configuration, which only affects logging.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.DataProtectionConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-dataprotectionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-dataprotectionconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataProtectionConfig() {
        return null;
    }

    /**
     * A description of the web ACL that helps with identification.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the web ACL.
     * <p>
     * You cannot change the name of a web ACL after you create it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Configures the level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.OnSourceDDoSProtectionConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-onsourceddosprotectionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-onsourceddosprotectionconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOnSourceDDoSProtectionConfig() {
        return null;
    }

    /**
     * The rule statements used to identify the web requests that you want to manage.
     * <p>
     * Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.wafv2.CfnWebACL.RuleProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-rules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRules() {
        return null;
    }

    /**
     * Key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     * <p>
     * <blockquote>
     * <p>
     * To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies the domains that AWS WAF should accept in a web request token.
     * <p>
     * This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tokendomains">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html#cfn-wafv2-webacl-tokendomains</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTokenDomains() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnWebACLProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnWebACLProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnWebACLProps> {
        java.lang.Object defaultAction;
        java.lang.String scope;
        java.lang.Object visibilityConfig;
        java.lang.Object associationConfig;
        java.lang.Object captchaConfig;
        java.lang.Object challengeConfig;
        java.lang.Object customResponseBodies;
        java.lang.Object dataProtectionConfig;
        java.lang.String description;
        java.lang.String name;
        java.lang.Object onSourceDDoSProtectionConfig;
        java.lang.Object rules;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.util.List<java.lang.String> tokenDomains;

        /**
         * Sets the value of {@link CfnWebACLProps#getDefaultAction}
         * @param defaultAction The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(software.amazon.awscdk.IResolvable defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getDefaultAction}
         * @param defaultAction The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(software.amazon.awscdk.services.wafv2.CfnWebACL.DefaultActionProperty defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getScope}
         * @param scope Specifies whether this is for an Amazon CloudFront distribution or for a regional application. This parameter is required.
         *              For an AWS Amplify application, use <code>CLOUDFRONT</code> . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
         *              <p>
         *              <blockquote>
         *              <p>
         *              For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
         *              <p>
         *              </blockquote>
         *              <p>
         *              For information about how to define the association of the web ACL with your resource, see <code>WebACLAssociation</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getVisibilityConfig}
         * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityConfig(software.amazon.awscdk.IResolvable visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getVisibilityConfig}
         * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.VisibilityConfigProperty visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getAssociationConfig}
         * @param associationConfig Specifies custom configurations for the associations between the web ACL and protected resources.
         *                          Use this to customize the maximum size of the request body that your protected resources forward to AWS WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes).
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
         *                          <p>
         *                          </blockquote>
         *                          <p>
         *                          For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationConfig(software.amazon.awscdk.IResolvable associationConfig) {
            this.associationConfig = associationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getAssociationConfig}
         * @param associationConfig Specifies custom configurations for the associations between the web ACL and protected resources.
         *                          Use this to customize the maximum size of the request body that your protected resources forward to AWS WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes).
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
         *                          <p>
         *                          </blockquote>
         *                          <p>
         *                          For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.AssociationConfigProperty associationConfig) {
            this.associationConfig = associationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getCaptchaConfig}
         * @param captchaConfig Specifies how AWS WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings.
         *                      If you don't specify this, AWS WAF uses its default settings for <code>CaptchaConfig</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder captchaConfig(software.amazon.awscdk.IResolvable captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getCaptchaConfig}
         * @param captchaConfig Specifies how AWS WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings.
         *                      If you don't specify this, AWS WAF uses its default settings for <code>CaptchaConfig</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder captchaConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.CaptchaConfigProperty captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getChallengeConfig}
         * @param challengeConfig Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own <code>ChallengeConfig</code> settings.
         *                        If you don't specify this, AWS WAF uses its default settings for <code>ChallengeConfig</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder challengeConfig(software.amazon.awscdk.IResolvable challengeConfig) {
            this.challengeConfig = challengeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getChallengeConfig}
         * @param challengeConfig Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own <code>ChallengeConfig</code> settings.
         *                        If you don't specify this, AWS WAF uses its default settings for <code>ChallengeConfig</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder challengeConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.ChallengeConfigProperty challengeConfig) {
            this.challengeConfig = challengeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getCustomResponseBodies}
         * @param customResponseBodies A map of custom response keys and content bodies.
         *                             When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
         *                             <p>
         *                             For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
         *                             <p>
         *                             For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResponseBodies(software.amazon.awscdk.IResolvable customResponseBodies) {
            this.customResponseBodies = customResponseBodies;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getCustomResponseBodies}
         * @param customResponseBodies A map of custom response keys and content bodies.
         *                             When you create a rule with a block action, you can send a custom response to the web request. You define these for the web ACL, and then use them in the rules and default actions that you define in the web ACL.
         *                             <p>
         *                             For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
         *                             <p>
         *                             For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResponseBodies(java.util.Map<java.lang.String, ? extends java.lang.Object> customResponseBodies) {
            this.customResponseBodies = customResponseBodies;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getDataProtectionConfig}
         * @param dataProtectionConfig Specifies data protection to apply to the web request data for the web ACL.
         *                             This is a web ACL level data protection option.
         *                             <p>
         *                             The data protection that you configure for the web ACL alters the data that's available for any other data collection activity, including your AWS WAF logging destinations, web ACL request sampling, and Amazon Security Lake data collection and management. Your other option for data protection is in the logging configuration, which only affects logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionConfig(software.amazon.awscdk.IResolvable dataProtectionConfig) {
            this.dataProtectionConfig = dataProtectionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getDataProtectionConfig}
         * @param dataProtectionConfig Specifies data protection to apply to the web request data for the web ACL.
         *                             This is a web ACL level data protection option.
         *                             <p>
         *                             The data protection that you configure for the web ACL alters the data that's available for any other data collection activity, including your AWS WAF logging destinations, web ACL request sampling, and Amazon Security Lake data collection and management. Your other option for data protection is in the logging configuration, which only affects logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataProtectionConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.DataProtectionConfigProperty dataProtectionConfig) {
            this.dataProtectionConfig = dataProtectionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getDescription}
         * @param description A description of the web ACL that helps with identification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getName}
         * @param name The name of the web ACL.
         *             You cannot change the name of a web ACL after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getOnSourceDDoSProtectionConfig}
         * @param onSourceDDoSProtectionConfig Configures the level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSourceDDoSProtectionConfig(software.amazon.awscdk.IResolvable onSourceDDoSProtectionConfig) {
            this.onSourceDDoSProtectionConfig = onSourceDDoSProtectionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getOnSourceDDoSProtectionConfig}
         * @param onSourceDDoSProtectionConfig Configures the level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSourceDDoSProtectionConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.OnSourceDDoSProtectionConfigProperty onSourceDDoSProtectionConfig) {
            this.onSourceDDoSProtectionConfig = onSourceDDoSProtectionConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getRules}
         * @param rules The rule statements used to identify the web requests that you want to manage.
         *              Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(software.amazon.awscdk.IResolvable rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getRules}
         * @param rules The rule statements used to identify the web requests that you want to manage.
         *              Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(java.util.List<? extends java.lang.Object> rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getTags}
         * @param tags Key:value pairs associated with an AWS resource.
         *             The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
         *             <p>
         *             <blockquote>
         *             <p>
         *             To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnWebACLProps#getTokenDomains}
         * @param tokenDomains Specifies the domains that AWS WAF should accept in a web request token.
         *                     This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenDomains(java.util.List<java.lang.String> tokenDomains) {
            this.tokenDomains = tokenDomains;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnWebACLProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnWebACLProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnWebACLProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnWebACLProps {
        private final java.lang.Object defaultAction;
        private final java.lang.String scope;
        private final java.lang.Object visibilityConfig;
        private final java.lang.Object associationConfig;
        private final java.lang.Object captchaConfig;
        private final java.lang.Object challengeConfig;
        private final java.lang.Object customResponseBodies;
        private final java.lang.Object dataProtectionConfig;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.Object onSourceDDoSProtectionConfig;
        private final java.lang.Object rules;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.util.List<java.lang.String> tokenDomains;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.visibilityConfig = software.amazon.jsii.Kernel.get(this, "visibilityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.associationConfig = software.amazon.jsii.Kernel.get(this, "associationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.captchaConfig = software.amazon.jsii.Kernel.get(this, "captchaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.challengeConfig = software.amazon.jsii.Kernel.get(this, "challengeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customResponseBodies = software.amazon.jsii.Kernel.get(this, "customResponseBodies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataProtectionConfig = software.amazon.jsii.Kernel.get(this, "dataProtectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.onSourceDDoSProtectionConfig = software.amazon.jsii.Kernel.get(this, "onSourceDDoSProtectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.tokenDomains = software.amazon.jsii.Kernel.get(this, "tokenDomains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultAction = java.util.Objects.requireNonNull(builder.defaultAction, "defaultAction is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            this.visibilityConfig = java.util.Objects.requireNonNull(builder.visibilityConfig, "visibilityConfig is required");
            this.associationConfig = builder.associationConfig;
            this.captchaConfig = builder.captchaConfig;
            this.challengeConfig = builder.challengeConfig;
            this.customResponseBodies = builder.customResponseBodies;
            this.dataProtectionConfig = builder.dataProtectionConfig;
            this.description = builder.description;
            this.name = builder.name;
            this.onSourceDDoSProtectionConfig = builder.onSourceDDoSProtectionConfig;
            this.rules = builder.rules;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.tokenDomains = builder.tokenDomains;
        }

        @Override
        public final java.lang.Object getDefaultAction() {
            return this.defaultAction;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.Object getVisibilityConfig() {
            return this.visibilityConfig;
        }

        @Override
        public final java.lang.Object getAssociationConfig() {
            return this.associationConfig;
        }

        @Override
        public final java.lang.Object getCaptchaConfig() {
            return this.captchaConfig;
        }

        @Override
        public final java.lang.Object getChallengeConfig() {
            return this.challengeConfig;
        }

        @Override
        public final java.lang.Object getCustomResponseBodies() {
            return this.customResponseBodies;
        }

        @Override
        public final java.lang.Object getDataProtectionConfig() {
            return this.dataProtectionConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOnSourceDDoSProtectionConfig() {
            return this.onSourceDDoSProtectionConfig;
        }

        @Override
        public final java.lang.Object getRules() {
            return this.rules;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getTokenDomains() {
            return this.tokenDomains;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
            data.set("scope", om.valueToTree(this.getScope()));
            data.set("visibilityConfig", om.valueToTree(this.getVisibilityConfig()));
            if (this.getAssociationConfig() != null) {
                data.set("associationConfig", om.valueToTree(this.getAssociationConfig()));
            }
            if (this.getCaptchaConfig() != null) {
                data.set("captchaConfig", om.valueToTree(this.getCaptchaConfig()));
            }
            if (this.getChallengeConfig() != null) {
                data.set("challengeConfig", om.valueToTree(this.getChallengeConfig()));
            }
            if (this.getCustomResponseBodies() != null) {
                data.set("customResponseBodies", om.valueToTree(this.getCustomResponseBodies()));
            }
            if (this.getDataProtectionConfig() != null) {
                data.set("dataProtectionConfig", om.valueToTree(this.getDataProtectionConfig()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOnSourceDDoSProtectionConfig() != null) {
                data.set("onSourceDDoSProtectionConfig", om.valueToTree(this.getOnSourceDDoSProtectionConfig()));
            }
            if (this.getRules() != null) {
                data.set("rules", om.valueToTree(this.getRules()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTokenDomains() != null) {
                data.set("tokenDomains", om.valueToTree(this.getTokenDomains()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACLProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnWebACLProps.Jsii$Proxy that = (CfnWebACLProps.Jsii$Proxy) o;

            if (!defaultAction.equals(that.defaultAction)) return false;
            if (!scope.equals(that.scope)) return false;
            if (!visibilityConfig.equals(that.visibilityConfig)) return false;
            if (this.associationConfig != null ? !this.associationConfig.equals(that.associationConfig) : that.associationConfig != null) return false;
            if (this.captchaConfig != null ? !this.captchaConfig.equals(that.captchaConfig) : that.captchaConfig != null) return false;
            if (this.challengeConfig != null ? !this.challengeConfig.equals(that.challengeConfig) : that.challengeConfig != null) return false;
            if (this.customResponseBodies != null ? !this.customResponseBodies.equals(that.customResponseBodies) : that.customResponseBodies != null) return false;
            if (this.dataProtectionConfig != null ? !this.dataProtectionConfig.equals(that.dataProtectionConfig) : that.dataProtectionConfig != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.onSourceDDoSProtectionConfig != null ? !this.onSourceDDoSProtectionConfig.equals(that.onSourceDDoSProtectionConfig) : that.onSourceDDoSProtectionConfig != null) return false;
            if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.tokenDomains != null ? this.tokenDomains.equals(that.tokenDomains) : that.tokenDomains == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultAction.hashCode();
            result = 31 * result + (this.scope.hashCode());
            result = 31 * result + (this.visibilityConfig.hashCode());
            result = 31 * result + (this.associationConfig != null ? this.associationConfig.hashCode() : 0);
            result = 31 * result + (this.captchaConfig != null ? this.captchaConfig.hashCode() : 0);
            result = 31 * result + (this.challengeConfig != null ? this.challengeConfig.hashCode() : 0);
            result = 31 * result + (this.customResponseBodies != null ? this.customResponseBodies.hashCode() : 0);
            result = 31 * result + (this.dataProtectionConfig != null ? this.dataProtectionConfig.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.onSourceDDoSProtectionConfig != null ? this.onSourceDDoSProtectionConfig.hashCode() : 0);
            result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tokenDomains != null ? this.tokenDomains.hashCode() : 0);
            return result;
        }
    }
}
