package software.amazon.awscdk.services.wafv2;

/**
 * A reference to a RegexPatternSet resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * RegexPatternSetReference regexPatternSetReference = RegexPatternSetReference.builder()
 *         .regexPatternSetArn("regexPatternSetArn")
 *         .regexPatternSetId("regexPatternSetId")
 *         .regexPatternSetName("regexPatternSetName")
 *         .scope("scope")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.008Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.RegexPatternSetReference")
@software.amazon.jsii.Jsii.Proxy(RegexPatternSetReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RegexPatternSetReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the RegexPatternSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegexPatternSetArn();

    /**
     * The Id of the RegexPatternSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegexPatternSetId();

    /**
     * The Name of the RegexPatternSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegexPatternSetName();

    /**
     * The Scope of the RegexPatternSet resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScope();

    /**
     * @return a {@link Builder} of {@link RegexPatternSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RegexPatternSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RegexPatternSetReference> {
        java.lang.String regexPatternSetArn;
        java.lang.String regexPatternSetId;
        java.lang.String regexPatternSetName;
        java.lang.String scope;

        /**
         * Sets the value of {@link RegexPatternSetReference#getRegexPatternSetArn}
         * @param regexPatternSetArn The ARN of the RegexPatternSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regexPatternSetArn(java.lang.String regexPatternSetArn) {
            this.regexPatternSetArn = regexPatternSetArn;
            return this;
        }

        /**
         * Sets the value of {@link RegexPatternSetReference#getRegexPatternSetId}
         * @param regexPatternSetId The Id of the RegexPatternSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regexPatternSetId(java.lang.String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
            return this;
        }

        /**
         * Sets the value of {@link RegexPatternSetReference#getRegexPatternSetName}
         * @param regexPatternSetName The Name of the RegexPatternSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regexPatternSetName(java.lang.String regexPatternSetName) {
            this.regexPatternSetName = regexPatternSetName;
            return this;
        }

        /**
         * Sets the value of {@link RegexPatternSetReference#getScope}
         * @param scope The Scope of the RegexPatternSet resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RegexPatternSetReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RegexPatternSetReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RegexPatternSetReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegexPatternSetReference {
        private final java.lang.String regexPatternSetArn;
        private final java.lang.String regexPatternSetId;
        private final java.lang.String regexPatternSetName;
        private final java.lang.String scope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.regexPatternSetArn = software.amazon.jsii.Kernel.get(this, "regexPatternSetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regexPatternSetId = software.amazon.jsii.Kernel.get(this, "regexPatternSetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regexPatternSetName = software.amazon.jsii.Kernel.get(this, "regexPatternSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.regexPatternSetArn = java.util.Objects.requireNonNull(builder.regexPatternSetArn, "regexPatternSetArn is required");
            this.regexPatternSetId = java.util.Objects.requireNonNull(builder.regexPatternSetId, "regexPatternSetId is required");
            this.regexPatternSetName = java.util.Objects.requireNonNull(builder.regexPatternSetName, "regexPatternSetName is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
        }

        @Override
        public final java.lang.String getRegexPatternSetArn() {
            return this.regexPatternSetArn;
        }

        @Override
        public final java.lang.String getRegexPatternSetId() {
            return this.regexPatternSetId;
        }

        @Override
        public final java.lang.String getRegexPatternSetName() {
            return this.regexPatternSetName;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("regexPatternSetArn", om.valueToTree(this.getRegexPatternSetArn()));
            data.set("regexPatternSetId", om.valueToTree(this.getRegexPatternSetId()));
            data.set("regexPatternSetName", om.valueToTree(this.getRegexPatternSetName()));
            data.set("scope", om.valueToTree(this.getScope()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.RegexPatternSetReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RegexPatternSetReference.Jsii$Proxy that = (RegexPatternSetReference.Jsii$Proxy) o;

            if (!regexPatternSetArn.equals(that.regexPatternSetArn)) return false;
            if (!regexPatternSetId.equals(that.regexPatternSetId)) return false;
            if (!regexPatternSetName.equals(that.regexPatternSetName)) return false;
            return this.scope.equals(that.scope);
        }

        @Override
        public final int hashCode() {
            int result = this.regexPatternSetArn.hashCode();
            result = 31 * result + (this.regexPatternSetId.hashCode());
            result = 31 * result + (this.regexPatternSetName.hashCode());
            result = 31 * result + (this.scope.hashCode());
            return result;
        }
    }
}
