package software.amazon.awscdk.services.wafv2;

/**
 * A reference to a WebACL resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * WebACLReference webACLReference = WebACLReference.builder()
 *         .scope("scope")
 *         .webAclArn("webAclArn")
 *         .webAclId("webAclId")
 *         .webAclName("webAclName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:40:17.009Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.WebACLReference")
@software.amazon.jsii.Jsii.Proxy(WebACLReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebACLReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Scope of the WebACL resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScope();

    /**
     * The ARN of the WebACL resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebAclArn();

    /**
     * The Id of the WebACL resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebAclId();

    /**
     * The Name of the WebACL resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebAclName();

    /**
     * @return a {@link Builder} of {@link WebACLReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebACLReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebACLReference> {
        java.lang.String scope;
        java.lang.String webAclArn;
        java.lang.String webAclId;
        java.lang.String webAclName;

        /**
         * Sets the value of {@link WebACLReference#getScope}
         * @param scope The Scope of the WebACL resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link WebACLReference#getWebAclArn}
         * @param webAclArn The ARN of the WebACL resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclArn(java.lang.String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        /**
         * Sets the value of {@link WebACLReference#getWebAclId}
         * @param webAclId The Id of the WebACL resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclId(java.lang.String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        /**
         * Sets the value of {@link WebACLReference#getWebAclName}
         * @param webAclName The Name of the WebACL resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webAclName(java.lang.String webAclName) {
            this.webAclName = webAclName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebACLReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebACLReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebACLReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebACLReference {
        private final java.lang.String scope;
        private final java.lang.String webAclArn;
        private final java.lang.String webAclId;
        private final java.lang.String webAclName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webAclArn = software.amazon.jsii.Kernel.get(this, "webAclArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webAclId = software.amazon.jsii.Kernel.get(this, "webAclId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webAclName = software.amazon.jsii.Kernel.get(this, "webAclName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            this.webAclArn = java.util.Objects.requireNonNull(builder.webAclArn, "webAclArn is required");
            this.webAclId = java.util.Objects.requireNonNull(builder.webAclId, "webAclId is required");
            this.webAclName = java.util.Objects.requireNonNull(builder.webAclName, "webAclName is required");
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.String getWebAclArn() {
            return this.webAclArn;
        }

        @Override
        public final java.lang.String getWebAclId() {
            return this.webAclId;
        }

        @Override
        public final java.lang.String getWebAclName() {
            return this.webAclName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scope", om.valueToTree(this.getScope()));
            data.set("webAclArn", om.valueToTree(this.getWebAclArn()));
            data.set("webAclId", om.valueToTree(this.getWebAclId()));
            data.set("webAclName", om.valueToTree(this.getWebAclName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.WebACLReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebACLReference.Jsii$Proxy that = (WebACLReference.Jsii$Proxy) o;

            if (!scope.equals(that.scope)) return false;
            if (!webAclArn.equals(that.webAclArn)) return false;
            if (!webAclId.equals(that.webAclId)) return false;
            return this.webAclName.equals(that.webAclName);
        }

        @Override
        public final int hashCode() {
            int result = this.scope.hashCode();
            result = 31 * result + (this.webAclArn.hashCode());
            result = 31 * result + (this.webAclId.hashCode());
            result = 31 * result + (this.webAclName.hashCode());
            return result;
        }
    }
}
